/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.mao.emo.cable;

import se.ericsson.cello.equipment.EquipmentMo;
import se.ericsson.cello.equipment.PiuDeviceMo;
import se.ericsson.cello.equipment.PlugInUnitMo;
import se.ericsson.cello.mao.Reservable;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.IllegalParentException;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoCanNotBeCreatedException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.ReferenceAttribute;
import se.ericsson.cello.moframework.StringAttribute;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.wcdma.rbs.boam.common.log.MessageLog;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.proxies.EqcCableProxy;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.proxies.EqcPmHelperProxy;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.proxies.EqcRrhIndProxy;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EqcCreateCableRspS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EqcGetDigCableParamRspS;
import se.ericsson.wcdma.rbs.boam.mao.alarm.MoAlarms;
import se.ericsson.wcdma.rbs.boam.mao.bcm.BoamHelper;
import se.ericsson.wcdma.rbs.boam.mao.bcm.BoamManagedObjectWithAlarms;
import se.ericsson.wcdma.rbs.boam.mao.common.ValidateAttributes;
import se.ericsson.wcdma.rbs.boam.mao.emo.cable.DigitalCableMoFactory;
import se.ericsson.wcdma.rbs.boam.mao.iface.gen.struct.SfpProductDataStruct;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.AuxPlugInUnitMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.DeviceGroupMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.DigitalCableMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.LoPowTxCableMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.RruDeviceGroupMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.RuDeviceGroupMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.RuifDeviceGroupMo;
import se.ericsson.wcdma.rbs.boam.pms.impl.MoScanner;
import se.ericsson.wcdma.rbs.boam.pms.impl.PmsException;

public class DigitalCableMoImpl
extends BoamManagedObjectWithAlarms
implements DigitalCableMo {
    public static final int MO_DATA_REVISION = 4010101;
    private static final ConnTable[] CONN_A_TAB = new ConnTable[]{new ConnTable(1, 55), new ConnTable(2, 56), new ConnTable(3, 57), new ConnTable(4, 58), new ConnTable(5, 59), new ConnTable(6, 60), new ConnTable(9, 80), new ConnTable(10, 81), new ConnTable(11, 82), new ConnTable(12, 83), new ConnTable(13, 84), new ConnTable(14, 85), new ConnTable(7, 62), new ConnTable(8, 63)};
    private static final ConnTable[] CONN_B_TAB = new ConnTable[]{new ConnTable(1, 62), new ConnTable(2, 63), new ConnTable(4, 84), new ConnTable(3, 85)};
    private final EqcCableProxy eqcCableProxy = EqcCableProxy.instance();
    private final EqcRrhIndProxy eqcRrhIndProxy = EqcRrhIndProxy.instance();
    private final MoScanner myScanner;

    public DigitalCableMoImpl(ManagedObject parent, AttrList attributes, String identity, Coordinator context, String userLabel, int alarmStatus, ManagedObject objectAConnectorRef, ManagedObject objectBConnectorRef, int objectAConnector, int objectBConnector, int electricalDelay) throws MoAccessException {
        super(parent, "DigitalCable", identity, context);
        MessageLog.traceEnter(this.getClass(), " DigitalCableMoImpl Normal constructor");
        int objAFroId = this.reserveAndGetFroId(objectAConnectorRef, context);
        int objBFroId = this.reserveAndGetFroId(objectBConnectorRef, context);
        this.checkPiu(objectAConnectorRef, context);
        this.checkPiu(objectBConnectorRef, context);
        for (int i = 0; i < CONN_A_TAB.length; ++i) {
            if (objectAConnector != DigitalCableMoImpl.CONN_A_TAB[i].mub) continue;
            objectAConnector = DigitalCableMoImpl.CONN_A_TAB[i].eqmi;
        }
        for (int j = 0; j < CONN_B_TAB.length; ++j) {
            if (objectBConnector != DigitalCableMoImpl.CONN_B_TAB[j].mub) continue;
            objectBConnector = DigitalCableMoImpl.CONN_B_TAB[j].eqmi;
        }
        EqcCreateCableRspS rspSig = this.eqcCableProxy.createCable(this.getTxIdTransactional(context), 0L, 50165, 0L, objAFroId, objectAConnector, objBFroId, objectBConnector);
        int cableFroId = (int)rspSig.cableFroId;
        this.initMoData(userLabel, alarmStatus, objectAConnectorRef, objectBConnectorRef, cableFroId, context);
        this.addObservers(50165, context);
        this.setElectricalDelay(electricalDelay, context);
        this.myScanner = this.createMoScanner(false, cableFroId, context);
        MessageLog.trace(1, this.getClass(), this.getType() + " MO is Created ");
    }

    public DigitalCableMoImpl(MoData recoveredData) throws MoNameAlreadyTakenException {
        super(recoveredData);
        MessageLog.traceEnter(this.getClass(), " DigitalCableMoImpl Recovery constructor");
        this.myData = recoveredData;
        try {
            this.addObservers(50165, null);
        }
        catch (MoAccessException e) {
            MessageLog.traceError(this.getClass(), "Couldn't init the Observers!!");
        }
        int froid = -1;
        try {
            froid = this.bcmGetIntAttribute("froId", null);
        }
        catch (MoAccessException e) {
            MessageLog.traceError(this.getClass(), "could not get fro id: " + (Object)((Object)e));
        }
        this.myScanner = this.createMoScanner(true, froid, null);
        MessageLog.trace(1, this.getClass(), "Version Attribute in MoData = " + this.myData.getRevision());
        MessageLog.trace(1, this.getClass(), "DigitalCable MO is Restored ");
    }

    private MoScanner createMoScanner(boolean isRecovery, int froid, Coordinator context) {
        try {
            MessageLog.trace(1, this.getClass(), "create MoScanner <---");
            MoScanner moScanner = new MoScanner(this, EqcPmHelperProxy.instance(), froid, -1, DigitalCableMoFactory.instance().getCounters(), null, isRecovery, context);
            MessageLog.trace(1, this.getClass(), "MoScanner created<---");
            return moScanner;
        }
        catch (Exception pmse) {
            MessageLog.traceError(this.getClass(), " Could not create MoScanner: " + pmse);
            return null;
        }
    }

    public static synchronized ManagedObject create(ManagedObject parent, AttrList attributes, String identity, ManagedObject source, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(DigitalCableMoImpl.class, "create()");
        DigitalCableMoImpl.checkTransaction(context);
        DigitalCableMoImpl.checkParent(parent);
        String checkedUserLabel = ValidateAttributes.checkAndGetStringAttribute(attributes, "userLabel", "optional", "", 0, 128, "DigitalCable");
        String[] acceptedClasses = new String[]{"PlugInUnit", "AuxPlugInUnit"};
        ManagedObject checkedConnectedToObjectARef = ValidateAttributes.checkAndGetReferenceAttribute("connectedToObjectARef", attributes, "mandatory", acceptedClasses, "DigitalCable");
        ManagedObject checkedConnectedToObjectBRef = ValidateAttributes.checkAndGetReferenceAttribute("connectedToObjectBRef", attributes, "mandatory", acceptedClasses, "DigitalCable");
        int checkedObjectAConnector = ValidateAttributes.checkAndGetIntAttribute(attributes, "objectAConnector", "mandatory", 1, 1, 14, "DigitalCable");
        int checkedObjectBConnector = ValidateAttributes.checkAndGetIntAttribute(attributes, "objectBConnector", "mandatory", 1, 1, 4, "DigitalCable");
        int electricalDelay = ValidateAttributes.checkAndGetIntAttribute(attributes, "electricalDelay", "mandatory", 0, ELECTRICAL_DELAY_MIN_VALUES, ELECTRICAL_DELAY_MAX_VALUES, "DigitalCable");
        int checkedAlarmStatus = ValidateAttributes.checkAndGetIntAttribute(attributes, "alarmStatus", "optional", 0, LoPowTxCableMo.ALARM_STATUS_MIN_VALUES, LoPowTxCableMo.ALARM_STATUS_MAX_VALUES, "LoPowTxCable");
        ValidateAttributes.checkOtherAttributes(attributes, "DigitalCable");
        DigitalCableMoImpl createdMo = new DigitalCableMoImpl(parent, attributes, identity, context, checkedUserLabel, checkedAlarmStatus, checkedConnectedToObjectARef, checkedConnectedToObjectBRef, checkedObjectAConnector, checkedObjectBConnector, electricalDelay);
        return createdMo;
    }

    public void delete(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "delete()");
        this.myData.handleTransaction(context, MoData.WRITE_ACCESS);
        if (this.myScanner != null) {
            this.myScanner.delete(context);
        }
        this.eqcCableProxy.deleteCable(this.getTxIdTransactional(context), 0, this.getFroId(context), 50165);
        ManagedObject connectedToObjectARef = this.getConnectedToObjectARef(context);
        ManagedObject connectedToObjectBRef = this.getConnectedToObjectBRef(context);
        this.releaseMo(connectedToObjectARef, context);
        this.releaseMo(connectedToObjectBRef, context);
        this.removeObservers(context);
        super.delete(context);
        MessageLog.trace(1, this.getClass(), this.getType() + " Mo is Deleted ");
    }

    public String getType() {
        return "DigitalCable";
    }

    public MoData getMyMoData() {
        MessageLog.traceEnter(this.getClass(), "getMyMoData()");
        return this.myData;
    }

    public boolean isMyMoDataPersistent() {
        MessageLog.traceEnter(this.getClass(), "isMyMoDataPersistent()");
        return true;
    }

    public int getObjectAConnector(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getObjectAConnector()");
        EqcGetDigCableParamRspS rspSig = this.eqcCableProxy.getDigCableParameters(this.getTxIdNonTransactional(context), 0, this.getFroId(context));
        for (int i = 0; i < CONN_A_TAB.length; ++i) {
            if (rspSig.objectAConnectorId != DigitalCableMoImpl.CONN_A_TAB[i].eqmi) continue;
            return DigitalCableMoImpl.CONN_A_TAB[i].mub;
        }
        return 0;
    }

    public int getObjectBConnector(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getObjectBConnector()");
        EqcGetDigCableParamRspS rspSig = this.eqcCableProxy.getDigCableParameters(this.getTxIdNonTransactional(context), 0, this.getFroId(context));
        for (int i = 0; i < CONN_B_TAB.length; ++i) {
            if (rspSig.objectBConnectorId != DigitalCableMoImpl.CONN_B_TAB[i].eqmi) continue;
            return DigitalCableMoImpl.CONN_B_TAB[i].mub;
        }
        return 0;
    }

    public ManagedObject getConnectedToObjectARef(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getConnectedToObjectARef()");
        ReferenceAttribute connectedToObjectARef = null;
        this.myData.handleTransaction(context, MoData.READ_ACCESS);
        connectedToObjectARef = (ReferenceAttribute)this.myData.getAttribute("connectedToObjectARef");
        return connectedToObjectARef.getValue(context);
    }

    public ManagedObject getConnectedToObjectBRef(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getConnectedToObjectBRef()");
        ReferenceAttribute connectedToObjectBRef = null;
        this.myData.handleTransaction(context, MoData.READ_ACCESS);
        connectedToObjectBRef = (ReferenceAttribute)this.myData.getAttribute("connectedToObjectBRef");
        return connectedToObjectBRef.getValue(context);
    }

    public String getUserLabel(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getUserLabel()");
        this.myData.handleTransaction(context, MoData.READ_ACCESS);
        StringAttribute userLabelAttr = (StringAttribute)this.myData.getAttribute("userLabel");
        return userLabelAttr.getValue(context);
    }

    public void setUserLabel(String value, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setUserLabel() ");
        this.myData.handleTransaction(context, MoData.WRITE_ACCESS);
        this.bcmSetStringAttribute("userLabel", value, 0, 128, this.getType(), context);
        this.sendAVC("userLabel", value, context);
    }

    public int getFroId(Coordinator context) {
        int froId = 0;
        MessageLog.traceEnter(this.getClass(), "getFroId()");
        try {
            froId = this.bcmGetIntAttribute("froId", context);
        }
        catch (MoAccessException moEx) {
            MessageLog.traceError(this.getClass(), "DigitalCable Cannot retrive FroId");
        }
        return froId;
    }

    public int getElectricalDelay(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getElectricalDelay()");
        EqcGetDigCableParamRspS rspSig = this.eqcCableProxy.getDigCableParameters(this.getTxIdNonTransactional(c), 0, this.getFroId(c));
        return rspSig.electricalDelay;
    }

    public void setElectricalDelay(int value, Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setElectricalDelay()");
        ValidateAttributes.checkTransaction(c);
        this.getMyMoData().handleTransaction(c, MoData.WRITE_ACCESS);
        ValidateAttributes.intValueRangeCheck("electricalDelay", value, ELECTRICAL_DELAY_MIN_VALUES, ELECTRICAL_DELAY_MAX_VALUES, "DigitalCable");
        this.eqcCableProxy.setDigCableParameters(this.getTxIdTransactional(c), 0L, this.getFroId(c), 1, value);
    }

    protected void addObservers(int froType, Coordinator context) throws MoAccessException {
        this.myMoAlarms = new MoAlarms((ManagedObject)this, this.eqcRrhIndProxy, froType, this.getFroId(context), context);
    }

    protected void removeObservers(Coordinator context) throws MoAccessException {
        this.myMoAlarms.delete(context);
    }

    private static void checkParent(ManagedObject parent) throws IllegalParentException {
        MessageLog.traceEnter(DigitalCableMoImpl.class, "checkParent()");
        if (parent == null || !(parent instanceof EquipmentMo)) {
            String msg = " Illegal parent, Expecting EquipmentMo, received for: DigitalCable";
            throw new IllegalParentException(msg);
        }
    }

    private void initMoData(String userLabel, int alarmStatus, ManagedObject aConnectorRef, ManagedObject bConnectorRef, int froId, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "initMoData() ");
        this.myData = new MoData(this.getLocalDistinguishedName(), this.getType(), true, context);
        this.myData.handleTransaction(context, MoData.WRITE_ACCESS);
        this.myData.setRevision(4010101);
        this.bcmStoreAndRegisterStringAttribute("userLabel", userLabel);
        this.bcmStoreAndRegisterReferenceAttribute("connectedToObjectARef", aConnectorRef);
        this.bcmStoreAndRegisterReferenceAttribute("connectedToObjectBRef", bConnectorRef);
        this.bcmStoreAndRegisterIntAttribute("froId", froId);
        this.initAlarmStatus(alarmStatus, context);
        this.myData.setRevision(4010101);
    }

    private boolean checkMoId(ManagedObject target, String strGenericDeviceMoId) {
        return target.getNamingAttributeValue().equalsIgnoreCase(strGenericDeviceMoId);
    }

    private void checkPiu(ManagedObject aPiuOrPiuDevice, Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "checkPiu()");
        if (!this.checkPiuRecursive(aPiuOrPiuDevice, c)) {
            throw new MoCanNotBeCreatedException("The necessay DeviceGroup RU,RRU,RUW, RRUW,RUIF,or DUI must be created before Digital cable:" + this.getFullDistinguishedName() + ",\n Please chck the XxDeviceGroup/DeviceGroup under the connected Object:" + aPiuOrPiuDevice.getFullDistinguishedName());
        }
    }

    private boolean checkPiuRecursive(ManagedObject aPiuOrPiuDevice, Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "checkPiuRecursive()");
        ManagedObject mo = null;
        MoIterator iter = aPiuOrPiuDevice.getChildren();
        while (iter.hasMoreElements()) {
            mo = iter.nextMo();
            if (mo instanceof RuDeviceGroupMo || mo instanceof RruDeviceGroupMo && (((AuxPlugInUnitMo)mo.getParent()).getAuType(c) == 20 || ((AuxPlugInUnitMo)mo.getParent()).getAuType(c) == 10 || ((AuxPlugInUnitMo)mo.getParent()).getAuType(c) == 27) || mo instanceof RuifDeviceGroupMo || mo instanceof DeviceGroupMo && (this.checkMoId(mo, "RUW") || this.checkMoId(mo, "DUI") || this.checkMoId(mo, "XCU") || this.checkMoId(mo, "AIR"))) {
                return true;
            }
            if (!(mo instanceof PiuDeviceMo) || !this.checkPiuRecursive(mo, c)) continue;
            return true;
        }
        return false;
    }

    private ManagedObject mapPiu2PiuDeviceIfDui(ManagedObject piuMo, Coordinator c) throws MoAccessException {
        MoIterator iter = BoamHelper.findMOs("DeviceGroup", "DUI", piuMo, 2);
        if (iter.hasMoreElements()) {
            return iter.nextMo().getParent();
        }
        return piuMo;
    }

    private int reserveAndGetFroId(ManagedObject piuMo, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "reserveAndGetFroId()");
        if (piuMo instanceof PlugInUnitMo) {
            int froId = BoamHelper.getPlugInUnitFroId(this.mapPiu2PiuDeviceIfDui(piuMo, context), context);
            ((PlugInUnitMo)piuMo).reserve((ManagedObject)this, context);
            return froId;
        }
        if (piuMo instanceof AuxPlugInUnitMo) {
            ((AuxPlugInUnitMo)piuMo).reserve(this, context);
            return ((AuxPlugInUnitMo)piuMo).getFroId(context);
        }
        return 0;
    }

    private void releaseMo(ManagedObject mo, Coordinator context) throws MoAccessException {
        if (mo instanceof PlugInUnitMo) {
            ((Reservable)mo).release((ManagedObject)this, context);
        } else if (mo instanceof AuxPlugInUnitMo) {
            ((AuxPlugInUnitMo)mo).release(this, context);
        }
    }

    public Struct getObjectAConnectorData(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getObjectAConnectorData()");
        EqcGetDigCableParamRspS rspSig = this.eqcCableProxy.getDigCableParameters(this.getTxIdNonTransactional(c), 0, this.getFroId(c));
        return new SfpProductDataStruct(rspSig.objectAConnectorData.vendorPartNumber, rspSig.objectAConnectorData.vendorProductName, rspSig.objectAConnectorData.productRevision, rspSig.objectAConnectorData.ericssonProductNo, rspSig.objectAConnectorData.productionDate, rspSig.objectAConnectorData.ericssonProductRevision, rspSig.objectAConnectorData.serialNumber, rspSig.objectAConnectorData.supportedRates, rspSig.objectAConnectorData.type);
    }

    public Struct getObjectBConnectorData(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getObjectBConnectorData()");
        EqcGetDigCableParamRspS rspSig = this.eqcCableProxy.getDigCableParameters(this.getTxIdNonTransactional(c), 0, this.getFroId(c));
        return new SfpProductDataStruct(rspSig.objectBConnectorData.vendorPartNumber, rspSig.objectBConnectorData.vendorProductName, rspSig.objectBConnectorData.productRevision, rspSig.objectBConnectorData.ericssonProductNo, rspSig.objectBConnectorData.productionDate, rspSig.objectBConnectorData.ericssonProductRevision, rspSig.objectBConnectorData.serialNumber, rspSig.objectBConnectorData.supportedRates, rspSig.objectBConnectorData.type);
    }

    public int getOperationalState(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getOperationalState()");
        EqcGetDigCableParamRspS rspSig = this.eqcCableProxy.getDigCableParameters(this.getTxIdNonTransactional(c), 0, this.getFroId(c));
        return rspSig.opState;
    }

    public int getNegotiatedRate(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getNegotiatedRate()");
        EqcGetDigCableParamRspS rspSig = this.eqcCableProxy.getDigCableParameters(this.getTxIdNonTransactional(c), 0, this.getFroId(c));
        return rspSig.negotiatedRate;
    }

    public int getAvailabilityStatus(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getAvailabilityStatus()");
        EqcGetDigCableParamRspS rspSig = this.eqcCableProxy.getDigCableParameters(this.getTxIdNonTransactional(c), 0, this.getFroId(c));
        return rspSig.availStatus;
    }

    public int[] getScannerValue(String counterName) throws PmsException {
        if (this.myScanner == null) {
            throw new PmsException("MoScanner not available");
        }
        return this.myScanner.getValue(counterName);
    }

    private static class ConnTable {
        final int mub;
        final int eqmi;

        ConnTable(int a, int b) {
            this.mub = a;
            this.eqmi = b;
        }
    }
}

