/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.mao.emo.cable;

import enea.ose.system.InSignal;
import se.ericsson.cello.equipment.EquipmentMo;
import se.ericsson.cello.equipment.PlugInUnitMaoi;
import se.ericsson.cello.equipment.PlugInUnitMo;
import se.ericsson.cello.faultmanagement.AdditionalInfo;
import se.ericsson.cello.faultmanagement.Event;
import se.ericsson.cello.mao.Reservable;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.IllegalParentException;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoCanNotBeCreatedException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.ReferenceAttribute;
import se.ericsson.cello.moframework.StringAttribute;
import se.ericsson.cello.moframework.ValueOutOfRangeException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.wcdma.rbs.boam.common.log.MessageLog;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.proxies.EqcCableProxy;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.proxies.EqcRrhIndProxy;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EqcCableEventIndS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EqcCreateCableRspS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EqcGetOilCableParamRspS;
import se.ericsson.wcdma.rbs.boam.mao.alarm.MoAlarms;
import se.ericsson.wcdma.rbs.boam.mao.bcm.BoamManagedObjectWithAlarms;
import se.ericsson.wcdma.rbs.boam.mao.common.MaoHasFro;
import se.ericsson.wcdma.rbs.boam.mao.common.ValidateAttributes;
import se.ericsson.wcdma.rbs.boam.mao.event.MoEvents;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.AuxPlugInUnitMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.OpticalInterfaceLinkMo;

public class OpticalInterfaceLinkMoImpl
extends BoamManagedObjectWithAlarms
implements OpticalInterfaceLinkMo {
    private static final int NOT_APPLICABLE = 0;
    public static final int MO_DATA_REVISION = 2040001;
    public MoEvents myMoEvents;
    protected EqcRrhIndProxy eqcRrhIndProxy = EqcRrhIndProxy.instance();
    protected EqcCableProxy eqcCableProxy = EqcCableProxy.instance();

    public OpticalInterfaceLinkMoImpl(ManagedObject parent, String motypeName, AttrList attributes, String identity, Coordinator context, String userLabel, ManagedObject objectAConnectorRef, ManagedObject objectBConnectorRef, int objectAConnector, int objectBConnector, int alarmStatus) throws MoAccessException {
        super(parent, motypeName, identity, context);
        MessageLog.traceEnter(this.getClass(), " OpticalInterfaceLinkMoImpl Normal constructor");
        this.reserveMo(objectAConnectorRef, context);
        this.reserveMo(objectBConnectorRef, context);
        int objAFroId = 0;
        int objBFroId = 0;
        if (objectAConnectorRef instanceof PlugInUnitMo) {
            objAFroId = ((PlugInUnitMaoi)objectAConnectorRef).getFroId(context);
        } else if (objectAConnectorRef instanceof AuxPlugInUnitMo) {
            objAFroId = ((MaoHasFro)objectAConnectorRef).getFroId(context);
        }
        if (objectBConnectorRef instanceof PlugInUnitMo) {
            objBFroId = ((PlugInUnitMaoi)objectBConnectorRef).getFroId(context);
        } else if (objectBConnectorRef instanceof AuxPlugInUnitMo) {
            objBFroId = ((MaoHasFro)objectBConnectorRef).getFroId(context);
        }
        EqcCreateCableRspS rspSig = this.eqcCableProxy.createCable(this.getTxIdTransactional(context), 0L, 50164, 0L, objAFroId, objectAConnector, objBFroId, objectBConnector);
        int cableFroId = (int)rspSig.cableFroId;
        this.initMoData(userLabel, objectAConnectorRef, objectBConnectorRef, cableFroId, alarmStatus, context);
        this.addObservers(50164, context);
        MessageLog.trace(1, this.getClass(), this.getType() + " MO is Created ");
    }

    public OpticalInterfaceLinkMoImpl(MoData recoveredData) throws MoNameAlreadyTakenException {
        super(recoveredData);
        MessageLog.traceEnter(this.getClass(), " OpticalLinkInterfaceMoImpl Recovery constructor");
        this.myData = recoveredData;
        try {
            this.addObservers(50164, null);
        }
        catch (MoAccessException e) {
            MessageLog.traceError(this.getClass(), "Couldn't init the Observers!!");
        }
        MessageLog.trace(1, this.getClass(), "Mo recovered");
    }

    public static synchronized ManagedObject create(ManagedObject parent, AttrList attributes, String identity, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(OpticalInterfaceLinkMoImpl.class, "create()");
        OpticalInterfaceLinkMoImpl.checkTransaction(context);
        OpticalInterfaceLinkMoImpl.checkParent(parent);
        String checkedUserLabel = ValidateAttributes.checkAndGetStringAttribute(attributes, "userLabel", "optional", "", 0, 128, "OpticalInterfaceLink");
        String[] acceptedClasses = new String[]{"PlugInUnit", "AuxPlugInUnit"};
        ManagedObject checkedConnectedToObjectARef = ValidateAttributes.checkAndGetReferenceAttribute("connectedToObjectARef", attributes, "mandatory", acceptedClasses, "OpticalInterfaceLink");
        ManagedObject checkedConnectedToObjectBRef = ValidateAttributes.checkAndGetReferenceAttribute("connectedToObjectBRef", attributes, "mandatory", acceptedClasses, "OpticalInterfaceLink");
        int checkedObjectAConnector = ValidateAttributes.checkAndGetIntAttribute(attributes, "objectAConnector", "mandatory", 1, 1, 8, "OpticalInterfaceLink");
        switch (checkedObjectAConnector) {
            case 1: {
                checkedObjectAConnector = 36;
                break;
            }
            case 2: {
                checkedObjectAConnector = 51;
                break;
            }
            case 3: {
                checkedObjectAConnector = 45;
                break;
            }
            case 4: {
                checkedObjectAConnector = 86;
                break;
            }
            case 8: {
                checkedObjectAConnector = 89;
                break;
            }
            case 5: {
                checkedObjectAConnector = 74;
                break;
            }
            case 6: {
                checkedObjectAConnector = 75;
                break;
            }
            case 7: {
                checkedObjectAConnector = 76;
                break;
            }
            default: {
                MessageLog.trace(1, OpticalInterfaceLinkMoImpl.class, "Mub value out of range: objectAConnector = " + checkedObjectAConnector);
                throw new ValueOutOfRangeException("objectAConnector", "OpticalInterfaceLink");
            }
        }
        int checkedObjectBConnector = ValidateAttributes.checkAndGetIntAttribute(attributes, "objectBConnector", "mandatory", 1, 1, 8, "OpticalInterfaceLink");
        switch (checkedObjectBConnector) {
            case 1: {
                checkedObjectBConnector = 37;
                break;
            }
            case 2: {
                checkedObjectBConnector = 38;
                break;
            }
            case 3: {
                checkedObjectBConnector = 49;
                break;
            }
            case 4: {
                checkedObjectBConnector = 88;
                break;
            }
            case 8: {
                checkedObjectBConnector = 87;
                break;
            }
            case 5: {
                checkedObjectBConnector = 77;
                break;
            }
            case 6: {
                checkedObjectBConnector = 78;
                break;
            }
            case 7: {
                checkedObjectBConnector = 79;
                break;
            }
            default: {
                MessageLog.trace(1, OpticalInterfaceLinkMoImpl.class, "Mub value out of range: objectBConnector = " + checkedObjectBConnector);
                throw new ValueOutOfRangeException("objectBConnector", "OpticalInterfaceLink");
            }
        }
        OpticalInterfaceLinkMoImpl.checkConnectorsAndRef(checkedConnectedToObjectARef, checkedObjectAConnector, checkedConnectedToObjectBRef, checkedObjectBConnector, context);
        int checkedAlarmStatus = ValidateAttributes.checkAndGetIntAttribute(attributes, "alarmStatus", "optional", 0, ALARM_STATUS_MIN_VALUES, ALARM_STATUS_MAX_VALUES, "OpticalInterfaceLink");
        ValidateAttributes.checkOtherAttributes(attributes, "OpticalInterfaceLink");
        OpticalInterfaceLinkMoImpl createdMo = new OpticalInterfaceLinkMoImpl(parent, "OpticalInterfaceLink", attributes, identity, context, checkedUserLabel, checkedConnectedToObjectARef, checkedConnectedToObjectBRef, checkedObjectAConnector, checkedObjectBConnector, checkedAlarmStatus);
        return createdMo;
    }

    public void delete(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "delete()");
        this.myData.handleTransaction(context, MoData.WRITE_ACCESS);
        int froId = this.getFroId(context);
        this.eqcCableProxy.deleteCable(this.getTxIdTransactional(context), 0, froId, 50164);
        this.removeObservers(context);
        ManagedObject connectedToObjectARef = this.getConnectedToObjectARef(context);
        ManagedObject connectedToObjectBRef = this.getConnectedToObjectBRef(context);
        this.releaseMo(connectedToObjectARef, context);
        this.releaseMo(connectedToObjectBRef, context);
        super.delete(context);
        MessageLog.trace(1, this.getClass(), this.getType() + " Mo is Deleted ");
    }

    public String getType() {
        return "OpticalInterfaceLink";
    }

    public MoData getMyMoData() {
        MessageLog.traceEnter(this.getClass(), "getMyMoData()");
        return this.myData;
    }

    public boolean isMyMoDataPersistent() {
        MessageLog.traceEnter(this.getClass(), "isMyMoDataPersistent()");
        return true;
    }

    public int getObjectAConnector(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getObjectAConnector()<---");
        EqcGetOilCableParamRspS rspSig = this.eqcCableProxy.getOilCableParameters(this.getTxIdNonTransactional(context), 0, this.getFroId(context));
        int mubValue = 0;
        switch (rspSig.objectAConnectorId) {
            case 36: {
                mubValue = 1;
                break;
            }
            case 51: {
                mubValue = 2;
                break;
            }
            case 45: {
                mubValue = 3;
                break;
            }
            case 74: {
                mubValue = 5;
                break;
            }
            case 75: {
                mubValue = 6;
                break;
            }
            case 76: {
                mubValue = 7;
                break;
            }
            case 86: {
                mubValue = 4;
                break;
            }
            case 89: {
                mubValue = 8;
                break;
            }
            default: {
                MessageLog.trace(2, this.getClass(), "Warning : could not match EQMI ObjectAConnectorId to MUB value : " + rspSig.objectAConnectorId);
            }
        }
        return mubValue;
    }

    public int getObjectBConnector(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getObjectBConnector()<---");
        EqcGetOilCableParamRspS rspSig = this.eqcCableProxy.getOilCableParameters(this.getTxIdNonTransactional(context), 0, this.getFroId(context));
        int mubValue = 0;
        switch (rspSig.objectBConnectorId) {
            case 37: {
                mubValue = 1;
                break;
            }
            case 38: {
                mubValue = 2;
                break;
            }
            case 49: {
                mubValue = 3;
                break;
            }
            case 77: {
                mubValue = 5;
                break;
            }
            case 78: {
                mubValue = 6;
                break;
            }
            case 79: {
                mubValue = 7;
                break;
            }
            case 88: {
                mubValue = 4;
                break;
            }
            case 87: {
                mubValue = 8;
                break;
            }
            default: {
                MessageLog.trace(2, this.getClass(), "Warning : could not match EQMI ObjectBConnectorId to MUB value : " + rspSig.objectBConnectorId);
            }
        }
        return mubValue;
    }

    public ManagedObject getConnectedToObjectARef(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getConnectedToObjectARef()");
        ReferenceAttribute connectedToObjectARef = null;
        this.myData.handleTransaction(context, MoData.READ_ACCESS);
        connectedToObjectARef = (ReferenceAttribute)this.myData.getAttribute("connectedToObjectARef");
        return connectedToObjectARef.getValue(context);
    }

    public ManagedObject getConnectedToObjectBRef(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getConnectedToObjectBRef()");
        ReferenceAttribute connectedToObjectBRef = null;
        this.myData.handleTransaction(context, MoData.READ_ACCESS);
        connectedToObjectBRef = (ReferenceAttribute)this.myData.getAttribute("connectedToObjectBRef");
        return connectedToObjectBRef.getValue(context);
    }

    public String getUserLabel(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getUserLabel()");
        this.myData.handleTransaction(context, MoData.READ_ACCESS);
        StringAttribute userLabelAttr = (StringAttribute)this.myData.getAttribute("userLabel");
        return userLabelAttr.getValue(context);
    }

    public void setUserLabel(String value, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setUserLabel() ");
        this.myData.handleTransaction(context, MoData.WRITE_ACCESS);
        this.bcmSetStringAttribute("userLabel", value, 0, 128, this.getType(), context);
        this.sendAVC("userLabel", value, context);
    }

    public int getFroId(Coordinator context) {
        int froId = 0;
        MessageLog.traceEnter(this.getClass(), "getFroId()");
        try {
            froId = this.bcmGetIntAttribute("froId", context);
        }
        catch (MoAccessException moEx) {
            MessageLog.trace(2, this.getClass(), "OpticalInterfaceLink Cannot retrive FroId");
        }
        return froId;
    }

    private static void checkParent(ManagedObject parent) throws IllegalParentException {
        MessageLog.traceEnter(OpticalInterfaceLinkMoImpl.class, "checkParent()");
        if (parent == null || !(parent instanceof EquipmentMo)) {
            String msg = " Illegal parent, Expecting EquipmentMo, received for mo OpticalInterfaceLink";
            throw new IllegalParentException(msg);
        }
    }

    private void initMoData(String userLabel, ManagedObject aConnectorRef, ManagedObject bConnectorRef, int froId, int alarmStatus, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "initMoData() ");
        this.myData = new MoData(this.getLocalDistinguishedName(), this.getType(), true, context);
        this.myData.handleTransaction(context, MoData.WRITE_ACCESS);
        this.myData.setRevision(2040001);
        this.bcmStoreAndRegisterStringAttribute("userLabel", userLabel);
        this.bcmStoreAndRegisterReferenceAttribute("connectedToObjectARef", aConnectorRef);
        this.bcmStoreAndRegisterReferenceAttribute("connectedToObjectBRef", bConnectorRef);
        this.bcmStoreAndRegisterIntAttribute("froId", froId);
        this.initAlarmStatus(alarmStatus, context);
        this.myData.setRevision(2040001);
    }

    public void eventRaised(InSignal receiveSig) {
        MessageLog.traceEnter(this.getClass(), "eventRaised()");
        String objectClass = this.getType();
        String managedObjectInstance = this.getFullDistinguishedName();
        String eventType = "0";
        String eventTime = "";
        String additionalText = this.bcmGetMEUserLabel();
        if (receiveSig instanceof EqcCableEventIndS) {
            MessageLog.trace(6, this.getClass(), "EqcCableEventIndS received");
            EqcCableEventIndS recSig = (EqcCableEventIndS)receiveSig;
            String specificEvent = "";
            int eventSpec = recSig.cableEventType;
            if (eventSpec == 49159) {
                specificEvent = this.getType() + "_CableDelayChanged";
                AdditionalInfo[] additionalInfoList = new AdditionalInfo[]{new AdditionalInfo("OilDelayChanged", this.getFullDistinguishedName())};
                new Event(objectClass, managedObjectInstance, eventType, eventTime, specificEvent, additionalText, additionalInfoList);
            } else {
                MessageLog.trace(6, this.getClass(), "Unknown EventType received and ignored. EventType: " + recSig.cableEventType);
            }
        } else {
            MessageLog.trace(6, this.getClass(), "Unexpected signal is received and ignored. SigNo:" + receiveSig.toString());
        }
    }

    private static void checkConnectorsAndRef(ManagedObject aRef, int aRefCon, ManagedObject bRef, int bRefCon, Coordinator context) throws MoAccessException {
        if (aRef instanceof AuxPlugInUnitMo && bRef instanceof PlugInUnitMo) {
            if (aRefCon != 86 || bRefCon != 37 && bRefCon != 38 && bRefCon != 49 && bRefCon != 77 && bRefCon != 78 && bRefCon != 79) {
                throw new MoCanNotBeCreatedException("The connector values are not correct");
            }
        } else if (aRef instanceof PlugInUnitMo && bRef instanceof AuxPlugInUnitMo) {
            if (bRefCon != 88 || aRefCon != 36 && aRefCon != 51 && aRefCon != 45 && aRefCon != 74 && aRefCon != 75 && aRefCon != 76) {
                throw new MoCanNotBeCreatedException("The connector values are not correct");
            }
        } else if (aRef instanceof AuxPlugInUnitMo && bRef instanceof AuxPlugInUnitMo) {
            int aAueType = ((AuxPlugInUnitMo)aRef).getAuType(context);
            int bAueType = ((AuxPlugInUnitMo)bRef).getAuType(context);
            boolean incorrectConfig = true;
            if (aRefCon == 86 && bRefCon == 87) {
                if (!(aAueType != 10 && aAueType != 20 || bAueType != 10 && bAueType != 20)) {
                    incorrectConfig = false;
                }
            } else if (aRefCon == 89 && bRefCon == 88 && aAueType == 20 && (bAueType == 10 || bAueType == 20)) {
                incorrectConfig = false;
            }
            if (incorrectConfig) {
                throw new MoCanNotBeCreatedException("The connector values are not correct");
            }
        } else {
            throw new MoCanNotBeCreatedException("The Managed Objects connected to an Oil must be an AuxPlugInUnitMo and a PlugInUnitMo, or two AuxPlugInUnitMos");
        }
    }

    private void reserveMo(ManagedObject mo, Coordinator context) throws MoAccessException {
        if (mo instanceof PlugInUnitMo) {
            ((Reservable)mo).reserve((ManagedObject)this, context);
        } else if (mo instanceof AuxPlugInUnitMo) {
            ((Reservable)mo).reserve((ManagedObject)this, context);
        }
    }

    private void releaseMo(ManagedObject mo, Coordinator context) throws MoAccessException {
        if (mo instanceof PlugInUnitMo) {
            ((Reservable)mo).release((ManagedObject)this, context);
        } else if (mo instanceof AuxPlugInUnitMo) {
            ((Reservable)mo).release((ManagedObject)this, context);
        }
    }

    private void addObservers(int froType, Coordinator context) throws MoAccessException {
        this.myMoAlarms = new MoAlarms((ManagedObject)this, this.eqcRrhIndProxy, froType, this.getFroId(context), context);
        this.myMoEvents = new MoEvents(this, this.eqcRrhIndProxy, this.getFroId(context), context);
    }

    private void removeObservers(Coordinator context) throws MoAccessException {
        this.myMoAlarms.delete(context);
        this.myMoEvents.delete(context);
    }
}

