/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.mao.emo.cable;

import enea.ose.system.InSignal;
import se.ericsson.cello.equipment.PlugInUnitMo;
import se.ericsson.cello.faultmanagement.Event;
import se.ericsson.cello.mao.Reservable;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.AttrMissingAtCreateException;
import se.ericsson.cello.moframework.IllegalParentException;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoCanNotBeCreatedException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoFilter;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.MoRepository;
import se.ericsson.cello.moframework.UndeletableMoException;
import se.ericsson.cello.moframework.WrongAttributeTypeException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.wcdma.rbs.boam.common.MoEventable;
import se.ericsson.wcdma.rbs.boam.common.log.MessageLog;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.proxies.EqcCableProxy;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.proxies.EqcRrhIndProxy;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EqcCableEventIndS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EqcGetGammaCableParamRspS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EqcGetIctCableParamRspS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EqcGetIstCableParamRspS;
import se.ericsson.wcdma.rbs.boam.mao.alarm.MoAlarms;
import se.ericsson.wcdma.rbs.boam.mao.bcm.BoamHelper;
import se.ericsson.wcdma.rbs.boam.mao.bcm.BoamManagedObjectWithAlarms;
import se.ericsson.wcdma.rbs.boam.mao.common.MaoHasFro;
import se.ericsson.wcdma.rbs.boam.mao.common.MoTypeFilter;
import se.ericsson.wcdma.rbs.boam.mao.common.ValidateAttributes;
import se.ericsson.wcdma.rbs.boam.mao.emo.cable.RbsCableMo;
import se.ericsson.wcdma.rbs.boam.mao.emo.intf.BbifBoardMoImpl;
import se.ericsson.wcdma.rbs.boam.mao.event.MoEvents;

public abstract class RbsCableMoImpl
extends BoamManagedObjectWithAlarms
implements RbsCableMo,
MaoHasFro,
MoEventable {
    protected static final int SUP_CLIENT_ID = 0;
    protected static final String IDENTITY = "identity";
    protected static final String CABLE_FRO_ID = "cableFroId";
    protected static final String CABLE_TYPE = "cableType";
    private static final String USER_LABEL = "userLabel";
    private static final int USER_LABEL_MIN_LENGTH = 0;
    private static final int USER_LABEL_MAX_LENGTH = 128;
    private static final String BBIF_BOARD_REF = "bbifBoardRef";
    private static final String BBIF_CONNECTOR = "bbifConnector";
    private static final String RFIF_PLUG_IN_UNIT_REF = "rfifPlugInUnitRef";
    protected static final String RFIF_DEVICE_GROUP_REF = "rfifDeviceGroupRef";
    private static final String RFIF_CONNECTOR = "rfifConnector";
    private static final String ELECTRICAL_DELAY = "electricalDelay";
    private static final String ELECTRICAL_DL_DELAY = "electricalDlDelay";
    private static final String ELECTRICAL_UL_DELAY = "electricalUlDelay";
    private static final String TAG_RBS_EVENT_SR_SWITCH_CLK_SRC = "_SuccessfulRecoveryActionPerformedSwitchedClockSource";
    protected static final int GAMMA_RBS_1A = 1;
    protected static final int GAMMA_RBS_1B = 2;
    protected static final int INTER_SUB_TIMING_RBS_1C = 1;
    protected static final int INTER_SUB_TIMING_RBS_1D = 1;
    protected static final int INTRA_CAB_TIMING_RBS_1C = 1;
    protected static final int INTRA_CAB_TIMING_RBS_1D = 1;
    public static final int MO_DATA_REVISION = 1020001;
    protected EqcRrhIndProxy eqcRrhIndProxy = EqcRrhIndProxy.instance();
    protected EqcCableProxy eqcCableProxy = EqcCableProxy.instance();
    private MoEvents myMoEvents = null;

    public RbsCableMoImpl(ManagedObject parent, String thisMoName, String identity, Coordinator context, int maxNoOfChildren) throws MoAccessException {
        super(parent, thisMoName, identity, context, maxNoOfChildren);
        MessageLog.traceEnter(this.getClass(), "RbsCable Normal constructor");
        if (parent == null) {
            throw new IllegalParentException(thisMoName);
        }
        this.myData = new MoData(this.getLocalDistinguishedName(), this.getType(), true, context);
        this.myData.handleTransaction(context, MoData.WRITE_ACCESS);
        this.myData.setRevision(1020001);
    }

    public RbsCableMoImpl(MoData recoveredData) throws MoNameAlreadyTakenException {
        super(recoveredData);
        MessageLog.traceEnter(this.getClass(), " RbsCableMoImpl Recovery constructor");
        this.myData = recoveredData;
    }

    public void delete(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "delete()");
        if (this.isReserved(context)) {
            String msg = "MO is reserved and cannot be deleted";
            MessageLog.trace(1, this.getClass(), msg);
            throw new UndeletableMoException((ManagedObject)this);
        }
        this.myData.handleTransaction(context, MoData.WRITE_ACCESS);
        this.eqcCableProxy.deleteCable(this.getTxIdTransactional(context), 0, this.getCableFroId(context), this.getCableType());
        this.releaseReservation(BBIF_BOARD_REF, this.bcmGetReferenceAttribute(BBIF_BOARD_REF, context), context);
        this.releaseReservation(RFIF_PLUG_IN_UNIT_REF, this.bcmGetReferenceAttribute(RFIF_PLUG_IN_UNIT_REF, context), context);
        this.removeObservers(context);
        super.delete(context);
        MessageLog.trace(1, this.getClass(), this.getType() + " Mo is Deleted ");
    }

    public int getCableFroId(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getCableFroId()");
        return this.bcmGetIntAttribute(CABLE_FRO_ID, context);
    }

    public int getFroId(Coordinator context) {
        MessageLog.traceEnter(this.getClass(), "getFroId()");
        int froId = 0;
        try {
            froId = this.getCableFroId(context);
        }
        catch (Exception e) {
            MessageLog.traceError(this.getClass(), e.getMessage());
        }
        return froId;
    }

    public MoData getMyMoData() {
        MessageLog.traceEnter(this.getClass(), "getMyMoData()");
        return this.myData;
    }

    public boolean isMyMoDataPersistent() {
        MessageLog.traceEnter(this.getClass(), "isMyMoDataPersistent()");
        return true;
    }

    public String getUserLabel(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getUserLabel() ");
        return this.bcmGetStringAttribute(USER_LABEL, context);
    }

    public void setUserLabel(String value, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setUserLabel() ");
        this.bcmSetStringAttribute(USER_LABEL, value, 0, 128, this.getType(), context);
        this.sendAVC(USER_LABEL, value, context);
    }

    public ManagedObject getBbifBoardRef(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getBbifBoardRef()");
        return this.bcmGetReferenceAttribute(BBIF_BOARD_REF, context);
    }

    public ManagedObject getRfifPlugInUnitRef(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getRfifPlugInUnitRef()");
        return this.bcmGetReferenceAttribute(RFIF_PLUG_IN_UNIT_REF, context);
    }

    public void eventRaised(InSignal recSig) {
        MessageLog.traceEnter(this.getClass(), "eventRaised()");
        String objectClass = this.getType();
        String managedObjectInstance = this.getFullDistinguishedName();
        String eventType = "0";
        String eventTime = "";
        String specificEvent = "";
        if (recSig instanceof EqcCableEventIndS) {
            if (((EqcCableEventIndS)recSig).cableEventType != 49157) {
                MessageLog.traceError(this.getClass(), "Unknown event received");
                return;
            }
            specificEvent = this.getType() + TAG_RBS_EVENT_SR_SWITCH_CLK_SRC;
            MessageLog.trace(6, this.getClass(), "MO = " + objectClass + " specificEvent = _SuccessfulRecoveryActionPerformedSwitchedClockSource");
            String additionalText = this.bcmGetMEUserLabel();
            new Event(objectClass, managedObjectInstance, eventType, eventTime, specificEvent, additionalText, null);
            MessageLog.trace(6, this.getClass(), "Event raised MO = " + objectClass + " " + "eventType = " + eventType + " " + "specificEvent = " + specificEvent);
        }
    }

    protected static synchronized ManagedObject checkAndGetBbifBoardRef(AttrList attributes, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(RbsCableMoImpl.class, "checkAndGetBbifBoardRef");
        int index = attributes.indexOf(BBIF_BOARD_REF);
        if (index == -1) {
            MessageLog.trace(1, RbsCableMoImpl.class, "bbifBoardRef is not included in attribute list");
            throw new AttrMissingAtCreateException(BBIF_BOARD_REF, "RbsCableMoImpl");
        }
        if (!(attributes.getValue(index) instanceof BbifBoardMoImpl)) {
            MessageLog.trace(1, RbsCableMoImpl.class, "bbifBoardRef is of wrong type");
            throw new WrongAttributeTypeException(BBIF_BOARD_REF, "RbsCableMoImpl");
        }
        ManagedObject ref = (ManagedObject)attributes.getValue(index);
        attributes.removeElementAt(index);
        return ref;
    }

    protected static synchronized ManagedObject checkAndGetRfifPlugInUnitRef(AttrList attributes, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(RbsCableMoImpl.class, "checkAndGetRfifPlugInUnitRef");
        int index = attributes.indexOf(RFIF_PLUG_IN_UNIT_REF);
        if (index == -1) {
            MessageLog.trace(1, RbsCableMoImpl.class, "rfifPlugInUnitRef is not included in attribute list");
            throw new AttrMissingAtCreateException(RFIF_PLUG_IN_UNIT_REF, "RbsCableMoImpl");
        }
        if (!(attributes.getValue(index) instanceof PlugInUnitMo)) {
            MessageLog.trace(1, RbsCableMoImpl.class, "rfifPlugInUnitRef is of wrong type");
            throw new WrongAttributeTypeException(RFIF_PLUG_IN_UNIT_REF, "RbsCableMoImpl");
        }
        ManagedObject ref = (ManagedObject)attributes.getValue(index);
        attributes.removeElementAt(index);
        return ref;
    }

    protected abstract int getCableType();

    protected ManagedObject checkPreconditionsGetRfifDeviceGroupRef(ManagedObject rfifPlugInUnitRef, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "checkPreconditionsGetRfifDeviceGroupRef()");
        ManagedObject iterMoRef = null;
        MoIterator iter = MoRepository.instance().select(rfifPlugInUnitRef, 1, (MoFilter)new MoTypeFilter("RfifDeviceGroup"));
        if (iter.size() == 0) {
            iter = BoamHelper.findMOs("DeviceGroup", "RFIF", rfifPlugInUnitRef, 1);
        }
        if (iter.size() == 0) {
            String msg = "RfifDeviceGroupMo does not exist ) ";
            MessageLog.trace(1, this.getClass(), msg);
            throw new MoCanNotBeCreatedException(msg);
        }
        while (iter.hasMoreElements()) {
            iterMoRef = iter.nextMo();
        }
        return iterMoRef;
    }

    protected int getRoValue(Coordinator context, int cableType, String valueType, int minValue, int maxValue) throws MoAccessException {
        int[] minValueAsArray = new int[]{minValue};
        int[] maxValueAsArray = new int[]{maxValue};
        return this.getRoValue(context, cableType, valueType, minValueAsArray, maxValueAsArray);
    }

    protected int getRoValue(Coordinator context, int cableType, String valueType, int[] minValues, int[] maxValues) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), " getRoValue() " + valueType);
        this.myData.handleTransaction(context, MoData.READ_ACCESS);
        int value = 0;
        switch (cableType) {
            case 50158: {
                EqcGetIstCableParamRspS rspSig1 = this.eqcCableProxy.getIstCableParameters(this.getTxIdNonTransactional(context), 0, this.getCableFroId(context));
                if (valueType.equals(BBIF_CONNECTOR)) {
                    value = rspSig1.bbifConnectorId;
                    if (value == 3) {
                        value = 1;
                        break;
                    }
                    MessageLog.trace(2, this.getClass(), "incorrect ro value");
                    break;
                }
                if (valueType.equals(RFIF_CONNECTOR)) {
                    value = rspSig1.rfifConnectorId;
                    if (value == 2) {
                        value = 1;
                        break;
                    }
                    MessageLog.trace(2, this.getClass(), "incorrect ro value");
                    break;
                }
                if (valueType.equals(ELECTRICAL_DL_DELAY)) {
                    value = rspSig1.electricalDlDelay;
                    break;
                }
                MessageLog.trace(2, this.getClass(), " Fault, should never happen ");
                break;
            }
            case 50159: {
                EqcGetIctCableParamRspS rspSig2 = this.eqcCableProxy.getIctCableParameters(this.getTxIdNonTransactional(context), 0, this.getCableFroId(context));
                if (valueType.equals(BBIF_CONNECTOR)) {
                    value = rspSig2.bbifConnectorId;
                    if (value == 2) {
                        value = 1;
                        break;
                    }
                    MessageLog.trace(2, this.getClass(), "incorrect ro value");
                    break;
                }
                if (valueType.equals(RFIF_CONNECTOR)) {
                    value = rspSig2.rfifConnectorId;
                    if (value == 3) {
                        value = 1;
                        break;
                    }
                    MessageLog.trace(2, this.getClass(), "incorrect ro value");
                    break;
                }
                if (valueType.equals(ELECTRICAL_UL_DELAY)) {
                    value = rspSig2.electricalUlDelay;
                    break;
                }
                MessageLog.trace(2, this.getClass(), " Fault, should never happen ");
                break;
            }
            default: {
                EqcGetGammaCableParamRspS rspSig3 = this.eqcCableProxy.getGammaCableParameters(this.getTxIdNonTransactional(context), 0, this.getCableFroId(context));
                if (valueType.equals(BBIF_CONNECTOR)) {
                    value = rspSig3.bbifConnectorId;
                    if (value == 0) {
                        value = 1;
                        break;
                    }
                    if (value == 1) {
                        value = 2;
                        break;
                    }
                    MessageLog.trace(2, this.getClass(), "incorrect ro value");
                    break;
                }
                if (valueType.equals(RFIF_CONNECTOR)) {
                    value = rspSig3.rfifConnectorId;
                    if (value == 0) {
                        value = 1;
                        break;
                    }
                    if (value == 1) {
                        value = 2;
                        break;
                    }
                    MessageLog.trace(2, this.getClass(), "incorrect ro value");
                    break;
                }
                if (valueType.equals(ELECTRICAL_DELAY)) {
                    value = rspSig3.electricalDelay;
                    break;
                }
                MessageLog.trace(2, this.getClass(), " Fault, should never happen ");
            }
        }
        ValidateAttributes.intValueRangeCheck(valueType, value, minValues, maxValues, this.getType());
        return value;
    }

    protected void setRoValue(Coordinator context, int cableType, int validParameter, String attrType, int value, int[] minValues, int[] maxValues) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), " setRoValue(), validParameter = " + validParameter);
        ValidateAttributes.intValueRangeCheck(attrType, value, minValues, maxValues, this.getType());
        this.myData.handleTransaction(context, MoData.WRITE_ACCESS);
        switch (cableType) {
            case 50158: {
                this.eqcCableProxy.setIstCableParameters(this.getTxIdTransactional(context), 0, this.getCableFroId(context), validParameter, value);
                break;
            }
            case 50159: {
                this.eqcCableProxy.setIctCableParameters(this.getTxIdTransactional(context), 0, this.getCableFroId(context), validParameter, value);
                break;
            }
            default: {
                this.eqcCableProxy.setGammaCableParameters(this.getTxIdTransactional(context), 0L, this.getCableFroId(context), validParameter, value);
            }
        }
    }

    protected void setReservation(String refName, ManagedObject moRef, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), " setReservation ");
        if (moRef != null) {
            ((Reservable)moRef).reserve((ManagedObject)this, context);
        } else {
            String msg = refName + " MO to be reserved is missing ";
            MessageLog.trace(2, this.getClass(), msg);
        }
    }

    protected void releaseReservation(String refName, ManagedObject moRef, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), " releaseReservation() ");
        if (moRef != null) {
            ((Reservable)moRef).release((ManagedObject)this, context);
        } else {
            String msg = refName + " MO to be released is missing ";
            MessageLog.trace(2, this.getClass(), msg);
        }
    }

    protected void addObservers(int froType, Coordinator context) throws MoAccessException {
        this.myMoAlarms = new MoAlarms((ManagedObject)this, this.eqcRrhIndProxy, froType, this.getFroId(context), context);
        this.myMoEvents = new MoEvents(this, this.eqcRrhIndProxy, this.getFroId(context), context);
    }

    protected void removeObservers(Coordinator context) throws MoAccessException {
        this.myMoAlarms.delete(context);
        this.myMoEvents.delete(context);
    }
}

