/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.mao.emo.power;

import enea.ose.system.InSignal;
import se.ericsson.cello.faultmanagement.AdditionalInfo;
import se.ericsson.cello.faultmanagement.Event;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoHasChildrenException;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.ReferenceAttribute;
import se.ericsson.cello.moframework.SequenceAttribute;
import se.ericsson.cello.moframework.ValueOutOfRangeException;
import se.ericsson.cello.moframework.WrongAttributeTypeException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.InactiveTransactionException;
import se.ericsson.wcdma.rbs.boam.common.AvailabilityStatusIntToEnum;
import se.ericsson.wcdma.rbs.boam.common.FroNotAccessibleException;
import se.ericsson.wcdma.rbs.boam.common.FroRequestFailedException;
import se.ericsson.wcdma.rbs.boam.common.log.MessageLog;
import se.ericsson.wcdma.rbs.boam.fpx.common.FroAttribute;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.proxies.EcPowerProxy;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.LrsCreatePossRspS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.LrsPossBattEventIndS;
import se.ericsson.wcdma.rbs.boam.mao.alarm.MoAlarms;
import se.ericsson.wcdma.rbs.boam.mao.bcm.BoamHelper;
import se.ericsson.wcdma.rbs.boam.mao.bcm.BoamManagedObject;
import se.ericsson.wcdma.rbs.boam.mao.bcm.BoamManagedObjectWithAlarms;
import se.ericsson.wcdma.rbs.boam.mao.common.ValidateAttributes;
import se.ericsson.wcdma.rbs.boam.mao.event.MoEvents;
import se.ericsson.wcdma.rbs.boam.mao.iface.gen.excep.BatteryNotConnectedException;
import se.ericsson.wcdma.rbs.boam.mao.iface.gen.excep.BatteryNotFullyChargedException;
import se.ericsson.wcdma.rbs.boam.mao.iface.gen.excep.OperationNotAllowedException;
import se.ericsson.wcdma.rbs.boam.mao.iface.gen.excep.ParameterValueErrorException;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.AcDeviceMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.BfDeviceMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.PowerSupplySystemMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.PsDeviceMo;

public class PowerSupplySystemMoImpl
extends BoamManagedObjectWithAlarms
implements PowerSupplySystemMo {
    private static final Class SELF = PowerSupplySystemMoImpl.class;
    private static final String POWER_SUPPLY_SYSTEM_FRO_ID = "powerSupplySystemFroId";
    private static final int PSS_MAX_NO_OF_CHILDREN = 1;
    private static final String TAG_LRS_POSS_BATTERY_TEST_RESULT = "_BatteryTestResult";
    public static final int MO_DATA_REVISION = 3020001;
    private final EcPowerProxy roProxy = EcPowerProxy.instance();
    private MoEvents myMoEvents;

    public PowerSupplySystemMoImpl(ManagedObject parent, String motypeName, String identity, Coordinator context, String userLabel, int systemOvervoltageAlarmLevel, int systemOvervoltageAlarmCeaseOffset, int systemUndervoltageAlarmLevel, int systemUndervoltageAlarmCeaseOffset, int batteryOvertempAlarmLevel, int batteryOvertempAlarmCeaseOffset, int tempDisconnect, int tempDisconnectCeaseOffset, int undervoltageDisconnectCeaseOffset, int mainLoadUndervoltageDisconnect, int priorityLoadUndervoltageDisconnect, int batteryTestEnable, int secureTransmEnable, int secureTransmBatteryBackupTimeLimit, String cyclicBattTestStartTime, int monthBatteryTest, int checkedAlarmStatus) throws MoAccessException {
        super(parent, motypeName, identity, context, 1);
        MessageLog.traceEnter(SELF, " PowerSupplySystemMoImpl()");
        MessageLog.traceEnter(SELF, " PowerSupplySystemMoImpl() try, before initMoData()");
        this.initMoData(identity, userLabel, checkedAlarmStatus, context);
        MessageLog.traceEnter(SELF, " PowerSupplySystemMoImpl() befor createRo");
        int possFroId = this.createRo(systemOvervoltageAlarmLevel, systemOvervoltageAlarmCeaseOffset, systemUndervoltageAlarmLevel, systemUndervoltageAlarmCeaseOffset, batteryOvertempAlarmLevel, batteryOvertempAlarmCeaseOffset, tempDisconnect, tempDisconnectCeaseOffset, undervoltageDisconnectCeaseOffset, mainLoadUndervoltageDisconnect, priorityLoadUndervoltageDisconnect, batteryTestEnable, secureTransmEnable, secureTransmBatteryBackupTimeLimit, cyclicBattTestStartTime, monthBatteryTest, context);
        this.bcmStoreAndRegisterIntAttribute(POWER_SUPPLY_SYSTEM_FRO_ID, possFroId);
        this.addObservers(81, context);
    }

    public PowerSupplySystemMoImpl(MoData recoveredData) throws MoNameAlreadyTakenException {
        super(recoveredData);
        MessageLog.traceEnter(SELF, " PowerSupplySystemMoImpl()");
        this.myData = recoveredData;
        SequenceAttribute psDeviceRefSequence = (SequenceAttribute)this.myData.getAttribute("psDeviceRef");
        if (psDeviceRefSequence == null) {
            MessageLog.traceError(SELF, "Recovered attribute psDeviceRef is null");
        }
        try {
            this.addObservers(81, null);
        }
        catch (MoAccessException e) {
            MessageLog.traceError(SELF, "Couldn't init the Observers!!");
        }
        MessageLog.trace(1, SELF, "Mo recovered");
    }

    public static synchronized ManagedObject create(ManagedObject parent, AttrList attributes, String identity, ManagedObject source, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(PowerSupplySystemMoImpl.class, "create()");
        ValidateAttributes.checkTransaction(context);
        ValidateAttributes.checkParent(parent, "Equipment");
        String checkedUserLabel = ValidateAttributes.checkAndGetStringAttribute(attributes, "userLabel", "optional", "", 0, 128, "PowerSupplySystem");
        int checkedPowerSupplySystemOvervoltageAlarmLevel = ValidateAttributes.checkAndGetIntAttribute(attributes, "systemOvervoltageAlarmLevel", "optional", -570, SYSTEM_OVERVOLTAGE_ALARM_LEVEL_MIN_VALUES, SYSTEM_OVERVOLTAGE_ALARM_LEVEL_MAX_VALUES, "PowerSupplySystem");
        int checkedPowerSupplySystemOvervoltageAlarmCeaseOffset = ValidateAttributes.checkAndGetIntAttribute(attributes, "systemOvervoltageAlarmCeaseOffset", "optional", 5, SYSTEM_OVERVOLTAGE_ALARM_CEASE_OFFSET_MIN_VALUES, SYSTEM_OVERVOLTAGE_ALARM_CEASE_OFFSET_MAX_VALUES, "PowerSupplySystem");
        int checkedPowerSupplySystemUndervoltageAlarmLevel = ValidateAttributes.checkAndGetIntAttribute(attributes, "systemUndervoltageAlarmLevel", "optional", -440, SYSTEM_UNDERVOLTAGE_ALARM_LEVEL_MIN_VALUES, SYSTEM_UNDERVOLTAGE_ALARM_LEVEL_MAX_VALUES, "PowerSupplySystem");
        int checkedPowerSupplySystemUndervoltageAlarmCeaseOffset = ValidateAttributes.checkAndGetIntAttribute(attributes, "systemUndervoltageAlarmCeaseOffset", "optional", 30, SYSTEM_UNDERVOLTAGE_ALARM_CEASE_OFFSET_MIN_VALUES, SYSTEM_UNDERVOLTAGE_ALARM_CEASE_OFFSET_MAX_VALUES, "PowerSupplySystem");
        int checkedPowerSupplyBatteryOvertempAlarmLevel = ValidateAttributes.checkAndGetIntAttribute(attributes, "batteryOvertempAlarmLevel", "optional", 58, BATTERY_OVERTEMP_ALARM_LEVEL_MIN_VALUES, BATTERY_OVERTEMP_ALARM_LEVEL_MAX_VALUES, "PowerSupplySystem");
        int checkedPowerSupplyBatteryOvertempAlarmCeaseOffset = ValidateAttributes.checkAndGetIntAttribute(attributes, "batteryOvertempAlarmCeaseOffset", "optional", 5, BATTERY_OVERTEMP_ALARM_CEASE_OFFSET_MIN_VALUES, BATTERY_OVERTEMP_ALARM_CEASE_OFFSET_MAX_VALUES, "PowerSupplySystem");
        int checkedPowerSupplyTempDisconnect = ValidateAttributes.checkAndGetIntAttribute(attributes, "temperatureDisconnect", "optional", 60, TEMPERATURE_DISCONNECT_MIN_VALUES, TEMPERATURE_DISCONNECT_MAX_VALUES, "PowerSupplySystem");
        int checkedPowerSupplyTempDisconnectCeaseOffset = ValidateAttributes.checkAndGetIntAttribute(attributes, "temperatureDisconnectCeaseOffset", "optional", 5, TEMPERATURE_DISCONNECT_CEASE_OFFSET_MIN_VALUES, TEMPERATURE_DISCONNECT_CEASE_OFFSET_MAX_VALUES, "PowerSupplySystem");
        int checkedPowerSupplyUndervoltageDisconnectCeaseOffset = ValidateAttributes.checkAndGetIntAttribute(attributes, "undervoltageDisconnectCeaseOffset", "optional", 40, UNDERVOLTAGE_DISCONNECT_CEASE_OFFSET_MIN_VALUES, UNDERVOLTAGE_DISCONNECT_CEASE_OFFSET_MAX_VALUES, "PowerSupplySystem");
        int checkedPowerSupplyMainLoadUndervoltageDisconnect = ValidateAttributes.checkAndGetIntAttribute(attributes, "mainLoadUndervoltageDisconnect", "optional", -410, MAIN_LOAD_UNDERVOLTAGE_DISCONNECT_MIN_VALUES, MAIN_LOAD_UNDERVOLTAGE_DISCONNECT_MAX_VALUES, "PowerSupplySystem");
        int checkedPowerSupplyPriorityLoadUndervoltageDisconnect = ValidateAttributes.checkAndGetIntAttribute(attributes, "priorityLoadUndervoltageDisconnect", "optional", -405, PRIORITY_LOAD_UNDERVOLTAGE_DISCONNECT_MIN_VALUES, PRIORITY_LOAD_UNDERVOLTAGE_DISCONNECT_MAX_VALUES, "PowerSupplySystem");
        int checkedPowerSupplyBatteryTestEnable = ValidateAttributes.checkAndGetBooleanAttribute(attributes, "batteryTestEnable", "optional", false, false, true, "PowerSupplySystem") ? 1 : 0;
        int checkedPowerSupplySecureTransmEnable = ValidateAttributes.checkAndGetBooleanAttribute(attributes, "secureTransmEnable", "optional", false, false, true, "PowerSupplySystem") ? 1 : 0;
        int checkedPowerSupplySecureTransmBatteryBackupTimeLimit = ValidateAttributes.checkAndGetIntAttribute(attributes, "secureTransmBatteryBackupTimeLimit", "optional", 30, SECURE_TRANSM_BATTERY_BACKUP_TIME_LIMIT_MIN_VALUES, SECURE_TRANSM_BATTERY_BACKUP_TIME_LIMIT_MAX_VALUES, "PowerSupplySystem");
        String checkedPowerSupplyCyclicBattTestStartTime = ValidateAttributes.checkAndGetStringAttribute(attributes, "cyclicBattTestStartTime", "optional", "03:00", 5, 5, "PowerSupplySystem");
        int checkedPowerSupplyMonthBatteryTest = ValidateAttributes.checkAndGetIntAttribute(attributes, "monthBatteryTest", "optional", 2340, MONTH_BATTERY_TEST_MIN_VALUES, MONTH_BATTERY_TEST_MAX_VALUES, "PowerSupplySystem");
        int checkedAlarmStatus = ValidateAttributes.checkAndGetIntAttribute(attributes, "alarmStatus", "optional", 0, ALARM_STATUS_MIN_VALUES, ALARM_STATUS_MAX_VALUES, "PowerSupplySystem");
        ValidateAttributes.checkOtherAttributes(attributes, "PowerSupplySystem");
        PowerSupplySystemMoImpl createdMo = new PowerSupplySystemMoImpl(parent, "PowerSupplySystem", identity, context, checkedUserLabel, checkedPowerSupplySystemOvervoltageAlarmLevel, checkedPowerSupplySystemOvervoltageAlarmCeaseOffset, checkedPowerSupplySystemUndervoltageAlarmLevel, checkedPowerSupplySystemUndervoltageAlarmCeaseOffset, checkedPowerSupplyBatteryOvertempAlarmLevel, checkedPowerSupplyBatteryOvertempAlarmCeaseOffset, checkedPowerSupplyTempDisconnect, checkedPowerSupplyTempDisconnectCeaseOffset, checkedPowerSupplyUndervoltageDisconnectCeaseOffset, checkedPowerSupplyMainLoadUndervoltageDisconnect, checkedPowerSupplyPriorityLoadUndervoltageDisconnect, checkedPowerSupplyBatteryTestEnable, checkedPowerSupplySecureTransmEnable, checkedPowerSupplySecureTransmBatteryBackupTimeLimit, checkedPowerSupplyCyclicBattTestStartTime, checkedPowerSupplyMonthBatteryTest, checkedAlarmStatus);
        return createdMo;
    }

    public void delete(Coordinator c) throws MoAccessException, MoHasChildrenException {
        MessageLog.traceEnter(SELF, "delete() ");
        this.myData.handleTransaction(c, MoData.WRITE_ACCESS);
        this.roProxy.deleteRo(new FroAttribute[]{new FroAttribute("froId", this.getFroId(c))}, "PowerSupplySystem", c);
        this.releaseOneDeviceMo("acDeviceRef", c);
        this.releaseOneDeviceMo("bfDeviceRef", c);
        SequenceAttribute psDeviceRefSequence = (SequenceAttribute)this.myData.getAttribute("psDeviceRef");
        this.releaseDeviceMos(psDeviceRefSequence, c);
        this.removeObservers(c);
        super.delete(c);
        MessageLog.trace(1, SELF, this.getType() + " Mo is Deleted ");
    }

    public int getPowerSupplySystemFroId(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(SELF, "getPowerSupplySystemFroId()");
        return this.bcmGetIntAttribute(POWER_SUPPLY_SYSTEM_FRO_ID, context);
    }

    public String getType() {
        return "PowerSupplySystem";
    }

    public void eventRaised(InSignal receiveSig) {
        MessageLog.traceEnter(SELF, "eventRaised()");
        if (receiveSig instanceof LrsPossBattEventIndS) {
            String sReson;
            MessageLog.trace(6, SELF, " LrsPossBattEventIndS received ");
            String objectClass = this.getType();
            String managedObjectInstance = this.getFullDistinguishedName();
            String eventType = "0";
            String eventTime = "";
            String additionalText = this.bcmGetMEUserLabel();
            LrsPossBattEventIndS recSig = (LrsPossBattEventIndS)receiveSig;
            String specificEvent = "";
            AdditionalInfo[] additionalInfoList = new AdditionalInfo[3];
            if (recSig.eventType == 49752) {
                specificEvent = this.getType() + TAG_LRS_POSS_BATTERY_TEST_RESULT;
                MessageLog.trace(6, SELF, "MO = " + objectClass + " specificEvent = _BatteryTestResult");
                sReson = "";
                if (recSig.startReason == 0) {
                    sReson = "Initial ";
                } else if (recSig.startReason == 1) {
                    sReson = "Manually ";
                } else if (recSig.startReason == 2) {
                    sReson = "Automatic ";
                } else if (recSig.startReason == 3) {
                    sReson = "AC failure ";
                } else {
                    MessageLog.traceError(SELF, "Parameter startReason in EQMI signal LrsPossBattEventIndS is " + sReson + " it should be 0-3 ");
                }
            } else {
                MessageLog.traceError(SELF, "Unknown eventType received");
                return;
            }
            int dischargedCapacity = recSig.dischargedCapacity;
            int batteryBackupTime = recSig.batteryBackupTime;
            additionalInfoList[0] = new AdditionalInfo("Start reason, ", sReson);
            additionalInfoList[1] = new AdditionalInfo("Battery capacity ", Integer.toString(dischargedCapacity) + " Ah");
            additionalInfoList[2] = new AdditionalInfo("Backup battery time ", Integer.toString(batteryBackupTime) + " min");
            MessageLog.trace(6, SELF, " Start reason " + sReson);
            MessageLog.trace(6, SELF, " Battery capacity = " + dischargedCapacity);
            MessageLog.trace(6, SELF, " Backup battery time = " + batteryBackupTime);
            new Event(objectClass, managedObjectInstance, eventType, eventTime, specificEvent, additionalText, additionalInfoList);
            MessageLog.trace(6, SELF, " Event has been sent to Cello, AdditionalInfo[1] = " + additionalInfoList[0]);
            MessageLog.trace(6, SELF, " Event has been sent to Cello, AdditionalInfo[2] = " + additionalInfoList[1]);
            MessageLog.trace(6, SELF, " Event has been sent to Cello, AdditionalInfo[3] = " + additionalInfoList[2]);
        }
    }

    public void allocPossDevice(ManagedObject devMo, int devFroId, int devType, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(SELF, "allocPossDevice():  ");
        this.myData.handleTransaction(context, MoData.WRITE_ACCESS);
        this.roProxy.allocatePossDevice(this.getTxIdTransactional(context), 0, devFroId, devType);
        if (devType == 11) {
            MessageLog.trace(1, SELF, " setting acDeviceRef");
            ((ReferenceAttribute)this.myData.getAttribute("acDeviceRef")).setValue(devMo);
            ((AcDeviceMo)devMo).reserve(this, context);
        } else if (devType == 10) {
            MessageLog.trace(1, SELF, " setting bfDeviceRef");
            ((ReferenceAttribute)this.myData.getAttribute("bfDeviceRef")).setValue(devMo);
            ((BfDeviceMo)devMo).reserve(this, context);
        }
        if (devType == 9) {
            MessageLog.trace(1, SELF, " adding one device to psDeviceRef");
            SequenceAttribute psDeviceRefSequence = (SequenceAttribute)this.myData.getAttribute("psDeviceRef");
            ReferenceAttribute attribute = new ReferenceAttribute("psDeviceRef", false, devMo);
            psDeviceRefSequence.addElement((Attribute)attribute);
            ((PsDeviceMo)devMo).reserve(this, context);
        }
    }

    public void deallocPossDevice(ManagedObject devMo, int devFroId, int devType, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(SELF, "deallocPossDevice():  ");
        this.myData.handleTransaction(context, MoData.WRITE_ACCESS);
        this.roProxy.deallocatePossDevice(this.getTxIdTransactional(context), 0, devFroId, devType);
        if (devType == 11) {
            MessageLog.trace(1, SELF, " resetting acDeviceRef");
            ((ReferenceAttribute)this.myData.getAttribute("acDeviceRef")).setValue(null);
            ((AcDeviceMo)devMo).release(this, context);
        } else if (devType == 10) {
            MessageLog.trace(1, SELF, " resetting bfDeviceRef");
            ((ReferenceAttribute)this.myData.getAttribute("bfDeviceRef")).setValue(null);
            ((BfDeviceMo)devMo).release(this, context);
        }
        if (devType == 9) {
            MessageLog.trace(1, SELF, " removing a device from psDeviceRef");
            SequenceAttribute psDeviceRefSequence = (SequenceAttribute)this.myData.getAttribute("psDeviceRef");
            Attribute[] attributes = psDeviceRefSequence.getValue(context);
            for (int i = 0; i < attributes.length; ++i) {
                MessageLog.trace(1, SELF, i + " removing a device from " + "psDeviceRef");
                ReferenceAttribute refAttr = (ReferenceAttribute)attributes[i];
                ManagedObject mo = refAttr.getValue(context);
                if (mo == null || !(mo instanceof PsDeviceMo) || ((PsDeviceMo)mo).getAuxDeviceFroId(context) != devFroId) continue;
                psDeviceRefSequence.removeElement(attributes[i]);
                ((PsDeviceMo)devMo).release(this, context);
            }
        }
    }

    public MoData getMyMoData() {
        MessageLog.traceEnter(SELF, "getMyMoData()");
        return this.myData;
    }

    public boolean isMyMoDataPersistent() {
        MessageLog.traceEnter(SELF, "isMyMoDataPersistent()");
        return true;
    }

    public String getPowerSupplySystemId(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(SELF, "getPowerSupplySystemId()");
        return super.bcmGetIdentity(this.getLocalDistinguishedName(), context);
    }

    public String getUserLabel(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(SELF, "getUserLabel()");
        return this.bcmGetStringAttribute("userLabel", context);
    }

    public void setUserLabel(String value, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(SELF, "setUserLabel()");
        this.bcmSetStringAttribute("userLabel", value, 0, 128, this.getType(), context);
        this.sendAVC("userLabel", value, context);
    }

    public int getMainPrioCurrentLoad(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(SELF, "getMainPrioCurrentLoad()");
        return (Integer)this.roProxy.getRo(new FroAttribute[]{new FroAttribute("froId", this.getFroId(context))}, "mainPrioCurrentLoad", "PowerSupplySystem", context);
    }

    public int getSystemPowerLoad(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(SELF, "getSystemPowerLoad()");
        return (Integer)this.roProxy.getRo(new FroAttribute[]{new FroAttribute("froId", this.getFroId(context))}, "systemPowerLoad", "PowerSupplySystem", context);
    }

    public int getBatteryCurrent(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(SELF, "getBatteryCurrent()");
        return (Integer)this.roProxy.getRo(new FroAttribute[]{new FroAttribute("froId", this.getFroId(context))}, "batteryCurrent", "PowerSupplySystem", context);
    }

    public int getSystemVoltage(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(SELF, "getSystemVoltage()");
        return (Integer)this.roProxy.getRo(new FroAttribute[]{new FroAttribute("froId", this.getFroId(context))}, "systemVoltage", "PowerSupplySystem", context);
    }

    public int getBatteryVoltage(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(SELF, "getBatteryVoltage()");
        return (Integer)this.roProxy.getRo(new FroAttribute[]{new FroAttribute("froId", this.getFroId(context))}, "batteryVoltage", "PowerSupplySystem", context);
    }

    public int getSystemOvervoltageAlarmLevel(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(SELF, "getSystemOvervoltageAlarmLevel()");
        return (Integer)this.roProxy.getRo(new FroAttribute[]{new FroAttribute("froId", this.getFroId(context))}, "systemOvervoltageAlarmLevel", "PowerSupplySystem", context);
    }

    public void setSystemOvervoltageAlarmLevel(int value, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(SELF, "setSystemOvervoltageAlarmLevel()");
        ValidateAttributes.intValueRangeCheck("systemOvervoltageAlarmLevel", value, PowerSupplySystemMo.SYSTEM_OVERVOLTAGE_ALARM_LEVEL_MIN_VALUES, PowerSupplySystemMo.SYSTEM_OVERVOLTAGE_ALARM_LEVEL_MAX_VALUES, "PowerSupplySystem");
        this.roProxy.setRo(new FroAttribute[]{new FroAttribute("paramId", 0), new FroAttribute("value", value), new FroAttribute("froId", this.getFroId(context))}, "PowerSupplySystem", context);
        this.sendAVC("systemOvervoltageAlarmLevel", value, context);
    }

    public int getSystemOvervoltageAlarmCeaseOffset(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(SELF, "getSystemOvervoltageAlarmCeaseOffset()");
        return (Integer)this.roProxy.getRo(new FroAttribute[]{new FroAttribute("froId", this.getFroId(context))}, "systemOvervoltageAlarmCeaseOffset", "PowerSupplySystem", context);
    }

    public void setSystemOvervoltageAlarmCeaseOffset(int value, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(SELF, "setSystemOvervoltageAlarmCeaseOffset()");
        ValidateAttributes.intValueRangeCheck("systemOvervoltageAlarmCeaseOffset", value, PowerSupplySystemMo.SYSTEM_OVERVOLTAGE_ALARM_CEASE_OFFSET_MIN_VALUES, PowerSupplySystemMo.SYSTEM_OVERVOLTAGE_ALARM_CEASE_OFFSET_MAX_VALUES, "PowerSupplySystem");
        this.roProxy.setRo(new FroAttribute[]{new FroAttribute("paramId", 1), new FroAttribute("value", value), new FroAttribute("froId", this.getFroId(context))}, "PowerSupplySystem", context);
        this.sendAVC("systemOvervoltageAlarmCeaseOffset", value, context);
    }

    public int getSystemUndervoltageAlarmLevel(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(SELF, "getSystemUndervoltageAlarmLevel()");
        return (Integer)this.roProxy.getRo(new FroAttribute[]{new FroAttribute("froId", this.getFroId(context))}, "systemUndervoltageAlarmLevel", "PowerSupplySystem", context);
    }

    public void setSystemUndervoltageAlarmLevel(int value, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(SELF, "setSystemUndervoltageAlarmLevel()");
        ValidateAttributes.intValueRangeCheck("systemUndervoltageAlarmLevel", value, PowerSupplySystemMo.SYSTEM_UNDERVOLTAGE_ALARM_LEVEL_MIN_VALUES, PowerSupplySystemMo.SYSTEM_UNDERVOLTAGE_ALARM_LEVEL_MAX_VALUES, "PowerSupplySystem");
        this.roProxy.setRo(new FroAttribute[]{new FroAttribute("paramId", 2), new FroAttribute("value", value), new FroAttribute("froId", this.getFroId(context))}, "PowerSupplySystem", context);
        this.sendAVC("systemUndervoltageAlarmLevel", value, context);
    }

    public int getSystemUndervoltageAlarmCeaseOffset(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(SELF, "getSystemUndervoltageAlarmCeaseOffset()");
        return (Integer)this.roProxy.getRo(new FroAttribute[]{new FroAttribute("froId", this.getFroId(context))}, "systemUndervoltageAlarmCeaseOffset", "PowerSupplySystem", context);
    }

    public void setSystemUndervoltageAlarmCeaseOffset(int value, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(SELF, "setSystemUndervoltageAlarmCeaseOffset()");
        ValidateAttributes.intValueRangeCheck("systemUndervoltageAlarmCeaseOffset", value, PowerSupplySystemMo.SYSTEM_UNDERVOLTAGE_ALARM_CEASE_OFFSET_MIN_VALUES, PowerSupplySystemMo.SYSTEM_UNDERVOLTAGE_ALARM_CEASE_OFFSET_MAX_VALUES, "PowerSupplySystem");
        this.roProxy.setRo(new FroAttribute[]{new FroAttribute("paramId", 3), new FroAttribute("value", value), new FroAttribute("froId", this.getFroId(context))}, "PowerSupplySystem", context);
        this.sendAVC("systemUndervoltageAlarmCeaseOffset", value, context);
    }

    public int getBatteryOvertempAlarmLevel(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(SELF, "getBatteryOvertempAlarmLevel()");
        return (Integer)this.roProxy.getRo(new FroAttribute[]{new FroAttribute("froId", this.getFroId(context))}, "batteryOvertempAlarmLevel", "PowerSupplySystem", context);
    }

    public void setBatteryOvertempAlarmLevel(int value, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(SELF, "setBatteryOvertempAlarmLevel()");
        ValidateAttributes.intValueRangeCheck("batteryOvertempAlarmLevel", value, PowerSupplySystemMo.BATTERY_OVERTEMP_ALARM_LEVEL_MIN_VALUES, PowerSupplySystemMo.BATTERY_OVERTEMP_ALARM_LEVEL_MAX_VALUES, "PowerSupplySystem");
        this.roProxy.setRo(new FroAttribute[]{new FroAttribute("paramId", 4), new FroAttribute("value", value), new FroAttribute("froId", this.getFroId(context))}, "PowerSupplySystem", context);
        this.sendAVC("batteryOvertempAlarmLevel", value, context);
    }

    public int getBatteryOvertempAlarmCeaseOffset(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(SELF, "getBatteryOvertempAlarmCeaseOffset()");
        return (Integer)this.roProxy.getRo(new FroAttribute[]{new FroAttribute("froId", this.getFroId(context))}, "batteryOvertempAlarmCeaseOffset", "PowerSupplySystem", context);
    }

    public void setBatteryOvertempAlarmCeaseOffset(int value, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(SELF, "setBatteryOvertempAlarmCeaseOffset()");
        ValidateAttributes.intValueRangeCheck("batteryOvertempAlarmCeaseOffset", value, PowerSupplySystemMo.BATTERY_OVERTEMP_ALARM_CEASE_OFFSET_MIN_VALUES, PowerSupplySystemMo.BATTERY_OVERTEMP_ALARM_CEASE_OFFSET_MAX_VALUES, "PowerSupplySystem");
        this.roProxy.setRo(new FroAttribute[]{new FroAttribute("paramId", 5), new FroAttribute("value", value), new FroAttribute("froId", this.getFroId(context))}, "PowerSupplySystem", context);
        this.sendAVC("batteryOvertempAlarmCeaseOffset", value, context);
    }

    public int getTemperatureDisconnect(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(SELF, "getTemperatureDisconnect()");
        return (Integer)this.roProxy.getRo(new FroAttribute[]{new FroAttribute("froId", this.getFroId(context))}, "temperatureDisconnect", "PowerSupplySystem", context);
    }

    public void setTemperatureDisconnect(int value, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(SELF, "setTemperatureDisconnect()");
        ValidateAttributes.intValueRangeCheck("temperatureDisconnect", value, PowerSupplySystemMo.TEMPERATURE_DISCONNECT_MIN_VALUES, PowerSupplySystemMo.TEMPERATURE_DISCONNECT_MAX_VALUES, "PowerSupplySystem");
        this.roProxy.setRo(new FroAttribute[]{new FroAttribute("paramId", 6), new FroAttribute("value", value), new FroAttribute("froId", this.getFroId(context))}, "PowerSupplySystem", context);
        this.sendAVC("temperatureDisconnect", value, context);
    }

    public int getTemperatureDisconnectCeaseOffset(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(SELF, "getTemperatureDisconnectCeaseOffset()");
        return (Integer)this.roProxy.getRo(new FroAttribute[]{new FroAttribute("froId", this.getFroId(context))}, "temperatureDisconnectCeaseOffset", "PowerSupplySystem", context);
    }

    public void setTemperatureDisconnectCeaseOffset(int value, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(SELF, "setTemperatureDisconnectCeaseOffset()");
        ValidateAttributes.intValueRangeCheck("temperatureDisconnectCeaseOffset", value, PowerSupplySystemMo.TEMPERATURE_DISCONNECT_CEASE_OFFSET_MIN_VALUES, PowerSupplySystemMo.TEMPERATURE_DISCONNECT_CEASE_OFFSET_MAX_VALUES, "PowerSupplySystem");
        this.roProxy.setRo(new FroAttribute[]{new FroAttribute("paramId", 7), new FroAttribute("value", value), new FroAttribute("froId", this.getFroId(context))}, "PowerSupplySystem", context);
        this.sendAVC("temperatureDisconnectCeaseOffset", value, context);
    }

    public int getUndervoltageDisconnectCeaseOffset(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(SELF, "getUndervoltageDisconnectCeaseOffset()");
        return (Integer)this.roProxy.getRo(new FroAttribute[]{new FroAttribute("froId", this.getFroId(context))}, "undervoltageDisconnectCeaseOffset", "PowerSupplySystem", context);
    }

    public void setUndervoltageDisconnectCeaseOffset(int value, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(SELF, "setUndervoltageDisconnectCeaseOffset()");
        ValidateAttributes.intValueRangeCheck("undervoltageDisconnectCeaseOffset", value, PowerSupplySystemMo.UNDERVOLTAGE_DISCONNECT_CEASE_OFFSET_MIN_VALUES, PowerSupplySystemMo.UNDERVOLTAGE_DISCONNECT_CEASE_OFFSET_MAX_VALUES, "PowerSupplySystem");
        this.roProxy.setRo(new FroAttribute[]{new FroAttribute("paramId", 8), new FroAttribute("value", value), new FroAttribute("froId", this.getFroId(context))}, "PowerSupplySystem", context);
        this.sendAVC("undervoltageDisconnectCeaseOffset", value, context);
    }

    public int getMainLoadUndervoltageDisconnect(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(SELF, "getMainLoadUndervoltageDisconnect()");
        return (Integer)this.roProxy.getRo(new FroAttribute[]{new FroAttribute("froId", this.getFroId(context))}, "mainLoadUndervoltageDisconnect", "PowerSupplySystem", context);
    }

    public void setMainLoadUndervoltageDisconnect(int value, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(SELF, "setMainLoadUndervoltageDisconnect()");
        ValidateAttributes.intValueRangeCheck("mainLoadUndervoltageDisconnect", value, PowerSupplySystemMo.MAIN_LOAD_UNDERVOLTAGE_DISCONNECT_MIN_VALUES, PowerSupplySystemMo.MAIN_LOAD_UNDERVOLTAGE_DISCONNECT_MAX_VALUES, "PowerSupplySystem");
        this.roProxy.setRo(new FroAttribute[]{new FroAttribute("paramId", 9), new FroAttribute("value", value), new FroAttribute("froId", this.getFroId(context))}, "PowerSupplySystem", context);
        this.sendAVC("mainLoadUndervoltageDisconnect", value, context);
    }

    public int getPriorityLoadUndervoltageDisconnect(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(SELF, "getPriorityLoadUndervoltageDisconnect()");
        return (Integer)this.roProxy.getRo(new FroAttribute[]{new FroAttribute("froId", this.getFroId(context))}, "priorityLoadUndervoltageDisconnect", "PowerSupplySystem", context);
    }

    public void setPriorityLoadUndervoltageDisconnect(int value, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(SELF, "setPriorityLoadUndervoltageDisconnect()");
        ValidateAttributes.intValueRangeCheck("priorityLoadUndervoltageDisconnect", value, PowerSupplySystemMo.PRIORITY_LOAD_UNDERVOLTAGE_DISCONNECT_MIN_VALUES, PowerSupplySystemMo.PRIORITY_LOAD_UNDERVOLTAGE_DISCONNECT_MAX_VALUES, "PowerSupplySystem");
        this.roProxy.setRo(new FroAttribute[]{new FroAttribute("paramId", 10), new FroAttribute("value", value), new FroAttribute("froId", this.getFroId(context))}, "PowerSupplySystem", context);
        this.sendAVC("priorityLoadUndervoltageDisconnect", value, context);
    }

    public boolean getBatteryTestEnable(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(SELF, "getBatteryTestEnable()");
        return (Boolean)this.roProxy.getRo(new FroAttribute[]{new FroAttribute("froId", this.getFroId(context))}, "batteryTestEnable", "PowerSupplySystem", context);
    }

    public void setBatteryTestEnable(boolean enableValue, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(SELF, "setBatteryTestEnable()");
        this.roProxy.setRo(new FroAttribute[]{new FroAttribute("paramId", 11), new FroAttribute("value", enableValue ? 1 : 0), new FroAttribute("froId", this.getFroId(context))}, "PowerSupplySystem", context);
        this.sendAVC("batteryTestEnable", enableValue, context);
    }

    public boolean getSecureTransmEnable(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(SELF, "getSecureTransmEnable()");
        return (Boolean)this.roProxy.getRo(new FroAttribute[]{new FroAttribute("froId", this.getFroId(context))}, "secureTransmEnable", "PowerSupplySystem", context);
    }

    public void setSecureTransmEnable(boolean enableValue, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(SELF, "setSecureTransmEnable()");
        this.roProxy.setRo(new FroAttribute[]{new FroAttribute("paramId", 12), new FroAttribute("value", enableValue ? 1 : 0), new FroAttribute("froId", this.getFroId(context))}, "PowerSupplySystem", context);
        this.sendAVC("secureTransmEnable", enableValue, context);
    }

    public int getSecureTransmBatteryBackupTimeLimit(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(SELF, "getSecureTransmBatteryBackupTimeLimit()");
        return (Integer)this.roProxy.getRo(new FroAttribute[]{new FroAttribute("froId", this.getFroId(context))}, "secureTransmBatteryBackupTimeLimit", "PowerSupplySystem", context);
    }

    public void setSecureTransmBatteryBackupTimeLimit(int value, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(SELF, "setSecureTransmBatteryBackupTimeLimit()");
        ValidateAttributes.intValueRangeCheck("secureTransmBatteryBackupTimeLimit", value, PowerSupplySystemMo.SECURE_TRANSM_BATTERY_BACKUP_TIME_LIMIT_MIN_VALUES, PowerSupplySystemMo.SECURE_TRANSM_BATTERY_BACKUP_TIME_LIMIT_MAX_VALUES, "PowerSupplySystem");
        this.roProxy.setRo(new FroAttribute[]{new FroAttribute("paramId", 13), new FroAttribute("value", value), new FroAttribute("froId", this.getFroId(context))}, "PowerSupplySystem", context);
        this.sendAVC("secureTransmBatteryBackupTimeLimit", value, context);
    }

    public String getCyclicBattTestStartTime(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(SELF, "getCyclicBattTestStartTime() ");
        int resultInt = (Integer)this.roProxy.getRo(new FroAttribute[]{new FroAttribute("froId", this.getFroId(context))}, "cyclicBattTestStartTime", "PowerSupplySystem", context);
        MessageLog.trace(2, SELF, "resultInt = " + resultInt);
        String resultStr = PowerSupplySystemMoImpl.minutsIntToTimeString(resultInt);
        MessageLog.trace(2, SELF, "String to be get = " + resultStr);
        return resultStr;
    }

    public void setCyclicBattTestStartTime(String s, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(SELF, "setCyclicBattTestStartTime() ");
        if (s.length() != 5 || s.charAt(2) != ':') {
            String msg = "attribute has wrong format. It should be (00:00) ";
            MessageLog.trace(2, SELF, msg);
            throw new WrongAttributeTypeException(msg, this.getType());
        }
        int value = this.timeStringToMinutsInt(s);
        String minValueString = "00:00";
        String maxValueString = "23:59";
        ValidateAttributes.intValueRangeCheck("cyclicBattTestStartTime", value, this.timeStringToMinutsInt("00:00"), this.timeStringToMinutsInt("23:59"), "PowerSupplySystem");
        this.roProxy.setRo(new FroAttribute[]{new FroAttribute("paramId", 14), new FroAttribute("value", value), new FroAttribute("froId", this.getFroId(context))}, "PowerSupplySystem", context);
        this.sendAVC("cyclicBattTestStartTime", s, context);
    }

    public int getMonthBatteryTest(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(SELF, "getMonthBatteryTest()");
        return (Integer)this.roProxy.getRo(new FroAttribute[]{new FroAttribute("froId", this.getFroId(context))}, "monthBatteryTest", "PowerSupplySystem", context);
    }

    public void setMonthBatteryTest(int value, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(SELF, "setMonthBatteryTest()");
        ValidateAttributes.intValueRangeCheck("monthBatteryTest", value, PowerSupplySystemMo.MONTH_BATTERY_TEST_MIN_VALUES, PowerSupplySystemMo.MONTH_BATTERY_TEST_MAX_VALUES, "PowerSupplySystem");
        this.roProxy.setRo(new FroAttribute[]{new FroAttribute("paramId", 15), new FroAttribute("value", value), new FroAttribute("froId", this.getFroId(context))}, "PowerSupplySystem", context);
        this.sendAVC("monthBatteryTest", value, context);
    }

    public int getOperationalState(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(SELF, "getOperationalState()");
        return (Integer)this.roProxy.getRo(new FroAttribute[]{new FroAttribute("froId", this.getFroId(context))}, "operationalState", "PowerSupplySystem", context);
    }

    public int getAvailabilityStatus(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(SELF, "getAvailabilityStatus()");
        return AvailabilityStatusIntToEnum.convGetAvailStatIntToEnum((Integer)this.roProxy.getRo(new FroAttribute[]{new FroAttribute("froId", this.getFroId(context))}, "availabilityStatus", "PowerSupplySystem", context));
    }

    public ManagedObject[] getPsDeviceRef(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(SELF, "getPsDeviceRef() ");
        SequenceAttribute psDeviceRefSequence = (SequenceAttribute)this.myData.getAttribute("psDeviceRef");
        return this.getMoRefArr(psDeviceRefSequence, context);
    }

    public ManagedObject getBfDeviceRef(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(SELF, "getBfDeviceRef() ");
        return this.bcmGetReferenceAttribute("bfDeviceRef", context);
    }

    public ManagedObject getAcDeviceRef(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(SELF, "getAcDeviceRef() ");
        return this.bcmGetReferenceAttribute("acDeviceRef", context);
    }

    public void actionStartBatteryTest(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(SELF, "actionStartBatteryTest()");
        this.myData.handleTransaction(context, MoData.READ_ACCESS);
        try {
            this.roProxy.actionWriteAccessRo(null, "actionStartBatteryTest", "PowerSupplySystem", context);
        }
        catch (FroRequestFailedException e) {
            MessageLog.trace(2, SELF, "FroRequestFailed error");
            if (e.getOrgErrorCode() == 5) {
                throw new BatteryNotConnectedException();
            }
            if (e.getOrgErrorCode() == 6) {
                throw new BatteryNotFullyChargedException();
            }
            if (e.getOrgErrorCode() == 1) {
                throw new ParameterValueErrorException();
            }
            if (e.getOrgErrorCode() == 7) {
                throw new OperationNotAllowedException();
            }
            MessageLog.trace(2, SELF, "Unknown exception tag: " + e.getErrorCode());
            throw e;
        }
        catch (FroNotAccessibleException e) {
            MessageLog.trace(2, SELF, "FroNotAccessibleException caught - nothing is done");
        }
    }

    public void actionStopBatteryTest(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(SELF, "actionStopBatteryTest()");
        this.myData.handleTransaction(context, MoData.READ_ACCESS);
        this.roProxy.actionWriteAccessRo(null, "actionStopBatteryTest", "PowerSupplySystem", context);
    }

    private int createRo(int systemOvervoltageAlarmLevel, int systemOvervoltageAlarmCeaseOffset, int systemUndervoltageAlarmLevel, int systemUndervoltageAlarmCeaseOffset, int batteryOvertempAlarmLevel, int batteryOvertempAlarmCeaseOffset, int tempDisconnect, int tempDisconnectCeaseOffset, int undervoltageDisconnectCeaseOffset, int mainLoadUndervoltageDisconnect, int priorityLoadUndervoltageDisconnect, int batteryTestEnable, int secureTransmEnable, int secureTransmBatteryBackupTimeLimit, String cyclicBattTestStartTime, int monthBatteryTest, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(SELF, " createRo() ");
        int cyclicBattTestStartTimeInt = this.timeStringToMinutsInt(cyclicBattTestStartTime);
        LrsCreatePossRspS cfmSig = (LrsCreatePossRspS)this.roProxy.createRo(new FroAttribute[]{new FroAttribute("systemOvervoltageAlarmLevel", systemOvervoltageAlarmLevel), new FroAttribute("systemOvervoltageAlarmCeaseOffset", systemOvervoltageAlarmCeaseOffset), new FroAttribute("systemUndervoltageAlarmLevel", systemUndervoltageAlarmLevel), new FroAttribute("systemUndervoltageAlarmCeaseOffset", systemUndervoltageAlarmCeaseOffset), new FroAttribute("batteryOvertempAlarmLevel", batteryOvertempAlarmLevel), new FroAttribute("batteryOvertempAlarmCeaseOffset", batteryOvertempAlarmCeaseOffset), new FroAttribute("temperatureDisconnect", tempDisconnect), new FroAttribute("temperatureDisconnectCeaseOffset", tempDisconnectCeaseOffset), new FroAttribute("undervoltageDisconnectCeaseOffset", undervoltageDisconnectCeaseOffset), new FroAttribute("mainLoadUndervoltageDisconnect", mainLoadUndervoltageDisconnect), new FroAttribute("priorityLoadUndervoltageDisconnect", priorityLoadUndervoltageDisconnect), new FroAttribute("batteryTestEnable", batteryTestEnable), new FroAttribute("secureTransmEnable", secureTransmEnable), new FroAttribute("secureTransmBatteryBackupTimeLimit", secureTransmBatteryBackupTimeLimit), new FroAttribute("cyclicBattTestStartTime", cyclicBattTestStartTimeInt), new FroAttribute("monthBatteryTest", monthBatteryTest)}, "PowerSupplySystem", context);
        this.myData.handleTransaction(context, MoData.WRITE_ACCESS);
        try {
            if (cfmSig.noOfBfDev > 0) {
                BoamManagedObject bfDevice = (BoamManagedObject)BoamHelper.getMoForFroId("BfDevice", cfmSig.bfDevFroId);
                this.bcmSetReferenceAttribute("bfDeviceRef", (ManagedObject)bfDevice, this.getType(), context);
                bfDevice.reserve(this, context);
            }
            if (cfmSig.noOfAcDev > 0) {
                BoamManagedObject acDevice = (BoamManagedObject)BoamHelper.getMoForFroId("AcDevice", cfmSig.acDevFroId);
                this.bcmSetReferenceAttribute("acDeviceRef", (ManagedObject)acDevice, this.getType(), context);
                acDevice.reserve(this, context);
            }
            SequenceAttribute psDeviceRefSequence = (SequenceAttribute)this.myData.getAttribute("psDeviceRef");
            for (int ind = 0; ind < cfmSig.noOfPsDev; ++ind) {
                BoamManagedObject psDevice = (BoamManagedObject)BoamHelper.getMoForFroId("PsDevice", cfmSig.psDevFroIds[ind]);
                ReferenceAttribute psDevMoRef = new ReferenceAttribute("psDeviceRef", false);
                psDevMoRef.setValue((ManagedObject)psDevice);
                psDeviceRefSequence.addElement((Attribute)psDevMoRef);
                psDevice.reserve(this, context);
            }
        }
        catch (MoAccessException e) {
            try {
                context.rollbackOnly();
            }
            catch (InactiveTransactionException e1) {
                // empty catch block
            }
            throw e;
        }
        MessageLog.trace(1, SELF, " RO is created ");
        return cfmSig.possFroId;
    }

    private void releaseOneDeviceMo(String attrName, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(SELF, "releaseOneDeviceMo() ");
        ManagedObject moRef = this.bcmGetReferenceAttribute(attrName, context);
        if (moRef != null) {
            ((BoamManagedObject)moRef).release(this, context);
        } else {
            String msg = "Device to be released is missing ";
            MessageLog.trace(1, SELF, msg);
        }
    }

    private void releaseDeviceMos(SequenceAttribute MoRefAttrList, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(SELF, "releaseDeviceMos() ");
        ManagedObject[] moRef = this.getMoRefArr(MoRefAttrList, context);
        for (int i = 0; i < moRef.length; ++i) {
            if (moRef[i] == null) continue;
            ((BoamManagedObject)moRef[i]).release(this, context);
        }
    }

    private ManagedObject[] getMoRefArr(SequenceAttribute MoRefAttrList, Coordinator context) throws MoAccessException {
        this.myData.handleTransaction(context, MoData.READ_ACCESS);
        Attribute[] attrList = MoRefAttrList.getValue(context);
        int length = attrList.length;
        ManagedObject[] moRefList = new ManagedObject[length];
        for (int i = 0; i < length; ++i) {
            moRefList[i] = ((ReferenceAttribute)attrList[i]).getValue(context);
        }
        return moRefList;
    }

    private void initMoData(String identity, String userLabel, int checkedAlarmStatus, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(SELF, "initMoData() ");
        this.myData = new MoData(this.getLocalDistinguishedName(), this.getType(), true, context);
        this.myData.handleTransaction(context, MoData.WRITE_ACCESS);
        this.bcmStoreAndRegisterStringAttribute("userLabel", userLabel);
        this.bcmStoreAndRegisterReferenceAttribute("acDeviceRef", null);
        this.bcmStoreAndRegisterReferenceAttribute("bfDeviceRef", null);
        SequenceAttribute psDeviceRefSequence = new SequenceAttribute("psDeviceRef", false);
        this.myData.registerPersistentAttr((Attribute)psDeviceRefSequence);
        this.initAlarmStatus(checkedAlarmStatus, context);
        this.myData.setRevision(3020001);
    }

    public int getFroId(Coordinator context) {
        MessageLog.traceEnter(SELF, "getFroId()");
        try {
            return this.bcmGetIntAttribute(POWER_SUPPLY_SYSTEM_FRO_ID, context);
        }
        catch (MoAccessException e) {
            MessageLog.traceError(SELF, "Can't find froId", e);
            return -1;
        }
    }

    private int timeStringToMinutsInt(String time) throws MoAccessException {
        if (time.length() < 5) {
            String msg = "attribute string is to short.";
            MessageLog.trace(2, SELF, msg);
            throw new ValueOutOfRangeException(msg, this.getType());
        }
        String hourStr = time.substring(0, 2);
        String minuteStr = time.substring(3, 5);
        int hours = Integer.parseInt(hourStr);
        int minutes = Integer.parseInt(minuteStr);
        if (minutes < 60 && hours < 24) {
            int dayMinutes = hours * 60 + minutes;
            MessageLog.trace(2, SELF, "Time(minutes) in format int = " + dayMinutes);
            return dayMinutes;
        }
        String msg = "attribute has value out of range. Hours should be between 0 and 23. Minutes should be between 0 and 59 ";
        MessageLog.trace(2, SELF, msg);
        throw new ValueOutOfRangeException(msg, this.getType());
    }

    private static String minutsIntToTimeString(int dayMinuts) throws MoAccessException {
        int hours = dayMinuts / 60;
        int minuts = dayMinuts % 60;
        String result2 = (hours < 10 ? "0" : "") + hours + ":" + (minuts < 10 ? "0" : "") + minuts;
        MessageLog.trace(2, SELF, "Time in string format = " + result2);
        return result2;
    }

    protected void addObservers(int froType, Coordinator context) throws MoAccessException {
        this.myMoAlarms = new MoAlarms((ManagedObject)this, this.roProxy, froType, this.getPowerSupplySystemFroId(context), context);
        this.myMoEvents = new MoEvents(this, this.roProxy, -6, context);
    }

    protected void removeObservers(Coordinator context) throws MoAccessException {
        this.myMoAlarms.delete(context);
        this.myMoEvents.delete(context);
    }
}

