/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.mao.rmo.antenna;

import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.AttrMissingAtCreateException;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.MoNotFoundException;
import se.ericsson.cello.moframework.NotHandledAttributeTypeException;
import se.ericsson.cello.moframework.UndeletableMoException;
import se.ericsson.cello.moframework.ValueOutOfRangeException;
import se.ericsson.cello.moframework.WrongAttributeTypeException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.InactiveTransactionException;
import se.ericsson.wcdma.rbs.boam.common.log.MessageLog;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.proxies.EqcAntennaBranchProxy;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EqcCreateAbRspS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EqcGetAbParamRspS;
import se.ericsson.wcdma.rbs.boam.fpx.scmi.proxies.ScRfAccessProxy;
import se.ericsson.wcdma.rbs.boam.fpx.scmi.sigs.LrsRfapGetParamAbRspS;
import se.ericsson.wcdma.rbs.boam.mao.alarm.MoAlarms;
import se.ericsson.wcdma.rbs.boam.mao.bcm.BoamManagedObject;
import se.ericsson.wcdma.rbs.boam.mao.bcm.BoamManagedObjectWithAlarms;
import se.ericsson.wcdma.rbs.boam.mao.common.ConfigNotSupportedException;
import se.ericsson.wcdma.rbs.boam.mao.common.MaoHasFro;
import se.ericsson.wcdma.rbs.boam.mao.common.ValidateAttributes;
import se.ericsson.wcdma.rbs.boam.mao.iface.gen.enumer.SupervisionState;
import se.ericsson.wcdma.rbs.boam.mao.iface.gen.excep.CellHaveBeenSetupByRncException;
import se.ericsson.wcdma.rbs.boam.mao.iface.gen.excep.FrequencyBandNotSupportedException;
import se.ericsson.wcdma.rbs.boam.mao.iface.gen.gmo.GenSectorMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.AntennaBranchMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.RetDeviceMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.SectorAntennaMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.SectorMo;
import se.ericsson.wcdma.rbs.boam.mao.rmo.antenna.AntennaBranchMoFactory;
import se.ericsson.wcdma.rbs.boam.mao.rmo.antenna.FqBandRanges;
import se.ericsson.wcdma.rbs.boam.mao.rmo.cell.SectorMoAdditional;
import se.ericsson.wcdma.rbs.boam.pms.impl.MoScanner;
import se.ericsson.wcdma.rbs.boam.pms.impl.PmsException;

public class AntennaBranchMoImpl
extends BoamManagedObjectWithAlarms
implements AntennaBranchMo {
    public static final Class SELF = AntennaBranchMoImpl.class;
    public static final String RF_ACCESS_POINT_FROID = "rfAccessPointFroId";
    public static final String AB_FRO_ID = "abFroId";
    private static final int ANTENNA_BRANCH_MAX_NO_OF_CHILDREN = 4;
    public static final int MO_DATA_REVISION = 6040700;
    private final EqcAntennaBranchProxy eqcAntennaBranchProxy = EqcAntennaBranchProxy.instance();
    private final ScRfAccessProxy scRfAccessProxy = ScRfAccessProxy.instance();
    private final MoScanner myScanner;

    private AntennaBranchMoImpl(ManagedObject parent, String motypeName, String identity, Coordinator context, String checkedUserLabel, String checkedBranchName, int checkedAntennaSupervisionThreshold, int checkedMechanicalAntennaTilt, int checkedFqBandHighEdge, int checkedFqBandLowEdge, int checkedAlarmStatus, int lowCurrentSupervision) throws MoAccessException {
        super(parent, motypeName, identity, context, 4);
        MessageLog.traceEnter(SELF, "AntennaBranchMoImpl()");
        ManagedObject sector = ((SectorAntennaMo)parent).getReservedBy(context)[0];
        int sectorFroId = ((MaoHasFro)sector).getFroId(context);
        EqcCreateAbRspS eqcSig = this.eqcAntennaBranchProxy.createAb(this.getTxIdTransactional(context), 0, sectorFroId, this.getIntForBranchName(checkedBranchName), ((MaoHasFro)parent).getFroId(context), lowCurrentSupervision);
        int abFroId = (int)eqcSig.abFroId;
        int rfAccessPointFroId = ((SectorMoAdditional)sector).getRfAccessPointFroId(context);
        this.initMoData(checkedUserLabel, abFroId, context, rfAccessPointFroId, checkedMechanicalAntennaTilt, checkedFqBandHighEdge, checkedAlarmStatus, checkedFqBandLowEdge);
        int antennaType = ((SectorAntennaMo)parent).getAntennaType(context);
        this.scRfAccessProxy.rfapCreateAb(this.getTxIdTransactional(context), 0, rfAccessPointFroId, this.getIntForBranchName(checkedBranchName), checkedAntennaSupervisionThreshold, antennaType, checkedFqBandHighEdge, checkedFqBandLowEdge);
        this.myScanner = this.createMoScanner(false, context);
        this.addObservers(100, context);
        MessageLog.trace(1, SELF, "AntennaBranch MO is Created ");
    }

    public AntennaBranchMoImpl(MoData recoveredData) throws MoNameAlreadyTakenException {
        super(recoveredData);
        MessageLog.traceEnter(SELF, "AntennaBranchMoImpl()");
        this.myData = recoveredData;
        this.myScanner = this.createMoScanner();
        try {
            this.addObservers(100, null);
        }
        catch (MoAccessException e) {
            MessageLog.traceError(SELF, "Couldn't init the Observers!!");
        }
        MessageLog.trace(1, SELF, "version attribute in MoData: " + this.myData.getRevision());
        MessageLog.trace(1, SELF, "AntennaBranch MO is restored");
    }

    public static synchronized ManagedObject create(ManagedObject parent, AttrList attributes, String identity, ManagedObject source, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(SELF, "create()");
        ValidateAttributes.checkTransaction(context);
        ValidateAttributes.checkParent(parent, "SectorAntenna");
        int lowCurrentSupervision = ValidateAttributes.checkAndGetIntAttribute(attributes, "lowCurrentSupervision", "optional", 1, 0, 1, "AntennaBranch");
        String checkedUserLabel = ValidateAttributes.checkAndGetStringAttribute(attributes, "userLabel", "optional", "", 0, 128, "AntennaBranch");
        String checkedBranchName = ValidateAttributes.checkAndGetStringAttribute(attributes, "branchName", "mandatory", "", 1, 1, "AntennaBranch");
        ValidateAttributes.stringValueInSetCheck("branchName", checkedBranchName, BRANCH_NAME_VALID_VALUES, "AntennaBranch");
        int checkedAlarmStatus = ValidateAttributes.checkAndGetIntAttribute(attributes, "alarmStatus", "optional", 0, ALARM_STATUS_MIN_VALUES, ALARM_STATUS_MAX_VALUES, "AntennaBranch");
        int checkedAntennaSupervisionThreshold = ValidateAttributes.checkAndGetIntAttribute(attributes, "antennaSupervisionThreshold", "optional", 0, ANTENNA_SUPERVISION_THRESHOLD_MIN_VALUES, ANTENNA_SUPERVISION_THRESHOLD_MAX_VALUES, "AntennaBranch");
        int checkedMechanicalAntennaTilt = ValidateAttributes.checkAndGetIntAttribute(attributes, "mechanicalAntennaTilt", "optional", 0, MECHANICAL_ANTENNA_TILT_MIN_VALUES, MECHANICAL_ANTENNA_TILT_MAX_VALUES, "AntennaBranch");
        int checkedFqBandHighEdge = AntennaBranchMoImpl.checkAndGetFqBandAttribue(attributes, "fqBandHighEdge", "AntennaBranch", context);
        int checkedFqBandLowEdge = AntennaBranchMoImpl.checkAndGetFqBandAttribue(attributes, "fqBandLowEdge", "AntennaBranch", context);
        AntennaBranchMoImpl.checkFrequencyBand(checkedFqBandLowEdge, checkedFqBandHighEdge);
        ValidateAttributes.checkOtherAttributes(attributes, "AntennaBranch");
        AntennaBranchMoImpl createdMo = new AntennaBranchMoImpl(parent, "AntennaBranch", identity, context, checkedUserLabel, checkedBranchName, checkedAntennaSupervisionThreshold, checkedMechanicalAntennaTilt, checkedFqBandHighEdge, checkedFqBandLowEdge, checkedAlarmStatus, lowCurrentSupervision);
        return createdMo;
    }

    private void initMoData(String checkedUserLabel, int abFroId, Coordinator context, int rfAccessPointFroId, int checkedMechanicalAntennaTilt, int checkedFqBandHighEdge, int checkedAlarmStatus, int checkedFqBandLowEdge) throws MoAccessException {
        MessageLog.traceEnter(SELF, "initMoData()");
        this.myData = new MoData(this.getLocalDistinguishedName(), this.getType(), true, context);
        this.myData.setRevision(6040700);
        this.bcmStoreAndRegisterStringAttribute("userLabel", checkedUserLabel);
        this.bcmStoreAndRegisterIntAttribute(RF_ACCESS_POINT_FROID, rfAccessPointFroId);
        this.bcmStoreAndRegisterIntAttribute("mechanicalAntennaTilt", checkedMechanicalAntennaTilt);
        this.bcmStoreAndRegisterIntAttribute(AB_FRO_ID, abFroId);
        this.initAlarmStatus(checkedAlarmStatus, context);
        this.myData.handleTransaction(context, MoData.WRITE_ACCESS);
    }

    public void delete(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(SELF, "delete()");
        this.myData.handleTransaction(context, MoData.WRITE_ACCESS);
        if (super.isReserved(context)) {
            throw new UndeletableMoException((ManagedObject)this);
        }
        String branchName = this.getBranchName(context);
        if (this.myScanner != null) {
            this.myScanner.delete(context);
        }
        this.eqcAntennaBranchProxy.deleteAb(this.getTxIdTransactional(context), 0, this.getFroId(context));
        try {
            this.scRfAccessProxy.rfapDeleteAb(this.getTxIdTransactional(context), 0, this.bcmGetIntAttribute(RF_ACCESS_POINT_FROID, context), this.getIntForBranchName(branchName));
        }
        catch (MoAccessException e) {
            try {
                context.rollbackOnly();
            }
            catch (InactiveTransactionException e1) {
                // empty catch block
            }
            throw e;
        }
        this.removeObservers(context);
        super.delete(context);
        MessageLog.trace(1, SELF, "AntennaBranch MO is deleted");
    }

    public String getType() {
        return "AntennaBranch";
    }

    public int getRfAccessPointFroId(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(SELF, "getRfAccessPointFroId()");
        return this.bcmGetIntAttribute(RF_ACCESS_POINT_FROID, context);
    }

    public int getAbFroId(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(SELF, "getAbFroId()");
        return this.bcmGetIntAttribute(AB_FRO_ID, context);
    }

    public String getUserLabel(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(SELF, "getUserLabel()");
        return this.bcmGetStringAttribute("userLabel", context);
    }

    public void setUserLabel(String value, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(SELF, "setUserLabel()");
        this.bcmSetStringAttribute("userLabel", value, 0, 128, this.getType(), context);
        this.sendAVC("userLabel", value, context);
    }

    public String getBranchName(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(SELF, "getBranchName()");
        EqcGetAbParamRspS rspSig = this.eqcAntennaBranchProxy.getAbParam(this.getTxIdNonTransactional(context), 0, this.getFroId(context));
        return this.getStringForBranchName((int)rspSig.branchName);
    }

    public boolean isPmCounterStartable(String name, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(SELF, "isPmCounterStartable(), counter name: " + name);
        if (name.equalsIgnoreCase("pmNoOfPowLimSlots")) {
            int noOfBranches = this.getNoOfTxBranch(context);
            if (this.getBranchName(context).equalsIgnoreCase("A")) {
                if (noOfBranches < 1) {
                    MessageLog.trace(3, this.getClass(), "pmNoOfPowLimSlots On antennaBranch A can not be started!! Probably the sector is not initiated.  NoOfTxBranch= " + noOfBranches);
                    return false;
                }
            } else if (noOfBranches < 2) {
                MessageLog.trace(3, this.getClass(), "pmNoOfPowLimSlots On antennaBranch B can not be started!! Probably the sector is not initiated or only one txBranch. NoOfTxBranch= " + noOfBranches);
                return false;
            }
        }
        return true;
    }

    private int getNoOfTxBranch(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(SELF, "getNoOfTxBranch()");
        int result2 = -1;
        SectorAntennaMo parentTmpRef = (SectorAntennaMo)this.getParent();
        ManagedObject[] sectorAntennaReservers = parentTmpRef.getReservedBy(context);
        GenSectorMo tmpSectorRef = null;
        for (int i = 0; i < sectorAntennaReservers.length; ++i) {
            ManagedObject mo = sectorAntennaReservers[i];
            if (!mo.getType().equalsIgnoreCase("Sector")) continue;
            tmpSectorRef = (SectorMo)mo;
            break;
        }
        if (tmpSectorRef != null && tmpSectorRef.isSectorInitialized(context)) {
            result2 = tmpSectorRef.getNumberOfTxBranches(context);
        }
        return result2;
    }

    public int getAntennaSupervisionThreshold(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(SELF, "getAntennaSupervisionThreshold()");
        LrsRfapGetParamAbRspS rspSig = this.scRfAccessProxy.rfapGetParamAb(this.getTxIdNonTransactional(context), 0, this.getRfAccessPointFroId(context));
        int antennaSupervisionThreshold = 0;
        int antennaBranch = this.getIntForBranchName(this.getBranchName(context));
        if (rspSig.antennaBranchParameters[antennaBranch].valid != 0) {
            antennaSupervisionThreshold = rspSig.antennaBranchParameters[antennaBranch].antennaSupervisionThreshold;
        }
        return antennaSupervisionThreshold;
    }

    public void setAntennaSupervisionThreshold(int value, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(SELF, "setAntennaSupervisionThreshold()");
        ValidateAttributes.intValueRangeCheck("antennaSupervisionThreshold", value, ANTENNA_SUPERVISION_THRESHOLD_MIN_VALUES, ANTENNA_SUPERVISION_THRESHOLD_MAX_VALUES, this.getType());
        int antennaBranch = this.getIntForBranchName(this.getBranchName(context));
        this.scRfAccessProxy.rfapSetAntennaSup(this.getTxIdTransactional(context), 0, this.getRfAccessPointFroId(context), antennaBranch, value);
        this.sendAVC("antennaSupervisionThreshold", value, context);
    }

    public int getFqBandHighEdge(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(SELF, "getFqBandHighEdge()");
        LrsRfapGetParamAbRspS rspSig = this.scRfAccessProxy.rfapGetParamAb(this.getTxIdNonTransactional(context), 0, this.getRfAccessPointFroId(context));
        int fqBandHighEdge = 0;
        int antennaBranch = this.getIntForBranchName(this.getBranchName(context));
        if (rspSig.antennaBranchParameters[antennaBranch].valid != 0) {
            fqBandHighEdge = rspSig.antennaBranchParameters[antennaBranch].fqBandHighEdge;
        }
        return fqBandHighEdge;
    }

    public int getFqBandLowEdge(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(SELF, "getFqBandLowEdge()");
        LrsRfapGetParamAbRspS rspSig = this.scRfAccessProxy.rfapGetParamAb(this.getTxIdNonTransactional(context), 0, this.getRfAccessPointFroId(context));
        int fqBandLowEdge = 0;
        int antennaBranch = this.getIntForBranchName(this.getBranchName(context));
        if (rspSig.antennaBranchParameters[antennaBranch].valid != 0) {
            fqBandLowEdge = rspSig.antennaBranchParameters[antennaBranch].fqBandLowEdge;
        }
        return fqBandLowEdge;
    }

    public void actionSetFrequencyBand(int fqBandLowEdge, int fqBandHighEdge, Coordinator context) throws MoAccessException, CellHaveBeenSetupByRncException, FrequencyBandNotSupportedException {
        MessageLog.traceEnter(SELF, "actionSetFrequencyBand()");
        AntennaBranchMoImpl.checkFrequencyBand(fqBandLowEdge, fqBandHighEdge);
        this.myData.handleTransaction(context, MoData.WRITE_ACCESS);
        int antennaBranch = this.getIntForBranchName(this.getBranchName(context));
        this.scRfAccessProxy.rfapSetFqband(this.getTxIdTransactional(context), 0, this.getRfAccessPointFroId(context), antennaBranch, fqBandLowEdge, fqBandHighEdge);
    }

    private static void checkFrequencyBand(int fqBandLowEdge, int fqBandHighEdge) throws MoAccessException {
        if (fqBandLowEdge >= fqBandHighEdge || FqBandRanges.lookup(fqBandLowEdge, fqBandHighEdge) == null) {
            throw new ValueOutOfRangeException("frequencyBand fqBandHighEdge: " + fqBandHighEdge + ", fqBandLowEdge: " + fqBandLowEdge, "AntennaBranch");
        }
    }

    public int getVerticalAntennaTilt(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(SELF, "getVerticalAntennaTilt()");
        RetDeviceMo retDevice = this.getRetDevRef(context);
        int electricalAntTilt = 0;
        if (retDevice != null) {
            electricalAntTilt = retDevice.getElectricalAntennaTilt(context);
        } else {
            MessageLog.trace(2, this.getClass(), "AntennaBranch retDevice reference is null. This means electricalAntTilt is 0");
        }
        return electricalAntTilt + this.getMechanicalAntennaTilt(context);
    }

    public int getMechanicalAntennaTilt(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(SELF, "getMechanicalAntennaTilt()");
        return this.bcmGetIntAttribute("mechanicalAntennaTilt", context);
    }

    public void setMechanicalAntennaTilt(int value, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(SELF, "setMechanicalAntennaTilt()");
        this.bcmSetIntAttribute("mechanicalAntennaTilt", value, MECHANICAL_ANTENNA_TILT_MIN_VALUES, MECHANICAL_ANTENNA_TILT_MAX_VALUES, this.getType(), context);
        this.sendAVC("mechanicalAntennaTilt", value, context);
    }

    public MoData getMyMoData() {
        MessageLog.traceEnter(SELF, "getMyMoData()");
        return this.myData;
    }

    public boolean isMyMoDataPersistent() {
        MessageLog.traceEnter(SELF, "isMyMoDataPersistent()");
        return true;
    }

    private static int checkAndGetFqBandAttribue(AttrList attributes, String attrName, String thisTypeName, Coordinator context) throws NotHandledAttributeTypeException, MoNotFoundException, ValueOutOfRangeException, AttrMissingAtCreateException, WrongAttributeTypeException {
        int index = attributes.indexOf(attrName);
        if (index == -1) {
            throw new AttrMissingAtCreateException(attrName, thisTypeName);
        }
        Object attribute = attributes.getValue(index);
        if (!(attribute instanceof Integer)) {
            throw new WrongAttributeTypeException(attrName, thisTypeName);
        }
        int attributeValue = (Integer)attribute;
        attributes.removeElementAt(index);
        return attributeValue;
    }

    private int getIntForBranchName(String antennaBranchName) throws MoAccessException {
        if (antennaBranchName != null) {
            if (antennaBranchName.equalsIgnoreCase("A")) {
                return 0;
            }
            if (antennaBranchName.equalsIgnoreCase("B")) {
                return 1;
            }
            if (antennaBranchName.equalsIgnoreCase("C")) {
                return 2;
            }
            if (antennaBranchName.equalsIgnoreCase("D")) {
                return 3;
            }
            if (antennaBranchName.equalsIgnoreCase("E")) {
                return 4;
            }
            if (antennaBranchName.equalsIgnoreCase("F")) {
                return 5;
            }
        }
        throw new ConfigNotSupportedException("Could not map antenna branch name to an integer value: " + antennaBranchName);
    }

    private String getStringForBranchName(int antennaBranchName) throws MoAccessException {
        switch (antennaBranchName) {
            case 0: {
                return "A";
            }
            case 1: {
                return "B";
            }
            case 2: {
                return "C";
            }
            case 3: {
                return "D";
            }
            case 4: {
                return "E";
            }
            case 5: {
                return "F";
            }
        }
        throw new ConfigNotSupportedException("Could not map antenna branch name to a string value: " + antennaBranchName);
    }

    private RetDeviceMo getRetDevRef(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(SELF, "getRetDevRef()");
        BoamManagedObject sectorAntenna = (BoamManagedObject)this.getParent();
        ManagedObject[] reservers = sectorAntenna.getReservedBy(context);
        for (int i = 0; i < reservers.length; ++i) {
            if (!(reservers[i] instanceof SectorMo)) continue;
            SectorMo sector = (SectorMo)reservers[i];
            ManagedObject[] retDevices = sector.getRetDevicesRef(context);
            if (retDevices.length == 0) {
                return null;
            }
            return (RetDeviceMo)retDevices[0];
        }
        return null;
    }

    private MoScanner createMoScanner(boolean recovery, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(SELF, "createMoScanner()");
        int[] tmpBranchId = new int[]{this.getFroId(context)};
        return new MoScanner(this, this.scRfAccessProxy, this.getRfAccessPointFroId(context), 0, AntennaBranchMoFactory.instance().getCounters(), tmpBranchId, recovery, context);
    }

    private MoScanner createMoScanner() {
        try {
            return this.createMoScanner(true, null);
        }
        catch (MoAccessException e) {
            MessageLog.traceError(SELF, "Couldn't setup counters!!", e);
            return null;
        }
    }

    public int[] getScannerValue(String counterName) throws MoAccessException {
        if (this.myScanner == null) {
            throw new PmsException("MoScanner not available");
        }
        return this.myScanner.getValue(counterName);
    }

    private void addObservers(int froType, Coordinator context) throws MoAccessException {
        this.myMoAlarms = new MoAlarms((ManagedObject)this, this.eqcAntennaBranchProxy, froType, this.getFroId(context), context);
    }

    private void removeObservers(Coordinator context) throws MoAccessException {
        this.myMoAlarms.delete(context);
    }

    public int getFroId(Coordinator context) {
        MessageLog.traceEnter(SELF, "getFroId()");
        int froId = 0;
        try {
            froId = this.getAbFroId(context);
        }
        catch (MoAccessException e) {
            MessageLog.trace(2, this.getClass(), "ExtTmaFroId could not be fetched ");
        }
        return froId;
    }

    public int getLowCurrentSupervision(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(SELF, "getLowCurrentSupervision() <---");
        return this.eqcAntennaBranchProxy.getAbParam((int)this.getTxIdNonTransactional((Coordinator)c), (int)0, (int)this.getAbFroId((Coordinator)c)).lowCurrentSupervision;
    }

    public void setLowCurrentSupervision(int value, Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(SELF, "setLowCurrentSupervision(" + value + ") <---");
        ValidateAttributes.checkTransaction(c);
        this.myData.handleTransaction(c, MoData.WRITE_ACCESS);
        ValidateAttributes.intValueInEnumerationCheck("lowCurrentSupervision", value, SupervisionState.class, "AntennaBranch");
        this.eqcAntennaBranchProxy.setAbParam(this.getTxIdNonTransactional(c), 0, this.getAbFroId(c), value);
        this.sendAVC("lowCurrentSupervision", value, c);
    }
}

