/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.mao.rmo.channel;

import enea.ose.system.InSignal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoCanNotBeCreatedException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoFactory;
import se.ericsson.cello.moframework.MoFactoryMgr;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.MoNotFoundException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.wcdma.rbs.boam.common.FroStateObserver;
import se.ericsson.wcdma.rbs.boam.common.PlugAndPlayObserver;
import se.ericsson.wcdma.rbs.boam.common.log.MessageLog;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.proxies.ChcPrachProxy;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.LrsPrachCreatedIndS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.LrsPrachDeletedIndS;
import se.ericsson.wcdma.rbs.boam.mao.common.ErrorMgr;
import se.ericsson.wcdma.rbs.boam.mao.common.PmCounterSetup;
import se.ericsson.wcdma.rbs.boam.mao.rmo.channel.PrachMoImpl;
import se.ericsson.wcdma.rbs.boam.pms.iface.PmCapableMoFactory;
import se.ericsson.wcdma.rbs.boam.pms.impl.Counter;
import se.ericsson.wcdma.rbs.boam.pms.impl.CounterGroup;
import se.ericsson.wcdma.rbs.boam.pms.impl.MoScannerAgent;

public class PrachMoFactory
implements PmCapableMoFactory,
PlugAndPlayObserver,
FroStateObserver {
    public static final int CLIENT_ID = 0;
    public static final int CM_OPERATION_OK = 0;
    private static PrachMoFactory instance = null;
    private final List counterList = new ArrayList();
    private ChcPrachProxy myProxy = ChcPrachProxy.instance();
    private HashMap prachList = new HashMap(5);

    private PrachMoFactory() {
        MessageLog.traceEnter(this.getClass(), "constructor");
        MoFactoryMgr.instance().register((MoFactory)this, this.getMoTypeName());
        this.myProxy.registerForPlugAndPLayInd(null, this, -12L);
        this.myProxy.registerForStatePropagation(null, this);
        this.setupPmsCounters();
    }

    public static synchronized PrachMoFactory instance() {
        if (instance == null) {
            instance = new PrachMoFactory();
        }
        return instance;
    }

    public ManagedObject createMo(ManagedObject parent, AttrList attributes, String identity, ManagedObject source, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "createMo()");
        throw new MoCanNotBeCreatedException(this.getMoTypeName());
    }

    public ManagedObject recoverMo(MoData recoveredData) throws MoNameAlreadyTakenException {
        MessageLog.traceEnter(this.getClass(), "recoverMo()");
        ErrorMgr.shotDownIfNull(null, "SW error!!, this shouldn't be happened. No recovery for " + this.getMoTypeName());
        return null;
    }

    public synchronized void createInd(InSignal createInd) {
        MessageLog.traceEnter(this.getClass(), "createInd()");
        LrsPrachCreatedIndS indicationSig = (LrsPrachCreatedIndS)createInd;
        try {
            Integer froId = new Integer(indicationSig.prachFroId);
            this.prachList.put(froId, this.createPhysicalCommonChannel(indicationSig));
        }
        catch (Throwable e) {
            MessageLog.traceError(this.getClass(), "Mo couldn't be created, froId: " + indicationSig.prachFroId, e);
        }
    }

    public synchronized void deleteInd(InSignal deleteInd) {
        MessageLog.traceEnter(this.getClass(), "deleteInd()");
        LrsPrachDeletedIndS indicationSig = (LrsPrachDeletedIndS)deleteInd;
        try {
            this.deletePrach(indicationSig.prachFroId);
        }
        catch (Throwable e) {
            MessageLog.traceError(this.getClass(), "PrachMo could not be deleted froID:" + indicationSig.prachFroId, e);
        }
    }

    public synchronized void changeInd(InSignal changeInd) {
        MessageLog.traceEnter(this.getClass(), "changeInd()");
    }

    public void serviceAvailable(String proxyName) {
    }

    public void serviceRemoved(String proxyName) {
        MessageLog.traceEnter(this.getClass(), "proxiesUnavailable()");
        try {
            this.deleteAll();
        }
        catch (Exception t) {
            MessageLog.traceError(this.getClass(), "Couldn't reset the object list", t);
        }
    }

    public void plugAndPlayInd(InSignal pnpIndSig) {
        MessageLog.traceEnter(this.getClass(), "plugAndPlayInd()");
        if (pnpIndSig == null) {
            MessageLog.traceError(this.getClass(), "The received signal is null!!");
            return;
        }
        if (pnpIndSig.getClass().getName().equals(LrsPrachCreatedIndS.class.getName())) {
            this.createInd(pnpIndSig);
        } else if (pnpIndSig.getClass().getName().equals(LrsPrachDeletedIndS.class.getName())) {
            this.deleteInd(pnpIndSig);
        } else {
            MessageLog.traceError(this.getClass(), "unexpected signal is received!! recSig:" + pnpIndSig.getClass().getName());
        }
    }

    public String getMoTypeName() {
        return "Prach";
    }

    private synchronized void deleteAll() throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "deleteAll()");
        Collection set = this.prachList.values();
        Iterator objs = set.iterator();
        PrachMoImpl tmpObj = null;
        while (objs.hasNext()) {
            tmpObj = (PrachMoImpl)objs.next();
            tmpObj.moScannerServiceNotAvailable();
            tmpObj.deletePrach(null);
        }
        this.prachList.clear();
    }

    private void deletePrach(int froId) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "deletePrach()");
        Integer key = new Integer(froId);
        PrachMoImpl mo = (PrachMoImpl)this.prachList.get(key);
        if (mo == null) {
            throw new MoNotFoundException("Couldn't find PrachMo froId:" + froId);
        }
        mo.deletePrach(null);
        this.prachList.remove(key);
    }

    private ManagedObject createPhysicalCommonChannel(LrsPrachCreatedIndS indicationSig) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "createPhysicalCommonChannel()");
        return PrachMoImpl.create(indicationSig);
    }

    public List getCounters() {
        return this.counterList;
    }

    private void setupPmsCounters() {
        MessageLog.traceEnter(this.getClass(), "setupPmsCounters()");
        try {
            PmCounterSetup.setupCounters(this.getMoTypeName(), this.counterList);
            CounterGroup cntGrp = new CounterGroup("PrachPmMeasReceivedBlocks");
            Counter cnt = new Counter("pmSuccReceivedBlocks", 1, cntGrp);
            this.counterList.add(cnt);
            cnt = new Counter("pmUnsuccReceivedBlocks", 1, cntGrp);
            this.counterList.add(cnt);
            new MoScannerAgent(this.getMoTypeName(), this.counterList);
        }
        catch (Exception pmse) {
            MessageLog.traceError(this.getClass(), " Could not setup boam.pms.MoScannerAgent.", pmse);
        }
    }

    public static synchronized void _setupCounter_onlyForTest() {
        if (instance != null) {
            MoFactoryMgr.instance().deregister(instance.getMoTypeName());
            instance = null;
        }
    }
}

