/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.mao.rmo.channel;

import java.util.ArrayList;
import java.util.Iterator;
import se.ericsson.cello.mao.Reservable;
import se.ericsson.cello.moframework.AttrNotReadableException;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.IntegerAttribute;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.ResourceLockedException;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.moframework.StructImpl;
import se.ericsson.cello.moframework.TransactionRequiredException;
import se.ericsson.cello.moframework.UndeletableMoException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.wcdma.rbs.boam.common.AvailabilityStatusIntToEnum;
import se.ericsson.wcdma.rbs.boam.common.log.MessageLog;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.proxies.ChcPrachProxy;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.LrsGetPrachParamRspS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.LrsPrachCreatedIndS;
import se.ericsson.wcdma.rbs.boam.mao.bcm.BoamHelper;
import se.ericsson.wcdma.rbs.boam.mao.bcm.BoamManagedObject;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.CarrierMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.PrachMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.RachMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.UbchDeviceSetMo;
import se.ericsson.wcdma.rbs.boam.mao.rmo.channel.ChannelHelper;
import se.ericsson.wcdma.rbs.boam.mao.rmo.channel.PrachMoFactory;
import se.ericsson.wcdma.rbs.boam.mao.rmo.channel.RachMoImpl;
import se.ericsson.wcdma.rbs.boam.pms.impl.MoScanner;
import se.ericsson.wcdma.rbs.boam.pms.impl.PmsException;

public class PrachMoImpl
extends BoamManagedObject
implements PrachMo {
    public static final String PM_RECEIVED_BLOCKS = "pmReceivedBlocks";
    private static final String PRACH_FRO_ID = "prachFroId";
    private static final String IDENTITY = "1";
    private final MoData myData;
    private final MoScanner myScanner;
    private final ChcPrachProxy chcPrachProxy = ChcPrachProxy.instance();
    private final UbchDeviceSetMo deviceSetRef;

    private PrachMoImpl(ManagedObject parent, int prachFroId, int ubchDevSetFroId, String moType, String identity) throws MoAccessException {
        super(parent, moType, identity, null);
        MessageLog.traceEnter(this.getClass(), "Normal constructor");
        this.myData = this.initMoData();
        this.myData.registerTransientAttr((Attribute)new IntegerAttribute(PRACH_FRO_ID, false, prachFroId));
        this.deviceSetRef = (UbchDeviceSetMo)ChannelHelper.resolveDeviceSetRefAndReserve(ubchDevSetFroId, "UbchDeviceSet", this);
        this.myScanner = this.createMoScanner(prachFroId);
        MessageLog.trace(1, this.getClass(), "MO created");
    }

    private MoScanner createMoScanner(int prachFroId) {
        try {
            int[] additionalInfo = new int[]{((CarrierMo)this.getParent()).getFroId(null)};
            return new MoScanner(this, this.chcPrachProxy, prachFroId, 0, PrachMoFactory.instance().getCounters(), additionalInfo, false, null);
        }
        catch (Exception pmse) {
            MessageLog.traceError(this.getClass(), "could not create MoScanner: " + pmse);
            return null;
        }
    }

    public static synchronized ManagedObject create(LrsPrachCreatedIndS indicationSig) throws MoAccessException {
        MessageLog.traceEnter(PrachMoImpl.class, "create() ");
        ManagedObject cellCarrier = BoamHelper.getMoForFroId("Carrier", indicationSig.cellCarrierFroId);
        PrachMoImpl prachMo = new PrachMoImpl(cellCarrier, indicationSig.prachFroId, indicationSig.ubchDevSetFroId, "Prach", IDENTITY);
        prachMo.createMyOwnCommonChannel(indicationSig);
        return prachMo;
    }

    public int[] getScannerValue(String counterName) throws MoAccessException {
        if (this.myScanner == null) {
            throw new PmsException("MoScanner not available");
        }
        return this.myScanner.getValue(counterName);
    }

    public void moScannerServiceNotAvailable() throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "moScannerServiceNotAvailable() ");
        this.myScanner.serviceRemoved(this.chcPrachProxy.getServiceName());
    }

    public void delete(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "delete()");
        throw new UndeletableMoException((ManagedObject)this);
    }

    public void deletePrach(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "deletePrach()");
        if (this.myScanner != null) {
            this.myScanner.delete(context);
        }
        this.deleteMyOwnCommonChannels(context);
        if (super.isReserved(context)) {
            MessageLog.trace(1, this.getClass(), " this Mo is reserved and can not be deleted ");
            throw new UndeletableMoException((ManagedObject)this);
        }
        ManagedObject ubchDevSetRef = this.getUbchDeviceSetRef(context);
        if (ubchDevSetRef != null) {
            ((Reservable)ubchDevSetRef).release((ManagedObject)this, context);
        }
        super.delete(context);
    }

    public String getType() {
        return "Prach";
    }

    public int getOperationalState(Coordinator context) throws MoAccessException, TransactionRequiredException, ResourceLockedException {
        MessageLog.traceEnter(this.getClass(), "getOperationalState()");
        LrsGetPrachParamRspS rspSig = this.chcPrachProxy.getPrachParam(0, this.getFroId(context));
        return rspSig.prachOpState;
    }

    public int getAvailabilityStatus(Coordinator context) throws MoAccessException, TransactionRequiredException, ResourceLockedException {
        MessageLog.traceEnter(this.getClass(), "getAvailabilityStatus()");
        LrsGetPrachParamRspS rspSig = this.chcPrachProxy.getPrachParam(0, this.getFroId(context));
        return AvailabilityStatusIntToEnum.convGetAvailStatIntToEnum(rspSig.prachAvailStatus);
    }

    public int getFroId(Coordinator context) {
        MessageLog.traceEnter(this.getClass(), "getFroId()");
        try {
            return this.bcmGetIntAttribute(PRACH_FRO_ID, context);
        }
        catch (MoAccessException e) {
            MessageLog.traceError(this.getClass(), "MoAccessException caught in getFroId(Corrdinator c) ", e);
            return 0;
        }
    }

    public ManagedObject getUbchDeviceSetRef(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getUbchDeviceSetRef()");
        return this.deviceSetRef;
    }

    public Struct actionReadNbapData(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "actionReadNbapData()");
        this.myData.handleTransaction(context, MoData.READ_ACCESS);
        LrsGetPrachParamRspS rspSig = this.chcPrachProxy.getPrachParam(0, this.getFroId(null));
        return this.convertSigToStruct(rspSig);
    }

    private Struct convertSigToStruct(LrsGetPrachParamRspS rspSig) throws MoAccessException {
        String[] names = new String[7];
        Object[] values = new Object[7];
        names[0] = "scramblingCodeWordNo";
        names[1] = "preambleSignatures";
        names[2] = "rachSlotFormat";
        names[3] = "rachSubChanNumbers";
        names[4] = "rachPunctureLimit";
        names[5] = "preambleThreshold";
        names[6] = "phChId";
        values[0] = new Integer(rspSig.scramblingCodeWordNo);
        values[1] = new Integer(rspSig.preambleSignatures);
        values[2] = new Integer(rspSig.rachSlotFormat);
        values[3] = new Integer(rspSig.rachSubChanNumbers);
        values[4] = new Integer(rspSig.rachPunctureLimit);
        values[5] = new Integer(rspSig.preambleThreshold);
        values[6] = new Integer(rspSig.prachPhysChId);
        if (rspSig.nbapIsValid == 1) {
            return new StructImpl(names, values);
        }
        MessageLog.trace(2, this.getClass(), " Nbap data is not valid ");
        throw new AttrNotReadableException((ManagedObject)this, this.getType() + "DataNotValid");
    }

    private MoData initMoData() throws MoAccessException {
        MessageLog.trace(1, this.getClass(), "initMoData()");
        return new MoData(this.getLocalDistinguishedName(), this.getType(), false, null);
    }

    public MoData getMyMoData() {
        MessageLog.traceEnter(this.getClass(), "getMyMoData()");
        return this.myData;
    }

    public boolean isMyMoDataPersistent() {
        MessageLog.traceEnter(this.getClass(), "isMyMoDataPersistent()");
        return false;
    }

    private void createMyOwnCommonChannel(LrsPrachCreatedIndS indicationSig) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "createMyOwnCommonChannel()");
        RachMoImpl.create(this, indicationSig.prachFroId, indicationSig.rachFroId, "Rach", IDENTITY);
    }

    private void deleteMyOwnCommonChannels(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "deleteMyOwnCommonChannels()");
        this.deleteMyChildren(context);
    }

    private void deleteMyChildren(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "deleteMyChildern()");
        ArrayList<ManagedObject> moList = new ArrayList<ManagedObject>();
        MoIterator mos = this.getChildren();
        while (mos.hasMoreElements()) {
            moList.add(mos.nextMo());
        }
        Iterator it = moList.iterator();
        while (it.hasNext()) {
            ((RachMo)it.next()).deleteRach(context);
        }
    }
}

