/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.mao.rmo.iub;

import enea.ose.system.InSignal;
import java.util.ArrayList;
import se.ericsson.cello.iptransport.IpAccessHostEtMaoi;
import se.ericsson.cello.mao.Reservable;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.AttrMissingAtCreateException;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.BooleanAttribute;
import se.ericsson.cello.moframework.IllegalParentException;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.MoRemovedException;
import se.ericsson.cello.moframework.NotHandledAttributeTypeException;
import se.ericsson.cello.moframework.ReferenceAttribute;
import se.ericsson.cello.moframework.ResourceLockedException;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.moframework.StructAttribute;
import se.ericsson.cello.moframework.StructImpl;
import se.ericsson.cello.moframework.TransactionRequiredException;
import se.ericsson.cello.moframework.UndeletableMoException;
import se.ericsson.cello.moframework.ValueOutOfRangeException;
import se.ericsson.cello.moframework.WrongAttributeTypeException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.wcdma.rbs.boam.common.log.MessageLog;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.proxies.ChcIubdsProxy;
import se.ericsson.wcdma.rbs.boam.fpx.ncmi.proxies.NcNbapProxy;
import se.ericsson.wcdma.rbs.boam.fpx.proxies.FroProxy;
import se.ericsson.wcdma.rbs.boam.mao.alarm.MoAlarms;
import se.ericsson.wcdma.rbs.boam.mao.bcm.BoamManagedObjectWithAlarms;
import se.ericsson.wcdma.rbs.boam.mao.common.AttrListImpl;
import se.ericsson.wcdma.rbs.boam.mao.common.ValidateAttributes;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.IubDataStreamsMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.IubMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.NbapCommonMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.NbapDedicatedMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.NodeBFunctionMo;
import se.ericsson.wcdma.rbs.boam.mao.rmo.iub.IubDataStreamsMoFactory;
import se.ericsson.wcdma.rbs.boam.mao.rmo.iub.IubMoFactory;
import se.ericsson.wcdma.rbs.boam.pms.impl.MoScanner;
import se.ericsson.wcdma.rbs.boam.pms.impl.PmsException;

public class IubMoImpl
extends BoamManagedObjectWithAlarms
implements IubMo {
    public static final String IUB_DATA_STREAMS_REF = "iubDataStreamsRef";
    private static final int IUB_MAX_NO_OF_INSTANCES = 1;
    private static final int NOT_DEFINED = -1;
    public static final int MO_DATA_REVISION = 7011000;
    private final NcNbapProxy ncNbapProxy = NcNbapProxy.instance();
    private final ChcIubdsProxy theLrsIubdsProxy = ChcIubdsProxy.instance();
    private final MoScanner myScanner;

    public IubMoImpl(ManagedObject parent, AttrList attributes, String identity, ManagedObject source, Coordinator context) throws MoAccessException, IllegalParentException, ValueOutOfRangeException, MoNameAlreadyTakenException, WrongAttributeTypeException, AttrMissingAtCreateException, TransactionRequiredException, NotHandledAttributeTypeException {
        super(parent, "Iub", identity, context);
        MessageLog.traceEnter(this.getClass(), "IubMoImpl()");
        if (!(parent instanceof NodeBFunctionMo)) {
            throw new IllegalParentException("Wrong parent: " + parent.getType());
        }
        Struct userplane = ValidateAttributes.checkAndGetStructAttribute(attributes, "userPlaneTransportOption", "mandatory", "Iub");
        this.checkUserPlaneTransportOption("userPlaneTransportOption", userplane, context);
        ManagedObject userPlaneIpResourceRef = ValidateAttributes.checkAndGetReferenceAttribute("userPlaneIpResourceRef", attributes, "optional", new String[]{"IpAccessHostEt"}, "Iub");
        if (this.checkTransportOption(userplane, "ipV4") && (userPlaneIpResourceRef == null || !userPlaneIpResourceRef.getType().equalsIgnoreCase("IpAccessHostEt"))) {
            throw new AttrMissingAtCreateException("userPlaneIpResourceRef", "UserPlaneTransportOption is IP and, attribute expected type:IpAccessHostEt, recievd type:" + userPlaneIpResourceRef);
        }
        int ipAccessHostEtFroId = -1;
        if (userPlaneIpResourceRef != null) {
            ((Reservable)userPlaneIpResourceRef).reserve((ManagedObject)this, context);
            ipAccessHostEtFroId = ((IpAccessHostEtMaoi)userPlaneIpResourceRef).getFroId(context);
        }
        Struct cntl = ValidateAttributes.checkAndGetStructAttribute(attributes, "controlPlaneTransportOption", "mandatory", "Iub");
        this.checkControlPlaneTransportOption("controlPlaneTransportOption", cntl, context);
        String checkedUserLabel = ValidateAttributes.checkAndGetStringAttribute(attributes, "userLabel", "optional", "", 0, 128, "Iub");
        int checkedRbsId = ValidateAttributes.checkAndGetIntAttribute(attributes, "rbsId", "mandatory", 0, RBS_ID_MIN_VALUES, RBS_ID_MAX_VALUES, "Iub");
        int checkedAlarmStatus = ValidateAttributes.checkAndGetIntAttribute(attributes, "alarmStatus", "optional", 0, IubMo.ALARM_STATUS_MIN_VALUES, IubMo.ALARM_STATUS_MAX_VALUES, "Iub");
        ValidateAttributes.checkOtherAttributes(attributes, "Iub");
        this.initMoData(checkedRbsId, cntl, checkedUserLabel, checkedAlarmStatus, userPlaneIpResourceRef, context);
        IubDataStreamsMo idsMo = (IubDataStreamsMo)this.createIubDataStreamsMoImpl(context);
        idsMo.update(this.checkTransportOption(userplane, "atm"), this.checkTransportOption(userplane, "ipV4"), ipAccessHostEtFroId, context);
        this.myScanner = this.createMoScanner(false, context);
        this.addObservers(context);
        MessageLog.trace(1, this.getClass(), " MO is Created ");
    }

    public IubMoImpl(MoData recoveredData) throws MoNameAlreadyTakenException {
        super(recoveredData);
        MessageLog.traceEnter(this.getClass(), "IubMoImpl()");
        this.myData = recoveredData;
        this.myScanner = this.createMoScanner(true, null);
        try {
            this.addObservers(null);
        }
        catch (MoAccessException e) {
            MessageLog.trace(1, this.getClass(), "The observers couldn't be initiated!!");
        }
        MessageLog.trace(1, this.getClass(), "Version Attribute in MoData = " + this.myData.getRevision());
        MessageLog.trace(1, this.getClass(), " MO is Restored ");
    }

    private MoScanner createMoScanner(boolean isRecovery, Coordinator context) {
        try {
            boolean dummyFroId = false;
            int[] additionalInfo = new int[]{0};
            return new MoScanner(this, this.ncNbapProxy, 0, 0, IubMoFactory.instance().getCounters(), additionalInfo, isRecovery, context);
        }
        catch (Exception pmse) {
            MessageLog.traceError(this.getClass(), "could not create MoScanner" + pmse);
            return null;
        }
    }

    private void addObservers(Coordinator context) throws MoAccessException {
        this.myMoAlarms = new MoAlarms((ManagedObject)this, new FroProxy[]{this.theLrsIubdsProxy}, 127, -21, context);
    }

    protected void removeObservers(Coordinator context) throws MoAccessException {
        this.myMoAlarms.delete(context);
    }

    private void initMoData(int checkedRbsId, Struct cntl, String checkedUserLabel, int checkedAlarmStatus, ManagedObject userPlaneIpResourceRef, Coordinator context) throws MoAccessException {
        this.myData = new MoData(this.getLocalDistinguishedName(), this.getType(), true, context);
        this.initAlarmStatus(checkedAlarmStatus, context);
        ReferenceAttribute refAttr = new ReferenceAttribute("userPlaneIpResourceRef", false, userPlaneIpResourceRef);
        this.myData.registerPersistentAttr((Attribute)refAttr);
        StructAttribute structAtt = new StructAttribute("controlPlaneTransportOption", false);
        BooleanAttribute attr = new BooleanAttribute("atm", false, ((Boolean)cntl.getValue("atm")).booleanValue());
        structAtt.addElement((Attribute)attr);
        attr = new BooleanAttribute("ipV4", false, ((Boolean)cntl.getValue("ipV4")).booleanValue());
        structAtt.addElement((Attribute)attr);
        this.myData.registerPersistentAttr((Attribute)structAtt);
        this.bcmStoreAndRegisterStringAttribute("userLabel", checkedUserLabel);
        this.bcmStoreAndRegisterIntAttribute("rbsId", checkedRbsId);
        this.bcmStoreAndRegisterReferenceAttribute(IUB_DATA_STREAMS_REF, null);
        this.myData.setRevision(7011000);
        this.myData.handleTransaction(context, MoData.WRITE_ACCESS);
    }

    public static synchronized ManagedObject create(ManagedObject parent, AttrList attributes, String identity, ManagedObject source, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(IubMoImpl.class, "create()");
        ValidateAttributes.checkMaxCardinality(parent, "Iub", 1);
        IubMoImpl createdMo = new IubMoImpl(parent, attributes, identity, source, context);
        return createdMo;
    }

    public String getType() {
        return "Iub";
    }

    private void checkUserPlaneTransportOption(String attrName, Struct cntl, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "checkUserPlaneTransportOption(), attr:" + attrName);
        this.checkPlaneTransportOptionDependingIfBothValuesCanBeTrue(attrName, cntl, true, context);
    }

    private void checkControlPlaneTransportOption(String attrName, Struct cntl, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "checkControlPlaneTransportOption(), attr:" + attrName);
        this.checkPlaneTransportOptionDependingIfBothValuesCanBeTrue(attrName, cntl, false, context);
    }

    private void checkPlaneTransportOptionDependingIfBothValuesCanBeTrue(String attrName, Struct cntl, boolean bOkToHaveBothTrue, Coordinator context) throws MoAccessException {
        boolean bBothValuesAreFalse;
        MessageLog.traceEnter(this.getClass(), "checkPlaneTransportOptionDependingIfBothValuesCanBeTrue(), attr:" + attrName);
        String[] names = cntl.getNames();
        boolean bBothValuesAreTrue = !bOkToHaveBothTrue && (Boolean)cntl.getValue(names[0]) != false && (Boolean)cntl.getValue(names[1]) != false;
        boolean bl = bBothValuesAreFalse = (Boolean)cntl.getValue(names[0]) == false && (Boolean)cntl.getValue(names[1]) == false;
        if (bBothValuesAreTrue || bBothValuesAreFalse) {
            StringBuffer trace = new StringBuffer(attrName + ": Both parameters can't be true/false at the same time!!");
            trace.append(names[0]).append("=").append((Boolean)cntl.getValue(names[0]));
            trace.append(" ; " + names[1]).append("=").append((Boolean)cntl.getValue(names[1]));
            MessageLog.trace(2, this.getClass(), trace.toString());
            throw new ValueOutOfRangeException(attrName, this.getType(), trace.toString());
        }
    }

    public ManagedObject createIubDataStreamsMoImpl(Coordinator context) throws MoAccessException, TransactionRequiredException, MoRemovedException {
        MessageLog.traceEnter(this.getClass(), "createIubDataStreamsMoImpl()");
        IubDataStreamsMoFactory factoryRef = IubDataStreamsMoFactory.instance();
        ManagedObject iubDataStreamsRef = factoryRef.createMo(this, new AttrListImpl(), "1", null, context);
        ReferenceAttribute attribute = (ReferenceAttribute)this.myData.getAttribute(IUB_DATA_STREAMS_REF);
        attribute.setValue(iubDataStreamsRef);
        MessageLog.trace(1, this.getClass(), "IubDataStreams is created ");
        return iubDataStreamsRef;
    }

    public void delete(Coordinator context) throws MoAccessException, UndeletableMoException {
        MessageLog.traceEnter(this.getClass(), "delete()");
        this.myData.handleTransaction(context, MoData.WRITE_ACCESS);
        IubDataStreamsMo iubDSRef = (IubDataStreamsMo)this.bcmGetReferenceAttribute(IUB_DATA_STREAMS_REF, context);
        ManagedObject moRef = this.getUserPlaneIpResourceRef(context);
        if (moRef != null) {
            ((Reservable)moRef).release((ManagedObject)this, context);
        }
        iubDSRef.delete(context, this.getType());
        if (this.myScanner != null) {
            this.myScanner.delete(context);
        }
        this.removeObservers(context);
        super.delete(context);
        MessageLog.trace(1, this.getClass(), "Mo is Deleted");
    }

    public void setUserLabel(String str, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setUserLabel()");
        this.bcmSetStringAttribute("userLabel", str, 0, 128, "Iub", context);
        this.sendAVC("userLabel", str, context);
    }

    public String getUserLabel(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getUserLabel()");
        return this.bcmGetStringAttribute("userLabel", context);
    }

    public int getRbsId(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getRbsId()");
        return super.bcmGetIntAttribute("rbsId", context);
    }

    public void setRbsId(int newRbsIdValue, Coordinator context) throws MoAccessException, ResourceLockedException, ValueOutOfRangeException, TransactionRequiredException {
        MessageLog.traceEnter(this.getClass(), "setRbsId()");
        this.bcmSetIntAttribute("rbsId", newRbsIdValue, RBS_ID_MIN_VALUES, RBS_ID_MAX_VALUES, "Iub", context);
        this.sendAVC("rbsId", newRbsIdValue, context);
    }

    public MoData getMyMoData() {
        MessageLog.traceEnter(this.getClass(), "getMyMoData()");
        return this.myData;
    }

    public boolean isMyMoDataPersistent() {
        MessageLog.traceEnter(this.getClass(), "isMyMoDataPersistent()");
        return true;
    }

    public ManagedObject getUserPlaneIpResourceRef(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getUserPlaneIpResourceRef()");
        return this.bcmGetReferenceAttribute("userPlaneIpResourceRef", c);
    }

    public void setUserPlaneIpResourceRef(ManagedObject value, Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setUserPlaneIpResourceRef()");
        IubMoImpl.checkTransaction(c);
        IubMoImpl.checkTransaction(c);
        this.myData.handleTransaction(c, MoData.WRITE_ACCESS);
        Struct userPlane = this.getUserPlaneTransportOption(c);
        if (this.checkTransportOption(userPlane, "ipV4") && (value == null || !value.getType().equalsIgnoreCase("IpAccessHostEt"))) {
            throw new ValueOutOfRangeException("userPlaneIpResourceRef", "Iub", "UserPlaneTransportOption is IP and expected type:IpAccessHostEt, received type:" + value);
        }
        ManagedObject oldRef = this.getUserPlaneIpResourceRef(c);
        if (value == null && oldRef == null) {
            throw new ValueOutOfRangeException("userPlaneIpResourceRef", "Iub", "the old  and  new value both are null!!. From null->null not allowed.");
        }
        int ipAccessHostEtFroId = -1;
        if (value == null) {
            ((Reservable)oldRef).release((ManagedObject)this, c);
        } else {
            if (oldRef != null) {
                ((Reservable)oldRef).release((ManagedObject)this, c);
            }
            ((Reservable)value).reserve((ManagedObject)this, c);
            ipAccessHostEtFroId = ((IpAccessHostEtMaoi)value).getFroId(c);
        }
        this.bcmSetReferenceAttribute("userPlaneIpResourceRef", value, this.getType(), c);
        IubDataStreamsMo iubDSRef = (IubDataStreamsMo)this.bcmGetReferenceAttribute(IUB_DATA_STREAMS_REF, c);
        iubDSRef.update(this.checkTransportOption(userPlane, "atm"), this.checkTransportOption(userPlane, "ipV4"), ipAccessHostEtFroId, c);
        this.sendAVC("userPlaneIpResourceRef", value, c);
    }

    public boolean checkTransportOption(Struct st, String transportOption) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "chechTransportOption()");
        boolean result2 = false;
        if (st != null && st.getNames().length != 0) {
            result2 = (Boolean)st.getValue(transportOption);
        }
        return result2;
    }

    public boolean isTransportOptioOldNewValueEqual(Struct oldValue, Struct newValue) throws MoAccessException {
        return this.checkTransportOption(oldValue, "ipV4") == this.checkTransportOption(newValue, "ipV4") && this.checkTransportOption(oldValue, "atm") == this.checkTransportOption(newValue, "atm");
    }

    public Struct getControlPlaneTransportOption(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getControlPlaneTransportOption()");
        this.myData.handleTransaction(c, MoData.READ_ACCESS);
        StructAttribute ctrl = (StructAttribute)this.myData.getAttribute("controlPlaneTransportOption");
        return this.structAttribute2Struct(ctrl, c);
    }

    public Struct getUserPlaneTransportOption(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getUserPlaneTransportOption()");
        this.myData.handleTransaction(c, MoData.READ_ACCESS);
        IubDataStreamsMo iubDSRef = (IubDataStreamsMo)this.bcmGetReferenceAttribute(IUB_DATA_STREAMS_REF, c);
        return iubDSRef.getUserPlaneTransportOption(c);
    }

    private Struct structAttribute2Struct(StructAttribute st, Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "structAttribute2Struct()");
        Attribute[] attrs = st.getElements(c);
        ArrayList<String> names = new ArrayList<String>();
        ArrayList<Boolean> values = new ArrayList<Boolean>();
        for (int i = 0; i < attrs.length; ++i) {
            BooleanAttribute attribute = (BooleanAttribute)attrs[i];
            names.add(attribute.getName());
            values.add(attribute.getValue(c));
        }
        return new StructImpl(names.toArray(new String[names.size()]), (Object[])values.toArray(new Boolean[values.size()]));
    }

    public void setControlPlaneTransportOption(Struct value, Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setControlPlaneTransportOption()");
        this.checkControlPlaneTransportOption("controlPlaneTransportOption", value, c);
        IubMoImpl.checkTransaction(c);
        this.myData.handleTransaction(c, MoData.WRITE_ACCESS);
        if (this.isTransportOptioOldNewValueEqual(this.getControlPlaneTransportOption(c), value)) {
            MessageLog.trace(2, this.getClass(), "The new value and the old value are the same, nothing to do!!");
            this.sendAVC("controlPlaneTransportOption", value, c);
            return;
        }
        StructAttribute ctrl = (StructAttribute)this.myData.getAttribute("controlPlaneTransportOption");
        ((BooleanAttribute)ctrl.getElement("ipV4", c)).setValue(this.checkTransportOption(value, "ipV4"));
        ((BooleanAttribute)ctrl.getElement("atm", c)).setValue(this.checkTransportOption(value, "atm"));
        MoIterator myChildren = this.getChildren();
        while (myChildren.hasMoreElements()) {
            ManagedObject mo = (ManagedObject)myChildren.nextElement();
            if (mo.getType().equalsIgnoreCase("NbapCommon")) {
                ((NbapCommonMo)mo).controlPlaneTransportOptionUpdated(c);
                continue;
            }
            if (!mo.getType().equalsIgnoreCase("NbapDedicated")) continue;
            ((NbapDedicatedMo)mo).controlPlaneTransportOptionUpdated(c);
        }
        this.sendAVC("controlPlaneTransportOption", value, c);
    }

    public void setUserPlaneTransportOption(Struct value, Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setUserPlaneTransportOption()");
        int ipAccessHostEtFroId = -1;
        this.checkUserPlaneTransportOption("userPlaneTransportOption", value, c);
        IubMoImpl.checkTransaction(c);
        this.myData.handleTransaction(c, MoData.WRITE_ACCESS);
        if (this.isTransportOptioOldNewValueEqual(this.getUserPlaneTransportOption(c), value)) {
            MessageLog.trace(2, this.getClass(), "The new value and the old value is same, nothing to do!!");
            return;
        }
        if (this.checkTransportOption(value, "ipV4")) {
            ManagedObject userPlaneIpResourceRef = this.getUserPlaneIpResourceRef(c);
            if (userPlaneIpResourceRef == null || !userPlaneIpResourceRef.getType().equalsIgnoreCase("IpAccessHostEt")) {
                throw new ValueOutOfRangeException("userPlaneIpResourceRef", "Iub", "UserPlaneTransportOption is IP and, attribute expected type:IpAccessHostEt, configured type:" + userPlaneIpResourceRef);
            }
            ipAccessHostEtFroId = ((IpAccessHostEtMaoi)userPlaneIpResourceRef).getFroId(c);
        }
        IubDataStreamsMo iubDSRef = (IubDataStreamsMo)this.bcmGetReferenceAttribute(IUB_DATA_STREAMS_REF, c);
        iubDSRef.update(this.checkTransportOption(value, "atm"), this.checkTransportOption(value, "ipV4"), ipAccessHostEtFroId, c);
        this.sendAVC("userPlaneTransportOption", value, c);
    }

    public void eventRaised(InSignal eventmInd) {
        MessageLog.traceEnter(this.getClass(), "eventRaised()");
        MessageLog.trace(6, this.getClass(), "Unexpected signal is received and ignored. SigNo:" + eventmInd.getSigNo() + " signal name " + eventmInd.getClass().getName());
    }

    public int getFroId(Coordinator c) {
        return -21;
    }

    public int[] getScannerValue(String name) throws MoAccessException {
        if (this.myScanner == null) {
            throw new PmsException("MoScanner not available");
        }
        return this.myScanner.getValue(name);
    }
}

