/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.mao.rmo.iub;

import se.ericsson.cello.mao.Reservable;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.AttrMissingAtCreateException;
import se.ericsson.cello.moframework.IllegalParentException;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.MoNotFoundException;
import se.ericsson.cello.moframework.NotHandledAttributeTypeException;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.moframework.TransactionRequiredException;
import se.ericsson.cello.moframework.ValueOutOfRangeException;
import se.ericsson.cello.moframework.WrongAttributeTypeException;
import se.ericsson.cello.sctp.SctpMaoi;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.usaal.UniSaalTpMaoi;
import se.ericsson.cello.usaal.UniSaalTpMo;
import se.ericsson.wcdma.rbs.boam.common.AvailabilityStatusIntToEnum;
import se.ericsson.wcdma.rbs.boam.common.FroNotAccessibleException;
import se.ericsson.wcdma.rbs.boam.common.FroRequestFailedException;
import se.ericsson.wcdma.rbs.boam.common.log.MessageLog;
import se.ericsson.wcdma.rbs.boam.fpx.ncmi.proxies.NcControlLinkProxy;
import se.ericsson.wcdma.rbs.boam.fpx.ncmi.proxies.NcNbapProxy;
import se.ericsson.wcdma.rbs.boam.fpx.ncmi.sigs.LrsGetCommunicCpParamRspS;
import se.ericsson.wcdma.rbs.boam.mao.alarm.MoAlarms;
import se.ericsson.wcdma.rbs.boam.mao.bcm.BoamHelper;
import se.ericsson.wcdma.rbs.boam.mao.bcm.BoamManagedObjectWithAlarms;
import se.ericsson.wcdma.rbs.boam.mao.common.ValidateAttributes;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.IubMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.NbapDedicatedMo;

public class NbapDedicatedMoImpl
extends BoamManagedObjectWithAlarms
implements NbapDedicatedMo {
    private static final int NOT_DEFINED = -1;
    public static final int MO_DATA_REVISION = 6020101;
    private NcNbapProxy ncNbapProxy = NcNbapProxy.instance();
    private NcControlLinkProxy lrsContLinkProxy = NcControlLinkProxy.instance();

    public NbapDedicatedMoImpl(ManagedObject parent, AttrList attributes, String identity, ManagedObject source, Coordinator context) throws MoAccessException {
        super(parent, "NbapDedicated", identity, context);
        MessageLog.traceEnter(this.getClass(), "Normal constructor");
        NbapDedicatedMoImpl.checkTransaction(context);
        this.checkParent(parent);
        this.initMoData(attributes, parent, context);
        this.addObservers(63, context);
    }

    public NbapDedicatedMoImpl(MoData recoveredData) throws MoNameAlreadyTakenException, MoAccessException {
        super(recoveredData);
        MessageLog.traceEnter(this.getClass(), "Recovery constructor");
        this.myData = recoveredData;
        try {
            this.addObservers(63, null);
        }
        catch (MoAccessException e) {
            MessageLog.traceError(this.getClass(), "Couldn't init the Observers!!");
        }
        MessageLog.trace(1, this.getClass(), "Mo recovered");
    }

    public static synchronized ManagedObject create(ManagedObject parent, AttrList attributes, String identity, ManagedObject source, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(NbapDedicatedMoImpl.class, "create()");
        NbapDedicatedMoImpl createdMo = new NbapDedicatedMoImpl(parent, attributes, identity, source, context);
        return createdMo;
    }

    public String getType() {
        return "NbapDedicated";
    }

    private void initMoData(AttrList attributes, ManagedObject parent, Coordinator context) throws MoAccessException, TransactionRequiredException, AttrMissingAtCreateException, WrongAttributeTypeException, NotHandledAttributeTypeException, ValueOutOfRangeException {
        MessageLog.traceEnter(this.getClass(), "initMoData()");
        this.myData = new MoData(this.getLocalDistinguishedName(), this.getType(), true, context);
        String checkedUserLabel = ValidateAttributes.checkAndGetStringAttribute(attributes, "userLabel", "optional", "", 0, 128, "NbapDedicated");
        int checkedL2EstablishReqRetryT = ValidateAttributes.checkAndGetIntAttribute(attributes, "l2EstablishReqRetryT", "optional", 1, L2_ESTABLISH_REQ_RETRY_T_MIN_VALUES, L2_ESTABLISH_REQ_RETRY_T_MAX_VALUES, "NbapDedicated");
        int checkedL2EstablishSupervisionT = ValidateAttributes.checkAndGetIntAttribute(attributes, "l2EstablishSupervisionT", "optional", 30, L2_ESTABLISH_SUPERVISION_T_MIN_VALUES, L2_ESTABLISH_SUPERVISION_T_MAX_VALUES, "NbapDedicated");
        int checkedAlarmStatus = ValidateAttributes.checkAndGetIntAttribute(attributes, "alarmStatus", "optional", 0, ALARM_STATUS_MIN_VALUES, ALARM_STATUS_MAX_VALUES, "NbapDedicated");
        this.initAlarmStatus(checkedAlarmStatus, context);
        UniSaalTpMo uniSaalTpRef1 = this.checkAndSaveUniSaalTpRef1(attributes, parent, context);
        int unisaalCepFroId1 = -1;
        if (uniSaalTpRef1 != null) {
            uniSaalTpRef1.reserve((ManagedObject)this, context);
            unisaalCepFroId1 = uniSaalTpRef1.getUsaalCepFroId(context);
        }
        UniSaalTpMo uniSaalTpRef2 = this.checkAndSaveUniSaalTpRef2(attributes, context);
        int unisaalCepFroId2 = -1;
        if (uniSaalTpRef2 != null) {
            uniSaalTpRef2.reserve((ManagedObject)this, context);
            unisaalCepFroId2 = uniSaalTpRef2.getUsaalCepFroId(context);
        }
        ManagedObject checkedSctpRef = ValidateAttributes.checkAndGetReferenceAttribute("sctpRef", attributes, "optional", new String[]{"Sctp"}, "NbapDedicated");
        ValidateAttributes.checkOtherAttributes(attributes, "NbapDedicated");
        if (checkedSctpRef != null) {
            ((Reservable)checkedSctpRef).reserve((ManagedObject)this, context);
        }
        this.bcmStoreAndRegisterStringAttribute("userLabel", checkedUserLabel);
        this.bcmStoreAndRegisterReferenceAttribute("sctpRef", checkedSctpRef);
        this.bcmStoreAndRegisterReferenceAttribute("uniSaalTpRef1", (ManagedObject)uniSaalTpRef1);
        this.bcmStoreAndRegisterReferenceAttribute("uniSaalTpRef2", (ManagedObject)uniSaalTpRef2);
        this.lrsCreateCommuicCP(context, 0, checkedL2EstablishReqRetryT, checkedL2EstablishSupervisionT);
        this.addSbToCommunicCP(context, unisaalCepFroId1, unisaalCepFroId2);
        this.bcAddCommunicCpToNbap(context);
        this.myData.setRevision(6020101);
        this.myData.handleTransaction(context, MoData.WRITE_ACCESS);
    }

    private void lrsCreateCommuicCP(Coordinator context, int clientId, int establishTimeout, int nbapEstSupervisionT) throws MoAccessException, FroRequestFailedException, FroNotAccessibleException {
        this.lrsContLinkProxy.createCommunicCp(this.getTxIdTransactional(context), clientId, establishTimeout, nbapEstSupervisionT);
    }

    private void bcAddCommunicCpToNbap(Coordinator context) throws MoAccessException, FroRequestFailedException, FroNotAccessibleException {
        this.ncNbapProxy.addCommunicCpToNbap(this.getTxIdTransactional(context), 0);
    }

    public void delete(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "delete()");
        this.myData.handleTransaction(context, MoData.WRITE_ACCESS);
        this.ncNbapProxy.delCommunicCpFromNbap(this.getTxIdTransactional(context), 0);
        this.lrsContLinkProxy.delCommunicCp(this.getTxIdTransactional(context), 0);
        this.releaseSctpRef(context);
        this.releaseUniSaalTpRef1(context);
        this.releaseUniSaalTpRef2(context);
        this.myData.delete(context);
        this.removeObservers(context);
        super.delete(context);
        MessageLog.trace(1, this.getClass(), "NbapDedicated is Deleted");
    }

    private void releaseSctpRef(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "releaseSctpRef()");
        ManagedObject sctpMo = this.getSctpRef(context);
        if (sctpMo != null) {
            ((Reservable)sctpMo).release((ManagedObject)this, context);
            MessageLog.trace(2, this.getClass(), "SctpRef released");
        }
        this.setSctpRef(null, context);
    }

    private void releaseUniSaalTpRef1(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "releaseUniSaalTpRef1()");
        ManagedObject uniSaalTpRef1 = this.getUniSaalTpRef1(context);
        if (uniSaalTpRef1 != null) {
            ((Reservable)uniSaalTpRef1).release((ManagedObject)this, context);
            MessageLog.trace(2, this.getClass(), "uniSaalTpRef2 released");
        }
    }

    private void releaseUniSaalTpRef2(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "releaseUniSaalTpRef2()");
        ManagedObject uniSaalTpRef2 = this.getUniSaalTpRef2(context);
        if (uniSaalTpRef2 != null) {
            ((Reservable)uniSaalTpRef2).release((ManagedObject)this, context);
            MessageLog.trace(2, this.getClass(), "uniSaalTpRef2 released");
        }
    }

    private void addSbToCommunicCP(Coordinator context, int unisaalCepFroId1, int unisaalCepFroId2) throws MoAccessException, FroNotAccessibleException, FroRequestFailedException {
        MessageLog.traceEnter(this.getClass(), "addSbToCommunicCP()");
        boolean atm = NbapDedicatedMoImpl.getControlPlaneTransportOptionAttributeValue(this.getParent(), "atm", context);
        boolean ipv4 = NbapDedicatedMoImpl.getControlPlaneTransportOptionAttributeValue(this.getParent(), "ipV4", context);
        int sctpFroId = -1;
        if (atm && !ipv4) {
            sctpFroId = -1;
            this.releaseSctpRef(context);
        } else if (ipv4 && !atm) {
            unisaalCepFroId1 = -1;
            unisaalCepFroId2 = -1;
            ManagedObject sctpMo = this.getSctpRef(context);
            if (sctpMo == null) {
                MoIterator sctpMos = BoamHelper.findMOs("Sctp");
                if (sctpMos.hasMoreElements()) {
                    sctpMo = (ManagedObject)sctpMos.nextElement();
                }
                if (sctpMo == null) {
                    MessageLog.traceError(this.getClass(), " For IP node: Couldn't finde Motype:Sctp");
                    throw new MoNotFoundException("For IP node: Couldn't finde Motype:Sctp");
                }
                this.setSctpRef(sctpMo, context);
            }
            sctpFroId = ((SctpMaoi)sctpMo).getFroId(context);
        } else {
            unisaalCepFroId1 = -1;
            unisaalCepFroId2 = -1;
            sctpFroId = -1;
        }
        this.lrsContLinkProxy.setCommunicSbRef(this.getTxIdTransactional(context), 0, unisaalCepFroId1, unisaalCepFroId2, sctpFroId);
    }

    public void controlPlaneTransportOptionUpdated(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "update()");
        ValidateAttributes.checkTransaction(context);
        this.myData.handleTransaction(context, MoData.WRITE_ACCESS);
        int unisaalCepFroId1 = -1;
        int unisaalCepFroId2 = -1;
        ManagedObject uniRef1 = this.getUniSaalTpRef1(context);
        ManagedObject uniRef2 = this.getUniSaalTpRef2(context);
        if (uniRef1 != null) {
            unisaalCepFroId1 = ((UniSaalTpMaoi)uniRef1).getUsaalCepFroId(context);
        }
        if (uniRef2 != null) {
            unisaalCepFroId2 = ((UniSaalTpMaoi)uniRef2).getUsaalCepFroId(context);
        }
        this.addSbToCommunicCP(context, unisaalCepFroId1, unisaalCepFroId2);
    }

    public String getUserLabel(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getUserLabel() ");
        return this.bcmGetStringAttribute("userLabel", context);
    }

    public void setUserLabel(String value, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setUserLabel() ");
        this.bcmSetStringAttribute("userLabel", value, 0, 128, this.getType(), context);
        this.sendAVC("userLabel", value, context);
    }

    public int getNbOfSB(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getNbOfSB()");
        LrsGetCommunicCpParamRspS cfmSig = this.lrsContLinkProxy.getCommunicCpParam(0, this.getTxIdNonTransactional(context));
        return cfmSig.numberOfSb;
    }

    public String getNbapDedicatedId(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getNbapDedicatedId()");
        return super.bcmGetIdentity(this.getLocalDistinguishedName(), context);
    }

    public int getOperationalState(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getOperationalState()");
        LrsGetCommunicCpParamRspS cfmSig = this.lrsContLinkProxy.getCommunicCpParam(0, this.getTxIdNonTransactional(context));
        return cfmSig.opState;
    }

    public void setL2EstablishReqRetryT(int l2EstablishReqRetryT, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setL2EstablishReqRetryT()");
        ValidateAttributes.checkTransaction(context);
        this.myData.handleTransaction(context, MoData.WRITE_ACCESS);
        ValidateAttributes.intValueRangeCheck("l2EstablishReqRetryT", l2EstablishReqRetryT, L2_ESTABLISH_REQ_RETRY_T_MIN_VALUES, L2_ESTABLISH_REQ_RETRY_T_MAX_VALUES, "NbapDedicated");
        this.lrsContLinkProxy.setCommuEstRetry(this.getTxIdTransactional(context), 0, l2EstablishReqRetryT);
        this.sendAVC("l2EstablishReqRetryT", l2EstablishReqRetryT, context);
    }

    public void setL2EstablishSupervisionT(int l2EstablishSupervisionT, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), " setL2EstablishSupervisionT()");
        ValidateAttributes.checkTransaction(context);
        this.myData.handleTransaction(context, MoData.WRITE_ACCESS);
        ValidateAttributes.intValueRangeCheck("l2EstablishSupervisionT", l2EstablishSupervisionT, L2_ESTABLISH_SUPERVISION_T_MIN_VALUES, L2_ESTABLISH_SUPERVISION_T_MAX_VALUES, "NbapDedicated");
        this.lrsContLinkProxy.setCommuNbapSuperv(this.getTxIdTransactional(context), 0, l2EstablishSupervisionT);
        this.sendAVC("l2EstablishSupervisionT", l2EstablishSupervisionT, context);
    }

    public int getAvailabilityStatus(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getAvailabilityStatus()");
        LrsGetCommunicCpParamRspS cfmSig = this.lrsContLinkProxy.getCommunicCpParam(0, this.getTxIdNonTransactional(context));
        return AvailabilityStatusIntToEnum.convGetAvailStatIntToEnum(cfmSig.availStatus);
    }

    public int getActiveBearer(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getActiveBearer()");
        LrsGetCommunicCpParamRspS cfmSig = this.lrsContLinkProxy.getCommunicCpParam(0, this.getTxIdNonTransactional(context));
        return cfmSig.activeSb;
    }

    public ManagedObject getUniSaalTpRef1(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getUniSaalTpRef1()");
        return this.bcmGetReferenceAttribute("uniSaalTpRef1", context);
    }

    public ManagedObject getUniSaalTpRef2(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getUniSaalTpRef2()");
        return this.bcmGetReferenceAttribute("uniSaalTpRef2", context);
    }

    public int getL2EstablishReqRetryT(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getL2EstablishReqRetryT()");
        LrsGetCommunicCpParamRspS cfmSig = this.lrsContLinkProxy.getCommunicCpParam(0, this.getTxIdNonTransactional(context));
        return cfmSig.estRetryT;
    }

    public int getL2EstablishSupervisionT(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getL2EstablishSupervisionT()");
        LrsGetCommunicCpParamRspS cfmSig = this.lrsContLinkProxy.getCommunicCpParam(0, this.getTxIdNonTransactional(context));
        return cfmSig.nbapEstSupervisionT;
    }

    public MoData getMyMoData() {
        MessageLog.traceEnter(this.getClass(), "getMyMoData()");
        return this.myData;
    }

    public boolean isMyMoDataPersistent() {
        MessageLog.traceEnter(this.getClass(), "isMyMoDataPersistent()");
        return true;
    }

    private void checkParent(ManagedObject parent) throws MoAccessException {
        if (!(parent instanceof IubMo)) {
            throw new IllegalParentException("Expecting Iub, received:" + parent.getClass().getName());
        }
    }

    private static boolean getControlPlaneTransportOptionAttributeValue(ManagedObject parent, String attributeName, Coordinator c) throws MoAccessException {
        Struct st = ((IubMo)parent).getControlPlaneTransportOption(c);
        return st != null && st.getNames().length != 0 ? (Boolean)st.getValue(attributeName) : false;
    }

    private UniSaalTpMo checkAndSaveUniSaalTpRef1(AttrList attributes, ManagedObject parent, Coordinator context) throws MoAccessException {
        int moUnSaTpRef1AttrIndex = attributes.indexOf("uniSaalTpRef1");
        UniSaalTpMo uniSaalTpRef1 = null;
        if (moUnSaTpRef1AttrIndex == -1) {
            MessageLog.trace(1, this.getClass(), " uniSaalTpRef1 is not included in the attribute list ");
            if ("optional".equalsIgnoreCase("mandatory") && NbapDedicatedMoImpl.getControlPlaneTransportOptionAttributeValue(parent, "atm", context)) {
                throw new AttrMissingAtCreateException("uniSaalTpRef1", this.getType());
            }
            return uniSaalTpRef1;
        }
        if (!(attributes.getValue(moUnSaTpRef1AttrIndex) instanceof UniSaalTpMo)) {
            MessageLog.trace(1, this.getClass(), " uniSaalTpRef1 has wrong type ");
            throw new WrongAttributeTypeException("uniSaalTpRef1", this.getType());
        }
        uniSaalTpRef1 = (UniSaalTpMo)attributes.getValue(moUnSaTpRef1AttrIndex);
        if (uniSaalTpRef1.getReservedBy(context) != null) {
            MessageLog.trace(1, this.getClass(), "uniRef1 already reserved by another MO");
            throw new WrongAttributeTypeException("uniSaalTpRef1", this.getType());
        }
        attributes.removeElementAt(moUnSaTpRef1AttrIndex);
        return uniSaalTpRef1;
    }

    private UniSaalTpMo checkAndSaveUniSaalTpRef2(AttrList attributes, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "checkAndSaveUniSaalTpRef2()");
        UniSaalTpMo uniSaalTpRef2 = null;
        int moUnSaTpRef2AttrIndex = attributes.indexOf("uniSaalTpRef2");
        if (moUnSaTpRef2AttrIndex == -1) {
            MessageLog.trace(1, this.getClass(), " uniSaalTpRef2 is not included in the attribute list ");
            if ("optional".equalsIgnoreCase("mandatory")) {
                throw new AttrMissingAtCreateException("uniSaalTpRef2", this.getType());
            }
            return uniSaalTpRef2;
        }
        if (!(attributes.getValue(moUnSaTpRef2AttrIndex) instanceof UniSaalTpMo)) {
            MessageLog.trace(1, this.getClass(), " uniSaalTpRef2 has wrong type ");
            throw new WrongAttributeTypeException("uniSaalTpRef2", this.getType());
        }
        uniSaalTpRef2 = (UniSaalTpMo)attributes.getValue(moUnSaTpRef2AttrIndex);
        if (uniSaalTpRef2.getReservedBy(context) != null) {
            MessageLog.trace(1, this.getClass(), "uniSaalTpRef2 already reserved by another MO ");
            throw new WrongAttributeTypeException("uniSaalTpRef2", this.getType());
        }
        attributes.removeElementAt(moUnSaTpRef2AttrIndex);
        return uniSaalTpRef2;
    }

    protected void addObservers(int froType, Coordinator context) throws MoAccessException {
        this.myMoAlarms = new MoAlarms((ManagedObject)this, this.lrsContLinkProxy, froType, -3, context);
    }

    protected void removeObservers(Coordinator context) throws MoAccessException {
        this.myMoAlarms.delete(context);
    }

    public ManagedObject getSctpRef(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getSctpRef()");
        return this.bcmGetReferenceAttribute("sctpRef", c);
    }

    private void setSctpRef(ManagedObject sctpRef, Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setSctpRef()");
        this.myData.handleTransaction(c, MoData.WRITE_ACCESS);
        if (sctpRef != null) {
            ((Reservable)sctpRef).reserve((ManagedObject)this, c);
        }
        this.bcmSetReferenceAttribute("sctpRef", sctpRef, this.getType(), c);
    }

    public void setUniSaalTpRef2(ManagedObject uniSaalTpRef2, Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setUniSaalTpRef2()");
        NbapDedicatedMoImpl.checkTransaction(c);
        this.myData.handleTransaction(c, MoData.WRITE_ACCESS);
        if (!this.checkSetUniSaalTpRef("uniSaalTpRef2", uniSaalTpRef2, this.getUniSaalTpRef2(c), this.getUniSaalTpRef1(c), c)) {
            return;
        }
        this.releaseUniSaalTpRef2(c);
        if (uniSaalTpRef2 != null) {
            ((Reservable)uniSaalTpRef2).reserve((ManagedObject)this, c);
        }
        this.bcmSetReferenceAttribute("uniSaalTpRef2", uniSaalTpRef2, this.getType(), c);
        this.updateSB(c);
        this.sendAVC("uniSaalTpRef2", uniSaalTpRef2, c);
    }

    public void setUniSaalTpRef1(ManagedObject uniSaalTpRef1, Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setUniSaalTpRef1()");
        NbapDedicatedMoImpl.checkTransaction(c);
        this.myData.handleTransaction(c, MoData.WRITE_ACCESS);
        if (!this.checkSetUniSaalTpRef("uniSaalTpRef1", uniSaalTpRef1, this.getUniSaalTpRef1(c), this.getUniSaalTpRef2(c), c)) {
            return;
        }
        this.releaseUniSaalTpRef1(c);
        if (uniSaalTpRef1 != null) {
            ((Reservable)uniSaalTpRef1).reserve((ManagedObject)this, c);
        }
        this.bcmSetReferenceAttribute("uniSaalTpRef1", uniSaalTpRef1, this.getType(), c);
        this.updateSB(c);
        this.sendAVC("uniSaalTpRef1", uniSaalTpRef1, c);
    }

    private boolean checkSetUniSaalTpRef(String attrName, ManagedObject newUniSaalTpRef, ManagedObject uniSaalTpRef2Change, ManagedObject nextUniSaalTpRef, Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "checkSetUniSaalTpRef() attrName:" + attrName);
        boolean atm = NbapDedicatedMoImpl.getControlPlaneTransportOptionAttributeValue(this.getParent(), "atm", c);
        boolean ipv4 = NbapDedicatedMoImpl.getControlPlaneTransportOptionAttributeValue(this.getParent(), "ipV4", c);
        if (atm && !ipv4 && newUniSaalTpRef == null && nextUniSaalTpRef == null) {
            MessageLog.trace(2, this.getClass(), attrName + " on the NbapDedicated,  both uniSaalTpRef1 and uniSaalTpRef2 are not allowed as NULLs in ATM mode");
            throw new ValueOutOfRangeException(attrName, "NbapDedicated", " both uniSaalTpRef1 and uniSaalTpRef2 are not allowed as NULLs in ATM mode");
        }
        if (newUniSaalTpRef != null) {
            if (!newUniSaalTpRef.getType().equalsIgnoreCase("UniSaalTp")) {
                MessageLog.trace(2, this.getClass(), attrName + " is of wrong type, expected UniSaalTpMo");
                throw new WrongAttributeTypeException(attrName, this.getType());
            }
            if (uniSaalTpRef2Change != null && uniSaalTpRef2Change.getLocalDistinguishedName().equalsIgnoreCase(newUniSaalTpRef.getFullDistinguishedName())) {
                MessageLog.trace(2, this.getClass(), attrName + " sets to the same value as before, ignoring!! OldRef=newRef= " + newUniSaalTpRef.getLocalDistinguishedName());
                return false;
            }
            ManagedObject reserver = ((UniSaalTpMo)newUniSaalTpRef).getReservedBy(c);
            if (reserver != null) {
                MessageLog.trace(2, this.getClass(), " uniSaalTpRef already reserved by another MO. The new " + attrName + newUniSaalTpRef.getLocalDistinguishedName() + " The reserver: " + reserver.getLocalDistinguishedName());
                throw new ValueOutOfRangeException(attrName, "NbapDedicated", " uniSaalTpRef already reserved by another MO. The new " + attrName + newUniSaalTpRef.getLocalDistinguishedName() + " The reserver: " + reserver.getLocalDistinguishedName());
            }
        }
        return true;
    }

    private void updateSB(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "updateSB()");
        ManagedObject uniSaalTpRef1 = this.getUniSaalTpRef1(c);
        ManagedObject uniSaalTpRef2 = this.getUniSaalTpRef2(c);
        int unisaalCepFroId1 = -1;
        int unisaalCepFroId2 = -1;
        if (uniSaalTpRef1 != null) {
            unisaalCepFroId1 = ((UniSaalTpMaoi)uniSaalTpRef1).getUsaalCepFroId(c);
        }
        if (uniSaalTpRef2 != null) {
            unisaalCepFroId2 = ((UniSaalTpMaoi)uniSaalTpRef2).getUsaalCepFroId(c);
        }
        this.addSbToCommunicCP(c, unisaalCepFroId1, unisaalCepFroId2);
    }
}

