/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.mao.rmo.node;

import java.util.ArrayList;
import java.util.List;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoCanNotBeCreatedException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoFactory;
import se.ericsson.cello.moframework.MoFactoryMgr;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.MoNotFoundException;
import se.ericsson.cello.moframework.MoRepository;
import se.ericsson.cello.transaction.Control;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.InactiveTransactionException;
import se.ericsson.cello.transaction.Terminator;
import se.ericsson.cello.transaction.TransactionRolledBackException;
import se.ericsson.cello.transaction.TransactionServiceImpl;
import se.ericsson.wcdma.rbs.boam.common.FroStateObserver;
import se.ericsson.wcdma.rbs.boam.common.generic.RbsGenericLicenseManager;
import se.ericsson.wcdma.rbs.boam.common.log.MessageLog;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.proxies.ChcNodeBFunctionProxy;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.RbsLicenseFeatureT;
import se.ericsson.wcdma.rbs.boam.mao.rmo.cell.RbsLocalCellMoImpl;
import se.ericsson.wcdma.rbs.boam.mao.rmo.node.NodeBFunctionMoImpl;
import se.ericsson.wcdma.rbs.boam.mao.rmo.node.RbsFeatureMoImpl;

public class RbsFeatureMoFactory
implements MoFactory,
FroStateObserver {
    private static RbsFeatureMoFactory instance = null;
    private static final ChcNodeBFunctionProxy chcNodeBProxy = ChcNodeBFunctionProxy.instance();
    public static final int CLIENT_ID = 0;

    private RbsFeatureMoFactory() {
        MessageLog.traceEnter(this.getClass(), "constructor");
        MoFactoryMgr.instance().register((MoFactory)this, this.getMoTypeName());
        chcNodeBProxy.registerForStatePropagation(null, this);
    }

    public static synchronized RbsFeatureMoFactory instance() {
        MessageLog.traceEnter(RbsFeatureMoFactory.class, "RbsFeatureMoFactory.instance()");
        if (instance == null) {
            instance = new RbsFeatureMoFactory();
        }
        return instance;
    }

    public ManagedObject createMo(ManagedObject parent, AttrList attributes, String identity, ManagedObject source, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "createMo()");
        throw new MoCanNotBeCreatedException(this.getMoTypeName());
    }

    public ManagedObject recoverMo(MoData recoveredData) throws MoNameAlreadyTakenException {
        MessageLog.traceEnter(this.getClass(), "recoverMo()");
        RbsFeatureMoImpl myData = null;
        try {
            myData = new RbsFeatureMoImpl(recoveredData);
        }
        catch (MoAccessException e) {
            e.printStackTrace();
        }
        return myData;
    }

    public String getMoTypeName() {
        return "RbsFeature";
    }

    public void serviceRemoved(String proxyName) {
    }

    public void serviceAvailable(String proxyName) throws MoAccessException {
        Control tx = null;
        try {
            tx = TransactionServiceImpl.instance().getTransactionFactory().create(5000);
            Coordinator txCoordinator = tx.getCoordinator();
            Terminator txTerminator = tx.getTerminator();
            ArrayList licenseFeatureListFro = RbsFeatureMoFactory.chcNodeBProxy.getFeatLicenseConst((int)txCoordinator.getTransactionID(), (int)0).licenseFeatureList;
            MessageLog.trace(9, this.getClass(), "getLicenseFeatureListFro");
            this.printRbsLicenseFeatureTList(licenseFeatureListFro);
            List licenseFeatureListMao = this.getLicenseFeatureListMao(txCoordinator);
            MessageLog.trace(9, this.getClass(), "getLicenseFeatureListMao");
            this.printRbsLicenseFeatureTList(licenseFeatureListMao);
            RbsGenericLicenseManager.generateFeatureMap(licenseFeatureListFro);
            this.deleteRbsFeatureMos(licenseFeatureListFro, licenseFeatureListMao, txCoordinator);
            this.createRbsFeatureMos(licenseFeatureListFro, licenseFeatureListMao, txCoordinator);
            txTerminator.commit();
        }
        catch (TransactionRolledBackException e) {
            e.printStackTrace();
        }
        catch (InactiveTransactionException e) {
            e.printStackTrace();
        }
    }

    private void deleteRbsFeatureMos(List froList, List maoList, Coordinator txCoordinator) throws MoAccessException {
        ArrayList copyMaoList = new ArrayList();
        copyMaoList.addAll(maoList);
        copyMaoList.removeAll(froList);
        MessageLog.trace(9, this.getClass(), "deleteRbsFeatureMos,copyMaoList");
        this.printRbsLicenseFeatureTList(copyMaoList);
        MoIterator iter = MoRepository.instance().lookupType(this.getMoTypeName());
        if (null == iter) {
            return;
        }
        while (iter.hasMoreElements()) {
            RbsFeatureMoImpl featureMo = (RbsFeatureMoImpl)iter.nextElement();
            RbsLicenseFeatureT tempRbsLicFeat = featureMo.getRbsLicFeature(txCoordinator);
            for (int i = 0; i < copyMaoList.size(); ++i) {
                if (!tempRbsLicFeat.equals((RbsLicenseFeatureT)copyMaoList.get(i))) continue;
                MessageLog.trace(9, this.getClass(), "delete :" + featureMo.getLocalDistinguishedName());
                featureMo.sysDelete(txCoordinator);
            }
        }
    }

    private void createRbsFeatureMos(List froList, List maoList, Coordinator txCoordinator) throws MoAccessException {
        int localFeatureFroId = -1;
        ArrayList copyFroList = new ArrayList();
        copyFroList.addAll(froList);
        copyFroList.removeAll(maoList);
        MessageLog.trace(9, this.getClass(), "createRbsFeatureMos,copyFroList");
        this.printRbsLicenseFeatureTList(copyFroList);
        NodeBFunctionMoImpl nodeB = NodeBFunctionMoImpl.getTheOneAndOnly();
        ManagedObject parentLic = MoRepository.instance().lookup("ManagedElement=1,SystemFunctions=1,Licensing=1");
        if (parentLic == null) {
            throw new MoNotFoundException("can not find parent: ManagedElement=1,SystemFunctions=1,Licensing=1");
        }
        for (int i = 0; i < copyFroList.size(); ++i) {
            RbsLicenseFeatureT tempRbsLicFeat = (RbsLicenseFeatureT)copyFroList.get(i);
            if (tempRbsLicFeat.featureType == 0) {
                localFeatureFroId = chcNodeBProxy.createRbsFeatureRo(txCoordinator.getTransactionID(), 0, tempRbsLicFeat.internalID, -1);
                new RbsFeatureMoImpl(parentLic, this.getMoTypeName(), tempRbsLicFeat.licenseName, tempRbsLicFeat, nodeB, localFeatureFroId, txCoordinator);
                continue;
            }
            MoIterator cellIter = MoRepository.instance().lookupType("RbsLocalCell");
            if (null == cellIter) {
                MessageLog.trace(9, this.getClass(), "no cell found, do nothing");
                continue;
            }
            while (cellIter.hasMoreElements()) {
                RbsLocalCellMoImpl cellMo = (RbsLocalCellMoImpl)cellIter.nextElement();
                localFeatureFroId = chcNodeBProxy.createRbsFeatureRo(txCoordinator.getTransactionID(), 0, tempRbsLicFeat.internalID, cellMo.getCellFroId(txCoordinator));
                new RbsFeatureMoImpl(parentLic, this.getMoTypeName(), cellMo.getNamingAttributeValue() + "-" + tempRbsLicFeat.licenseName, tempRbsLicFeat, cellMo, localFeatureFroId, txCoordinator);
            }
        }
    }

    private List getLicenseFeatureListMao(Coordinator txCoordinator) throws MoAccessException {
        ArrayList<RbsLicenseFeatureT> lst = new ArrayList<RbsLicenseFeatureT>();
        MoIterator iter = MoRepository.instance().lookupType(this.getMoTypeName());
        if (null == iter) {
            return lst;
        }
        while (iter.hasMoreElements()) {
            RbsFeatureMoImpl featureMo = (RbsFeatureMoImpl)iter.nextElement();
            RbsLicenseFeatureT tempRbsLicFeat = featureMo.getRbsLicFeature(txCoordinator);
            if (lst.contains(tempRbsLicFeat)) continue;
            lst.add(tempRbsLicFeat);
        }
        return lst;
    }

    private void printRbsLicenseFeatureTList(List lst) {
        for (int i = 0; i < lst.size(); ++i) {
            MessageLog.trace(9, this.getClass(), "******************internalID : " + ((RbsLicenseFeatureT)lst.get((int)i)).internalID + "******************featureType : " + ((RbsLicenseFeatureT)lst.get((int)i)).featureType + "******************licenseKey : " + ((RbsLicenseFeatureT)lst.get((int)i)).licenseKey + "******************licenseName : " + ((RbsLicenseFeatureT)lst.get((int)i)).licenseName + "******************hasFeatureState : " + ((RbsLicenseFeatureT)lst.get((int)i)).hasFeatureState);
        }
    }
}

