/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.pms.impl;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import se.ericsson.wcdma.rbs.boam.common.log.MessageLog;
import se.ericsson.wcdma.rbs.boam.pms.impl.Counter;
import se.ericsson.wcdma.rbs.boam.pms.impl.CounterScannerAgent;
import se.ericsson.wcdma.rbs.boam.pms.impl.MoScannerAgentMgr;
import se.ericsson.wcdma.rbs.boam.pms.impl.PmsException;
import se.ericsson.wcdma.rbs.boam.pms.impl.RBScannerFactory;

public class MoScannerAgent {
    private final Map counterScannerAgents = new HashMap(1);

    public MoScannerAgent(String moType, List counters) throws PmsException {
        MessageLog.trace(3, this.getClass(), "MoScannerAgent(), MO type:" + moType);
        if (moType == null) {
            throw new PmsException("MO type cannot be null");
        }
        if (moType.length() == 0) {
            throw new PmsException("MO type name cannot be empty string");
        }
        if (counters == null) {
            throw new PmsException("counters cannot be null, MO type: " + moType);
        }
        if (counters.isEmpty()) {
            throw new PmsException("counters list cannot be empty, MO type: " + moType);
        }
        this.init(moType, counters);
        MoScannerAgentMgr.instance().register(moType, this);
    }

    private void init(String moType, List counters) {
        MessageLog.trace(3, this.getClass(), "init()");
        Iterator iter = counters.iterator();
        while (iter.hasNext()) {
            Counter counter = (Counter)iter.next();
            if (this.counterScannerAgents.containsKey(counter.getName())) {
                MessageLog.traceError(this.getClass(), "The counter is already is registered:" + counter.getName());
                continue;
            }
            this.counterScannerAgents.put(counter.getName(), new CounterScannerAgent(counter));
        }
        RBScannerFactory.instance().registerObservationClass(moType, counters);
    }

    public CounterScannerAgent lookup(String counter) {
        if (counter == null) {
            MessageLog.trace(3, this.getClass(), "The counter is null.");
            return null;
        }
        if (!this.counterScannerAgents.containsKey(counter)) {
            MessageLog.trace(3, this.getClass(), "The counter is already is registered:" + counter);
            return null;
        }
        return (CounterScannerAgent)this.counterScannerAgents.get(counter);
    }
}

