/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.pmapplication;

import se.ericsson.cello.pms.generic.BasicScannerFactory;
import se.ericsson.cello.pms.generic.PmStateListener;
import se.ericsson.cello.pms.generic.PmsPortal;
import se.ericsson.cello.support.servloc.ServiceLocatorFacade;
import se.ericsson.cello.support.servloc.ServiceRepository;
import se.ericsson.crbs.cat.pmapplication.PmThreadSwitcherI;
import se.ericsson.crbs.cat.pmcommon.PmBase;
import se.ericsson.crbs.cat.pmcommon.PmCounterRegistrationItem;
import se.ericsson.crbs.cat.pmcommon.PmLists;
import se.ericsson.crbs.omf.mao.genericmo.attributes.manager.PmCounter;
import se.ericsson.crbs.omf.mao.genericmo.attributes.manager.PmCounterRegistration;
import se.ericsson.crbs.omf.mao.genericmo.attributes.manager.PmMoClassCounterType;

public class PmStateListenerImpl
extends PmBase
implements PmStateListener,
PmCounterRegistration {
    private PmsPortal m_pmsPortal;
    private BasicScannerFactory m_scannerFactory;
    private Callback m_callback;
    private PmThreadSwitcherI m_threadSwitcher;
    private PmLists.PmCounterRegistrationItemList m_counterRegistrationItems;

    public PmStateListenerImpl(Callback callback, PmsPortal pmsPortal, BasicScannerFactory scannerFactory, PmThreadSwitcherI threadSwitcher) {
        this.info("PmStateListener created");
        this.m_pmsPortal = pmsPortal;
        this.m_scannerFactory = scannerFactory;
        this.m_callback = callback;
        this.m_threadSwitcher = threadSwitcher;
        this.m_counterRegistrationItems = new PmLists.PmCounterRegistrationItemList();
        this.m_callback.stateListener_mopplet_startEvent();
    }

    public synchronized void init() {
        this.enter("init");
        this.general("Start signal proxy and wait for counter registrations");
        String riLinkName = "RiLink";
        String riPortName = "RiPort";
        String[] riLinkCounterNames = new String[]{"pmLinkDelayHigh", "pmLinkDelayLow", "pmLinkRestart", "pmLinkStabilityError"};
        String[] riPortCounterNames = new String[]{"pmBitError", "pmL3OamBadCrc", "pmL3OamRetransmission", "pmLossOfFrame", "pmLossOfSignal", "pmSfpRxPower", "pmSfpTemperature", "pmSfpTxBias", "pmSfpTxPower", "pmSfpVoltage"};
        int[] riLinkMultiplicities = new int[]{1, 1, 1, 1};
        int[] riPortMultiplicities = new int[]{6, 1, 1, 1, 1, 1, 1, 1, 1, 1};
        this.m_pmsPortal.registerCounterTypes(riLinkName, riLinkCounterNames, riLinkMultiplicities, this.m_scannerFactory);
        this.m_pmsPortal.registerCounterTypes(riPortName, riPortCounterNames, riPortMultiplicities, this.m_scannerFactory);
        for (int i = 0; i < this.m_counterRegistrationItems.size(); ++i) {
            PmCounterRegistrationItem counterRegistrationItem = this.m_counterRegistrationItems.get(i);
            String moClassName = counterRegistrationItem.moClassName;
            PmCounter[] pmCounters = counterRegistrationItem.pmCounters;
            String[] counterNames = new String[pmCounters.length];
            int[] counterMultiplicities = new int[pmCounters.length];
            for (int j = 0; j < counterNames.length; ++j) {
                counterNames[j] = pmCounters[j].getCounterName();
                counterMultiplicities[j] = pmCounters[j].getMultiplicity();
            }
            this.m_pmsPortal.registerCounterTypes(moClassName, counterNames, counterMultiplicities, this.m_scannerFactory);
        }
        this.info("PmsiAdaptor registered counters for " + this.m_counterRegistrationItems.size() + " MO classes to PMS");
    }

    public void start() {
        this.enter("start");
    }

    private static void appendKeyValue(StringBuffer buffer, String key, String value) {
        int length;
        if (value == null) {
            length = 0;
            value = "<NULL>";
        } else {
            length = value.length();
        }
        buffer.append("\n");
        buffer.append(key);
        buffer.append(": (");
        buffer.append(length);
        buffer.append(")'");
        buffer.append(value);
        buffer.append("'");
    }

    private static void appendKeyValue(StringBuffer buffer, String key, long value) {
        buffer.append("\n");
        buffer.append(key);
        buffer.append(": ");
        buffer.append(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean registerCounters(PmMoClassCounterType[] counterTypes) {
        this.enter("registerCounters");
        boolean validCounterTypes = true;
        block5: for (int i = 0; i < counterTypes.length; ++i) {
            PmMoClassCounterType pmCounterType = counterTypes[i];
            String moClassName = pmCounterType.getMoClassName();
            PmCounter[] pmCounters = pmCounterType.getPmCounters();
            if (moClassName.equals("")) {
                this.error("Empty moClassName name.");
                validCounterTypes = false;
                break;
            }
            for (int j = 0; j < pmCounters.length; ++j) {
                PmCounter pmCounter = pmCounters[j];
                String pmCounterName = pmCounter.getCounterName();
                int counterMultiplicity = pmCounter.getMultiplicity();
                if (pmCounterName.equals("")) {
                    this.error("Found empty counter name for moClassName (" + moClassName + ").");
                    validCounterTypes = false;
                    continue block5;
                }
                if (counterMultiplicity >= 1 && counterMultiplicity <= 256) continue;
                this.error("Found invalid counter multiplicity (" + counterMultiplicity + ") for pmCounterName (" + pmCounterName + "), moClassName (" + moClassName + ")." + " Minimum is 1 and maximum is " + 256);
                validCounterTypes = false;
            }
        }
        boolean countersRegistered = false;
        if (validCounterTypes) {
            StoreCounterTypesRunnable storeCounterTypesRunnable = new StoreCounterTypesRunnable(counterTypes);
            this.m_threadSwitcher.executeInMainThread(storeCounterTypesRunnable);
            StoreCounterTypesRunnable storeCounterTypesRunnable2 = storeCounterTypesRunnable;
            synchronized (storeCounterTypesRunnable2) {
                long waitTime = 3000L;
                long endTime = System.currentTimeMillis() + waitTime;
                while (!storeCounterTypesRunnable.hasStoredCounters()) {
                    try {
                        long timeLeft = endTime - System.currentTimeMillis();
                        if (waitTime < timeLeft || timeLeft <= 0L) break;
                        storeCounterTypesRunnable.wait(timeLeft);
                    }
                    catch (InterruptedException timeLeft) {}
                }
                if (storeCounterTypesRunnable.hasStoredCounters()) {
                    countersRegistered = true;
                } else {
                    StringBuffer moClasses = new StringBuffer();
                    for (int i = 0; i < counterTypes.length; ++i) {
                        PmMoClassCounterType pmCounterType = counterTypes[i];
                        String moClassName = pmCounterType.getMoClassName();
                        moClasses.append(" " + moClassName);
                    }
                    this.error("PmsiAdaptor failed to store counter registrations, PM counters will not be reported for MO class(es):" + moClasses.toString());
                }
            }
        }
        return countersRegistered;
    }

    public void publishService() {
        this.enter("publishService");
        ServiceRepository serviceRepository = ServiceLocatorFacade.getRepository();
        if (serviceRepository == null) {
            this.error("ServiceRepository is NULL");
        }
        serviceRepository.addService((Object)this, PmCounterRegistration.class, null);
    }

    public class StoreCounterTypesRunnable
    implements Runnable {
        private PmLists.PmCounterRegistrationItemList m_innerCounterTypes = new PmLists.PmCounterRegistrationItemList();
        private boolean m_hasStoredCounters = false;

        public StoreCounterTypesRunnable(PmMoClassCounterType[] counterTypes) {
            for (int i = 0; i < counterTypes.length; ++i) {
                String moClassName = counterTypes[i].getMoClassName();
                PmCounter[] pmCounters = counterTypes[i].getPmCounters();
                String innerMoClassName = moClassName;
                PmCounter[] innerPmCounters = new PmCounter[pmCounters.length];
                for (int j = 0; j < innerPmCounters.length; ++j) {
                    PmCounter innerPmCounter;
                    PmCounter pmCounter = pmCounters[j];
                    String innerCounterName = pmCounter.getCounterName();
                    int innerCounterMultiplicity = pmCounter.getMultiplicity();
                    StringBuffer buffer = new StringBuffer();
                    buffer.append("Received counter definition.");
                    PmStateListenerImpl.appendKeyValue(buffer, "moClassName", innerMoClassName);
                    PmStateListenerImpl.appendKeyValue(buffer, "counterName", innerCounterName);
                    PmStateListenerImpl.appendKeyValue(buffer, "multiplicity", innerCounterMultiplicity);
                    PmStateListenerImpl.this.general(buffer.toString());
                    innerPmCounters[j] = innerPmCounter = new PmCounter(innerCounterName, innerCounterMultiplicity);
                }
                this.m_innerCounterTypes.add(new PmCounterRegistrationItem(innerMoClassName, innerPmCounters));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            PmStateListenerImpl.this.enter("StoreCounterTypesRunnable.run");
            for (int i = 0; i < this.m_innerCounterTypes.size(); ++i) {
                PmStateListenerImpl.this.m_counterRegistrationItems.add(this.m_innerCounterTypes.get(i));
            }
            StoreCounterTypesRunnable storeCounterTypesRunnable = this;
            synchronized (storeCounterTypesRunnable) {
                this.m_hasStoredCounters = true;
                this.notify();
            }
        }

        public boolean hasStoredCounters() {
            return this.m_hasStoredCounters;
        }

        public PmLists.PmCounterRegistrationItemList getInnerCounterTypes() {
            return this.m_innerCounterTypes;
        }
    }

    public static interface Callback {
        public void stateListener_mopplet_startEvent();
    }
}

