/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.pmproxy.signals;

import enea.ose.io.SignalInputStream;
import enea.ose.io.SignalOutputStream;
import enea.ose.system.UnlinkedSignal;
import java.io.IOException;
import se.ericsson.crbs.cat.pmcommon.PmBase;
import se.ericsson.crbs.logging.AbstractLogger;

public abstract class PmBaseSignal
extends UnlinkedSignal {
    protected final Class THIS_CLASS;
    protected final AbstractLogger logger;
    public final String signalName;
    public final String signalIdentity;
    public long procedureRef;
    public long connectionRef;

    protected PmBaseSignal(Class cls, String sigName, int sigNo) {
        super(sigNo);
        this.THIS_CLASS = cls;
        this.logger = PmBase.getLogger(this.THIS_CLASS.getName());
        this.signalName = sigName;
        this.signalIdentity = "SignalNo = " + sigNo;
    }

    protected abstract boolean onInitReceive(SignalInputStream var1) throws IOException;

    protected abstract boolean onInitSend(SignalOutputStream var1) throws IOException;

    public void initReceive() {
        this.enter("initReceive");
        this.general("Receiving signal: " + this.signalName);
        SignalInputStream sis = this.getSignalInputStream();
        try {
            this.procedureRef = sis.readU32();
            this.connectionRef = sis.readU32();
            this.onInitReceive(sis);
        }
        catch (IOException e) {
            this.error("Failed to receive signal " + this.signalName + ": " + this.signalIdentity + e.getMessage());
        }
    }

    public void initSend() {
        this.enter("initSend");
        SignalOutputStream sos = this.getSignalOutputStream();
        try {
            sos.writeU32(this.procedureRef);
            sos.writeU32(this.connectionRef);
            this.onInitSend(sos);
        }
        catch (IOException e) {
            this.error("Exception: " + e);
        }
    }

    public void info(String msg) {
        this.logger.info(this.THIS_CLASS, msg);
    }

    public void debug(String msg) {
        this.logger.traceDebug(this.THIS_CLASS, msg);
    }

    public void general(String msg) {
        this.logger.traceGeneral(this.THIS_CLASS, msg);
    }

    public void error(String msg) {
        this.logger.traceError(this.THIS_CLASS, msg);
    }

    public void abnormal(String msg) {
        this.logger.traceAbnormal(this.THIS_CLASS, msg);
    }

    public void param(String msg) {
        this.logger.traceParam(this.THIS_CLASS, msg);
    }

    public void enter(String msg) {
        this.logger.traceEnter(this.THIS_CLASS, msg);
    }

    protected abstract String onGetSignalDescription();

    public String getSignalDescription() {
        return this.onGetSignalDescription();
    }

    public String getSignalIdentity() {
        return this.signalIdentity;
    }

    public String toString() {
        return this.getSignalDescription();
    }

    public boolean equals(Object other) {
        if (other instanceof PmBaseSignal) {
            PmBaseSignal o = (PmBaseSignal)((Object)other);
            return this.procedureRef == o.procedureRef && this.connectionRef == o.connectionRef && this.signalName == o.signalName;
        }
        return false;
    }

    public int hashCode() {
        int hash = 7;
        hash = 31 * hash + (this.signalName == null ? 0 : this.signalName.hashCode());
        hash = 31 * hash + (this.signalIdentity == null ? 0 : this.signalIdentity.hashCode());
        hash = 31 * hash + (int)(this.procedureRef ^ this.procedureRef >>> 32);
        hash = 31 * hash + (int)(this.connectionRef ^ this.connectionRef >>> 32);
        return hash;
    }
}

