/*
 * Decompiled with CFR 0.152.
 */
package com.prismtech.corba.jacorb;

import com.prismtech.corba.jacorb.ConfigurableSSLSocketFactory;
import com.prismtech.corba.jacorb.KeyMaterialProvider;
import com.prismtech.corba.jacorb.PTrustManager;
import com.prismtech.corba.security.d;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.security.KeyStore;
import java.security.cert.X509Certificate;
import java.util.List;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.orb.ORB;
import org.jacorb.orb.factory.ServerSocketFactory;
import org.jacorb.security.ssl.sun_jsse.KeyStoreUtil;
import org.omg.CORBA.BAD_INV_ORDER;
import org.omg.CORBA.INITIALIZE;

public class SSLServerSocketFactory
implements ConfigurableSSLSocketFactory,
Configurable,
ServerSocketFactory {
    private javax.net.ServerSocketFactory factory;
    private boolean requireMutualAuth;
    private boolean supportClientAuth;
    private String[] cipherSuites;
    private Logger logger;
    private ORB orb;
    private boolean initialized;
    private KeyMaterialProvider keyMaterialProvider;
    private String keyManagerAlgorithm = null;
    private String trustManagerAlgorithm = null;
    protected String keystore_provider = null;
    protected String keystore_provider_impl = null;
    private String jsseProvider = null;
    private String jsseProviderImpl = null;

    public SSLServerSocketFactory(ORB oRB) {
        this.orb = oRB;
    }

    public void configure(Configuration configuration) {
        short s2;
        org.jacorb.config.Configuration configuration2 = (org.jacorb.config.Configuration)configuration;
        this.logger = configuration2.getNamedLogger("prismtech.sec.jsse");
        this.keyManagerAlgorithm = configuration.getAttribute("jacorb.security.jsse.server.key_manager_algorithm", "SunX509");
        this.trustManagerAlgorithm = configuration.getAttribute("jacorb.security.jsse.server.trust_manager_algorithm", "SunX509");
        this.keystore_provider = configuration.getAttribute("jacorb.security.keystore_provider", null);
        this.keystore_provider_impl = configuration.getAttribute("jacorb.security.keystore_provider_impl", null);
        this.jsseProvider = configuration.getAttribute("jacorb.security.jsse.provider", null);
        this.jsseProviderImpl = configuration.getAttribute("jacorb.security.jsse.provider_impl", null);
        short s3 = Short.parseShort(configuration.getAttribute("jacorb.security.ssl.server.supported_options"), 16);
        if ((s3 & 0x40) != 0) {
            this.logger.info("Will create SSL sockets that request client authentication");
            this.supportClientAuth = true;
        }
        if (((s2 = Short.parseShort(configuration.getAttribute("jacorb.security.ssl.server.required_options"), 16)) & 0x40) != 0) {
            this.requireMutualAuth = true;
            this.supportClientAuth = false;
            this.logger.info("Will create SSL sockets that require client authentication");
        }
        List list = configuration2.getAttributeList("jacorb.security.ssl.server.cipher_suites");
        this.cipherSuites = list.toArray(new String[list.size()]);
        if (this.logger.isDebugEnabled() && !list.isEmpty()) {
            this.logger.debug("Using Cipher Suites: " + list);
        }
        try {
            this.setKeyMaterialProvider((d)this.orb.resolve_initial_references("SSLServerCurrent"));
        }
        catch (Exception exception) {
            this.logger.fatalError("Failed to resolve \"SSLServerCurrent\"", exception);
            throw new RuntimeException("Failed to resolve \"SSLServerCurrent\" " + exception);
        }
    }

    public void setKeyMaterialProvider(KeyMaterialProvider keyMaterialProvider) {
        this.keyMaterialProvider = keyMaterialProvider;
        this.keyMaterialProvider.connectTo(this);
    }

    public ServerSocket createServerSocket(int n2) {
        SSLServerSocket sSLServerSocket = (SSLServerSocket)this.getSocketFactory().createServerSocket(n2);
        this.initSocket(sSLServerSocket);
        return sSLServerSocket;
    }

    private void initSocket(SSLServerSocket sSLServerSocket) {
        if (this.supportClientAuth) {
            sSLServerSocket.setNeedClientAuth(this.supportClientAuth);
        } else if (this.requireMutualAuth) {
            sSLServerSocket.setNeedClientAuth(this.requireMutualAuth);
        }
        if (this.cipherSuites != null && this.cipherSuites.length > 0) {
            sSLServerSocket.setEnabledCipherSuites(this.cipherSuites);
        }
    }

    public ServerSocket createServerSocket(int n2, int n3) {
        SSLServerSocket sSLServerSocket = (SSLServerSocket)this.getSocketFactory().createServerSocket(n2, n3);
        this.initSocket(sSLServerSocket);
        return sSLServerSocket;
    }

    public ServerSocket createServerSocket(int n2, int n3, InetAddress inetAddress) {
        SSLServerSocket sSLServerSocket = (SSLServerSocket)this.getSocketFactory().createServerSocket(n2, n3, inetAddress);
        this.initSocket(sSLServerSocket);
        return sSLServerSocket;
    }

    public boolean isSSL(ServerSocket serverSocket) {
        return serverSocket instanceof SSLServerSocket;
    }

    public void switchToClientMode(Socket socket) {
    }

    private synchronized javax.net.ServerSocketFactory getSocketFactory() {
        if (this.factory == null) {
            this.initialize();
        }
        return this.factory;
    }

    private void initialize() {
        try {
            Object object;
            KeyStore keyStore = this.keyMaterialProvider.getKeyStore();
            char[] cArray = this.keyMaterialProvider.getKeyPassPhrase();
            X509Certificate[] x509CertificateArray = this.keyMaterialProvider.getTrustees();
            TrustManager[] trustManagerArray = this.keyMaterialProvider.getTrustManagers();
            if (keyStore == null) {
                throw new BAD_INV_ORDER("The SSLServerSocketFactory hasn't been initialized with a KeyStore");
            }
            KeyManagerFactory keyManagerFactory = null;
            if (this.jsseProvider != null && this.jsseProvider.length() > 0) {
                KeyStoreUtil.checkProvider(this.jsseProvider, this.jsseProviderImpl);
                keyManagerFactory = KeyManagerFactory.getInstance(this.keyManagerAlgorithm, this.jsseProvider);
            } else {
                keyManagerFactory = KeyManagerFactory.getInstance(this.keyManagerAlgorithm);
            }
            keyManagerFactory.init(keyStore, cArray);
            if (trustManagerArray == null && (this.requireMutualAuth || this.supportClientAuth)) {
                if (x509CertificateArray != null) {
                    trustManagerArray = new X509TrustManager[]{new PTrustManager(this.requireMutualAuth, x509CertificateArray, this.orb.getConfiguration())};
                } else {
                    object = null;
                    if (this.jsseProvider != null && this.jsseProvider.length() > 0) {
                        KeyStoreUtil.checkProvider(this.jsseProvider, this.jsseProviderImpl);
                        object = TrustManagerFactory.getInstance(this.trustManagerAlgorithm, this.jsseProvider);
                    } else {
                        object = TrustManagerFactory.getInstance(this.trustManagerAlgorithm);
                    }
                    ((TrustManagerFactory)object).init(keyStore);
                    trustManagerArray = ((TrustManagerFactory)object).getTrustManagers();
                }
            }
            object = null;
            if (this.jsseProvider != null && this.jsseProvider.length() > 0) {
                KeyStoreUtil.checkProvider(this.jsseProvider, this.jsseProviderImpl);
                object = SSLContext.getInstance("TLS", this.jsseProvider);
            } else {
                object = SSLContext.getInstance("TLS");
            }
            ((SSLContext)object).init(keyManagerFactory.getKeyManagers(), trustManagerArray, this.keyMaterialProvider.getSecureRandom());
            this.factory = ((SSLContext)object).getServerSocketFactory();
            if (this.initialized && this.orb.getBasicAdapter() != null) {
                this.orb.getBasicAdapter().renewSSLServerSockets();
            }
            this.initialized = true;
            this.keyMaterialProvider.setInitialConfigurationDone();
        }
        catch (Exception exception) {
            this.logger.error("Failed to create SSLServerSocketFactory from KeyStore", exception);
            throw new INITIALIZE("Failed to create SSLServerSocketFactory from KeyStore: " + exception);
        }
    }

    public synchronized void reconfigure() {
        this.factory = null;
        this.initialize();
    }
}

