/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.policies;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.config.Configuration;
import org.jacorb.orb.policies.PolicyUtil;
import org.jacorb.util.ObjectUtil;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.InvalidPolicies;
import org.omg.CORBA.NO_PERMISSION;
import org.omg.CORBA.Policy;
import org.omg.CORBA.SetOverrideType;
import org.omg.CORBA._PolicyManagerLocalBase;

public class PolicyManager
extends _PolicyManagerLocalBase {
    private static final Policy[] EMPTY_RESULT = new Policy[0];
    private final Map policy_overrides = new HashMap();
    private final Logger logger;

    public PolicyManager(Configuration config) {
        this.logger = config.getNamedLogger("jacorb.orb.policies");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Policy[] get_policy_overrides(int[] ts) {
        ArrayList policyList;
        if (ts == null) {
            throw new IllegalArgumentException("Argument may not be null");
        }
        Map map = this.policy_overrides;
        synchronized (map) {
            if (this.policy_overrides.isEmpty()) {
                return EMPTY_RESULT;
            }
            if (ts.length == 0) {
                Collection values = this.policy_overrides.values();
                return values.toArray(new Policy[values.size()]);
            }
            policyList = new ArrayList(ts.length);
            for (int i2 = 0; i2 < ts.length; ++i2) {
                Object policy = this.policy_overrides.get(ObjectUtil.newInteger(ts[i2]));
                if (policy == null) continue;
                policyList.add(policy);
            }
        }
        Policy[] result = policyList.toArray(new Policy[policyList.size()]);
        if (this.logger.isDebugEnabled() && result.length > 0) {
            this.logger.debug("get_policy_overrides returns " + result.length + " policies");
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set_policy_overrides(Policy[] policies, SetOverrideType set_add) throws InvalidPolicies {
        if (policies == null) {
            throw new IllegalArgumentException("Argument may not be null");
        }
        HashMap<Integer, Policy> newPolicies = new HashMap<Integer, Policy>();
        StringBuffer sb = new StringBuffer();
        for (int i2 = 0; i2 < policies.length; ++i2) {
            if (!PolicyUtil.isInvocationPolicy(policies[i2].policy_type())) {
                throw new NO_PERMISSION("Not an invocation policy, type " + policies[i2].policy_type());
            }
            Integer key = ObjectUtil.newInteger(policies[i2].policy_type());
            if (newPolicies.put(key, policies[i2]) != null) {
                throw new BAD_PARAM("Multiple policies of type " + policies[i2].policy_type(), 30, CompletionStatus.COMPLETED_NO);
            }
            if (!this.logger.isDebugEnabled()) continue;
            sb.append(' ');
            sb.append(policies[i2].policy_type());
        }
        Map i2 = this.policy_overrides;
        synchronized (i2) {
            if (set_add == SetOverrideType.SET_OVERRIDE) {
                PolicyUtil.checkValidity(Collections.unmodifiableMap(newPolicies));
                this.policy_overrides.clear();
                this.policy_overrides.putAll(newPolicies);
            } else if (set_add == SetOverrideType.ADD_OVERRIDE) {
                HashMap<Integer, Policy> test = new HashMap<Integer, Policy>(this.policy_overrides);
                test.putAll(this.policy_overrides);
                test.putAll(newPolicies);
                PolicyUtil.checkValidity(Collections.unmodifiableMap(test));
                this.policy_overrides.clear();
                this.policy_overrides.putAll(test);
            }
        }
        if (this.logger.isDebugEnabled()) {
            String prefix = set_add == SetOverrideType.ADD_OVERRIDE ? "ADD_OVERRIDE" : "SET_OVERRIDE";
            this.logger.debug(prefix + ", types: " + sb);
        }
    }
}

