/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.poa;

import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentHashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.jacorb.orb.dsi.ServerRequest;
import org.jacorb.orb.giop.GIOPConnection;
import org.jacorb.poa.RequestAnalyserProcessor;
import org.jacorb.poa.SingleThreadRequestAnalyserProcessor;

public class DefaultRequestAnalyserProcessor
extends RequestAnalyserProcessor {
    protected ConcurrentHashMap requestconnections = new ConcurrentHashMap();
    private boolean enableRemoval;
    private RAPRemovalThread removalThread = null;
    private long removalTimeout = 10000L;
    private long inactivityTimeout = 900000L;

    public void configure(Configuration configuration) throws ConfigurationException {
        this.enableRemoval = configuration.getAttributeAsBoolean("jacorb.poa.requestanalyserprocessor.enable_removal", true);
        this.removalTimeout = configuration.getAttributeAsLong("jacorb.poa.requestanalyserprocessor.removal_timeout", 10000L);
        this.inactivityTimeout = configuration.getAttributeAsLong("jacorb.poa.requestanalyserprocessor.inactivity_timeout", 300000L);
        if (this.enableRemoval) {
            this.removalThread = new RAPRemovalThread();
            this.removalThread.setDaemon(true);
            this.removalThread.start();
        }
    }

    public boolean verify(ServerRequest dsi) {
        return dsi.getAnalyser() == 1;
    }

    public void process(RequestAnalyserProcessor.ProcessorArgs pa) {
        Object d2 = this.requestconnections.get(pa.sr.getConnection());
        if (d2 == null) {
            d2 = new SingleThreadRequestAnalyserProcessor();
            this.requestconnections.put(pa.sr.getConnection(), d2);
        }
        ((RequestAnalyserProcessor)d2).process(pa);
    }

    public void shutdown() {
        if (this.removalThread != null) {
            this.removalThread.end();
        }
        Iterator i2 = this.requestconnections.values().iterator();
        while (i2.hasNext()) {
            RequestAnalyserProcessor r2 = (RequestAnalyserProcessor)i2.next();
            r2.shutdown();
        }
    }

    private class RAPRemovalThread
    extends Thread {
        private boolean run = true;

        private RAPRemovalThread() {
        }

        public void run() {
            while (this.run) {
                Iterator i2 = DefaultRequestAnalyserProcessor.this.requestconnections.entrySet().iterator();
                while (i2.hasNext()) {
                    long lastAccessTime;
                    Map.Entry entry = (Map.Entry)i2.next();
                    RequestAnalyserProcessor r2 = (RequestAnalyserProcessor)entry.getValue();
                    GIOPConnection connection = (GIOPConnection)entry.getKey();
                    if (!(r2 instanceof SingleThreadRequestAnalyserProcessor) || (lastAccessTime = ((SingleThreadRequestAnalyserProcessor)r2).getAccessTime()) >= System.currentTimeMillis() - DefaultRequestAnalyserProcessor.this.inactivityTimeout && !connection.isClosed()) continue;
                    r2.shutdown();
                    i2.remove();
                }
                try {
                    RAPRemovalThread.sleep(DefaultRequestAnalyserProcessor.this.removalTimeout);
                }
                catch (InterruptedException interruptedException) {}
            }
        }

        public void end() {
            this.run = false;
            this.interrupt();
        }
    }
}

