/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.security.ssl.sun_jsse;

import java.io.ByteArrayInputStream;
import java.security.cert.CertificateFactory;
import java.util.HashMap;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.security.cert.X509Certificate;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.orb.ORB;
import org.jacorb.orb.dsi.ServerRequest;
import org.jacorb.orb.giop.GIOPConnection;
import org.jacorb.orb.iiop.ServerIIOPConnection;
import org.jacorb.orb.portableInterceptor.ServerRequestInfoImpl;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.NO_PERMISSION;
import org.omg.PortableInterceptor.ForwardRequest;
import org.omg.PortableInterceptor.ServerRequestInfo;
import org.omg.PortableInterceptor.ServerRequestInterceptor;
import org.omg.Security.AttributeType;
import org.omg.Security.ExtensibleFamily;

public class ServerInvocationInterceptor
extends LocalObject
implements ServerRequestInterceptor,
Configurable {
    public static final String DEFAULT_NAME = "ServerInvocationInterceptor";
    private String name = "ServerInvocationInterceptor";
    private AttributeType type = null;
    private HashMap sessionCredentials = new HashMap();
    private Logger logger;
    private short serverSupportedOptions = 0;
    private short serverRequiredOptions = 0;

    public ServerInvocationInterceptor(ORB orb) throws ConfigurationException {
        this.type = new AttributeType(new ExtensibleFamily(0, 1), 2);
        this.configure(orb.getConfiguration());
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        this.logger = ((org.jacorb.config.Configuration)configuration).getNamedLogger("jacorb.security.ssl.interceptor");
        this.serverSupportedOptions = Short.parseShort(configuration.getAttribute("jacorb.security.ssl.server.supported_options", "20"), 16);
        this.serverRequiredOptions = Short.parseShort(configuration.getAttribute("jacorb.security.ssl.server.required_options", "0"), 16);
    }

    public String name() {
        return this.name;
    }

    public void destroy() {
    }

    public void receive_request(ServerRequestInfo ri) throws ForwardRequest {
    }

    public void receive_request_service_contexts(ServerRequestInfo ri) throws ForwardRequest {
        CertificateFactory certificateFactory;
        SSLSocket sslSocket;
        block14: {
            ServerRequest request = ((ServerRequestInfoImpl)ri).request;
            GIOPConnection connection = null;
            if (request != null) {
                connection = request.getConnection();
            }
            if (connection == null) {
                if (this.logger.isErrorEnabled()) {
                    this.logger.error("target has no connection!");
                }
                return;
            }
            if (!connection.isSSL()) {
                return;
            }
            if (!(connection.getTransport() instanceof ServerIIOPConnection)) {
                return;
            }
            ServerIIOPConnection transport = (ServerIIOPConnection)connection.getTransport();
            sslSocket = (SSLSocket)transport.getSocket();
            SSLSession session = sslSocket.getSession();
            if (this.sessionCredentials.containsKey(session)) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.info("Reusing SSL session credentials.");
                }
                return;
            }
            certificateFactory = null;
            try {
                certificateFactory = CertificateFactory.getInstance("X.509");
            }
            catch (Exception e2) {
                if (!this.logger.isWarnEnabled()) break block14;
                this.logger.warn(e2.getMessage());
            }
        }
        try {
            X509Certificate[] certs = sslSocket.getSession().getPeerCertificateChain();
            int size = certs.length;
            java.security.cert.X509Certificate[] newCerts = new java.security.cert.X509Certificate[size];
            for (int i2 = size - 1; 0 <= i2; --i2) {
                newCerts[i2] = (java.security.cert.X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(certs[i2].getEncoded()));
            }
        }
        catch (Exception e3) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("Exception " + e3.getMessage() + " in ServerInvocationInterceptor");
            }
            if ((this.serverRequiredOptions & 0x40) != 0) {
                throw new NO_PERMISSION("Establish trust in client required, but failed");
            }
            return;
        }
    }

    public void send_reply(ServerRequestInfo ri) {
        this.removeAttribute();
    }

    public void send_exception(ServerRequestInfo ri) throws ForwardRequest {
        this.removeAttribute();
    }

    public void send_other(ServerRequestInfo ri) throws ForwardRequest {
        this.removeAttribute();
    }

    private void removeAttribute() {
    }
}

