/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.genericlog;

import se.ericsson.cello.genericlog.InvalidParameterException;
import se.ericsson.cello.genericlog.LogFullException;
import se.ericsson.cello.genericlog.LogInternalErrorException;
import se.ericsson.cello.genericlog.LogMgr;
import se.ericsson.cello.genericlog.proxy.CelloLsiDeleteLogRsp;
import se.ericsson.cello.genericlog.proxy.CelloLsiSyncLogRsp;
import se.ericsson.cello.genericlog.proxy.CelloLsiWriteRecordRsp;
import se.ericsson.cello.genericlog.proxy.LogServiceProxy;

public class Log {
    public static final AddTimeStamp ADD_TIME_STAMP = new AddTimeStamp(1L);
    public static final AddTimeStamp ADD_NO_TIME_STAMP = new AddTimeStamp(0L);
    public static final long TIME_BY_LSI = -1L;
    private String logName;
    private long maxSize;
    private LogMgr.StorageType storage;
    private LogMgr.LogFormat format;
    private String location;
    private LogMgr.LogFullAction logFullAction;
    private LogMgr.InsertInfoRecords insertInfoRecords;
    private long sysParRef;
    private String additionalInfo;
    private long bufferSize;
    private long inactivityTimeout;
    private LogServiceProxy theLogServiceProxy;
    private long clientRef = 0L;

    Log(String string, long l, LogMgr.StorageType storageType, LogMgr.LogFormat logFormat, String string2, LogMgr.LogFullAction logFullAction, LogMgr.InsertInfoRecords insertInfoRecords, long l2, String string3, long l3, long l4) {
        this.logName = string;
        this.maxSize = l;
        this.storage = storageType;
        this.format = logFormat;
        this.location = string2;
        this.logFullAction = logFullAction;
        this.insertInfoRecords = insertInfoRecords;
        this.sysParRef = l2;
        this.additionalInfo = string3;
        this.bufferSize = l3;
        this.inactivityTimeout = l4;
        this.theLogServiceProxy = LogServiceProxy.instance();
    }

    public void writeRecord(AddTimeStamp addTimeStamp, String string) throws LogInternalErrorException, LogFullException, InvalidParameterException {
        long l = 0L;
        if (addTimeStamp == ADD_TIME_STAMP) {
            l = System.currentTimeMillis() / 1000L;
        }
        CelloLsiWriteRecordRsp celloLsiWriteRecordRsp = this.theLogServiceProxy.lsi2WriteRecord(this.logName, addTimeStamp.getValue(), l, this.clientRef, string);
        switch ((int)celloLsiWriteRecordRsp.result) {
            case 0: {
                return;
            }
            case 13: {
                throw new LogFullException(LogMgr.getResultMsg((int)celloLsiWriteRecordRsp.result));
            }
            case 10000: {
                throw new InvalidParameterException(LogMgr.getResultMsg((int)celloLsiWriteRecordRsp.result));
            }
        }
        throw new LogInternalErrorException((int)celloLsiWriteRecordRsp.result);
    }

    public void lsi2WriteRecord(AddTimeStamp addTimeStamp, long l, String string) throws LogInternalErrorException, LogFullException, InvalidParameterException {
        if (addTimeStamp == ADD_TIME_STAMP && l == -1L) {
            l = System.currentTimeMillis() / 1000L;
        }
        CelloLsiWriteRecordRsp celloLsiWriteRecordRsp = this.theLogServiceProxy.lsi2WriteRecord(this.logName, addTimeStamp.getValue(), l, this.clientRef, string);
        switch ((int)celloLsiWriteRecordRsp.result) {
            case 0: {
                return;
            }
            case 13: {
                throw new LogFullException(LogMgr.getResultMsg((int)celloLsiWriteRecordRsp.result));
            }
            case 10000: {
                throw new InvalidParameterException(LogMgr.getResultMsg((int)celloLsiWriteRecordRsp.result));
            }
        }
        throw new LogInternalErrorException((int)celloLsiWriteRecordRsp.result);
    }

    public void lsi5WriteRecord(AddTimeStamp addTimeStamp, long l, long l2, String string) throws LogInternalErrorException, LogFullException, InvalidParameterException {
        if (addTimeStamp == ADD_TIME_STAMP && l == -1L) {
            l = System.currentTimeMillis() / 1000L;
        }
        CelloLsiWriteRecordRsp celloLsiWriteRecordRsp = this.theLogServiceProxy.lsi5WriteRecord(this.logName, addTimeStamp.getValue(), l, this.clientRef, l2, string);
        switch ((int)celloLsiWriteRecordRsp.result) {
            case 0: {
                return;
            }
            case 13: {
                throw new LogFullException(LogMgr.getResultMsg((int)celloLsiWriteRecordRsp.result));
            }
            case 10000: {
                throw new InvalidParameterException(LogMgr.getResultMsg((int)celloLsiWriteRecordRsp.result));
            }
        }
        throw new LogInternalErrorException((int)celloLsiWriteRecordRsp.result);
    }

    public void deleteLog() throws LogInternalErrorException {
        CelloLsiDeleteLogRsp celloLsiDeleteLogRsp = this.theLogServiceProxy.deleteLog(this.logName);
        switch ((int)celloLsiDeleteLogRsp.result) {
            case 0: {
                return;
            }
        }
        throw new LogInternalErrorException((int)celloLsiDeleteLogRsp.result);
    }

    public void syncLog() throws LogInternalErrorException {
        CelloLsiSyncLogRsp celloLsiSyncLogRsp = this.theLogServiceProxy.syncLog(this.logName);
        switch ((int)celloLsiSyncLogRsp.result) {
            case 0: {
                return;
            }
        }
        throw new LogInternalErrorException((int)celloLsiSyncLogRsp.result);
    }

    public String getLogName() {
        return new String(this.logName);
    }

    public int getMaxSize() {
        return (int)this.maxSize;
    }

    public LogMgr.LogFormat getFormat() {
        return this.format;
    }

    public LogMgr.StorageType getStorage() {
        return this.storage;
    }

    public String getLocation() {
        return new String(this.location);
    }

    public LogMgr.LogFullAction getLogFullAction() {
        return this.logFullAction;
    }

    public LogMgr.InsertInfoRecords getInsertInfoRecords() {
        return this.insertInfoRecords;
    }

    public long getSysParRef() {
        return this.sysParRef;
    }

    public String getAdditionalInfo() {
        return this.additionalInfo;
    }

    public long getBufferSize() {
        return this.bufferSize;
    }

    public long getInactivityTimeout() {
        return this.inactivityTimeout;
    }

    public static class AddTimeStamp {
        private long value;

        AddTimeStamp(long l) {
            this.value = l;
        }

        long getValue() {
            return this.value;
        }
    }
}

