/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.thread;

import java.util.Vector;

public class ReadWriteLock {
    private int activeReaders;
    private int waitingReaders;
    private int activeWriters;
    private final Vector writerLocks = new Vector();

    public synchronized void requestRead() {
        if (this.activeWriters == 0 && this.writerLocks.size() == 0) {
            ++this.activeReaders;
        } else {
            ++this.waitingReaders;
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public synchronized void readAccomplished() {
        if (--this.activeReaders == 0) {
            this.notifyWriters();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestWrite() {
        Object object;
        Object object2 = object = new Object();
        synchronized (object2) {
            ReadWriteLock readWriteLock = this;
            synchronized (readWriteLock) {
                boolean bl;
                boolean bl2 = bl = this.writerLocks.size() == 0 && this.activeReaders == 0 && this.activeWriters == 0;
                if (bl) {
                    ++this.activeWriters;
                    return;
                }
                this.writerLocks.addElement(object);
            }
            try {
                object.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public synchronized void writeAccomplished() {
        --this.activeWriters;
        if (this.waitingReaders > 0) {
            this.notifyReaders();
        } else {
            this.notifyWriters();
        }
    }

    private void notifyReaders() {
        this.activeReaders += this.waitingReaders;
        this.waitingReaders = 0;
        this.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyWriters() {
        if (this.writerLocks.size() > 0) {
            Object e = this.writerLocks.firstElement();
            this.writerLocks.removeElement(e);
            ++this.activeWriters;
            Object e2 = e;
            synchronized (e2) {
                e.notify();
            }
        }
    }

    public static class Test {
        Resource resource = new Resource();

        public Test() {
            new Writer("w/0").start();
            new Reader("r/1").start();
            new Writer("w/1").start();
            new Writer("w/2").start();
            new Reader("r/2").start();
            new Reader("r/3").start();
        }

        public static void main(String[] stringArray) {
            Test test = new Test();
        }

        class Writer
        extends Thread {
            private String name;

            Writer(String string) {
                this.name = string;
            }

            public void run() {
                System.out.println("Starting " + this.name);
                Test.this.resource.write(this.name);
                System.out.println("Stopping " + this.name);
            }
        }

        class Reader
        extends Thread {
            private String name;

            Reader(String string) {
                this.name = string;
            }

            public void run() {
                System.out.println("Starting " + this.name);
                Test.this.resource.read(this.name);
                System.out.println("Stopping " + this.name);
            }
        }

        static class Resource {
            ReadWriteLock lock = new ReadWriteLock();

            Resource() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void read(String string) {
                try {
                    this.lock.requestRead();
                    System.out.println("\t\t" + string + " reading");
                    try {
                        Thread.currentThread();
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    System.out.println("\t\t" + string + " done");
                }
                finally {
                    this.lock.readAccomplished();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void write(String string) {
                try {
                    this.lock.requestWrite();
                    System.out.println("\t\t" + string + " writing");
                    try {
                        Thread.currentThread();
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    System.out.println("\t\t" + string + " done");
                }
                finally {
                    this.lock.writeAccomplished();
                }
            }
        }
    }
}

