/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.mimparser.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.xml.sax.XMLReader;
import se.ericsson.cello.mimparser.DerivedDataType;
import se.ericsson.cello.mimparser.DomainExtension;
import se.ericsson.cello.mimparser.MimModel;
import se.ericsson.cello.mimparser.MomAssociationEnd;
import se.ericsson.cello.mimparser.MomBiDirectionalAssociation;
import se.ericsson.cello.mimparser.MomChild;
import se.ericsson.cello.mimparser.MomClass;
import se.ericsson.cello.mimparser.MomContainment;
import se.ericsson.cello.mimparser.MomEntity;
import se.ericsson.cello.mimparser.MomEnum;
import se.ericsson.cello.mimparser.MomException;
import se.ericsson.cello.mimparser.MomMetaData;
import se.ericsson.cello.mimparser.MomSoftLink;
import se.ericsson.cello.mimparser.MomStruct;
import se.ericsson.cello.mimparser.MomSupport;
import se.ericsson.cello.mimparser.MomSupported;
import se.ericsson.cello.mimparser.MomUniDirectionalAssociation;
import se.ericsson.cello.mimparser.MomVisitor;
import se.ericsson.cello.mimparser.model.DomainExtensionImpl;
import se.ericsson.cello.mimparser.model.MimPartImpl;
import se.ericsson.cello.mimparser.model.MomBase;
import se.ericsson.cello.mimparser.model.MomBiDirectionalAssociationImpl;
import se.ericsson.cello.mimparser.model.MomContainmentImpl;
import se.ericsson.cello.mimparser.model.MomEntityResolvable;
import se.ericsson.cello.mimparser.model.MomRelationshipExtImpl;
import se.ericsson.cello.mimparser.model.MomRelationshipImpl;
import se.ericsson.cello.mimparser.model.MomSoftLinkImpl;
import se.ericsson.cello.mimparser.model.MomSupportImpl;
import se.ericsson.cello.mimparser.model.MomUniDirectionalAssociationImpl;
import se.ericsson.cello.mimparser.model.ReferenceResolver;
import se.ericsson.cello.mimparser.model.RelationshipResolver;
import se.ericsson.cello.mimparser.state.DtdVersionSettable;

public class MimModelImpl
implements MimModel,
DtdVersionSettable {
    private String momFile;
    private int contentLevel;
    private boolean isTemporaryModel = false;
    private int cacheSize = Integer.MAX_VALUE;
    private List parsedDescriptions = new ArrayList(0);
    private List containmentRelationships = new ArrayList(0);
    private List supportRelationships = new ArrayList(0);
    private List relationshipsExt = new ArrayList(0);
    private ReferenceResolver referenceResolver = new ReferenceResolver();
    private RelationshipResolver relationshipResolver = new RelationshipResolver();
    private Map myClasses = new HashMap(0);
    private Map myStructs = new HashMap(0);
    private Map myEnums = new HashMap(0);
    private Map exceptions = new HashMap(0);
    private Map myDataTypes = new HashMap(0);
    private String dtdVersion;
    private String version;
    private String name;
    private String release;
    private String description;
    private String applicationTag;
    private String copyright;
    private XMLReader clientSuppliedXMLReader;
    private MomMetaData momMetaData;
    private DomainExtension domainExtension;
    private List warningList;
    private List uniDirectionalRelationships = new ArrayList(0);
    private List biDirectionalRelationships = new ArrayList(0);
    private List softLinkRelationships = new ArrayList(0);
    private List myMimParts = new ArrayList(0);

    public MimModelImpl(String string, int n) {
        this.momFile = string;
        this.contentLevel = n;
        this.warningList = new ArrayList(0);
    }

    public void setTemporaryModel() {
        this.isTemporaryModel = true;
    }

    public DomainExtension getDomain() {
        return this.domainExtension;
    }

    public void setDomain(DomainExtensionImpl domainExtensionImpl) {
        this.domainExtension = domainExtensionImpl;
    }

    public MomMetaData getMomMetaData() {
        return this.momMetaData;
    }

    public void setMomMetaData(MomMetaData momMetaData) {
        this.momMetaData = momMetaData;
    }

    public Iterator getMimParts() {
        return this.myMimParts.iterator();
    }

    public void addMimParts(MimPartImpl mimPartImpl) {
        this.myMimParts.add(mimPartImpl);
    }

    public String getDtdVersion() {
        return this.dtdVersion;
    }

    public void setDtdVersion(String string) {
        this.dtdVersion = string;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String string) {
        this.version = string;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getRelease() {
        return this.release;
    }

    public void setRelease(String string) {
        this.release = string;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public String getApplicationTag() {
        return this.applicationTag;
    }

    public void setApplicationTag(String string) {
        this.applicationTag = string;
    }

    public String getCopyright() {
        return this.copyright;
    }

    public void setCopyright(String string) {
        this.copyright = string;
    }

    public boolean hasWarnings() {
        return !this.warningList.isEmpty();
    }

    public Iterator getWarningList() {
        return this.warningList.iterator();
    }

    public void addToWarningList(String string) {
        this.warningList.add(string);
    }

    public MomClass getRoot() {
        return this.getClass("ManagedElement");
    }

    public MomClass getClass(String string) {
        return (MomClass)this.myClasses.get(string);
    }

    public Iterator getClasses() {
        return this.myClasses.values().iterator();
    }

    public DerivedDataType getDerivedDataType(String string) {
        return (DerivedDataType)this.myDataTypes.get(string);
    }

    public Iterator getAllDerivedDataType() {
        return this.myDataTypes.values().iterator();
    }

    public Iterator findDerivedDataTypes(String string) {
        Iterator iterator = this.getAllDerivedDataType();
        return this.simpleFind(string, iterator);
    }

    public Iterator findClasses(String string) {
        Iterator iterator = this.getClasses();
        return this.simpleFind(string, iterator);
    }

    public Iterator findEnums(String string) {
        Iterator iterator = this.getEnums();
        return this.simpleFind(string, iterator);
    }

    public Iterator findStructs(String string) {
        Iterator iterator = this.getStructs();
        return this.simpleFind(string, iterator);
    }

    private Iterator simpleFind(String string, Iterator iterator) {
        ArrayList<MomEntity> arrayList = new ArrayList<MomEntity>();
        while (iterator.hasNext()) {
            String string2;
            MomEntity momEntity = (MomEntity)iterator.next();
            String string3 = momEntity.getName();
            if (string.equals("*")) {
                arrayList.add(momEntity);
                continue;
            }
            if (string.startsWith("*")) {
                string2 = string.substring(1);
                if (!string3.endsWith(string2)) continue;
                arrayList.add(momEntity);
                continue;
            }
            if (string.endsWith("*")) {
                string2 = string.substring(0, string.length() - 1);
                if (!string3.startsWith(string2)) continue;
                arrayList.add(momEntity);
                continue;
            }
            if (!string3.equals(string)) continue;
            arrayList.add(momEntity);
        }
        return arrayList.iterator();
    }

    public void addClass(String string, MomClass momClass) {
        if (!this.isTemporaryModel) {
            this.myClasses.put(string, momClass);
        }
    }

    public void addStruct(String string, MomStruct momStruct) {
        if (!this.isTemporaryModel) {
            this.myStructs.put(string, momStruct);
        }
    }

    public void addEnum(String string, MomEnum momEnum) {
        if (!this.isTemporaryModel) {
            this.myEnums.put(string, momEnum);
        }
    }

    public void addDerivedDataType(String string, DerivedDataType derivedDataType) {
        if (!this.isTemporaryModel) {
            this.myDataTypes.put(string, derivedDataType);
        }
    }

    public MomStruct getStruct(String string) {
        return (MomStruct)this.myStructs.get(string);
    }

    public Iterator getStructs() {
        return this.myStructs.values().iterator();
    }

    public MomEnum getEnum(String string) {
        return (MomEnum)this.myEnums.get(string);
    }

    public Iterator getEnums() {
        return this.myEnums.values().iterator();
    }

    void addException(String string, MomException momException) {
        this.exceptions.put(string, momException);
    }

    MomException getException(String string) {
        return (MomException)this.exceptions.get(string);
    }

    public void accept(MomVisitor momVisitor) {
        MomEntity momEntity;
        Iterator iterator = this.getClasses();
        while (iterator.hasNext()) {
            momEntity = (MomClass)iterator.next();
            momVisitor.visitClass((MomClass)momEntity);
        }
        iterator = this.getEnums();
        while (iterator.hasNext()) {
            momEntity = (MomEnum)iterator.next();
            momVisitor.visitEnum((MomEnum)momEntity);
        }
        iterator = this.getStructs();
        while (iterator.hasNext()) {
            momEntity = (MomStruct)iterator.next();
            momVisitor.visitStruct((MomStruct)momEntity);
        }
    }

    public String getMomFile() {
        return this.momFile;
    }

    public int getContentLevel() {
        return this.contentLevel;
    }

    public void addparsedDescription(MomBase momBase) {
        if (this.parsedDescriptions.size() == this.cacheSize) {
            this.removeFromCache(1);
        }
        this.parsedDescriptions.add(momBase);
    }

    public void cleanUp() {
        int n = this.parsedDescriptions.size();
        this.removeFromCache(n);
        this.cacheSize = 0;
    }

    public void setCache(int n) {
        if (n < this.parsedDescriptions.size()) {
            this.removeFromCache(this.parsedDescriptions.size() - n);
        }
        this.cacheSize = n;
    }

    private void removeFromCache(int n) {
        int n2 = n;
        int n3 = this.parsedDescriptions.size();
        if (n2 > n3) {
            n2 = n3;
        }
        int n4 = 0;
        for (int i = 0; i < n2; ++i) {
            MomBase momBase = (MomBase)this.parsedDescriptions.get(n4);
            momBase.setDescription(null);
            this.parsedDescriptions.remove(n4);
        }
    }

    public void addMomEntityStructToBeResolved(String string, MomEntityResolvable momEntityResolvable) {
        if (!this.isTemporaryModel) {
            this.referenceResolver.addStructRef(string, momEntityResolvable);
        }
    }

    public void addMomEntityMoToBeResolved(String string, MomEntityResolvable momEntityResolvable) {
        if (!this.isTemporaryModel) {
            this.referenceResolver.addMoRef(string, momEntityResolvable);
        }
    }

    public void addMomEntityDerivedDataTypeToBeResolved(String string, MomEntityResolvable momEntityResolvable) {
        if (!this.isTemporaryModel) {
            this.referenceResolver.addDerivedDataTypeRef(string, momEntityResolvable);
        }
    }

    public void addMomEntityEnumToBeResolved(String string, MomEntityResolvable momEntityResolvable) {
        if (!this.isTemporaryModel) {
            this.referenceResolver.addEnumRef(string, momEntityResolvable);
        }
    }

    public void resolveReferences() {
        if (!this.isTemporaryModel) {
            this.referenceResolver.resolve(this);
            this.referenceResolver = null;
        }
    }

    public void addRelationshipToBeResolved(MomRelationshipImpl momRelationshipImpl) {
        if (!this.isTemporaryModel) {
            this.relationshipResolver.addRelationship(momRelationshipImpl);
        }
    }

    public void resolveRelationships() {
        if (!this.isTemporaryModel) {
            this.relationshipResolver.resolve(this);
            this.relationshipResolver = null;
        }
    }

    public XMLReader getXMLReader() {
        return this.clientSuppliedXMLReader;
    }

    public void setXMLReader(XMLReader xMLReader) {
        this.clientSuppliedXMLReader = xMLReader;
    }

    public int getCacheSize() {
        return this.cacheSize;
    }

    public Iterator getContainmentRelationships() {
        return this.containmentRelationships.iterator();
    }

    public void addContainmentRelationshipToBeResolved(MomContainmentImpl momContainmentImpl) {
        this.containmentRelationships.add(momContainmentImpl);
        this.relationshipResolver.addContainment(momContainmentImpl);
    }

    public Iterator getBiDirectionalAssociations() {
        return this.biDirectionalRelationships.iterator();
    }

    public void addBiDirectionalAssociationToBeResolved(MomBiDirectionalAssociationImpl momBiDirectionalAssociationImpl) {
        this.biDirectionalRelationships.add(momBiDirectionalAssociationImpl);
        this.relationshipResolver.addBiDirectionalAssociation(momBiDirectionalAssociationImpl);
    }

    public Iterator getSoftLinkRelationships() {
        return this.softLinkRelationships.iterator();
    }

    public void addSoftLinkRelationShipToBeResolved(MomSoftLinkImpl momSoftLinkImpl) {
        this.softLinkRelationships.add(momSoftLinkImpl);
        this.relationshipResolver.addSoftLink(momSoftLinkImpl);
    }

    public Iterator getSupportRelationships() {
        return this.supportRelationships.iterator();
    }

    public void addSupportRelationShipToBeResolved(MomSupportImpl momSupportImpl) {
        this.supportRelationships.add(momSupportImpl);
        this.relationshipResolver.addSupport(momSupportImpl);
    }

    public Iterator getUniDirectionalAssociations() {
        return this.uniDirectionalRelationships.iterator();
    }

    public void addUniDirectionalRelationShipToBeResolved(MomUniDirectionalAssociationImpl momUniDirectionalAssociationImpl) {
        this.uniDirectionalRelationships.add(momUniDirectionalAssociationImpl);
        this.relationshipResolver.addUniDirectionalAssociation(momUniDirectionalAssociationImpl);
    }

    public Iterator getRelationships() {
        return this.relationshipsExt.iterator();
    }

    public void addRelationshipToBeResolved(MomRelationshipExtImpl momRelationshipExtImpl) {
        this.relationshipsExt.add(momRelationshipExtImpl);
    }

    public Iterator getBiDirectionalAssociations(String string, String string2) {
        ArrayList<MomBiDirectionalAssociation> arrayList = new ArrayList<MomBiDirectionalAssociation>();
        Iterator iterator = this.getBiDirectionalAssociations();
        while (iterator.hasNext()) {
            MomBiDirectionalAssociation momBiDirectionalAssociation = (MomBiDirectionalAssociation)iterator.next();
            if (string != null && string2 == null) {
                String string3 = momBiDirectionalAssociation.getAssociationEndFrom().getHasClass().getMomClass().getName();
                if (!string.equals(string3)) continue;
                arrayList.add(momBiDirectionalAssociation);
                continue;
            }
            if (string2 != null && string == null) {
                Iterator iterator2 = momBiDirectionalAssociation.getAssociationEndsTo();
                while (iterator2.hasNext()) {
                    MomAssociationEnd momAssociationEnd = (MomAssociationEnd)iterator2.next();
                    if (!string2.equals(momAssociationEnd.getHasClass().getName())) continue;
                    arrayList.add(momBiDirectionalAssociation);
                }
                continue;
            }
            if (string2 == null || string == null) continue;
            boolean bl = false;
            boolean bl2 = false;
            String string4 = momBiDirectionalAssociation.getAssociationEndFrom().getHasClass().getMomClass().getName();
            if (string.equals(string4)) {
                bl = true;
            }
            Iterator iterator3 = momBiDirectionalAssociation.getAssociationEndsTo();
            while (iterator3.hasNext()) {
                MomAssociationEnd momAssociationEnd = (MomAssociationEnd)iterator3.next();
                if (!string2.equals(momAssociationEnd.getHasClass().getName())) continue;
                bl2 = true;
            }
            if (!bl || !bl2) continue;
            arrayList.add(momBiDirectionalAssociation);
        }
        return arrayList.iterator();
    }

    public Iterator getContainmentRelationships(String string, String string2) {
        Iterator iterator = this.getContainmentRelationships();
        ArrayList<MomContainment> arrayList = new ArrayList<MomContainment>();
        while (iterator.hasNext()) {
            MomContainment momContainment = (MomContainment)iterator.next();
            if (string != null && string2 == null) {
                String string3 = momContainment.getParent().getHasClass().getMomClass().getName();
                if (!string.equals(string3)) continue;
                arrayList.add(momContainment);
                continue;
            }
            if (string2 != null && string == null) {
                Iterator iterator2 = momContainment.getChildren();
                while (iterator2.hasNext()) {
                    MomChild momChild = (MomChild)iterator2.next();
                    if (!string2.equals(momChild.getHasClass().getName())) continue;
                    arrayList.add(momContainment);
                }
                continue;
            }
            if (string2 == null || string == null) continue;
            boolean bl = false;
            boolean bl2 = false;
            String string4 = momContainment.getParent().getHasClass().getMomClass().getName();
            if (string.equals(string4)) {
                bl = true;
            }
            Iterator iterator3 = momContainment.getChildren();
            while (iterator3.hasNext()) {
                MomChild momChild = (MomChild)iterator3.next();
                if (!string2.equals(momChild.getHasClass().getName())) continue;
                bl2 = true;
            }
            if (!bl || !bl2) continue;
            arrayList.add(momContainment);
        }
        return arrayList.iterator();
    }

    public Iterator getSoftLinkRelationships(String string, String string2) {
        ArrayList<MomSoftLink> arrayList = new ArrayList<MomSoftLink>();
        Iterator iterator = this.getSoftLinkRelationships();
        while (iterator.hasNext()) {
            MomSoftLink momSoftLink = (MomSoftLink)iterator.next();
            if (string != null && string2 == null) {
                String string3 = momSoftLink.getParent().getHasClass().getMomClass().getName();
                if (!string.equals(string3)) continue;
                arrayList.add(momSoftLink);
                continue;
            }
            if (string2 != null && string == null) {
                Iterator iterator2 = momSoftLink.getChildren();
                while (iterator2.hasNext()) {
                    MomChild momChild = (MomChild)iterator2.next();
                    if (!string2.equals(momChild.getHasClass().getName())) continue;
                    arrayList.add(momSoftLink);
                }
                continue;
            }
            if (string2 == null || string == null) continue;
            boolean bl = false;
            boolean bl2 = false;
            String string4 = momSoftLink.getParent().getHasClass().getMomClass().getName();
            if (string.equals(string4)) {
                bl = true;
            }
            Iterator iterator3 = momSoftLink.getChildren();
            while (iterator3.hasNext()) {
                MomChild momChild = (MomChild)iterator3.next();
                if (!string2.equals(momChild.getHasClass().getName())) continue;
                bl2 = true;
            }
            if (!bl || !bl2) continue;
            arrayList.add(momSoftLink);
        }
        return arrayList.iterator();
    }

    public Iterator getSupportRelationships(String string, String string2) {
        ArrayList<MomSupport> arrayList = new ArrayList<MomSupport>();
        Iterator iterator = this.getSupportRelationships();
        while (iterator.hasNext()) {
            MomSupport momSupport = (MomSupport)iterator.next();
            if (string != null && string2 == null) {
                String string3 = momSupport.getSupporter().getHasClass().getMomClass().getName();
                if (!string.equals(string3)) continue;
                arrayList.add(momSupport);
                continue;
            }
            if (string2 != null && string == null) {
                Iterator iterator2 = momSupport.getSupported();
                while (iterator2.hasNext()) {
                    MomSupported momSupported = (MomSupported)iterator2.next();
                    if (!string2.equals(momSupported.getHasClass().getName())) continue;
                    arrayList.add(momSupport);
                }
                continue;
            }
            if (string2 == null || string == null) continue;
            boolean bl = false;
            boolean bl2 = false;
            String string4 = momSupport.getSupporter().getHasClass().getMomClass().getName();
            if (string.equals(string4)) {
                bl = true;
            }
            Iterator iterator3 = momSupport.getSupported();
            while (iterator3.hasNext()) {
                MomSupported momSupported = (MomSupported)iterator3.next();
                if (!string2.equals(momSupported.getHasClass().getName())) continue;
                bl2 = true;
            }
            if (!bl || !bl2) continue;
            arrayList.add(momSupport);
        }
        return arrayList.iterator();
    }

    public Iterator getUniDirectionalAssociations(String string, String string2) {
        ArrayList<MomUniDirectionalAssociation> arrayList = new ArrayList<MomUniDirectionalAssociation>();
        Iterator iterator = this.getUniDirectionalAssociations();
        while (iterator.hasNext()) {
            Object object;
            MomUniDirectionalAssociation momUniDirectionalAssociation = (MomUniDirectionalAssociation)iterator.next();
            if (string != null && string2 == null && string.equals(object = momUniDirectionalAssociation.getHasClass().getMomClass().getName())) {
                arrayList.add(momUniDirectionalAssociation);
            }
            if (string2 != null && string == null) {
                object = momUniDirectionalAssociation.getAssociationEndsTo();
                while (object.hasNext()) {
                    MomAssociationEnd momAssociationEnd = (MomAssociationEnd)object.next();
                    if (!string2.equals(momAssociationEnd.getHasClass().getName())) continue;
                    arrayList.add(momUniDirectionalAssociation);
                }
                continue;
            }
            if (string == null || string2 == null) continue;
            boolean bl = false;
            boolean bl2 = false;
            String string3 = momUniDirectionalAssociation.getHasClass().getMomClass().getName();
            if (string.equals(string3)) {
                bl = true;
            }
            Iterator iterator2 = momUniDirectionalAssociation.getAssociationEndsTo();
            while (iterator2.hasNext()) {
                MomAssociationEnd momAssociationEnd = (MomAssociationEnd)iterator2.next();
                if (!string2.equals(momAssociationEnd.getHasClass().getName())) continue;
                bl2 = true;
            }
            if (!bl || !bl2) continue;
            arrayList.add(momUniDirectionalAssociation);
        }
        return arrayList.iterator();
    }
}

