/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.mimparser.state;

import org.xml.sax.Attributes;
import se.ericsson.cello.mimparser.model.DomainExtensionImpl;
import se.ericsson.cello.mimparser.model.MomActionImpl;
import se.ericsson.cello.mimparser.model.MomParameterImpl;
import se.ericsson.cello.mimparser.state.ConditionState;
import se.ericsson.cello.mimparser.state.DependenciesScriptState;
import se.ericsson.cello.mimparser.state.DependenciesState;
import se.ericsson.cello.mimparser.state.DeprecatedState;
import se.ericsson.cello.mimparser.state.DisturbancesState;
import se.ericsson.cello.mimparser.state.DomainExtensionState;
import se.ericsson.cello.mimparser.state.FeatureState;
import se.ericsson.cello.mimparser.state.FilterState;
import se.ericsson.cello.mimparser.state.MomBaseState;
import se.ericsson.cello.mimparser.state.ObsoleteState;
import se.ericsson.cello.mimparser.state.ParameterState;
import se.ericsson.cello.mimparser.state.PreConditionState;
import se.ericsson.cello.mimparser.state.SideEffectsState;
import se.ericsson.cello.mimparser.state.SpecificationState;
import se.ericsson.cello.mimparser.state.TakesEffectState;
import se.ericsson.cello.mimparser.state.TransactionConstraintState;
import se.ericsson.cello.mimparser.state.VisibilityState;
import se.ericsson.cello.mimparser.statemachine.StateMachine;

class ActionState
extends MomBaseState {
    private MomActionImpl momAction;
    public static final String ACTION_TAG = "action";

    public ActionState(MomActionImpl momActionImpl) {
        super(ACTION_TAG);
        this.momAction = momActionImpl;
    }

    public void startElement(StateMachine stateMachine, String string, Attributes attributes) {
        super.startElement(stateMachine, string, this.momAction);
        stateMachine.getDataTypeManager().handleDataTypes(this.momAction, string, attributes);
        if (ParameterState.isParameter(string)) {
            MomParameterImpl momParameterImpl = new MomParameterImpl(string, attributes, stateMachine.getParseInfo().getMimModel(), stateMachine.getParseInfo().getNextId());
            this.momAction.addParameter(momParameterImpl);
            stateMachine.pushState(new ParameterState(momParameterImpl, string));
        } else if (string.equals("raisesException")) {
            String string2 = attributes.getValue("name");
            this.momAction.addException(string2);
        } else if (string.equals("deprecated")) {
            stateMachine.pushState(new DeprecatedState(this.momAction));
        } else if (string.equals("disturbances")) {
            stateMachine.pushState(new DisturbancesState(this.momAction));
        } else if (string.equals("takesEffect")) {
            stateMachine.pushState(new TakesEffectState(this.momAction));
        } else if (string.equals("sideEffects")) {
            stateMachine.pushState(new SideEffectsState(this.momAction));
        } else if (string.equals("dependencies")) {
            stateMachine.pushState(new DependenciesState(this.momAction));
        } else if (string.equals("precondition")) {
            stateMachine.pushState(new PreConditionState(this.momAction));
        } else if (string.equals("condition")) {
            stateMachine.pushState(new ConditionState(this.momAction));
        } else if (string.equals("specification")) {
            stateMachine.pushState(new SpecificationState(this.momAction));
        } else if (string.equals("obsolete")) {
            stateMachine.pushState(new ObsoleteState(this.momAction));
        } else if (string.equals("visibility")) {
            stateMachine.pushState(new VisibilityState(this.momAction));
        } else if (string.equals("filter")) {
            stateMachine.pushState(new FilterState(this.momAction));
        } else if (string.equals("dependenciesScript")) {
            stateMachine.pushState(new DependenciesScriptState(this.momAction));
        } else if (string.equals("feature")) {
            stateMachine.pushState(new FeatureState(this.momAction));
        } else if (string.equals("transactionConstraint")) {
            stateMachine.pushState(new TransactionConstraintState(this.momAction));
        } else if (string.equals("domainExtension")) {
            DomainExtensionImpl domainExtensionImpl = new DomainExtensionImpl(string, attributes, stateMachine.getParseInfo().getMimModel(), stateMachine.getParseInfo().getNextId());
            this.momAction.setDomain(domainExtensionImpl);
            stateMachine.pushState(new DomainExtensionState(domainExtensionImpl));
        } else if (string.equals("lockBeforeModify")) {
            this.momAction.setLockBeforeModify();
        } else if (string.equals("lockBeforeExecute")) {
            this.momAction.setLockBeforeExecute();
        } else if (string.equals("transactionRequired")) {
            this.momAction.setTransactionRequired();
        } else if (string.equals("interfaceOnly")) {
            this.momAction.setInterfaceOnly();
        }
    }
}

