/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.ncli.mibmgr;

import java.lang.reflect.Array;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.ncli.mibmgr.DumpFormatter;
import se.ericsson.cello.ncli.mibmgr.MoAttribute;
import se.ericsson.cello.ncli.server.logging.Log;

public class PlainDumpFormatter
implements DumpFormatter {
    private static final String EQUALS = "=";
    private static final String NEW_LINE = "\n";
    private static final int SPACE = 40;

    public String format(MoAttribute moAttribute) {
        Log.trace(this.getClass(), "Format mo " + moAttribute.getLdn());
        Log.trace(this.getClass(), "Num attrs " + moAttribute.getAttributes().length);
        Log.trace(this.getClass(), "Num values " + (moAttribute.getValues() != null ? moAttribute.getValues().length : 0));
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getMoSeparator()).append(NEW_LINE);
        this.append(stringBuffer, "MO", 40);
        stringBuffer.append(moAttribute.getLdn()).append(NEW_LINE);
        stringBuffer.append(this.getMoSeparator()).append(NEW_LINE);
        if (moAttribute.getValues() == null) {
            stringBuffer.append("ERROR DURING COLLECTION").append(NEW_LINE);
        } else {
            int n = 0;
            try {
                for (n = 0; n < moAttribute.getAttributes().length; ++n) {
                    Log.trace(this.getClass(), "attr=" + moAttribute.getAttributes()[n]);
                    this.append(stringBuffer, moAttribute.getAttributes()[n], 40);
                    stringBuffer.append(this.getValueAsString(moAttribute.getValues()[n])).append(NEW_LINE);
                }
            }
            catch (MoAccessException moAccessException) {
                Log.trace(this.getClass(), "Error formatting attribute " + moAttribute.getAttributes()[n]);
            }
        }
        return stringBuffer.toString();
    }

    private String getValueAsString(Object object) throws MoAccessException {
        String string = "";
        if (object instanceof Integer || object instanceof Long || object instanceof String || object instanceof Float || object instanceof Boolean || object instanceof ManagedObject) {
            string = object.toString();
        } else if (object instanceof Integer[] || object instanceof Long[] || object instanceof String[] || object instanceof Float[] || object instanceof Boolean[] || object instanceof ManagedObject[]) {
            string = this.getSequenceValueAsString((Object[])object);
        } else if (object instanceof int[] || object instanceof long[] || object instanceof float[] || object instanceof boolean[]) {
            string = this.getPrimitiveSequenceValue(object);
        } else if (object instanceof Struct) {
            string = this.getStructAsString((Struct)object);
        } else if (object instanceof Struct[]) {
            string = this.getStructSeqAsString((Struct[])object);
        } else {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("VALUE TYPE UNKNOWN!!!").append(NEW_LINE);
            Log.trace(this.getClass(), "Value type unknown");
            string = stringBuffer.toString();
        }
        return string;
    }

    private String getStructAsString(Struct struct) throws MoAccessException {
        int n = 0;
        StringBuffer stringBuffer = new StringBuffer(NEW_LINE);
        for (int i = 0; i < struct.getNames().length; ++i) {
            stringBuffer.append("   >>> " + ++n + ".").append(struct.getNames()[i]).append(EQUALS).append(this.getValueAsString(struct.getValues()[i])).append(NEW_LINE);
        }
        return stringBuffer.toString();
    }

    private String getStructSeqAsString(Struct[] structArray) throws MoAccessException {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < structArray.length; ++i) {
            stringBuffer.append(this.getStructAsString(structArray[i])).append(NEW_LINE);
        }
        return stringBuffer.toString();
    }

    private String getSequenceValueAsString(Object[] objectArray) {
        StringBuffer stringBuffer = new StringBuffer("");
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i] != null) {
                stringBuffer.append(objectArray[i].toString());
            }
            stringBuffer.append(" ");
        }
        return stringBuffer.toString();
    }

    private String getPrimitiveSequenceValue(Object object) {
        int n = Array.getLength(object);
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            Object object2 = Array.get(object, i);
            stringBuffer.append(String.valueOf(object2)).append(" ");
        }
        stringBuffer.append(NEW_LINE);
        return stringBuffer.toString();
    }

    private void append(StringBuffer stringBuffer, String string, int n) {
        StringBuffer stringBuffer2 = new StringBuffer(" ");
        n -= string.length();
        for (int i = 0; i < n; ++i) {
            stringBuffer2.append(" ");
        }
        stringBuffer.append(string).append(stringBuffer2);
    }

    public String getMoSeparator() {
        return "===============================================================================================================";
    }

    public String getHeader() {
        return "";
    }

    public String getFooter() {
        return "";
    }
}

