/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.ncli.server.command.implementors;

import se.ericsson.cello.ncli.server.command.handlers.CommandResultListener;
import se.ericsson.cello.ncli.server.command.implementors.MoSearchableCommand;
import se.ericsson.cello.ncli.server.command.result.PrintoutFactory;
import se.ericsson.cello.ncli.server.cs.NodeServices;
import se.ericsson.cello.ncli.server.exceptions.ExceptionHandler;
import se.ericsson.cello.ncli.server.logging.Log;
import se.ericsson.cello.neal.cm.Mo;

public class SearchCommand
extends MoSearchableCommand {
    boolean xmlFlag = false;

    public SearchCommand(CommandResultListener commandResultListener, NodeServices nodeServices) {
        super(commandResultListener, nodeServices);
    }

    public void execute() {
        Log.trace(SearchCommand.class, "execute()");
        this.printout = PrintoutFactory.createPrintout(this.xmlFlag, "SEARCH");
        try {
            Mo[] moArray = this.searchMos();
            if (moArray == null) {
                this.sendResponse();
                return;
            }
            if (this.checkCancellation()) {
                this.printout.addInhibitedString();
                this.commandCancelled();
                return;
            }
            this.printout.addResultString();
            this.printout.addResult(moArray);
            this.printout.addEndText();
        }
        catch (Exception exception) {
            this.printout.addErrorText(ExceptionHandler.map(exception, ""));
        }
        this.sendResponse();
    }

    public void setXmlFlag(boolean bl) {
        this.xmlFlag = bl;
    }
}

