/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.ncli.server.completion;

import java.util.ArrayList;
import java.util.StringTokenizer;
import se.ericsson.cello.ncli.server.completion.Completer;
import se.ericsson.cello.ncli.server.completion.CompleterFactory;
import se.ericsson.cello.ncli.server.completion.CsCmdCompleter;
import se.ericsson.cello.ncli.server.completion.completers.CmdSearchCompleter;
import se.ericsson.cello.ncli.server.cs.NodeServices;
import se.ericsson.cello.ncli.server.logging.Log;

public class SearchCriteriaCompleter
extends CsCmdCompleter {
    protected static final String ADDFLAG = "-a";
    protected static final String REMOVEFLAG = "-rm";
    protected static final String LISTFLAG = "-l";
    protected static final String CLEARFLAG = "-clear";
    protected static final String EXPRESSIONFLAG = "-e";
    protected static final String LEFT_BRACKET = "(";
    protected static final String RIGHT_BRACKET = ")";
    private String moType = null;

    public SearchCriteriaCompleter(NodeServices nodeServices) {
        super(nodeServices);
    }

    public void completeString(String string) {
        Log.trace(SearchCriteriaCompleter.class, "completeString()");
        this.completedString = "";
        this.completionOptionList = new ArrayList(0);
        this.globalAddr = false;
        this.moAddress = null;
        if (string == null || string.length() == 0) {
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        int n = stringTokenizer.countTokens();
        Log.trace(CsCmdCompleter.class, "nrOfTokens=" + n);
        if (n <= 0) {
            Log.trace(CsCmdCompleter.class, "nrOfTokens == 0, this CmdCompleter should not have been called.");
            this.completedString = string;
            return;
        }
        String string2 = stringTokenizer.nextToken();
        if (!this.completeFirstToken(string2, stringTokenizer, string)) {
            this.completedString = string;
            this.completionOptionList.clear();
        }
    }

    protected boolean completeFirstToken(String string, StringTokenizer stringTokenizer, String string2) {
        Log.trace(SearchCriteriaCompleter.class, ".completeFirstToken() currToken='" + string + "', aStringToComplete ='" + string2 + "'");
        if (string.equals("search")) {
            if (!stringTokenizer.hasMoreTokens()) {
                if (string2.endsWith(" ")) {
                    return this.completeMoAddress("", stringTokenizer, string2);
                }
                Log.trace(CsCmdCompleter.class, ".completeFirstToken(), this CmdCompleter should not have been called.");
                return false;
            }
            string = stringTokenizer.nextToken();
            return this.completeMoAddress(string, stringTokenizer, string2);
        }
        if (!stringTokenizer.hasMoreTokens()) {
            if (string2.endsWith(" ")) {
                return this.completeMoAddress("", stringTokenizer, string2);
            }
            Log.trace(CsCmdCompleter.class, ".completeFirstToken(), this CmdCompleter should not have been called.");
            return false;
        }
        boolean bl = false;
        string = stringTokenizer.nextToken();
        bl = this.completeMoAddress(string, stringTokenizer, string2);
        if (bl) {
            return true;
        }
        if (stringTokenizer.hasMoreElements()) {
            string = stringTokenizer.nextToken();
            bl = this.completeAttrName(string, stringTokenizer, string2);
        }
        return bl;
    }

    protected boolean completeSearchExpressionWithinBrackets(String string, StringTokenizer stringTokenizer, String string2) {
        String string3;
        this.completedString = "";
        this.completionOptionList = new ArrayList();
        int n = stringTokenizer.countTokens();
        Log.trace(SearchCriteriaCompleter.class, "nrOfTokens = " + n);
        if (!string.equals(EXPRESSIONFLAG)) {
            Log.trace(SearchCriteriaCompleter.class, "Error : firstToken should have been -e");
            return false;
        }
        if (n == 0) {
            this.completedString = string2.concat(LEFT_BRACKET);
        } else if (n == 1 && !(string3 = stringTokenizer.nextToken()).equals(LEFT_BRACKET)) {
            this.completedString = string2;
        }
        return true;
    }

    protected boolean completeMoAddress(String string, StringTokenizer stringTokenizer, String string2) {
        Log.trace(SearchCriteriaCompleter.class, "completeMoAddress() currToken='" + string + "', aStringToComplete ='" + string2 + "'");
        if (string.equals(EXPRESSIONFLAG)) {
            return this.completeSearchExpressionWithinBrackets(string, stringTokenizer, string2);
        }
        boolean bl = super.completeMoAddress(string, stringTokenizer, string2);
        if (bl) {
            return true;
        }
        if (stringTokenizer.hasMoreTokens()) {
            string = stringTokenizer.nextToken();
        } else if (string2.endsWith(" ")) {
            string = "";
        } else {
            return false;
        }
        return this.completeAttrName(string, stringTokenizer, string2);
    }

    protected boolean completeMoType(String string, StringTokenizer stringTokenizer, String string2) {
        Log.trace(SearchCriteriaCompleter.class, "completeMoType() currToken='" + string + "', aStringToComplete ='" + string2 + "'");
        this.moAddress = !stringTokenizer.hasMoreTokens() ? this.nodeServices.getWorkingMo().getLdn() : this.nodeServices.getAddressResolver().resolveAddress(string);
        int n = this.moAddress.lastIndexOf(",");
        String string3 = null;
        string3 = n > -1 ? this.moAddress.substring(n + 1) : this.moAddress;
        n = string3.lastIndexOf("=");
        if (n > -1) {
            this.moType = string3.substring(0, n);
        }
        if (stringTokenizer.hasMoreTokens()) {
            string = stringTokenizer.nextToken();
            return this.completeAttrName(string, stringTokenizer, string2);
        }
        if (string2.endsWith(" ") && string.length() != 0) {
            string = "";
            return this.completeAttrName(string, stringTokenizer, string2);
        }
        Completer completer = CompleterFactory.createMoTypeCompleter(this.nodeServices);
        completer.completeString(string);
        int n2 = string2.lastIndexOf(string);
        String string4 = string2.substring(0, n2);
        this.completedString = string4.concat(completer.getCompletedString());
        this.completionOptionList = completer.getCompletionOptionList();
        return true;
    }

    protected boolean completeAttrName(String string, StringTokenizer stringTokenizer, String string2) {
        Log.trace(CmdSearchCompleter.class, "completeAttrName() currToken='" + string + "', aStringToComplete ='" + string2 + "'");
        if (stringTokenizer.hasMoreTokens()) {
            string = stringTokenizer.nextToken();
            return this.completeAttrName(string, stringTokenizer, string2);
        }
        String string3 = string;
        if (string2.endsWith(" ")) {
            string3 = "";
        }
        Completer completer = CompleterFactory.createAttrNameCompleter(this.nodeServices, this.moType, true, true);
        int n = string2.lastIndexOf(string3);
        String string4 = string2.substring(0, n);
        completer.completeString(string3);
        String string5 = completer.getCompletedString();
        if (string5.endsWith(" ")) {
            string5 = string5.substring(0, string5.length() - 1);
        }
        if (completer.getCompletionOptionList().size() == 0) {
            this.completedString = string4.concat(string5);
        } else if (completer.getCompletionOptionList().size() == 1) {
            this.completedString = string4.concat(string5).concat(" ");
            this.completionOptionList.clear();
        } else if (completer.getCompletionOptionList().size() > 1) {
            this.completedString = string4.concat(string5);
            this.completionOptionList = completer.getCompletionOptionList();
        }
        return true;
    }
}

