/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.ncli.server.completion.completers;

import java.util.ArrayList;
import java.util.StringTokenizer;
import se.ericsson.cello.ncli.server.completion.BaseCompleter;
import se.ericsson.cello.ncli.server.completion.Completer;
import se.ericsson.cello.ncli.server.completion.util.CompletionHelper;
import se.ericsson.cello.ncli.server.cs.NodeServices;
import se.ericsson.cello.ncli.server.logging.Log;
import se.ericsson.cello.neal.fm.SeverityInfo;

public class CmdAlarmSevCompleter
extends BaseCompleter
implements Completer {
    private static final String WARNING = "WARNING";
    private static final String MINOR = "MINOR";
    private static final String MAJOR = "MAJOR";
    private static final String CRITICAL = "CRITICAL";
    private static final String SET = "-set";
    private static final String REMOVE = "-rm";
    private static final String LIST = "-list";
    private String base = "alarmsev ";

    public CmdAlarmSevCompleter(NodeServices nodeServices) {
        super(nodeServices);
    }

    public void completeString(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        int n = stringTokenizer.countTokens();
        this.completedString = "";
        this.completionOptionList = new ArrayList(0);
        Log.trace(CmdAlarmSevCompleter.class, ".completeString() nrOfTokens='" + n + "', aStringToComplete ='" + string + "'");
        if (n == 1) {
            this.completedString = this.base + "-";
            this.completionOptionList.add(LIST);
            this.completionOptionList.add(REMOVE);
            this.completionOptionList.add(SET);
        } else if (n == 2) {
            String string2 = stringTokenizer.nextToken();
            string2 = stringTokenizer.nextToken();
            this.completedString = string;
            if ("-".equals(string2)) {
                this.completionOptionList.add(LIST);
                this.completionOptionList.add(REMOVE);
                this.completionOptionList.add(SET);
            } else if (LIST.startsWith(string2)) {
                this.completedString = this.base + LIST;
            } else if (REMOVE.equals(string2)) {
                this.completeRemove(string + " ");
            } else if (REMOVE.startsWith(string2)) {
                this.completedString = this.base + REMOVE + " ";
            } else if (SET.startsWith(string2)) {
                this.completedString = this.base + SET + " " + "\"\"" + " ";
            }
        } else if (string.startsWith(this.base + SET)) {
            this.completeSet(string);
        } else if (string.startsWith(this.base + REMOVE)) {
            this.completeRemove(string);
        } else {
            this.completedString = string;
            this.completionOptionList.clear();
        }
    }

    private void completeRemove(String string) {
        SeverityInfo[] severityInfoArray = this.nodeServices.getFm().getAllModifiedSeverity();
        if (string.trim().endsWith(REMOVE)) {
            this.completedString = string.trim() + " ";
            for (int i = 0; i < severityInfoArray.length; ++i) {
                this.completionOptionList.add(severityInfoArray[i].getSpecificProblem());
            }
        } else {
            int n = (this.base + REMOVE + " ").length();
            String string2 = string.substring(0, n);
            String string3 = string.substring(n);
            string3 = CompletionHelper.stripLeadingAndTrailingQuotes(string3);
            ArrayList<String> arrayList = new ArrayList<String>();
            for (int i = 0; i < severityInfoArray.length; ++i) {
                if (!severityInfoArray[i].getSpecificProblem().startsWith(string3)) continue;
                arrayList.add(severityInfoArray[i].getSpecificProblem());
            }
            String string4 = CompletionHelper.getCommonStartStrForSubsetIgnoreCase(arrayList);
            if (!string4.equals("")) {
                this.completedString = arrayList.size() == 1 ? string2 + "\"" + string4 + "\"" : string2 + "\"" + string4;
            }
            if (arrayList.size() > 1) {
                this.completionOptionList = arrayList;
            }
        }
    }

    private void completeSet(String string) {
        if (string.trim().endsWith("\"")) {
            this.completedString = string.trim() + " ";
            this.completionOptionList.add(CRITICAL);
            this.completionOptionList.add(MAJOR);
            this.completionOptionList.add(MINOR);
            this.completionOptionList.add(WARNING);
        } else {
            String string2 = string.substring(0, string.lastIndexOf(" "));
            String string3 = string.substring(string.lastIndexOf(" "));
            this.completedString = string2 + " " + this.completeSeverity(string3.trim());
        }
    }

    private String completeSeverity(String string) {
        String string2 = string;
        if (string.equalsIgnoreCase("M")) {
            this.completionOptionList.add(MAJOR);
            this.completionOptionList.add(MINOR);
        } else {
            string2 = MAJOR.startsWith(string.toUpperCase()) ? MAJOR : (MINOR.startsWith(string.toUpperCase()) ? MINOR : (CRITICAL.startsWith(string.toUpperCase()) ? CRITICAL : (WARNING.startsWith(string.toUpperCase()) ? WARNING : string)));
        }
        return string2;
    }
}

