/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.ncli.server.configuration;

import se.ericsson.cello.ncli.server.configuration.ConfigurationReader;
import se.ericsson.cello.ncli.server.logging.Log;
import se.ericsson.cello.pri.LongSystemParameter;
import se.ericsson.cello.pri.PriJavaProxy;
import se.ericsson.cello.pri.PriJavaProxyFactory;
import se.ericsson.cello.pri.PriProcessNotFoundException;
import se.ericsson.cello.pri.StringSystemParameter;
import se.ericsson.cello.pri.SystemParameterNotFoundException;
import se.ericsson.cello.pri.WrongSystemParameterTypeException;

public class Configuration
implements ConfigurationReader {
    private static final long MAX_SESSION_DEFAULT = 2L;
    private static final long REQ_FREE_MEM_DEFAULT = 200L;
    private static final long MOM_OPTION_DEFAULT = 0L;
    private static final String MOM_PATH_DEFAULT = null;
    private static final long SESSION_DATA_STORAGE_TIME_DEFAULT = 300L;
    private static final long MAX_SESSION_SP_KEY = 22L;
    private static final long REQ_FREE_MEM_SP_KEY = 23L;
    private static final long MOM_OPTION_SP_KEY = 24L;
    private static final long MOM_PATH_SP_KEY = 25L;
    private static final long SESSION_DATA_STORAGE_TIME_SP_KEY = 30L;
    private long maxNrOfSessions;
    private long requiredFreeMemory;
    private boolean isMomAware;
    private boolean isMomAsFilter;
    private String momPath = null;
    private long sessionDataStorageTime;
    private long momOption;
    private PriJavaProxy pri;

    public Configuration() {
        this.setDefaultValues();
        if (System.getProperty("javasim") == null) {
            try {
                this.pri = PriJavaProxyFactory.createPriJavaProxy();
                Log.trace(Configuration.class, "Java Proxy successfully created.");
                this.maxNrOfSessions = this.getLongParameter(22L, 2L, "NcliNumberOfSessions");
                this.requiredFreeMemory = this.getLongParameter(23L, 200L, "NcliRequiredFreeMemory");
                this.momOption = this.getLongParameter(24L, 0L, "NcliMomOption");
                this.momPath = this.getStringParameter(25L, MOM_PATH_DEFAULT, "NcliMomXmlFilePath");
                this.sessionDataStorageTime = this.getLongParameter(30L, 300L, "NcliSessionStorageTime");
                this.logPriSystemParameters();
                this.setMomOptions(this.momOption);
            }
            catch (PriProcessNotFoundException priProcessNotFoundException) {
                Log.info(Configuration.class, "Failed to create PRI Proxy, using default values.", (Exception)((Object)priProcessNotFoundException));
            }
        }
    }

    private void logPriSystemParameters() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Read PRI System Parameters: ");
        stringBuffer.append("id 22=" + this.maxNrOfSessions);
        stringBuffer.append(", id 23=" + this.requiredFreeMemory);
        stringBuffer.append(", id 24=" + this.momOption);
        String string = "null";
        if (this.momPath != null) {
            string = this.momPath;
        }
        stringBuffer.append(", id 25=" + string);
        stringBuffer.append(", id 30=" + this.sessionDataStorageTime);
        Log.info(Configuration.class, stringBuffer.toString());
    }

    private void setDefaultValues() {
        this.maxNrOfSessions = 2L;
        this.requiredFreeMemory = 200L;
        this.sessionDataStorageTime = 300L;
        this.momPath = MOM_PATH_DEFAULT;
        this.setMomOptions(0L);
    }

    private long getLongParameter(long l, long l2, String string) {
        long l3 = l2;
        try {
            LongSystemParameter longSystemParameter = this.pri.getLongSystemParameter(l);
            if (longSystemParameter.isValid()) {
                l3 = longSystemParameter.getValue();
            }
        }
        catch (SystemParameterNotFoundException systemParameterNotFoundException) {
            Log.info(Configuration.class, "Parameter " + l + " not found, using default value");
        }
        catch (WrongSystemParameterTypeException wrongSystemParameterTypeException) {
            Log.info(Configuration.class, "Parameter " + l + " has wrong type, using default value");
        }
        Log.trace(Configuration.class, "Using system parameter " + l + " (" + string + ")" + " = " + l3);
        return l3;
    }

    private String getStringParameter(long l, String string, String string2) {
        String string3 = string;
        try {
            StringSystemParameter stringSystemParameter = this.pri.getStringSystemParameter(l);
            string3 = stringSystemParameter.getValue();
        }
        catch (SystemParameterNotFoundException systemParameterNotFoundException) {
            Log.info(Configuration.class, "Parameter " + l + " not found, using default value");
        }
        catch (WrongSystemParameterTypeException wrongSystemParameterTypeException) {
            Log.info(Configuration.class, "Parameter " + l + " has wrong type, using default value");
        }
        Log.trace(Configuration.class, "Using system parameter " + l + " (" + string2 + ")" + " = " + string3);
        return string3;
    }

    private void setMomOptions(long l) {
        if (l == 0L) {
            this.isMomAware = false;
            this.isMomAsFilter = false;
        } else if (l == 1L) {
            this.isMomAware = true;
            this.isMomAsFilter = false;
        } else if (l == 2L) {
            this.isMomAware = true;
            this.isMomAsFilter = true;
        } else {
            this.isMomAware = false;
            this.isMomAsFilter = false;
        }
    }

    public int getMaxNrOfSessions() {
        return (int)this.maxNrOfSessions;
    }

    public boolean isMomAware() {
        return this.isMomAware;
    }

    public String getMomFilePath() {
        return this.momPath;
    }

    public long getRequiredFreeMemory() {
        return this.requiredFreeMemory * 1024L;
    }

    public boolean isMomAsFilter() {
        return this.isMomAsFilter;
    }

    public long getSessionDataStorageTime() {
        return this.sessionDataStorageTime;
    }
}

