/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.ncli.server.cs;

import se.ericsson.cello.mimparser.MimModel;
import se.ericsson.cello.ncli.server.cs.NodeServices;
import se.ericsson.cello.ncli.server.cs.momfilter.MomFilteredNodeImpl;
import se.ericsson.cello.ncli.server.logging.Log;
import se.ericsson.cello.neal.Node;
import se.ericsson.cello.neal.NodeException;

public class NodeFactory {
    public static Node createNode(NodeServices nodeServices) throws NodeException {
        Log.trace(NodeFactory.class, "Creating NEAL Node object");
        Node node = se.ericsson.cello.neal.NodeFactory.getNode();
        if (nodeServices.getConfiguration().isMomAsFilter()) {
            Log.trace(NodeFactory.class, "Mom Filer enabled. Creating filtered Node");
            MimModel mimModel = null;
            try {
                mimModel = nodeServices.getMimModel();
            }
            catch (Exception exception) {
                throw new RuntimeException("Failed to read the required MOM XML File.", exception);
            }
            return new MomFilteredNodeImpl(node, mimModel);
        }
        return node;
    }

    private NodeFactory() {
    }
}

