/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.omf.mao.commonmo.transactions;

import se.ericsson.cello.transaction.Control;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.InactiveTransactionException;
import se.ericsson.cello.transaction.Terminator;
import se.ericsson.cello.transaction.TransactionRolledBackException;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.commonmo.transactions.IllegalTransactionStateException;
import se.ericsson.crbs.omf.mao.commonmo.transactions.MaoTransaction;
import se.ericsson.crbs.omf.mao.commonmo.transactions.TransactionState;

class CppTransaction
implements MaoTransaction {
    private static final TransactionState INITIAL_STATE = TransactionState.ACTIVE;
    private static final Class THIS_CLASS = CppTransaction.class;
    private static AbstractLogger logger = LoggingService.getLogger(THIS_CLASS.getName());
    private TransactionState state = INITIAL_STATE;
    private final Control cppControl;

    CppTransaction(Control aCppControlObject) {
        this.cppControl = aCppControlObject;
    }

    public void commit() throws IllegalTransactionStateException {
        logger.traceEnter(THIS_CLASS, "commit()");
        if (this.state != TransactionState.ACTIVE) {
            throw new IllegalTransactionStateException(this.state, "Cannot commit transaction " + this.toString());
        }
        Terminator terminator = this.cppControl.getTerminator();
        try {
            terminator.commit();
            this.state = TransactionState.COMMITTED;
        }
        catch (InactiveTransactionException itx) {
            throw new IllegalTransactionStateException(this.state, (Throwable)itx);
        }
        catch (TransactionRolledBackException trbx) {
            this.state = TransactionState.ROLLED_BACK;
            throw new IllegalTransactionStateException(this.state, (Throwable)trbx);
        }
        logger.traceReturn(THIS_CLASS, "commit()");
    }

    public Coordinator getCoordinator() {
        return this.cppControl.getCoordinator();
    }

    public TransactionState getState() {
        return this.state;
    }

    public void rollback() throws IllegalTransactionStateException {
        logger.traceEnter(THIS_CLASS, "rollback()");
        if (this.state != TransactionState.ACTIVE && this.state != TransactionState.ROLLBACK_ONLY) {
            throw new IllegalTransactionStateException(this.state, "Cannot rollback transaction " + this.toString());
        }
        Terminator terminator = this.cppControl.getTerminator();
        try {
            terminator.rollback();
            this.state = TransactionState.ROLLED_BACK;
        }
        catch (InactiveTransactionException itx) {
            throw new IllegalTransactionStateException(this.state, (Throwable)itx);
        }
        logger.traceReturn(THIS_CLASS, "rollback()");
    }

    public void setRollbackOnly() throws IllegalTransactionStateException {
        logger.traceEnter(THIS_CLASS, "setRollbackOnly()");
        if (this.state != TransactionState.ACTIVE && this.state != TransactionState.ROLLBACK_ONLY) {
            throw new IllegalTransactionStateException(this.state, "Cannot mark transaction rollback-only: " + this.toString());
        }
        try {
            this.getCoordinator().rollbackOnly();
        }
        catch (InactiveTransactionException itx) {
            throw new IllegalTransactionStateException(this.state, (Throwable)itx);
        }
        logger.traceReturn(THIS_CLASS, "setRollbackOnly()");
    }
}

