/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.omf.mao.commonmo.transactions;

import se.ericsson.cello.transaction.Control;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.TransactionFactory;
import se.ericsson.cello.transaction.TransactionRolledBackException;
import se.ericsson.crbs.omf.mao.commonmo.transactions.CouldNotCreateTransactionException;
import se.ericsson.crbs.omf.mao.commonmo.transactions.CppTransaction;
import se.ericsson.crbs.omf.mao.commonmo.transactions.MaoTransaction;
import se.ericsson.crbs.omf.mao.commonmo.transactions.TransactionServices;

class TransactionServicesImpl
implements TransactionServices {
    private static final int MAO_DEFAULT_TX_TIMEOUT = 59;
    private final TransactionFactory myTransactionFactory;

    public TransactionServicesImpl(TransactionFactory aTransactionFactory) {
        this.myTransactionFactory = aTransactionFactory;
    }

    public MaoTransaction createTransaction() throws CouldNotCreateTransactionException {
        return this.createTransaction(59);
    }

    public MaoTransaction createTransaction(int timeout) throws CouldNotCreateTransactionException {
        Control controlObject = null;
        try {
            controlObject = this.myTransactionFactory.create(timeout);
        }
        catch (TransactionRolledBackException trbx) {
            throw new CouldNotCreateTransactionException("Failed to create production MaoTransaction with timeout " + timeout, trbx);
        }
        return new CppTransaction(controlObject);
    }

    public MaoTransaction wrapExistingTransaction(Coordinator cppCoordinator) {
        Control controlObject = this.myTransactionFactory.get(cppCoordinator.getTransactionID());
        return new CppTransaction(controlObject);
    }
}

