/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.omf.mao.commonmo.validation;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.AttrMissingAtCreateException;
import se.ericsson.cello.moframework.AttrNotSettableAtCreateException;
import se.ericsson.cello.moframework.IllegalParentException;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoCanNotBeCreatedException;
import se.ericsson.cello.moframework.MoCardinalityViolationException;
import se.ericsson.cello.moframework.MoHasChildrenException;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.commonmo.Definitions;
import se.ericsson.crbs.omf.mao.commonmo.MoIteratorImpl;
import se.ericsson.crbs.omf.mao.commonmo.ProcessingFailureException;
import se.ericsson.crbs.omf.mao.commonmo.metadata.AttributeMetaData;
import se.ericsson.crbs.omf.mao.commonmo.metadata.ChildMetaData;
import se.ericsson.crbs.omf.mao.commonmo.metadata.MoMetaData;
import se.ericsson.crbs.omf.mao.commonmo.metadata.finder.MoMetaDataFinder;
import se.ericsson.crbs.omf.mao.commonmo.metadata.types.AttributeDataType;
import se.ericsson.crbs.omf.mao.commonmo.validation.AttributeMetaDataValidatorImpl;
import se.ericsson.crbs.omf.mao.commonmo.validation.MoValidator;
import se.ericsson.crbs.omf.mao.commonmo.validation.MoValidatorFactory;
import se.ericsson.crbs.omf.mao.wrappers.MoRepositoryWrapper;

class MoMetaDataValidator {
    private static final Class THIS_CLASS = MoMetaDataValidator.class;
    private static AbstractLogger logger = LoggingService.getLogger(MoMetaDataValidator.class.getName());
    private final MoValidatorFactory moValidatorFactory;
    private final MoMetaDataFinder moMetaDataFinder;
    private final MoMetaData moMetaData;
    private final String moType;
    private final MoRepositoryWrapper moRepositoryWrapper;

    public MoMetaDataValidator(MoMetaData aMoMetaData, String aMoType, MoMetaDataFinder aMoMetaDataFinder, MoValidatorFactory aMoValidatorFactory, MoRepositoryWrapper aMoRepositoryWrapper) {
        this.moMetaDataFinder = aMoMetaDataFinder;
        this.moMetaData = aMoMetaData;
        this.moType = aMoType;
        this.moValidatorFactory = aMoValidatorFactory;
        this.moRepositoryWrapper = aMoRepositoryWrapper;
    }

    private void checkAttributeUniqueness(String attributeName, Object attributeValue, Coordinator coordinator) throws NoSuchAttributeException, MoAccessException, ProcessingFailureException {
        logger.traceDebug(THIS_CLASS, "checking uniqueness of " + attributeName + " = " + attributeValue.toString());
        MoValidator moValidator = this.moValidatorFactory.createMoValidatorImpl(this.moType);
        if (!moValidator.checkUniquenessInNode(this.moType, attributeName, attributeValue, "long", coordinator, "")) {
            throw new ProcessingFailureException("Attribute " + attributeName + " in " + this.moType + " MO is not unique. ");
        }
    }

    public MoIterator checkCardinality(ManagedObject parent) throws MoAccessException {
        logger.traceEnter(this.getClass(), "checkCardinality()");
        MoIterator allChildrenOfParent = parent.getChildren();
        ArrayList<ManagedObject> siblingList = new ArrayList<ManagedObject>();
        while (allChildrenOfParent.hasMoreElements()) {
            ManagedObject currentChild = allChildrenOfParent.nextMo();
            if (!currentChild.getType().equalsIgnoreCase(this.moType)) continue;
            siblingList.add(currentChild);
        }
        int maxCardinality = this.moMetaData.getMaxCardinality(parent.getType(), this.moMetaDataFinder);
        if (maxCardinality != -1 && siblingList.size() >= maxCardinality) {
            logger.info(THIS_CLASS, "MoCardinality (" + maxCardinality + ") " + "violated for MO of type " + this.moType);
            throw new MoCardinalityViolationException("MoCardinality (" + maxCardinality + ") " + "violated for MO of type " + this.moType);
        }
        logger.traceReturn(this.getClass(), "checkCardinality()");
        return new MoIteratorImpl(siblingList);
    }

    private void checkManadatoryAttributesArePresent(AttrList clientAttributes) throws MoAccessException, IOException {
        String currentMandatoryAttributeName;
        Map mandatoryAttributes = this.moMetaDataFinder.getMandatoryAttributes(this.moType);
        Iterator mandatoryAttrNameIter = mandatoryAttributes.keySet().iterator();
        while (mandatoryAttrNameIter.hasNext() && this.moMetaDataFinder.getMoAttributes(this.moType, currentMandatoryAttributeName = (String)mandatoryAttrNameIter.next()).getReplacedBy() == null) {
            boolean present;
            boolean bl = present = clientAttributes.indexOf(currentMandatoryAttributeName) != -1;
            if (!present) {
                String replMoType = this.moType;
                Struct replacing = this.moMetaDataFinder.getMoAttributes(replMoType, currentMandatoryAttributeName).getReplacing();
                while (!present && replacing != null) {
                    String replAttrName;
                    if (replacing.getValue("moName") != null) {
                        replMoType = (String)replacing.getValue("moName");
                    }
                    present = (replAttrName = (String)replacing.getValue("attributeName")) != null && replMoType.equals(this.moType) && clientAttributes.indexOf(replAttrName) != -1;
                    replacing = this.moMetaDataFinder.getMoAttributes(replMoType, replAttrName).getReplacing();
                }
            }
            if (present) continue;
            logger.traceError(this.getClass(), "Mandatory attribute missing at create in " + this.moType + ": " + currentMandatoryAttributeName);
            throw new AttrMissingAtCreateException(currentMandatoryAttributeName, this.moType);
        }
    }

    public void checkParent(ManagedObject parent) throws MoAccessException {
        logger.traceEnter(this.getClass(), "checkParent()");
        boolean parentFound = false;
        Iterator parentTypeIter = this.moMetaData.getChildMetaData(this.moMetaDataFinder).iterator();
        while (parentTypeIter.hasNext()) {
            ChildMetaData currentChildMetaData = (ChildMetaData)parentTypeIter.next();
            if (!parent.getType().equalsIgnoreCase(currentChildMetaData.getParentName())) continue;
            parentFound = true;
            break;
        }
        if (!parentFound) {
            logger.traceError(this.getClass(), "Illegal parent for " + this.moType + ": " + parent.getType());
            throw new IllegalParentException("Illegal parent for " + this.moType + ": " + parent.getType());
        }
        logger.traceReturn(this.getClass(), "checkParent()");
    }

    private void validateAttribute(String attributeName, Object attributeValue, Coordinator coordinator) throws MoAccessException {
        Map attributes = this.moMetaData.getAttributes();
        AttributeMetaData attributeMetaData = (AttributeMetaData)attributes.get(attributeName);
        logger.traceEnter(this.getClass(), "validateAttribute(" + attributeName + ")");
        if (attributeMetaData == null) {
            throw new NoSuchAttributeException(attributeName, this.moType);
        }
        if (attributeMetaData.isReadOnly() && !attributeMetaData.isMandatory()) {
            logger.traceDebug(THIS_CLASS, "Trying to set read-only attribute in MO " + this.moType + " .Attribute: " + attributeName);
            throw new AttrNotSettableAtCreateException(attributeName, this.moType);
        }
        if (attributeMetaData.isMandatory() && attributeValue == null) {
            logger.traceError(THIS_CLASS, "Mandatory attribute " + attributeName + " cannot be null");
            throw new ProcessingFailureException("Mandatory attribute " + attributeName + " cannot be null");
        }
        AttributeMetaDataValidatorImpl amdv = new AttributeMetaDataValidatorImpl(this.moType, this.moMetaDataFinder, this.moRepositoryWrapper);
        AttributeDataType dataType = attributeMetaData.getData();
        amdv.checkAttribute(dataType, attributeName, attributeValue, attributeMetaData.isMandatory());
        if (attributeMetaData.isUniqueInNode() && "Integer".equals(attributeMetaData.getData().getJavaReturnType())) {
            this.checkAttributeUniqueness(attributeName, attributeValue, coordinator);
        }
        logger.traceReturn(this.getClass(), "validateAttribute(" + attributeName + ")");
    }

    public void verifyAtCreate(AttrList clientAttributes, boolean isAutoTriggered, Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(this.getClass(), "verifyAtCreate()");
        boolean systemCreated = this.moMetaData.isSystemCreated();
        try {
            if (systemCreated && !isAutoTriggered) {
                throw new MoCanNotBeCreatedException("MO " + this.moType + " is system created and can not be created by User.");
            }
            for (int idx = 0; idx < clientAttributes.size(); ++idx) {
                String currentAttributeName = clientAttributes.getName(idx);
                if (currentAttributeName.equalsIgnoreCase(this.moType + "id")) {
                    logger.traceError(THIS_CLASS, "The naming attribute must not appear in the attribute list!");
                    throw new NoSuchAttributeException(clientAttributes.getName(idx), this.moType);
                }
                Object currentAttributeValue = clientAttributes.getValue(idx);
                if (Definitions.isTransparentData(currentAttributeName)) continue;
                this.validateAttribute(currentAttributeName, currentAttributeValue, coordinator);
            }
            this.checkManadatoryAttributesArePresent(clientAttributes);
        }
        catch (IOException e) {
            throw new ProcessingFailureException("Could not read MO Meta data from MOM for mo: " + this.moType + ". " + e.getMessage());
        }
        logger.traceReturn(this.getClass(), "verifyAtCreate()");
    }

    public final void verifyAtDelete(boolean isAutoTriggered, ManagedObject managedObject) throws ProcessingFailureException, MoHasChildrenException {
        logger.traceEnter(this.getClass(), "verifyAtDelete() " + this.moType);
        if (managedObject.getChildren().size() != 0) {
            MoIterator moIterator = managedObject.getChildren();
            while (moIterator.hasMoreElements()) {
                MoMetaData aMoMetaData = this.moMetaDataFinder.getMoData(moIterator.nextMo().getType());
                if (aMoMetaData.isSystemCreated()) continue;
                throw new MoHasChildrenException(managedObject);
            }
        }
        if (this.moMetaData.isSystemCreated() && !isAutoTriggered) {
            throw new ProcessingFailureException(this.getClass() + ".verifyAtDelete: MO " + this.moType + " cannot be deleted - it was created by the system and " + "not as the result of any user action");
        }
        logger.traceReturn(this.getClass(), "verifyAtDelete() " + this.moType);
    }
}

