/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.omf.mao.data;

import BasicConfig.MOidpair;
import CosNaming.NameComponent;
import java.util.StringTokenizer;

public final class MOName {
    public static final String RDN_DELIMITER = ",";
    public static final String TYPE_DELIMITER = "=";
    public static final MOName NULL_NAME = new MOName();
    public static final MOidpair NULL_ID = NULL_NAME.getMOidpair();
    private String rdnSeq;

    public static MOName create(NameComponent[] anRDNSeq) {
        return new MOName(anRDNSeq);
    }

    public static MOName create(String anRDNSeq) {
        return new MOName(anRDNSeq);
    }

    private MOName() {
    }

    private MOName(NameComponent[] anRDNSeq) {
        if (anRDNSeq == null || anRDNSeq.length == 0) {
            this.rdnSeq = null;
            return;
        }
        StringBuffer seq = new StringBuffer(anRDNSeq[0].id);
        for (int i = 1; i < anRDNSeq.length; ++i) {
            seq.append(RDN_DELIMITER);
            seq.append(anRDNSeq[i].id);
        }
        this.rdnSeq = seq.toString();
    }

    private MOName(String anRDNSeq) {
        this.rdnSeq = anRDNSeq;
    }

    public boolean equals(Object anObject) {
        boolean equality = false;
        if (this == anObject) {
            equality = true;
        } else if (anObject instanceof MOName) {
            MOName moName = (MOName)anObject;
            equality = this.rdnSeq == null && moName.rdnSeq == null || this.rdnSeq != null && this.rdnSeq.equals(moName.rdnSeq);
        } else {
            equality = this.rdnSeq != null && this.rdnSeq.equals(anObject);
        }
        return equality;
    }

    public String getFirstRDN() {
        String res = null;
        if (this.rdnSeq != null) {
            int rdnIdx = this.rdnSeq.indexOf(RDN_DELIMITER);
            res = rdnIdx == -1 ? this.rdnSeq : this.rdnSeq.substring(0, rdnIdx);
        }
        return res;
    }

    public String getId() {
        String res = null;
        if (this.rdnSeq != null) {
            int idIdx = this.rdnSeq.lastIndexOf(TYPE_DELIMITER) + 1;
            res = this.rdnSeq.substring(idIdx);
        }
        return res;
    }

    public String getLastRDN() {
        String res = null;
        if (this.rdnSeq != null) {
            int rdnIdx = this.rdnSeq.lastIndexOf(RDN_DELIMITER) + 1;
            res = this.rdnSeq.substring(rdnIdx);
        }
        return res;
    }

    public MOidpair getMOidpair() {
        NameComponent[] nameSequence = this.getNameComponentSeq();
        MOidpair idPair = new MOidpair();
        idPair.name(nameSequence);
        return idPair;
    }

    public NameComponent[] getNameComponentSeq() {
        NameComponent[] res = null;
        if (this.rdnSeq == null) {
            res = new NameComponent[]{};
        } else {
            StringTokenizer tokenizer = new StringTokenizer(this.rdnSeq, RDN_DELIMITER);
            int nTokens = tokenizer.countTokens();
            if (nTokens == 0) {
                throw new IllegalArgumentException("rdnSeq is empty");
            }
            NameComponent[] seq = new NameComponent[nTokens];
            for (int i = 0; i < nTokens; ++i) {
                NameComponent nameComponent;
                String rdn = tokenizer.nextToken();
                seq[i] = nameComponent = new NameComponent(rdn, "");
            }
            res = seq;
        }
        return res;
    }

    public int getNoOfRDNs() {
        int number = 0;
        if (this.rdnSeq != null) {
            number = 1;
            int len = this.rdnSeq.length();
            int i = this.rdnSeq.indexOf(RDN_DELIMITER) + 1;
            while (i != 0 && i < len) {
                ++number;
                i = this.rdnSeq.indexOf(RDN_DELIMITER, i) + 1;
            }
        }
        return number;
    }

    public MOName getParentName() {
        MOName res = null;
        if (this.rdnSeq != null) {
            int rdnIdx = this.rdnSeq.lastIndexOf(RDN_DELIMITER);
            if (rdnIdx == -1) {
                res = NULL_NAME;
            } else {
                String parentRDNSeq = this.rdnSeq.substring(0, rdnIdx);
                res = new MOName(parentRDNSeq);
            }
        }
        return res;
    }

    public String getRDNSeq() {
        return this.rdnSeq;
    }

    public MOName getSubName(int aFromRDNIndex, int aToRDNIndex) {
        int from = 0;
        int fromCounter = aFromRDNIndex;
        int toCounter = aToRDNIndex;
        while (fromCounter-- > 0) {
            from = this.rdnSeq.indexOf(RDN_DELIMITER, from) + 1;
        }
        int toIndex = 0;
        while (toCounter-- > 0) {
            toIndex = this.rdnSeq.indexOf(RDN_DELIMITER, toIndex) + 1;
        }
        if (toIndex > 0) {
            --toIndex;
        }
        if (toIndex == 0) {
            toIndex = this.rdnSeq.length();
        }
        String subSeq = this.rdnSeq.substring(from, toIndex);
        return new MOName(subSeq);
    }

    public String getType() {
        String res = null;
        if (this.rdnSeq != null) {
            String rdn = this.getLastRDN();
            res = rdn.substring(0, rdn.indexOf(TYPE_DELIMITER));
        }
        return res;
    }

    public int hashCode() {
        return this.rdnSeq.hashCode();
    }

    public boolean isChildOf(MOName anRDNSeq) {
        boolean res = false;
        if (this.isIndirectChildOf(anRDNSeq)) {
            int anNoOfRDNs = anRDNSeq.getNoOfRDNs();
            int noOfRDNs = this.getNoOfRDNs();
            res = noOfRDNs == anNoOfRDNs + 1;
        }
        return res;
    }

    public boolean isIndirectChildOf(MOName anRDNSeq) {
        boolean res = false;
        res = this.rdnSeq == null || anRDNSeq.rdnSeq == null ? false : this.rdnSeq.startsWith(anRDNSeq.rdnSeq + RDN_DELIMITER);
        return res;
    }

    public boolean isIndirectParentOf(MOName anRDNSeq) {
        boolean res = false;
        if (anRDNSeq != null) {
            res = anRDNSeq.isIndirectChildOf(this);
        }
        return res;
    }

    public boolean isParentOf(MOName anRDNSeq) {
        boolean res = false;
        if (anRDNSeq != null) {
            res = anRDNSeq.isChildOf(this);
        }
        return res;
    }

    public boolean isSibling(MOName anRDNSeq) {
        MOName parent;
        boolean res = false;
        if (anRDNSeq.getNoOfRDNs() == this.getNoOfRDNs() && !(parent = this.getParentName()).equals(NULL_NAME)) {
            MOName moUnderTestParent = anRDNSeq.getParentName();
            if (parent.getRDNSeq().equals(moUnderTestParent.getRDNSeq())) {
                res = true;
            }
        }
        return res;
    }

    public String toString() {
        return this.rdnSeq;
    }
}

