/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.omf.mao.genericmo.froproxy;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Map;
import se.ericsson.cello.maofro.proxy.MaoFroGenericProxy;
import se.ericsson.cello.maofro.proxy.TagNameDictionary;
import se.ericsson.cello.maofro.proxy.TagNameDictionaryException;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.SoftwareErrorException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;

public class CppMaoFroProxyAdaptor
extends MaoFroGenericProxy {
    private static boolean lsv106orLater = true;
    private static AbstractLogger logger = LoggingService.getLogger(CppMaoFroProxyAdaptor.class.getName());
    private static final Class THIS_CLASS = CppMaoFroProxyAdaptor.class;

    public CppMaoFroProxyAdaptor(TagNameDictionary tagnamedictionary, String moType) throws TagNameDictionaryException {
        super(tagnamedictionary, moType);
        logger.traceEnter(THIS_CLASS, "CppMaoFroProxyAdaptor(" + tagnamedictionary + ", " + moType + ")");
        logger.traceReturn(THIS_CLASS, "CppMaoFroProxyAdaptor");
    }

    public Map getAttributes(Coordinator coordinator, int froId, Collection attributes) throws MoAccessException {
        Map result = null;
        logger.traceEnter(THIS_CLASS, "getAttributes(" + coordinator + ", " + froId + ", " + attributes + ")");
        if (lsv106orLater) {
            try {
                logger.traceDebug(THIS_CLASS, "getAttributes() using super.getAttributes()");
                result = super.getAttributes(coordinator, froId, attributes);
            }
            catch (ClassCastException cce) {
                lsv106orLater = false;
                logger.traceDebug(THIS_CLASS, "getAttributes() super.getAttributes() failed (ClassCastException)");
            }
        }
        if (!lsv106orLater) {
            try {
                result = this.getAttributesByReflection(coordinator, froId, attributes);
            }
            catch (SoftwareErrorException swe) {
                lsv106orLater = true;
            }
        }
        logger.traceReturn(THIS_CLASS, "getAttributes");
        return result;
    }

    public Map getAttributesByReflection(Coordinator coordinator, int froId, Collection attributes) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "getAttributesByReflection(" + coordinator + ", " + froId + ", " + attributes + ")");
        String msg = "Error in calling private method handleGetAttributes!";
        Map result = null;
        try {
            Method method = MaoFroGenericProxy.class.getDeclaredMethod("handleGetAttributes", Coordinator.class, Integer.TYPE, Collection.class);
            method.setAccessible(true);
            result = (Map)method.invoke((Object)this, coordinator, new Integer(froId), attributes);
        }
        catch (SecurityException e) {
            logger.traceError(((Object)((Object)this)).getClass(), "Error in calling private method handleGetAttributes!", e);
            throw new SoftwareErrorException((Throwable)e);
        }
        catch (NoSuchMethodException e) {
            logger.traceError(((Object)((Object)this)).getClass(), "Error in calling private method handleGetAttributes!", e);
            throw new SoftwareErrorException((Throwable)e);
        }
        catch (IllegalArgumentException e) {
            logger.traceError(((Object)((Object)this)).getClass(), "Error in calling private method handleGetAttributes!", e);
            throw new SoftwareErrorException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            logger.traceError(((Object)((Object)this)).getClass(), "Error in calling private method handleGetAttributes!", e);
            throw new SoftwareErrorException((Throwable)e);
        }
        catch (InvocationTargetException e) {
            Throwable targetException = e.getTargetException();
            if (targetException instanceof MoAccessException) {
                throw (MoAccessException)targetException;
            }
            logger.traceError(((Object)((Object)this)).getClass(), "Error in calling private method handleGetAttributes!", targetException);
            throw new SoftwareErrorException(targetException);
        }
        logger.traceReturn(THIS_CLASS, "getAttributesByReflection");
        return result;
    }
}

