/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.omf.mao.genericmo.xml;

import java.util.ArrayList;
import org.xml.sax.Attributes;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import se.ericsson.cello.maofro.framework.ArrayParameter;
import se.ericsson.cello.maofro.framework.IllegalParameterValueException;
import se.ericsson.cello.maofro.framework.Parameter;
import se.ericsson.cello.maofro.framework.SignedIntParameter;
import se.ericsson.cello.maofro.framework.StringParameter;
import se.ericsson.cello.maofro.framework.StructParameter;
import se.ericsson.cello.maofro.framework.UnsignedIntParameter;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.genericmo.xml.AbstractXmlHandler;
import se.ericsson.crbs.omf.mao.genericmo.xml.LongParameter;
import se.ericsson.crbs.omf.mao.genericmo.xml.MoRefParameter;

public class XmlHandlerImplR1A
extends AbstractXmlHandler
implements ErrorHandler {
    private static final Class THIS_CLASS = XmlHandlerImplR1A.class;
    private static final AbstractLogger logger = LoggingService.getLogger();

    public void startDocument() throws SAXException {
        String msg = "startDocument()";
        logger.traceEnter(THIS_CLASS, "startDocument()");
        this.attributeList = new ArrayList();
        logger.traceReturn(THIS_CLASS, "startDocument()");
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes attributes) throws SAXException {
        String msg = "startElement()";
        logger.traceEnter(THIS_CLASS, "startElement()");
        if ("attr".equals(qName)) {
            String attrName = attributes.getValue("name");
            String attrType = attributes.getValue("type");
            String attrData = attributes.getValue("value");
            if (attrType == null) {
                String errMsg = "Attribute type not found in attr tag: " + qName;
                logger.traceReturn(THIS_CLASS, errMsg);
                return;
            }
            String debMsg = "Attribute found, name=" + attrName + " type=" + attrType;
            logger.traceDebug(THIS_CLASS, debMsg);
            this.startExtractPrimitiveType(attrName, attrType, attrData);
        } else if ("struct".equals(qName)) {
            String attrName = attributes.getValue("name");
            this.attributeStack.push(new StructParameter(attrName == null ? "struct" : attrName));
        } else if ("array".equals(qName)) {
            String attrName = attributes.getValue("name");
            this.attributeStack.push(new ArrayParameter(attrName == null ? "array" : attrName));
        } else if ("moref".equals(qName)) {
            String attrName = attributes.getValue("name");
            this.attributeStack.push(new MoRefParameter(attrName == null ? "moref" : attrName));
        }
        logger.traceReturn(THIS_CLASS, "startElement()");
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        String msg = "endElement()";
        logger.traceEnter(THIS_CLASS, "endElement()");
        if ("attr".equals(qName) || "array".equals(qName) || "struct".equals(qName) || "moref".equals(qName)) {
            if (this.attributeStack.isEmpty()) {
                String errMsg = "Attribute stack is empty at end of element: " + qName;
                logger.traceReturn(THIS_CLASS, errMsg);
                return;
            }
            Object parameter = this.attributeStack.pop();
            if (this.attributeStack.isEmpty()) {
                this.attributeList.add(parameter);
                String genMsg = "Attribute " + ((Parameter)parameter).getName() + " added to attribute list.";
                logger.traceGeneral(THIS_CLASS, genMsg);
            } else {
                this.addCurrEltToCompositeParentElt(parameter);
            }
        }
        logger.traceReturn(THIS_CLASS, "endElement()");
    }

    public void error(SAXParseException saxparseexception) throws SAXException {
        logger.traceAbnormal(THIS_CLASS, saxparseexception.getMessage());
    }

    public void fatalError(SAXParseException saxparseexception) throws SAXException {
        logger.traceAbnormal(THIS_CLASS, saxparseexception.getMessage());
    }

    private void addCurrEltToCompositeParentElt(Object parameter) throws SAXException {
        Object parent = this.attributeStack.peek();
        if (parent instanceof StructParameter) {
            StructParameter structParameter = (StructParameter)parent;
            try {
                structParameter.add((Parameter)parameter);
            }
            catch (IllegalParameterValueException e) {
                throw new SAXException("Illegal Parameter Value. Original Exception message: " + e.getMessage());
            }
        } else if (parent instanceof ArrayParameter) {
            ArrayParameter arrayParameter = (ArrayParameter)parent;
            try {
                arrayParameter.add((Parameter)parameter);
            }
            catch (IllegalParameterValueException e) {
                throw new SAXException("Illegal Parameter Value. Original Exception message: " + e.getMessage());
            }
        } else if (parent instanceof MoRefParameter) {
            this.handleEndElementForMoRef(parameter, parent);
        }
    }

    private void handleEndElementForMoRef(Object parameter, Object parent) {
        MoRefParameter moRefParameter = (MoRefParameter)((Object)parent);
        String name = ((Parameter)parameter).getName();
        if ("ldn".equals(name)) {
            moRefParameter.setLdn(((StringParameter)parameter).getValue());
        } else if ("froType".equals(name)) {
            moRefParameter.setFroType(((SignedIntParameter)parameter).getValue());
        } else if ("froId".equals(name)) {
            moRefParameter.setFroId(((SignedIntParameter)parameter).getValue());
        }
    }

    private void startExtractPrimitiveType(String attrName, String attrType, String attrData) throws SAXException {
        if ("S32".equals(attrType)) {
            this.startExtractS32(attrName, attrData);
        } else if ("S64".equals(attrType)) {
            this.startExtractS64(attrName, attrData);
        } else if ("U32".equals(attrType)) {
            this.startExtractU32(attrName, attrData);
        } else if ("STRING".equals(attrType)) {
            this.startExtractString(attrName, attrData);
        }
    }

    private void startExtractS32(String attrName, String attrData) {
        this.attributeStack.push(new SignedIntParameter(attrName == null ? "s32" : attrName, Integer.parseInt(attrData)));
    }

    private void startExtractString(String attrName, String attrData) throws SAXException {
        try {
            this.attributeStack.push(new StringParameter(attrName == null ? "string" : attrName, attrData));
        }
        catch (IllegalParameterValueException e) {
            throw new SAXException("Illegal Parameter Value. Original Exception message: " + e.getMessage());
        }
    }

    private void startExtractS64(String attrName, String attrData) throws SAXException {
        this.attributeStack.push(new LongParameter(attrName == null ? "s64" : attrName, Long.parseLong(attrData)));
    }

    private void startExtractU32(String attrName, String attrData) throws SAXException {
        try {
            this.attributeStack.push(new UnsignedIntParameter(attrName == null ? "u32" : attrName, (long)Integer.parseInt(attrData)));
        }
        catch (NumberFormatException e) {
            throw new SAXException("Wrong number format. Original Exception message: " + e.getMessage());
        }
        catch (IllegalParameterValueException e) {
            throw new SAXException("Illegal Parameter Value. Original Exception message: " + e.getMessage());
        }
    }
}

