/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.omf.mao.indications;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.InactiveTransactionException;
import se.ericsson.cello.transaction.Resource;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.indications.wrappers.NotificationSenderWrapperFactory;

public class ResourceAVCWrapper
implements Resource {
    private static final Class THIS_CLASS = ResourceAVCWrapper.class;
    private static AbstractLogger logger = LoggingService.getLogger(ResourceAVCWrapper.class.getName());
    private static Map resourceAVCWrapperHashMap = Collections.synchronizedMap(new HashMap());
    private final ManagedObject mo;
    private final String key;
    private final List attrNames = new ArrayList();
    private final List attrValues = new ArrayList();
    private final Object mutexInstance = new Object();

    private ResourceAVCWrapper(ManagedObject inMo, Coordinator inCoordinator) {
        this.mo = inMo;
        this.key = ResourceAVCWrapper.key(inMo, inCoordinator);
        logger.traceGeneral(THIS_CLASS, "ResourceAVCWrapper() key: " + this.key);
        resourceAVCWrapperHashMap.put(this.key, this);
        try {
            inCoordinator.registerResource((Resource)this);
        }
        catch (InactiveTransactionException e) {
            logger.traceError(THIS_CLASS, "ResourceAVCWrapper(): could not register resource");
        }
    }

    private static String key(ManagedObject inMo, Coordinator inCoordinator) {
        return inMo.getLocalDistinguishedName() + "#" + ResourceAVCWrapper.transId(inCoordinator);
    }

    private static int transId(Coordinator inCoordinator) {
        return inCoordinator.getTransactionID();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ResourceAVCWrapper getInstance(ManagedObject inMo, Coordinator inCoordinator) {
        ResourceAVCWrapper wrapper;
        logger.traceEnter(THIS_CLASS, "getInstance()");
        String key = ResourceAVCWrapper.key(inMo, inCoordinator);
        logger.traceDebug(THIS_CLASS, "getInstance() key: " + key);
        Map map = resourceAVCWrapperHashMap;
        synchronized (map) {
            wrapper = resourceAVCWrapperHashMap.containsKey(key) ? (ResourceAVCWrapper)resourceAVCWrapperHashMap.get(key) : new ResourceAVCWrapper(inMo, inCoordinator);
        }
        logger.traceReturn(THIS_CLASS, "getInstance() key: " + key);
        return wrapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeAttribute(String inAttrName, Object inNewValue) {
        logger.traceEnter(THIS_CLASS, "storeAttribute() inAttrName:" + inAttrName + "inNewValue" + inNewValue);
        Object object = this.mutexInstance;
        synchronized (object) {
            this.attrNames.add(inAttrName);
            this.attrValues.add(inNewValue);
        }
        logger.traceReturn(THIS_CLASS, "storeAttribute()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() {
        logger.traceEnter(THIS_CLASS, "commit() key: " + this.key);
        Object object = this.mutexInstance;
        synchronized (object) {
            this.pushAvc();
        }
        resourceAVCWrapperHashMap.remove(this.key);
        logger.traceReturn(THIS_CLASS, "commit()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback() {
        logger.traceEnter(THIS_CLASS, "rollback() key: " + this.key);
        Object object = this.mutexInstance;
        synchronized (object) {
            resourceAVCWrapperHashMap.remove(this.key);
        }
        logger.traceReturn(THIS_CLASS, "rollback()");
    }

    private void pushAvc() {
        String[] attrNameArray = new String[this.attrNames.size()];
        Object[] attrValuesArray = new Object[this.attrValues.size()];
        attrNameArray = this.attrNames.toArray(attrNameArray);
        attrValuesArray = this.attrValues.toArray(attrValuesArray);
        for (int i = 0; i < attrNameArray.length; ++i) {
            logger.traceDebug(THIS_CLASS, " pushAvc() key " + this.key + " name: " + attrNameArray[i] + " value: " + attrValuesArray[i]);
        }
        NotificationSenderWrapperFactory.getNotificationSender().pushAvc(this.mo, attrNameArray, attrValuesArray);
    }

    public boolean prepare() {
        return true;
    }
}

