/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.supsys.omf.aue.step2.actions;

import java.util.ArrayList;
import java.util.StringTokenizer;
import se.ericsson.cello.aueframework.common.AueException;
import se.ericsson.cello.aueframework.converter.ConverterContext;
import se.ericsson.cello.aueframework.converter.MoDataAccessor;
import se.ericsson.cello.aueframework.converter.MoDataAction;
import se.ericsson.cello.aueframework.converter.MoDataWrapper;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.IntegerAttribute;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.omf.aue.common.CrbsAueException;
import se.ericsson.crbs.omf.aue.common.logging.AbstractLogger;
import se.ericsson.crbs.omf.aue.common.logging.LoggingService;
import se.ericsson.crbs.omf.aue.step2.actions.util.Step2Handler;

public class CreateExternalNodesAction
implements MoDataAction {
    private static final Class THIS_CLASS = CreateExternalNodesAction.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private static final String LDNS_OF_EXTERNAL_NODES_TO_CREATE_NAME_FROM_STEP_1 = "ldnsOfExternalNodesToCreate";

    public void perform(MoDataWrapper moDataWrapper, ConverterContext converterContext, Coordinator coordinator) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "perform()");
        String[] stringArray = this.getLdnsOfExternalNodesToCreateFromStep1(converterContext);
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i].trim();
            int n = this.getFroIdFromStep1(string, converterContext);
            this.createMo(converterContext, string, n, coordinator);
        }
        logger.traceReturn(THIS_CLASS, "perform()");
    }

    private String[] getLdnsOfExternalNodesToCreateFromStep1(ConverterContext converterContext) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "getLdnsOfExternalNodesToCreateFromStep1()");
        String[] stringArray = new String[]{};
        Step2Handler step2Handler = (Step2Handler)converterContext.getAttribute("CURRENT_STEP2_HANDLER");
        String string = step2Handler.retrieveFromAuePersistency("", LDNS_OF_EXTERNAL_NODES_TO_CREATE_NAME_FROM_STEP_1);
        if (string == null || string.length() == 0) {
            logger.traceDebug(THIS_CLASS, "No ExternalNodes to create.");
        } else {
            ArrayList<String> arrayList = new ArrayList<String>();
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            while (stringTokenizer.hasMoreTokens()) {
                arrayList.add(stringTokenizer.nextToken());
            }
            stringArray = arrayList.toArray(stringArray);
        }
        logger.traceReturn(THIS_CLASS, "getLdnsOfExternalNodesToCreateFromStep1()");
        return stringArray;
    }

    private int getFroIdFromStep1(String string, ConverterContext converterContext) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "getFroIdFromStep1()");
        int n = 0;
        Step2Handler step2Handler = (Step2Handler)converterContext.getAttribute("CURRENT_STEP2_HANDLER");
        String string2 = step2Handler.retrieveFromAuePersistency(string, "froId");
        if (string2 == null || string2.length() == 0) {
            throw new CrbsAueException("Can not find froId in AuePersistency database table for ldn=" + string);
        }
        try {
            n = Integer.parseInt(string2);
        }
        catch (Exception exception) {
            throw new CrbsAueException("Can not read froId from AuePersistency database table for ldn=" + string + " Exception=" + exception.toString(), (Throwable)exception);
        }
        logger.traceReturn(THIS_CLASS, "getFroIdFromStep1()");
        return n;
    }

    private void createMo(ConverterContext converterContext, String string, int n, Coordinator coordinator) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "createMo()");
        MoDataAccessor moDataAccessor = converterContext.getMoDataAccessor();
        try {
            MoDataWrapper moDataWrapper = moDataAccessor.create(string, coordinator);
            moDataWrapper.handleTransaction(coordinator, MoData.WRITE_ACCESS);
            this.addFroIdAttribute(moDataWrapper, n);
        }
        catch (AueException aueException) {
            CrbsAueException crbsAueException = new CrbsAueException(aueException.getMessage());
            crbsAueException.setStackTrace(aueException.getStackTrace());
            throw crbsAueException;
        }
        logger.traceReturn(THIS_CLASS, "createMo()");
    }

    private void addFroIdAttribute(MoDataWrapper moDataWrapper, int n) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "addFroIdAttribute()");
        IntegerAttribute integerAttribute = new IntegerAttribute("froId", false, n);
        moDataWrapper.registerPersistentAttr((Attribute)integerAttribute);
        logger.traceReturn(THIS_CLASS, "addFroIdAttribute()");
    }
}

