/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.emas.sm.applications;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.JTextField;
import se.ericsson.cello.emas.sm.applications.PutToFtpServerView;
import se.ericsson.cello.emas.sm.applications.ResultPrintoutHelper;
import se.ericsson.cello.support.gui.ErrorDialog;
import se.ericsson.cello.support.gui.gengui.InputVerifier;
import se.ericsson.cello.support.gui.guilib.comp.Log;
import se.ericsson.cello.support.gui.guilib.infra.AbstractApplicationController;
import se.ericsson.cello.support.mgr.cellomom.CVActionMainResult;
import se.ericsson.cello.support.mgr.cellomom.CVCurrentDetailedActivity;
import se.ericsson.cello.support.mgr.cellomom.CVCurrentMainActivity;
import se.ericsson.cello.support.proxy.CSException;
import se.ericsson.cello.support.proxy.MOProxy;
import se.ericsson.cello.support.proxy.NameValue;
import se.ericsson.cello.support.proxy.Struct;

public class PutToFtpServerController
extends AbstractApplicationController
implements ActionListener,
MOProxy.MOListener {
    private PutToFtpServerView view;
    private MOProxy cvMO;
    private boolean currentMainIdleReceived = false;
    private boolean putIsActive = false;

    protected void init() {
        Log.trace((String)"init()");
        this.view = (PutToFtpServerView)this.getView();
        String cvName = (String)this.getParameter("CV_NAME");
        String ldn = (String)this.getParameter("LDNLIST");
        this.cvMO = new MOProxy(ldn);
        try {
            this.cvMO = MOProxy.getRoot().getChildren(2, "ConfigurationVersion", "", null)[0];
            MOProxy meProxy = MOProxy.getRoot().getChildren(2, "ManagedElementData", "", null)[0];
        }
        catch (CSException e) {
            this.reportException((Exception)((Object)e), "ERROR_GET", null);
            Log.logError((String)"Error getting the ConfigurationVersion MO", (Throwable)e);
        }
        Object[] args = new Object[]{cvName, cvName};
        this.getApplication().setTitle("PUT_TO_FTP_SERVER", args);
        this.view.setInfoText(this.getString("PUT_TO_FTP_INFO_TEXT", args));
        this.view.setActionListener(this);
        this.cvMO.addMOListener((MOProxy.MOListener)this);
        this.view.cvFileNameField.setInputVerifier((InputVerifier)new CvFileNameFieldInputVerifier());
        this.view.userNameField.setInputVerifier((InputVerifier)new UserNameInputVerifier());
        this.view.cvFilePathField.setInputVerifier((InputVerifier)new CvFilePathFieldInputVerifier());
        this.view.cvFileNameField.setInputVerifier((InputVerifier)new CvFileNameFieldInputVerifier());
        this.view.setHelpTag("SOFTWAREMANAGER_PUTTOFTPSERVERVIEW_HELP");
    }

    public void actionPerformed(ActionEvent event) {
        String command = event.getActionCommand();
        if (command == "close button pressed") {
            this.viewClosing();
        } else if (command == "put to ftp button pressed") {
            this.putCv();
        } else if (command.equals("ENTRYFIELD_FILLEDIN")) {
            this.updatePutToFtpButtonState();
        }
    }

    private void updatePutToFtpButtonState() {
        this.view.setPutToFtpEnabled(this.view.checkMandatoryFields() && !this.view.cvFileNameField.faultyValueEntered());
        this.view.setDefaultButton(this.view.getPutToFtpButton());
    }

    private void putCv() {
        this.view.setProgressBarText("");
        try {
            NameValue[] params = new NameValue[]{new NameValue("param", (Object)((String)this.getParameter("CV_NAME"))), new NameValue("param", (Object)this.view.getPathOnFtpServer()), new NameValue("param", (Object)this.view.getCvBackupNameOnFtpServer()), new NameValue("param", (Object)this.view.getFtpFieldValue()), new NameValue("param", (Object)this.view.getUserNameFieldValue()), new NameValue("param", (Object)this.view.getPasswordFieldValue())};
            this.cvMO.action("putToFtpServer", params, null);
            this.putIsActive = true;
            this.view.startProgressBar();
            this.view.setPutStartedComponentsEnabled();
        }
        catch (CSException e) {
            this.reportException((Exception)((Object)e), "ERROR_ACTION", null);
            Log.logError((String)"Error during putCvToFtpServer action in ConfigurationVersion MO", (Throwable)e);
        }
    }

    public void childCreated(MOProxy childMO) {
    }

    public void childDeleted(MOProxy childMO) {
    }

    public void attributesChanged(MOProxy anMO, NameValue[] someAttributes) {
        Log.trace((String)"------  method attributesChanged in class PutToFtpServerController");
        if (this.putIsActive) {
            for (int i = 0; i < someAttributes.length; ++i) {
                if (someAttributes[i].name.equals("currentDetailedActivity") && CVCurrentDetailedActivity.get((Object)someAttributes[i].value) != CVCurrentDetailedActivity.IDLE) {
                    this.view.setProgressBarText(this.getString(CVCurrentDetailedActivity.get((Object)someAttributes[i].value).toString(), null));
                    continue;
                }
                if (!someAttributes[i].name.equals("currentMainActivity") || CVCurrentMainActivity.get((Object)someAttributes[i].value) != CVCurrentMainActivity.IDLE) continue;
                this.currentMainIdleReceived = true;
            }
            if (this.currentMainIdleReceived) {
                this.currentMainIdleReceived = false;
                this.putIsActive = false;
                this.view.stopProgressBar();
                this.view.setPutStoppedComponentEnabled();
                this.view.setPutToFtpEnabled(this.view.checkMandatoryFields() && !this.view.cvFileNameField.faultyValueEntered());
                String progresBarText = this.getString("PUTCV_PROGRESSBAR_DONE", null);
                try {
                    Struct cvActionResultData = (Struct)this.cvMO.getAttribute("actionResult");
                    Struct[] additionalActionResultData = (Struct[])this.cvMO.getAttribute("additionalActionResultData");
                    String result = ResultPrintoutHelper.processResult(this.view.getBundle());
                    NameValue cvActionMainResult = cvActionResultData.getNameValue("mainResult");
                    if (CVActionMainResult.get((Object)((Integer)cvActionMainResult.getValue())) == CVActionMainResult.EXECUTION_FAILED) {
                        this.view.setProgressBarText("");
                        ErrorDialog error = ErrorDialog.create((Component)((Object)this.view), (String)this.getString("PUT_EXECUTION_FAILED_MSG", null), (String)result, null, null, null, null);
                        error.setTitle(this.getString("PUT_EXECUTION_FAILED", null));
                        error.setLocationRelativeTo(null);
                        error.setModal(false);
                        error.show();
                    } else if (CVActionMainResult.get((Object)((Integer)cvActionMainResult.getValue())) == CVActionMainResult.EXECUTED_WITH_WARNINGS) {
                        this.view.setProgressBarText("");
                        ErrorDialog error = ErrorDialog.create((Component)((Object)this.view), (String)this.getString("PUT_EXECUTED_WITH_WARNINGS_MSG", null), (String)result, null, null, null, null);
                        error.setTitle(this.getString("PUT_EXECUTED_WITH_WARNINGS", null));
                        error.setLocationRelativeTo(null);
                        error.setModal(false);
                        error.show();
                    } else {
                        this.view.setProgressBarText(progresBarText);
                    }
                }
                catch (NoSuchFieldException e) {
                    this.reportException(e, "ERROR_ACTION", null);
                }
                catch (CSException e) {
                    this.reportException((Exception)((Object)e), "ERROR_ACTION", null);
                }
            }
        }
    }

    private void setTitle(String cvName) {
        this.getApplication().setTitle("CV_NAME", null);
    }

    protected void stop() {
        Log.trace((String)"stop");
        if (this.cvMO != null) {
            this.cvMO.removeMOListener((MOProxy.MOListener)this);
        }
    }

    protected void afterVisible() {
        this.view.setFocus();
    }

    protected void beforeVisible() {
        this.view.setToolTips();
    }

    protected void viewClosing() {
        this.getApplicationManager().exitApplicationEMTApp();
    }

    private static class CvFilePathFieldInputVerifier
    extends InputVerifier {
        private CvFilePathFieldInputVerifier() {
        }
    }

    private static class UserNameInputVerifier
    extends InputVerifier {
        private UserNameInputVerifier() {
        }
    }

    private static class CvFileNameFieldInputVerifier
    extends InputVerifier {
        private CvFileNameFieldInputVerifier() {
        }

        public boolean verify(JComponent input) {
            JTextField field = (JTextField)input;
            String value = field.getText();
            return value.length() <= 251;
        }
    }
}

