/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.emas.sm.applications;

import BasicConfig.Session;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import se.ericsson.cello.emas.sm.applications.ExecutionFailedException;
import se.ericsson.cello.emas.sm.applications.HardSoftSelection;
import se.ericsson.cello.emas.sm.applications.UpgradePackagePiuTypeController;
import se.ericsson.cello.emas.sm.applications.UpgradePackagePiuTypeView;
import se.ericsson.cello.emas.sm.applications.UpgradePackageView;
import se.ericsson.cello.emas.sm.applications.VerificationActionException;
import se.ericsson.cello.support.gui.EmasProgressMonitor;
import se.ericsson.cello.support.gui.guilib.comp.IconHelper;
import se.ericsson.cello.support.gui.guilib.comp.Log;
import se.ericsson.cello.support.gui.guilib.infra.AbstractApplication;
import se.ericsson.cello.support.gui.guilib.infra.AbstractApplicationController;
import se.ericsson.cello.support.gui.guilib.infra.AbstractController;
import se.ericsson.cello.support.gui.guilib.infra.ApplicationManager;
import se.ericsson.cello.support.mgr.AttributeBuffer;
import se.ericsson.cello.support.mgr.TimeConverter;
import se.ericsson.cello.support.mgr.cellomom.Information;
import se.ericsson.cello.support.mgr.cellomom.InvokedAction;
import se.ericsson.cello.support.mgr.cellomom.SupportedUpgradeTypesStatusData;
import se.ericsson.cello.support.mgr.cellomom.UpgradePackageState;
import se.ericsson.cello.support.mgr.cellomom.UpgradeProgressInformation;
import se.ericsson.cello.support.proxy.CSException;
import se.ericsson.cello.support.proxy.MOProxy;
import se.ericsson.cello.support.proxy.NameValue;
import se.ericsson.cello.support.proxy.Struct;
import se.ericsson.cello.support.proxy.Transaction;

public class UpgradePackageController
extends AbstractApplicationController
implements ActionListener,
MOProxy.MOListener {
    private UpgradePackageView view;
    private MOProxy upgradePackageMo;
    private boolean isCreateNewUpgradePackage;
    private AttributeBuffer attributeCache;
    private boolean initHadError = false;
    private String initErrorMessageKey;
    private Object[] initErrorMessageArgs;
    private Exception initErrorException;
    private static final NameValue[] NO_ARGS = new NameValue[0];
    private static final int TRANSACTION_TIMEOUT = 600000;
    private static final String[] upgradePackageMoAttributes = new String[]{"cppUpVersion", "upCompatibilityIndex", "administrativeData", "confirmationDeadline", "ftpServerIpAddress", "progressCount", "progressHeader", "progressTotal", "state", "upFilePathOnFtpServer", "isDeletable", "userLabel", "guiName", "upgradeControlFilePath", "user", "password"};
    private NameValue[] s = new NameValue[]{new NameValue("rebootNodeUpgrade", (Object)SupportedUpgradeTypesStatusData.REBOOTNODEUPGRADE_DEFAULT), new NameValue("update", (Object)SupportedUpgradeTypesStatusData.UPDATE_DEFAULT), new NameValue("upgrade", (Object)SupportedUpgradeTypesStatusData.UPGRADE_DEFAULT)};
    private Struct supportedUpgradeTypesStatus = new Struct(this.s);
    private boolean active = false;
    boolean isApplicationRunning;
    private boolean upgradeButtonPressed = false;
    private boolean updateButtonPressed = false;
    private boolean installButtonPressed = false;
    private boolean installPiuButtonPressed = false;
    private boolean verifyButtonPressed = false;
    private boolean cancelInstallButtonPressed = false;
    private boolean cancelUpgradeButtonPressed = false;
    private boolean deleting = false;
    private MOProxy cvMO;
    private String progressBarTitle;
    private String progressBarMessage;
    private String createProgressBarTitle;
    private String createProgressBarMessage;
    private Integer lastActionIdentity = null;
    private UpgradePackageState upState = null;
    private Vector<String> itemListActionResult = new Vector();
    private String nameOfActionInText = null;
    private String infoText = null;
    private String additionalText = null;
    private String timeText = null;
    private String actionId_text = null;
    private int MAX_LENGTH = 120;
    private boolean generate_LDN_basedOnXmlFileName = true;
    private MOProxy swManagementMO;
    private boolean rebootNodeUpgradeAllowed = false;
    private boolean updateAllowed = false;
    private boolean upgradeAllowed = false;
    private String messageUpgrade = "";
    private String defaultButtonForUpgrade = "";
    private boolean cancelAllowed = true;
    private int WAIT_TIME = 5000;
    static final String UP_DELETED_NOTIFICATION = "se.ericsson.cello.emas.sm.UP_DELETED";
    static final String UP_CREATED_NOTIFICATION = "se.ericsson.cello.emas.sm.UP_CREATED";

    public void init() {
        Log.trace((String)"init()");
        this.view = (UpgradePackageView)this.getView();
        this.view.setActionListener(this);
        this.setTitle();
        try {
            this.cvMO = MOProxy.getRoot().getChildren(2, "ConfigurationVersion", "", null)[0];
        }
        catch (CSException e) {
            this.reportException((Exception)((Object)e), "ERROR_GET", null);
            Log.logError((String)"Error getting the ConfigurationVersion MO", (Throwable)e);
        }
        if (this.processApplicationParameters()) {
            this.view.setCreateEnabled(false);
            this.view.setInstallEnabled(false);
            this.view.setInstallPiuEnabled(false);
            this.view.setCancelInstallEnabled(false);
            this.view.setDeleteEnabled(false);
            this.view.setVerifyEnabled(false);
            this.view.setUpgradeEnabled(false);
            this.view.setConfirmEnabled(false);
            this.view.setCancelUpgradeEnabled(false);
            this.view.setUpdateEnabled(false);
            this.setResultActionDataList(true);
            this.setLoadModuleList();
            this.setBasedOnUpgradePackageList();
            this.view.setCloseEnabled(true);
            this.view.setApplyVisible(!this.isCreateNewUpgradePackage);
            this.view.setProgressBarEnabled(!this.isCreateNewUpgradePackage);
            this.view.setAdministrativeData_productInfo(" " + this.getString("UP_PRODUCT_INFORMATION_LABEL", null));
            this.view.setCppUpVersion_productInfo(" " + this.getString("UP_PRODUCT_INFORMATION_LABEL", null));
            if (!this.isCreateNewUpgradePackage) {
                this.updateSupportedUpgradeTypes();
                this.readAndShowMoAttributes(false);
                this.view.setApplyEnabled(false);
                this.upgradePackageMo.addMOListener((MOProxy.MOListener)this);
                this.cvMO.addMOListener((MOProxy.MOListener)this);
            }
        }
        ((JList)this.view.actionResultList.getFieldComponent()).addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.isControlDown() && e.getKeyCode() == 67) {
                    UpgradePackageController.this.copyToClipBoard((JList)((UpgradePackageController)UpgradePackageController.this).view.actionResultList.getFieldComponent());
                }
            }
        });
        ((JList)this.view.loadModuleList.getFieldComponent()).addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.isControlDown() && e.getKeyCode() == 67) {
                    UpgradePackageController.this.copyToClipBoard((JList)((UpgradePackageController)UpgradePackageController.this).view.loadModuleList.getFieldComponent());
                }
            }
        });
        ((JList)this.view.basedOnUpgradePackageList.getFieldComponent()).addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.isControlDown() && e.getKeyCode() == 67) {
                    UpgradePackageController.this.copyToClipBoard((JList)((UpgradePackageController)UpgradePackageController.this).view.basedOnUpgradePackageList.getFieldComponent());
                }
            }
        });
    }

    private void copyToClipBoard(JList aList) {
        StringBuffer strBuf = new StringBuffer();
        try {
            Object[] objects = aList.getSelectedValues();
            for (int i = 0; i < objects.length; ++i) {
                strBuf.append((String)objects[i]);
                strBuf.append("\n");
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        Clipboard cb = Toolkit.getDefaultToolkit().getSystemClipboard();
        StringSelection ss = new StringSelection(strBuf.toString());
        cb.setContents(ss, null);
    }

    protected void afterVisible() {
        if (this.initHadError) {
            if (this.initErrorException != null) {
                this.reportException(this.initErrorException, this.initErrorMessageKey, this.initErrorMessageArgs);
            } else {
                this.showMessageDialog(this.initErrorMessageKey, this.initErrorMessageArgs, "GSL_ERROR", null, 0, null);
            }
            this.getApplication().stopApplication();
        }
        this.isApplicationRunning = true;
    }

    protected void beforeVisible() {
        this.view.setDefaultButton(this.view.getCreateButton());
        this.view.setToolTipsOnLabels();
    }

    protected boolean canStop() {
        return true;
    }

    protected void stop() {
        Log.trace((String)"stop");
        if (this.upgradePackageMo != null) {
            this.upgradePackageMo.removeMOListener((MOProxy.MOListener)this);
        }
        if (this.cvMO != null) {
            this.cvMO.removeMOListener((MOProxy.MOListener)this);
        }
    }

    public void actionPerformed(ActionEvent event) {
        String command = event.getActionCommand();
        Log.trace((String)("actionPerformed: actionCommand = " + command));
        if (command.equals("ENTRYFIELD_FILLEDIN")) {
            this.view.setApplyEnabled(this.checkInputFields());
        } else if (command == "APPLY button pressed") {
            this.view.setApplyEnabled(false);
            this.writeMoAttributes();
        } else if (command == "create button pressed") {
            this.createProgressBarTitle = this.getString("CREATE_PROGRESS_BAR_TITLE_UP", null);
            this.createProgressBarMessage = this.getString("CREATE_PROGRESS_BAR_MESSAGE_UP", null);
            new CreateThread().start();
            this.view.setApplyVisible(true);
            this.view.setApplyEnabled(false);
        } else if (command == "install button pressed") {
            HardSoftSelection selection = this.userSelectsHardSoftCancel("UP_INSTALL_CONFIRM_TITLE", "UP_INSTALL_CONFIRM_MSG", "UP_SOFT_INSTALL", "UP_HARD_INSTALL");
            if (selection != HardSoftSelection.CANCEL) {
                this.view.actionResultList.setVisible(false);
                this.installButtonPressed = true;
                this.installUpgradePackage(selection);
            }
        } else if (command == "install piutype button pressed") {
            String upLdn = (String)this.getParameter("LDNLIST");
            Object[][] parameters = new Object[][]{{"LDNLIST", upLdn}};
            this.startDialog(false, "PIUTYPE_INSTALL_TITLE", null, UpgradePackagePiuTypeView.class, UpgradePackagePiuTypeController.class, parameters);
        } else if (command == "Close button pressed") {
            this.viewClosing();
        } else if (command == "cancel-install button pressed") {
            Object[] buttonTitles = new Object[]{this.getString("UP_INSTALL_CANCEL_CONFIRM_YES", null), this.getString("UP_INSTALL_CANCEL_CONFIRM_NO", null)};
            if (this.userConfirmsAction("UP_INSTALL_CANCEL_TITLE", "UP_INSTALL_CANCEL_MSG", buttonTitles)) {
                this.cancelInstallButtonPressed = true;
                this.view.actionResultList.setVisible(false);
                this.cancelInstall();
                this.readAndShowMoAttributes(false);
            }
        } else if (command == "delete button pressed") {
            this.deleteUp();
        } else if (command == "verify button pressed") {
            this.view.setVerifyEnabled(false);
            this.view.setDeleteEnabled(false);
            this.view.setApplyEnabled(false);
            this.verifyButtonPressed = true;
            this.setButtonStatus();
            this.view.actionResultList.setVisible(false);
            this.verifyUpgrade();
        } else if (command == "refresh button pressed") {
            this.view.setApplyEnabled(false);
            this.refreshAll();
        } else if (command == "upgrade button pressed") {
            this.upgrade();
        } else if (command == "confirm button pressed") {
            if (this.userConfirmsAction("UP_CONFIRM_CONFIRM_TITLE", "UP_CONFIRM_CONFIRM_MSG")) {
                this.confirmUpgradePackage();
                this.readAndShowMoAttributes(false);
            }
        } else if (command == "cancel-upgrade button pressed") {
            if (this.userConfirmsAction("UP_UPGRADE_CANCEL_TITLE", "UP_UPGRADE_CANCEL_MSG") && !this.cancelUpgradeButtonPressed) {
                this.cancelUpgradeButtonPressed = true;
                this.view.setConfirmEnabled(false);
                Runnable readRunner = new Runnable(){

                    public void run() {
                        UpgradePackageController.this.cancelUpgrade();
                        UpgradePackageController.this.readAndShowMoAttributes(true);
                    }
                };
                new Thread(readRunner).start();
            }
        } else if (command == "update button pressed" && this.userConfirmsAction("UP_UPDATE_CONFIRM_TITLE", "UP_UPDATE_CONFIRM_MSG")) {
            this.updateButtonPressed = true;
            this.updateNode();
        }
        this.setButtonStatus();
        this.setEntryFieldStatus();
    }

    protected void viewClosing() {
        this.getApplicationManager().exitApplicationEMTApp();
    }

    private void upgrade() {
        int value;
        Object[] buttons = this.getButtonsForUpgrade();
        if (buttons != null && (value = JOptionPane.showOptionDialog(null, this.messageUpgrade, this.getString("UP_UPGRADE_CONFIRM_TITLE", null), 0, 3, null, buttons, this.defaultButtonForUpgrade)) != -1) {
            HardSoftSelection selection = buttons.length == 3 ? HardSoftSelection.get(value) : (value == 0 ? (this.rebootNodeUpgradeAllowed ? HardSoftSelection.HARD : HardSoftSelection.SOFT) : HardSoftSelection.CANCEL);
            if (selection != HardSoftSelection.CANCEL) {
                this.view.actionResultList.setVisible(false);
                this.view.setApplyEnabled(false);
                this.upgradeButtonPressed = true;
                this.cancelUpgradeButtonPressed = false;
                this.setButtonStatus();
                this.upgradeNodeWithUpgradePackage(selection);
            }
        }
    }

    private void deleteUp() {
        if (this.userConfirmsAction("UP_DELETE_CONFIRM_TITLE", "UP_DELETE_CONFIRM_MSG")) {
            this.progressBarTitle = this.getString("PROGRESS_BAR_TITLE_UP", null);
            this.progressBarMessage = this.getString("PROGRESS_BAR_MESSAGE_UP", null);
            boolean isDeletable = false;
            try {
                isDeletable = (Boolean)this.upgradePackageMo.getAttribute("isDeletable", null);
            }
            catch (CSException e) {
                Log.logError((String)"Error getting attribute. ", (Throwable)e);
            }
            if (isDeletable) {
                new DeleteThread().start();
            } else {
                this.showNotDeletableMessage();
            }
        }
    }

    public void createUpgradePackage() {
        this.view.setProgressBarEnabled(true);
        Transaction createTransaction = null;
        try {
            if (this.upgradePackageMo == null) {
                createTransaction = new Transaction(600000);
                this.createUpgradePackage(createTransaction);
                createTransaction.commit();
                createTransaction.end();
                this.isCreateNewUpgradePackage = false;
                this.readAndShowMoAttributes(false);
                String notificationType = UP_CREATED_NOTIFICATION;
                String notificationLdn = this.upgradePackageMo.getDN();
                Log.logNotify((String)("Performing sendEmNotification('Add') " + notificationLdn));
                this.sendNotification(notificationType, notificationLdn);
            }
        }
        catch (CSException e) {
            this.isCreateNewUpgradePackage = false;
            this.reportException((Exception)((Object)e), "UP_CREATE_ERROR_MSG", null);
            this.finishFailedTransaction(createTransaction, "Creation of UpgradePackageMO" + this.upgradePackageMo.getDN() + " failed", (Exception)((Object)e));
            this.view.setProgressBarEnabled(false);
            this.isCreateNewUpgradePackage = true;
            this.upgradePackageMo = null;
            return;
        }
    }

    private void sendNotification(String notificationType, Object moLdns) {
        AbstractApplication abstractApplication = this.view.getApplication();
        ApplicationManager applicationManager = abstractApplication.getApplicationManager();
        UpgradePackageController source = this;
        applicationManager.sendNotification(notificationType, (Object)source, moLdns);
    }

    public void installUpgradePackage(HardSoftSelection typeSelection) {
        if (typeSelection == HardSoftSelection.CANCEL) {
            return;
        }
        try {
            this.view.setInstallEnabled(false);
            this.view.setCancelInstallEnabled(true);
            this.view.setDeleteEnabled(false);
            this.view.setCancelUpgradeEnabled(false);
            this.view.setConfirmEnabled(false);
            this.view.setApplyEnabled(false);
            this.lastActionIdentity = typeSelection == HardSoftSelection.HARD ? (Integer)this.upgradePackageMo.action("nonBlockingForcedInstall", NO_ARGS, null) : (Integer)this.upgradePackageMo.action("nonBlockingInstall", NO_ARGS, null);
        }
        catch (CSException e) {
            this.reportException((Exception)((Object)e), "UP_INSTALL_ERROR_MSG", null);
            this.finishFailedTransaction(null, "Installation of UpgradePackageMO" + this.upgradePackageMo.getDN() + " failed", (Exception)((Object)e));
            this.readAndShowMoAttributes(false);
        }
    }

    public void createUpgradePackage(Transaction createMoTransaction) throws CSException {
        String userLabel;
        this.swManagementMO = MOProxy.getRoot().getChildren(1, "SwManagement", "")[0];
        String upgradePackageLDN = MOProxy.genLDN((String)this.swManagementMO.getDN(), (String)"UpgradePackage");
        if (this.generate_LDN_basedOnXmlFileName) {
            upgradePackageLDN = this.generateLdnBasedOnXmlFileName(upgradePackageLDN, this.view.getUpFilePath().trim());
        }
        Log.trace((String)("LDN of new UpgradePackageMO=" + upgradePackageLDN));
        this.upgradePackageMo = new MOProxy(upgradePackageLDN);
        ArrayList<NameValue> creationArgs = new ArrayList<NameValue>(5);
        creationArgs.add(new NameValue("upFilePathOnFtpServer", (Object)this.view.getUpFilePath().trim()));
        creationArgs.add(new NameValue("ftpServerIpAddress", (Object)this.view.getFtpServer()));
        if (this.view.getPassword() != null && this.view.getPassword() != "") {
            creationArgs.add(new NameValue("password", (Object)this.view.getPassword()));
        }
        if (this.view.getUsername() != null && this.view.getUsername() != "") {
            creationArgs.add(new NameValue("user", (Object)this.view.getUsername()));
        }
        if ((userLabel = this.view.getUserLabel()) != null) {
            creationArgs.add(new NameValue("userLabel", (Object)userLabel));
        }
        NameValue[] createArgsArray = creationArgs.toArray(new NameValue[creationArgs.size()]);
        this.upgradePackageMo.create(createArgsArray, createMoTransaction.session);
        this.readMoAttributes(false, createMoTransaction);
        Log.trace((String)"UpgradePackage created");
        this.upgradePackageMo.addMOListener((MOProxy.MOListener)this);
        this.cvMO.addMOListener((MOProxy.MOListener)this);
    }

    private void verifyUpgrade() {
        try {
            this.lastActionIdentity = (Integer)this.upgradePackageMo.action("verifyUpgrade", NO_ARGS, null);
        }
        catch (CSException e) {
            this.reportException((Exception)((Object)e), "UP_VERIFYUPGRADE_ERROR_MSG", null);
            this.finishFailedTransaction(null, "Verify Upgrade failed on " + this.upgradePackageMo.getDN(), (Exception)((Object)e));
        }
    }

    public void upgradeNodeWithUpgradePackage(HardSoftSelection typeSelection) {
        if (typeSelection == HardSoftSelection.CANCEL) {
            return;
        }
        try {
            String upgradeAction = typeSelection == HardSoftSelection.HARD ? "rebootNodeUpgrade" : "upgrade";
            this.view.setCancelUpgradeEnabled(true);
            this.lastActionIdentity = (Integer)this.upgradePackageMo.action(upgradeAction, NO_ARGS, null);
        }
        catch (CSException e) {
            this.reportException((Exception)((Object)e), "UP_UPGRADE_ERROR_MSG", null);
            this.finishFailedTransaction(null, "Upgrade failed on " + this.upgradePackageMo.getDN(), (Exception)((Object)e));
            return;
        }
    }

    public void updateNode() {
        try {
            this.lastActionIdentity = (Integer)this.upgradePackageMo.action("update", NO_ARGS, null);
        }
        catch (CSException e) {
            Log.logError((String)"Error executing the update action", (Throwable)e);
            this.reportException((Exception)((Object)e), "", null);
        }
    }

    public void confirmUpgradePackage() {
        try {
            this.upgradePackageMo.action("confirmUpgrade", NO_ARGS, null);
        }
        catch (CSException e) {
            this.reportException((Exception)((Object)e), "UP_CONFIRM_ERROR_MSG", null);
            this.finishFailedTransaction(null, "Confirming upgrade package failed on" + this.upgradePackageMo.getDN(), (Exception)((Object)e));
        }
    }

    public void cancelUpgrade() {
        Transaction cancelTransaction = null;
        try {
            cancelTransaction = new Transaction(600000);
            this.upgradePackageMo.action("cancelUpgrade", NO_ARGS, cancelTransaction.session);
            cancelTransaction.commit();
            cancelTransaction.end();
            this.showMessageDialog("UP_UPGRADE_CANCELED_MSG", null, "UP_UPGRADE_CANCELED_TITLE", null, 1, null);
        }
        catch (CSException e) {
            this.reportException((Exception)((Object)e), "UP_CANCEL_ERROR_MSG", null);
            this.finishFailedTransaction(cancelTransaction, "Canceling an upgrade failed on " + this.upgradePackageMo.getDN(), (Exception)((Object)e));
        }
    }

    private void cancelInstall() {
        Transaction cancelTransaction = null;
        try {
            cancelTransaction = new Transaction(600000);
            this.lastActionIdentity = (Integer)this.upgradePackageMo.action("cancelInstall", NO_ARGS, cancelTransaction.session);
            cancelTransaction.commit();
            cancelTransaction.end();
            this.showMessageDialog("UP_INSTALL_CANCELED_MSG", null, "UP_INSTALL_CANCELED_TITLE", null, 1, null);
        }
        catch (CSException e) {
            this.reportException((Exception)((Object)e), "UP_CANCEL_ERROR_MSG", null);
            this.finishFailedTransaction(cancelTransaction, "Canceling an upgrade failed on " + this.upgradePackageMo.getDN(), (Exception)((Object)e));
        }
    }

    public void discardUpgradePackage() {
        Transaction discardTransaction = null;
        try {
            discardTransaction = new Transaction(600000);
            this.upgradePackageMo.action("cancelUpgrade", NO_ARGS, discardTransaction.session);
            discardTransaction.commit();
            discardTransaction.end();
        }
        catch (CSException e) {
            this.reportException((Exception)((Object)e), "UP_DISCARD_ERROR_MSG", null);
            this.finishFailedTransaction(discardTransaction, "Discarding an upgrade failed on " + this.upgradePackageMo.getDN(), (Exception)((Object)e));
        }
    }

    public String gettingNames(String tag) {
        return this.getString(tag, null);
    }

    public void attributesChanged(MOProxy anMO, NameValue[] someAttributes) {
        for (int i = 0; i < someAttributes.length; ++i) {
            this.attributeCache.setAttribute(someAttributes[i].name, someAttributes[i].value);
            if (someAttributes[i].name.equals("progressHeader")) {
                UpgradeProgressInformation progressInfo = UpgradeProgressInformation.get((Object)someAttributes[i].value);
                if (progressInfo == UpgradeProgressInformation.EXECUTION_FAILED) {
                    this.reportException(new ExecutionFailedException(), "UP_INSTALL_OR_UPGRADE_ERROR_MSG", null);
                    this.view.getProgressModel().setValue(0);
                    this.upgradeButtonPressed = false;
                    this.updateButtonPressed = false;
                    this.installButtonPressed = false;
                    this.installPiuButtonPressed = false;
                    this.verifyButtonPressed = false;
                } else if (progressInfo == UpgradeProgressInformation.VERIFICATION_FAILED) {
                    this.reportException(new VerificationActionException(), "UP_VERIFY_ERROR_MSG", null);
                    this.view.getProgressModel().setValue(0);
                    this.upgradeButtonPressed = false;
                    this.updateButtonPressed = false;
                    this.installButtonPressed = false;
                    this.installPiuButtonPressed = false;
                    this.verifyButtonPressed = false;
                    this.cancelAllowed = false;
                }
                if (progressInfo != UpgradeProgressInformation.IDLE) continue;
                this.upgradeButtonPressed = false;
                this.updateButtonPressed = false;
                this.installButtonPressed = false;
                this.installPiuButtonPressed = false;
                this.verifyButtonPressed = false;
                this.cancelAllowed = false;
                this.updateSupportedUpgradeTypes();
                this.readAndShowMoAttributes(false);
                continue;
            }
            if (someAttributes[i].name.equals("state")) {
                UpgradePackageState info = UpgradePackageState.get((Object)someAttributes[i].value);
                if (info != UpgradePackageState.INSTALL_EXECUTING) continue;
                this.upgradeButtonPressed = false;
                this.updateButtonPressed = false;
                this.installButtonPressed = false;
                this.installPiuButtonPressed = false;
                this.verifyButtonPressed = false;
                this.cancelAllowed = true;
                this.readAndShowMoAttributes(false);
                this.view.setProgressBarEnabled(true);
                continue;
            }
            if (someAttributes[i].name.equals("actionResult")) {
                this.setResultActionDataList(true);
                continue;
            }
            if (!someAttributes[i].name.equals("currentUpgradePackage")) continue;
            this.active = false;
            if (!someAttributes[i].value.equals(this.upgradePackageMo)) continue;
            this.active = true;
        }
        this.showMoAttributes();
    }

    public void childCreated(MOProxy childMO) {
    }

    public void childDeleted(MOProxy childMO) {
    }

    protected boolean processApplicationParameters() {
        Log.trace((String)"processApplicationParameters()");
        String ldn = (String)this.getParameter("LDNLIST");
        if (ldn == null || ldn.equals("")) {
            this.isCreateNewUpgradePackage = true;
        } else {
            this.isCreateNewUpgradePackage = false;
            MOProxy mo = new MOProxy(ldn);
            try {
                if (mo != null && mo.isExisting() && mo.getType().equals("SwManagement")) {
                    this.isCreateNewUpgradePackage = true;
                } else if (mo != null && mo.isExisting() && mo.getType().equals("UpgradePackage")) {
                    this.upgradePackageMo = mo;
                    this.isCreateNewUpgradePackage = false;
                } else {
                    this.initHadError = true;
                    this.initErrorMessageKey = "ERROR_ILLEGAL_MO_IN_LDNLIST";
                    this.initErrorMessageArgs = new Object[]{ldn};
                }
            }
            catch (Exception e) {
                Log.logError((String)"Error checking existance of MO", (Throwable)e);
                this.initHadError = true;
                this.initErrorMessageKey = "ERROR_MO_DOES_NOT_EXIST";
                this.initErrorMessageArgs = new Object[]{ldn};
                this.initErrorException = e;
            }
        }
        Log.trace((String)(this.isCreateNewUpgradePackage ? "Application set to create new UpgradePackage" : "Application set to display existing UpgradePackage"));
        return !this.initHadError;
    }

    protected boolean readMoAttributes(boolean infinite, Transaction readTransaction) {
        Log.trace((String)"readMoAttributes()");
        if (this.upgradePackageMo == null) {
            return false;
        }
        Session txSession = readTransaction != null ? readTransaction.session : null;
        MOProxy currentUpgradePackage = null;
        while (true) {
            try {
                Object[] moValues = null;
                moValues = this.upgradePackageMo.getAttributes(upgradePackageMoAttributes, txSession);
                currentUpgradePackage = (MOProxy)this.cvMO.getAttribute("currentUpgradePackage", txSession);
                this.attributeCache = null;
                this.attributeCache = new AttributeBuffer();
                for (int nVal = 0; nVal < moValues.length; ++nVal) {
                    if (moValues[nVal] == null) continue;
                    this.attributeCache.put((Object)upgradePackageMoAttributes[nVal], moValues[nVal]);
                }
                this.active = false;
                if (!currentUpgradePackage.equals((Object)this.upgradePackageMo)) break;
                this.active = true;
            }
            catch (CSException e) {
                if (infinite) {
                    try {
                        Thread.sleep(this.WAIT_TIME);
                    }
                    catch (Exception ex) {}
                    continue;
                }
                if (this.isApplicationRunning) {
                    this.reportException((Exception)((Object)e), "ERROR_GET", null);
                } else {
                    this.initHadError = true;
                    this.initErrorMessageKey = "ERROR_READING_MO_ATTRIBUTE";
                    this.initErrorMessageArgs = new Object[]{this.upgradePackageMo.getDN()};
                    this.initErrorException = e;
                }
                return false;
            }
            break;
        }
        return true;
    }

    protected void showMoAttributes() {
        Log.trace((String)"showMoAttributes()");
        if (this.attributeCache == null) {
            throw new IllegalStateException("attributeCache==null");
        }
        try {
            this.view.ldn.setValue(this.upgradePackageMo.getDN());
            this.view.ldn.setVisible(true);
            Struct adminData = (Struct)this.attributeCache.get((Object)"administrativeData");
            Integer stateInteger = (Integer)this.attributeCache.get((Object)"state");
            this.upState = UpgradePackageState.get((Object)stateInteger);
            this.view.setUserLabel((String)this.attributeCache.get((Object)"userLabel"));
            String administrativeData_productName = (String)adminData.getElementValue("productName");
            this.view.setAdministrativeData_productName(administrativeData_productName);
            String administrativeData_productRevision = (String)adminData.getElementValue("productRevision");
            this.view.setAdministrativeData_productRevision(administrativeData_productRevision);
            String administrativeData_productNumber = (String)adminData.getElementValue("productNumber");
            this.view.setAdministrativeData_productNumber(administrativeData_productNumber);
            String administrativeData_productionDate = (String)adminData.getElementValue("productionDate");
            this.view.setAdministrativeData_productionDate(new TimeConverter().formatTime(administrativeData_productionDate));
            String administrativeData_productInfo = (String)adminData.getElementValue("productInfo");
            this.view.setAdministrativeData_productInfo(" " + this.getString("UP_PRODUCT_INFORMATION_LABEL", null) + " " + administrativeData_productInfo);
            Struct cppUpVersionData = (Struct)this.attributeCache.getAttribute("cppUpVersion");
            String cppUpVersion_productName = (String)cppUpVersionData.getElementValue("productName");
            this.view.setCppUpVersion_productName(cppUpVersion_productName);
            String cppUpVersion_productRevision = (String)cppUpVersionData.getElementValue("productRevision");
            this.view.setCppUpVersion_productRevision(cppUpVersion_productRevision);
            String cppUpVersion_productNumber = (String)cppUpVersionData.getElementValue("productNumber");
            this.view.setCppUpVersion_productNumber(cppUpVersion_productNumber);
            String cppUpVersion_productionDate = (String)cppUpVersionData.getElementValue("productionDate");
            this.view.setCppUpVersion_productionDate(new TimeConverter().formatTime(cppUpVersion_productionDate));
            String cppUpVersion_productInfo = (String)cppUpVersionData.getElementValue("productInfo");
            this.view.setCppUpVersion_productInfo(" " + this.getString("UP_PRODUCT_INFORMATION_LABEL", null) + " " + cppUpVersion_productInfo);
            this.view.setUpState(UpgradePackageState.get((Object)stateInteger));
            this.view.setUpActive(this.active);
            String upfilePathString = (String)this.attributeCache.get((Object)"upFilePathOnFtpServer");
            this.view.setUpFilePath(upfilePathString);
            if (upfilePathString.length() <= 50) {
                this.view.upFilePathField.setToolTip(upfilePathString);
            } else {
                boolean bContinue = true;
                String sTemp = upfilePathString.substring(50);
                String sMultiLinePath = "<html>" + upfilePathString.substring(0, 50);
                while (bContinue) {
                    if (sTemp.length() <= 50) {
                        bContinue = false;
                        sMultiLinePath = sMultiLinePath + "<br>" + sTemp + "</html>";
                        continue;
                    }
                    sMultiLinePath = sMultiLinePath + "<br>" + sTemp.substring(0, 50);
                    sTemp = sTemp.substring(50);
                }
                this.view.upFilePathField.setToolTip(sMultiLinePath);
            }
            if (this.upState != UpgradePackageState.ONLY_DELETEABLE) {
                this.view.setFtpServer((String)this.attributeCache.get((Object)"ftpServerIpAddress"));
                String ConfDeadLinedate = (String)this.attributeCache.get((Object)"confirmationDeadline");
                this.view.setConfirmationDeadline(new TimeConverter().formatTime(ConfDeadLinedate));
            }
            this.view.upCompatibilityIndex.setValue((String)this.attributeCache.getAttribute("upCompatibilityIndex"));
            this.view.setUser((String)this.attributeCache.getAttribute("user"));
            this.view.setPassword((String)this.attributeCache.getAttribute("password"));
            this.setButtonStatus();
            this.setEntryFieldStatus();
            this.showProgressBar();
            UpgradeProgressInformation progressInfo = UpgradeProgressInformation.get((Object)((Integer)this.attributeCache.get((Object)"progressHeader")));
            if (this.upState == UpgradePackageState.NOT_INSTALLED && progressInfo == UpgradeProgressInformation.EXECUTION_FAILED) {
                this.view.getProgressModel().setValue(0);
            }
            this.setTitle();
        }
        catch (NoSuchFieldException e) {
            this.reportException(e, "GSL_ERROR", null);
        }
    }

    protected void writeMoAttributes() {
        Log.trace((String)"writeMoAttributes()");
        Transaction writeMoTransaction = null;
        try {
            AttributeBuffer attributeBuffer = new AttributeBuffer();
            attributeBuffer.setAttribute("userLabel", (Object)this.view.getUserLabel());
            writeMoTransaction = new Transaction();
            this.upgradePackageMo.setAttributes(attributeBuffer.getNameValues(), writeMoTransaction.session);
            writeMoTransaction.commit();
            writeMoTransaction.end();
            NameValue[] updateFTPServerDataActionParameters = new NameValue[]{new NameValue("ftpServerIpAddress", (Object)this.view.getFtpServer()), new NameValue("upFilePathOnFtpServer", (Object)this.view.getUpFilePath()), new NameValue("user", (Object)this.view.getUsername()), new NameValue("password", (Object)this.view.getPassword())};
            writeMoTransaction = new Transaction();
            this.upgradePackageMo.action("updateFTPServerData", updateFTPServerDataActionParameters, writeMoTransaction.session);
            writeMoTransaction.commit();
            writeMoTransaction.end();
        }
        catch (CSException e) {
            Log.logError((String)"", (Throwable)e);
            this.reportException((Exception)((Object)e), "ERROR_SET", null);
            this.finishFailedTransaction(writeMoTransaction, "Error writing attributes to UpgradePackageMO " + this.upgradePackageMo.getDN(), (Exception)((Object)e));
        }
    }

    protected boolean readAndShowMoAttributes(boolean how) {
        boolean isReadSuccessful = this.readMoAttributes(how, null);
        if (isReadSuccessful) {
            this.showMoAttributes();
        }
        return isReadSuccessful;
    }

    protected boolean userConfirmsAction(String title, String message) {
        String filePath = null;
        filePath = this.upState == UpgradePackageState.ONLY_DELETEABLE ? (String)this.attributeCache.get((Object)"upgradeControlFilePath") : this.view.getUpFilePath();
        Object[] messageArguments = new Object[]{filePath.trim(), this.view.getFtpServer(), this.view.getUsername(), this.view.getUserLabel(), this.upgradePackageMo.getDN()};
        int selection = this.showConfirmDialog(message, messageArguments, title, null, 0, 3, null);
        return selection == 0;
    }

    protected boolean userConfirmsAction(String title, String message, Object[] buttonTitles) {
        Object[] messageArguments = new Object[]{this.view.getUpFilePath(), this.view.getFtpServer(), this.view.getUsername(), this.view.getUserLabel()};
        int selection = UpgradePackageController.showOptionDialog((AbstractController)this, message, messageArguments, title, null, 0, 3, null, buttonTitles, buttonTitles[1]);
        return selection == 0;
    }

    public HardSoftSelection userSelectsHardSoftCancel(String title, String message, String softOption, String hardOption) {
        Object[] messageArgs = new Object[]{this.view.getUpFilePath().trim(), this.view.getFtpServer(), this.view.getUsername(), this.view.getUserLabel()};
        return UpgradePackageController.userSelectsHardSoftCancel(title, message, messageArgs, softOption, hardOption, (AbstractController)this);
    }

    public static HardSoftSelection userSelectsHardSoftCancel(String title, String message, Object[] messageArgs, String softOption, String hardOption, AbstractController controller) {
        String translatedSoftOption = controller.getString(softOption, null);
        Object[] options = new String[]{translatedSoftOption, controller.getString(hardOption, null), controller.getString("GSL_CANCEL", null)};
        int selection = UpgradePackageController.showOptionDialog(controller, message, messageArgs, title, null, 0, 3, null, options, translatedSoftOption);
        return HardSoftSelection.get(selection);
    }

    protected boolean checkInputFields() {
        return this.view.checkMandatoryFields();
    }

    private void showProgressBar() {
        Runnable setValue = new Runnable(){

            public void run() {
                Integer progressStepVal = (Integer)UpgradePackageController.this.attributeCache.get((Object)"progressHeader");
                UpgradeProgressInformation progressStep = UpgradeProgressInformation.get((Object)progressStepVal);
                String progressStepName = UpgradePackageController.this.getString(progressStep.toString(), null);
                int progressTotal = (Integer)UpgradePackageController.this.attributeCache.get((Object)"progressTotal");
                int progressCount = (Integer)UpgradePackageController.this.attributeCache.get((Object)"progressCount");
                if (progressStep == UpgradeProgressInformation.IDLE) {
                    UpgradePackageController.this.view.setProgressString("");
                    UpgradePackageController.this.view.getProgressModel().setMaximum(0);
                    UpgradePackageController.this.view.getProgressModel().setValue(0);
                } else if (progressTotal > 0) {
                    UpgradePackageController.this.view.setProgressString(progressStepName);
                    UpgradePackageController.this.view.getProgressModel().setMaximum(progressTotal);
                    UpgradePackageController.this.view.getProgressModel().setValue(progressCount);
                } else if (progressStep == UpgradeProgressInformation.EXECUTION_FAILED) {
                    UpgradePackageController.this.view.setProgressString(progressStepName);
                    UpgradePackageController.this.view.getProgressModel().setMaximum(0);
                    UpgradePackageController.this.view.getProgressModel().setValue(0);
                } else {
                    UpgradePackageController.this.view.setProgressString(progressStepName + UpgradePackageController.this.getString("UP_NO_PROGRESS_INDICATION", null));
                    UpgradePackageController.this.view.getProgressModel().setMaximum(10);
                    int newValue = UpgradePackageController.this.view.getProgressModel().getValue() < 5 ? 9 : 1;
                    UpgradePackageController.this.view.getProgressModel().setValue(newValue);
                }
            }
        };
        SwingUtilities.invokeLater(setValue);
    }

    private void setButtonStatus() {
        UpgradeProgressInformation progressInfo;
        boolean inputFields = this.checkInputFields();
        if (this.attributeCache != null) {
            this.upState = UpgradePackageState.get((Object)((Integer)this.attributeCache.get((Object)"state")));
            progressInfo = UpgradeProgressInformation.get((Object)((Integer)this.attributeCache.get((Object)"progressHeader")));
            try {
                this.rebootNodeUpgradeAllowed = (Boolean)this.supportedUpgradeTypesStatus.getElementValue("rebootNodeUpgrade");
                this.updateAllowed = (Boolean)this.supportedUpgradeTypesStatus.getElementValue("update");
                this.upgradeAllowed = (Boolean)this.supportedUpgradeTypesStatus.getElementValue("upgrade");
            }
            catch (NoSuchFieldException e) {
                Log.logError((String)"Error reading attribute. ", (Throwable)e);
                this.reportException(e, "", null);
            }
        } else {
            this.upState = UpgradePackageState.NOT_INSTALLED;
            progressInfo = UpgradeProgressInformation.IDLE;
            this.rebootNodeUpgradeAllowed = false;
            this.updateAllowed = false;
            this.upgradeAllowed = false;
        }
        this.view.setCreateEnabled(inputFields && this.isCreateNewUpgradePackage);
        if (this.upState.equals(UpgradePackageState.UPGRADE_EXECUTING)) {
            this.upgradeButtonPressed = false;
        }
        if (progressInfo == UpgradeProgressInformation.DOWNLOADING_FILES) {
            this.installButtonPressed = false;
            this.installPiuButtonPressed = false;
        } else if (progressInfo == UpgradeProgressInformation.VERIFICATION_INITIATED) {
            this.cancelAllowed = false;
        } else if (progressInfo == UpgradeProgressInformation.VERIFICATION_FINISHED) {
            this.cancelAllowed = true;
        }
        if (!this.upState.equals(UpgradePackageState.INSTALL_EXECUTING)) {
            this.cancelInstallButtonPressed = false;
        }
        this.view.setInstallEnabled(!this.isCreateNewUpgradePackage && !this.deleting && !this.installButtonPressed && !this.verifyButtonPressed && !this.upgradeButtonPressed && !this.updateButtonPressed && progressInfo != UpgradeProgressInformation.DOWNLOADING_FILES && (this.upState.equals(UpgradePackageState.NOT_INSTALLED) || this.upState.equals(UpgradePackageState.UPGRADE_COMPLETED) || this.upState.equals(UpgradePackageState.INSTALL_NOT_COMPLETED) || this.upState.equals(UpgradePackageState.INSTALL_COMPLETED)));
        this.view.setInstallPiuEnabled(this.active && !this.isCreateNewUpgradePackage && !this.deleting && !this.installButtonPressed && !this.installPiuButtonPressed && !this.verifyButtonPressed && !this.upgradeButtonPressed && !this.updateButtonPressed && this.upState.equals(UpgradePackageState.UPGRADE_COMPLETED));
        this.view.setCancelInstallEnabled(this.upState.equals(UpgradePackageState.INSTALL_EXECUTING) && !this.cancelInstallButtonPressed && !this.verifyButtonPressed);
        this.view.setDeleteEnabled(!this.isCreateNewUpgradePackage && !this.upState.equals(UpgradePackageState.INSTALL_EXECUTING) && !this.upState.equals(UpgradePackageState.UPGRADE_EXECUTING) && !this.upState.equals(UpgradePackageState.AWAITING_CONFIRMATION) && !this.upgradeButtonPressed && !this.updateButtonPressed && !this.installButtonPressed && !this.deleting && !this.verifyButtonPressed || this.upState.equals(UpgradePackageState.ONLY_DELETEABLE));
        this.view.setVerifyEnabled(!this.verifyButtonPressed && !this.updateButtonPressed && !this.upgradeButtonPressed && !this.upState.equals(UpgradePackageState.INSTALL_EXECUTING) && (this.upState.equals(UpgradePackageState.UPGRADE_COMPLETED) || this.upState.equals(UpgradePackageState.INSTALL_COMPLETED)));
        this.view.setUpgradeEnabled(!(!this.upState.equals(UpgradePackageState.INSTALL_COMPLETED) && !this.upState.equals(UpgradePackageState.UPGRADE_COMPLETED) || this.verifyButtonPressed || this.updateButtonPressed || this.upgradeButtonPressed || this.installButtonPressed || this.upState.equals(UpgradePackageState.INSTALL_EXECUTING) || !this.rebootNodeUpgradeAllowed && !this.upgradeAllowed));
        this.view.setCancelUpgradeEnabled(this.upState.equals(UpgradePackageState.UPGRADE_EXECUTING) && this.cancelAllowed || this.upState.equals(UpgradePackageState.AWAITING_CONFIRMATION));
        this.view.setConfirmEnabled(this.upState.equals(UpgradePackageState.AWAITING_CONFIRMATION) && !this.cancelUpgradeButtonPressed);
        this.view.setUpdateEnabled((this.upState.equals(UpgradePackageState.INSTALL_COMPLETED) || this.upState.equals(UpgradePackageState.UPGRADE_COMPLETED)) && !this.updateButtonPressed && !this.upgradeButtonPressed && !this.verifyButtonPressed && !this.installButtonPressed && !this.upState.equals(UpgradePackageState.INSTALL_EXECUTING) && this.updateAllowed);
    }

    protected void setTitle() {
        String titleKey;
        if (this.isCreateNewUpgradePackage || this.attributeCache == null) {
            titleKey = "UPGRADE_PACKAGE_CREATE_TITLE";
            this.view.setHelpTag("SOFTWAREMANAGER_UPGRADEPACKAGEPROPERTIES_BUTTON_HELP");
        } else {
            this.upState = UpgradePackageState.get((Object)((Integer)this.attributeCache.get((Object)"state")));
            if (this.upState == UpgradePackageState.NOT_INSTALLED) {
                titleKey = "UPGRADE_PACKAGE_NOT_INSTALL_TITLE";
                this.view.setHelpTag("SOFTWAREMANAGER_UPGRADEPACKAGEINSTALL_BUTTON_HELP");
            } else if (this.upState == UpgradePackageState.INSTALL_EXECUTING) {
                titleKey = "UPGRADE_PACKAGE_INSTALL_EXECUTING_TITLE";
                this.view.setHelpTag("SOFTWAREMANAGER_UPGRADEPACKAGEUPGRADE_BUTTON_HELP");
            } else if (this.upState == UpgradePackageState.INSTALL_NOT_COMPLETED) {
                titleKey = "UPGRADE_PACKAGE_INSTALL_NOT_COMPLETED_TITLE";
                this.view.setHelpTag("SOFTWAREMANAGER_UPGRADEPACKAGEINSTALL_BUTTON_HELP");
            } else if (this.upState == UpgradePackageState.INSTALL_COMPLETED) {
                titleKey = "UPGRADE_PACKAGE_INSTALL_COMPLETED_TITLE";
                this.view.setHelpTag("SOFTWAREMANAGER_UPGRADEPACKAGEUPGRADE_BUTTON_HELP");
            } else if (this.upState == UpgradePackageState.UPGRADE_EXECUTING) {
                titleKey = "UPGRADE_PACKAGE_UPGRADE_EXCEUTING_TITLE";
                this.view.setHelpTag("SOFTWAREMANAGER_UPGRADEPACKAGEUPGRADE_BUTTON_HELP");
            } else if (this.upState == UpgradePackageState.UPGRADE_COMPLETED) {
                titleKey = "UPGRADE_PACKAGE_UPGRADE_COMPLETED_TITLE";
                this.view.setHelpTag("SOFTWAREMANAGER_UPGRADEPACKAGEPROPERTIES_BUTTON_HELP");
            } else if (this.upState == UpgradePackageState.AWAITING_CONFIRMATION) {
                titleKey = "UPGRADE_PACKAGE_CONFIRM_TITLE";
                this.view.setHelpTag("SOFTWAREMANAGER_UPGRADEPACKAGECONFIRM_BUTTON_HELP");
            } else if (this.upState == UpgradePackageState.ONLY_DELETEABLE) {
                titleKey = "UPGRADE_PACKAGE_PROPERTIES_TITLE";
                this.view.setHelpTag("SOFTWAREMANAGER_UPGRADEPACKAGEPROPERTIES_BUTTON_HELP");
            } else {
                titleKey = "UPGRADE_PACKAGE_PROPERTIES_TITLE";
                this.view.setHelpTag("SOFTWAREMANAGER_UPGRADEPACKAGEPROPERTIES_BUTTON_HELP");
                Log.logError((String)("New upgrade package state encountered = " + this.upState));
            }
        }
        this.getApplication().setTitle(titleKey, null);
    }

    protected void finishFailedTransaction(Transaction transaction, String logMessage, Exception exception) {
        UpgradePackageController.finishFailedTransaction((AbstractController)this, transaction, logMessage, exception);
    }

    public static void finishFailedTransaction(AbstractController controller, Transaction transaction, String logMessage, Exception exception) {
        if (logMessage != null) {
            Log.log((int)5, (String)logMessage);
        }
        if (transaction != null) {
            try {
                transaction.rollback();
            }
            catch (CSException eRollback) {
                Log.logError((String)"Secondary Error rolling back transaction", (Throwable)eRollback);
            }
            try {
                transaction.end();
            }
            catch (CSException eEndTransaction) {
                Log.logError((String)"Secondary Error ending transaction", (Throwable)eEndTransaction);
            }
        } else {
            Log.logError((String)"Error during UpgradePackage install/upgrade", (Throwable)exception);
        }
    }

    public static int showOptionDialog(AbstractController controller, String msgKey, Object[] msgArgs, String titleKey, Object[] titleArgs, int optionType, int msgType, String iconName, Object[] options, Object initialValue) {
        Icon icon = IconHelper.createIcon((String)iconName);
        String msg = controller.getString(msgKey, msgArgs);
        String title = controller.getString(titleKey, titleArgs);
        return JOptionPane.showOptionDialog(null, msg, title, optionType, msgType, icon, options, initialValue);
    }

    private void refreshAll() {
        this.updateSupportedUpgradeTypes();
        this.readAndShowMoAttributes(false);
        this.setResultActionDataList(true);
        this.setLoadModuleList();
        this.setBasedOnUpgradePackageList();
    }

    private void updateSupportedUpgradeTypes() {
        try {
            this.supportedUpgradeTypesStatus = (Struct)this.upgradePackageMo.action("readSupportedUpgradeTypesStatus", new NameValue[0], null);
        }
        catch (CSException cSException) {
            // empty catch block
        }
    }

    private void setResultActionDataList(boolean showOnlyLastAction) {
        Struct[] infoSeq = null;
        this.itemListActionResult.clear();
        if (this.upgradePackageMo == null) {
            return;
        }
        try {
            infoSeq = (Struct[])this.upgradePackageMo.getAttribute("actionResult");
            Integer actionId = null;
            char charWhiteSpace = ' ';
            char charTabulation = '\t';
            char charNewLine = '\n';
            if (infoSeq != null && infoSeq.length != 0) {
                for (int i = 0; i < infoSeq.length; ++i) {
                    Integer aInvokedActionInteger = null;
                    InvokedAction aInvokedAction = null;
                    try {
                        aInvokedActionInteger = (Integer)infoSeq[i].getElementValue("typeOfInvokedAction");
                        aInvokedAction = InvokedAction.get((Object)aInvokedActionInteger);
                        this.nameOfActionInText = this.getString(aInvokedAction.toString(), null);
                    }
                    catch (Exception e) {
                        this.nameOfActionInText = "ActionResultData typeOfInvokedAction undefined: " + aInvokedActionInteger;
                    }
                    Integer myInfo = null;
                    try {
                        myInfo = (Integer)infoSeq[i].getElementValue("info");
                        this.infoText = this.getString(Information.get((Object)myInfo).toString(), null);
                    }
                    catch (Exception e) {
                        this.infoText = "ActionResultData info undefined: " + myInfo;
                    }
                    this.additionalText = (String)infoSeq[i].getElementValue("additionalInfo");
                    this.additionalText = this.additionalText.replace(charTabulation, charWhiteSpace);
                    this.infoText = this.infoText.replace(charTabulation, charWhiteSpace);
                    this.infoText = this.infoText.replace(charNewLine, charWhiteSpace);
                    this.timeText = (String)infoSeq[i].getElementValue("time");
                    this.timeText = new TimeConverter().formatTime(this.timeText);
                    actionId = (Integer)infoSeq[i].getElementValue("actionId");
                    this.actionId_text = actionId.toString();
                    if (showOnlyLastAction && this.lastActionIdentity != null && actionId != null) {
                        if (this.lastActionIdentity.compareTo(actionId) != 0) continue;
                        this.addItemsToList();
                        continue;
                    }
                    this.addItemsToList();
                }
            }
            this.view.actionResultList.removeAllItems();
            this.view.setFocusInTabbebPane("actionResult");
            this.view.actionResultList.addItems(this.itemListActionResult.toArray(new String[0]));
            this.view.actionResultList.setVisible(true);
            this.view.basePanel.validate();
        }
        catch (Exception e) {
            Log.logError((String)"Error setting value to action result data list", (Throwable)e);
        }
    }

    private void setLoadModuleList() {
        if (this.upgradePackageMo == null) {
            return;
        }
        Vector<String> itemList = new Vector<String>();
        String item = null;
        MOProxy[] loadMuduleSeq = null;
        try {
            loadMuduleSeq = (MOProxy[])this.upgradePackageMo.getAttribute("loadModuleList");
            String guiName = null;
            String filePath = null;
            if (loadMuduleSeq != null && loadMuduleSeq.length != 0) {
                for (int i = 0; i < loadMuduleSeq.length; ++i) {
                    guiName = (String)loadMuduleSeq[i].getAttribute("guiName", null);
                    filePath = (String)loadMuduleSeq[i].getAttribute("loadModuleFilePath", null);
                    item = this.getString("TEXT_FROM_GUINAME_FILE_PATH", new Object[]{guiName, filePath});
                    itemList.add(item);
                }
            }
            this.view.loadModuleList.removeAllItems();
            this.view.setFocusInTabbebPane("loadModuleList");
            this.view.loadModuleList.addItems(itemList.toArray(new String[0]));
        }
        catch (Exception exep) {
            Log.logError((String)"Error setting value to loadModuleList", (Throwable)exep);
        }
    }

    private void setBasedOnUpgradePackageList() {
        if (this.upgradePackageMo == null) {
            return;
        }
        Vector<String> itemList = new Vector<String>();
        String item = null;
        Struct[] basedOnUpSeq = null;
        try {
            basedOnUpSeq = (Struct[])this.upgradePackageMo.getAttribute("basedOnUpgradePackages");
            if (basedOnUpSeq != null && basedOnUpSeq.length != 0) {
                for (int i = 0; i < basedOnUpSeq.length; ++i) {
                    item = this.getString("TEXT_FROMNAME_NUMER_REVISION", new Object[]{basedOnUpSeq[i].getElementValue("productName"), basedOnUpSeq[i].getElementValue("productNumber"), basedOnUpSeq[i].getElementValue("productRevision")});
                    itemList.add(item);
                }
            }
            this.view.basedOnUpgradePackageList.removeAllItems();
            this.view.setFocusInTabbebPane("basedOnUpgradePackages");
            this.view.basedOnUpgradePackageList.addItems(itemList.toArray(new String[0]));
        }
        catch (Exception exep) {
            Log.logError((String)"Error setting value to basedOnUpgradePackageList", (Throwable)exep);
        }
    }

    private void showNotDeletableMessage() {
        try {
            String[] deletePreventingCVs = (String[])this.upgradePackageMo.getAttribute("deletePreventingCVs", null);
            StringBuffer message = new StringBuffer();
            StringBuffer message2 = new StringBuffer();
            for (int i = 0; i < deletePreventingCVs.length; ++i) {
                String delPrevCV = "\t" + deletePreventingCVs[i] + "\n";
                message.append(delPrevCV);
            }
            Struct[] adminData = (Struct[])this.upgradePackageMo.getAttribute("deletePreventingUPs", null);
            if (adminData != null && adminData.length != 0) {
                for (int i = 0; i < adminData.length; ++i) {
                    message2.append("\t" + (String)adminData[i].getElementValue("productName") + " " + (String)adminData[i].getElementValue("productNumber") + " " + (String)adminData[i].getElementValue("productRevision") + "\n");
                }
            }
            Object[] messageArgs = new String[]{message.toString(), message2.toString()};
            this.showMessageDialog("UP_DELETE_ERROR_REFERENCED_BY_CV_MSG", messageArgs, "GSL_ERROR", null, 0, null);
        }
        catch (CSException e) {
            this.reportException((Exception)((Object)e), "ERROR_GET", null);
            Log.logError((String)"Error getting attribute", (Throwable)e);
        }
        catch (Exception e) {
            Log.logError((String)"Error getting attribute", (Throwable)e);
        }
    }

    private void addItemsToList() {
        int beginIndex = 0;
        int endIndex = this.MAX_LENGTH;
        int endOnNewLine = 0;
        int endOnSpace = 0;
        int endOnMax = 0;
        int txtLen = this.additionalText.length();
        this.itemListActionResult.add("typeOfInvokedAction: " + this.nameOfActionInText);
        this.itemListActionResult.add("time: " + this.timeText);
        this.itemListActionResult.add("info: " + this.infoText);
        this.itemListActionResult.add("additionalInfo: ");
        if (txtLen > this.MAX_LENGTH) {
            while (txtLen >= endIndex) {
                String tmpString = this.additionalText.substring(beginIndex, endIndex);
                if (tmpString.lastIndexOf("\n") != -1) {
                    endOnNewLine = tmpString.indexOf("\n");
                    this.itemListActionResult.add(tmpString.substring(0, endOnNewLine));
                    beginIndex = beginIndex + endOnNewLine + 1;
                    endIndex = beginIndex + this.MAX_LENGTH;
                    continue;
                }
                if (tmpString.lastIndexOf(" ") != -1) {
                    endOnSpace = tmpString.lastIndexOf(" ");
                    this.itemListActionResult.add(tmpString.substring(0, endOnSpace));
                    beginIndex = beginIndex + endOnSpace + 1;
                    endIndex = beginIndex + this.MAX_LENGTH;
                    continue;
                }
                endOnMax = tmpString.length() > this.MAX_LENGTH ? this.MAX_LENGTH : tmpString.length();
                this.itemListActionResult.add(tmpString.substring(0, endOnMax));
                beginIndex = beginIndex + endOnMax + 1;
                endIndex = beginIndex + this.MAX_LENGTH;
            }
            this.itemListActionResult.add(this.additionalText.substring(beginIndex, txtLen));
        } else {
            this.itemListActionResult.add(this.additionalText);
        }
        this.itemListActionResult.add("actionId: " + this.actionId_text);
        this.itemListActionResult.add("======================================================");
        this.itemListActionResult.add("");
    }

    private void setEntryFieldStatus() {
        boolean status = !this.upState.equals(UpgradePackageState.INSTALL_EXECUTING) && !this.upState.equals(UpgradePackageState.UPGRADE_EXECUTING) && !this.verifyButtonPressed;
        this.view.disableAllentryFields(status);
    }

    private String generateLdnBasedOnXmlFileName(String oldLDN, String upFilePath) {
        if (upFilePath == null || upFilePath.equals("")) {
            return oldLDN;
        }
        String newLDN = "";
        String upgradePackageId = "";
        try {
            int index = upFilePath.lastIndexOf("/");
            if (index < 0) {
                index = upFilePath.lastIndexOf("\\");
            }
            if (index >= 0) {
                upgradePackageId = upFilePath.substring(index + 1);
                if (upgradePackageId.length() == 0) {
                    return oldLDN;
                }
            } else {
                upgradePackageId = upFilePath;
            }
            if ((index = upgradePackageId.lastIndexOf(".")) >= 0) {
                upgradePackageId = upgradePackageId.substring(0, index);
            }
            if (upgradePackageId.equals("")) {
                return oldLDN;
            }
            String oldLDNwithoutId = oldLDN.substring(0, oldLDN.lastIndexOf("=") + 1);
            newLDN = oldLDNwithoutId + upgradePackageId;
            if (this.ldnExists(newLDN)) {
                int uniqueNumber = this.swManagementMO.getChildren(1, "UpgradePackage", "").length + 1;
                upgradePackageId = upgradePackageId + "_" + uniqueNumber;
                newLDN = oldLDNwithoutId + upgradePackageId;
                while (this.ldnExists(newLDN)) {
                    upgradePackageId = upgradePackageId.substring(0, upgradePackageId.lastIndexOf("_"));
                    upgradePackageId = upgradePackageId + "_" + ++uniqueNumber;
                    newLDN = oldLDNwithoutId + upgradePackageId;
                }
            }
            return newLDN;
        }
        catch (Exception e) {
            return oldLDN;
        }
    }

    private boolean ldnExists(String ldn) throws Exception {
        MOProxy mo = new MOProxy(ldn);
        return mo.isExisting();
    }

    private String[] getButtonsForUpgrade() {
        try {
            String[] myButtons = new String[]{this.getString("UP_SOFT_UPGRADE", null), this.getString("UP_HARD_UPGRADE", null), this.getString("GSL_CANCEL", null)};
            this.defaultButtonForUpgrade = this.getString("UP_SOFT_UPGRADE", null);
            Object[] messageArgs = new Object[]{this.view.getUpFilePath()};
            if (this.rebootNodeUpgradeAllowed && this.upgradeAllowed) {
                this.messageUpgrade = this.getString("UP_UPGRADE_CONFIRM_MSG", messageArgs) + this.getString("UP_UPGRADE_SOFT", null) + this.getString("UP_UPGRADE_HARD", null);
                return myButtons;
            }
            if (this.rebootNodeUpgradeAllowed) {
                this.messageUpgrade = this.getString("UP_UPGRADE_CONFIRM_MSG", messageArgs) + this.getString("UP_UPGRADE_HARD", null);
                myButtons = new String[]{this.getString("UP_HARD_UPGRADE", null), this.getString("GSL_CANCEL", null)};
                this.defaultButtonForUpgrade = this.getString("UP_HARD_UPGRADE", null);
                return myButtons;
            }
            if (this.upgradeAllowed) {
                this.messageUpgrade = this.getString("UP_UPGRADE_CONFIRM_MSG", messageArgs) + this.getString("UP_UPGRADE_SOFT", null);
                myButtons = new String[]{this.getString("UP_SOFT_UPGRADE", null), this.getString("GSL_CANCEL", null)};
                return myButtons;
            }
            return null;
        }
        catch (Exception e) {
            this.reportException(e, "ERROR_GET", null);
            Log.logError((String)"Error getting attribute", (Throwable)e);
            return null;
        }
    }

    private class CreateProgressThread
    extends Thread {
        public void run() {
            EmasProgressMonitor pm = new EmasProgressMonitor(null, (Object)UpgradePackageController.this.createProgressBarTitle, (Object)UpgradePackageController.this.createProgressBarMessage, "", 0, 100);
            int progressCount = 0;
            pm.setMillisToPopup(0);
            pm.setMillisToDecideToPopup(0);
            while (UpgradePackageController.this.isCreateNewUpgradePackage) {
                if (progressCount == 99) {
                    progressCount = 0;
                    pm.resetProgressBar();
                }
                pm.setProgress(progressCount++);
                try {
                    CreateProgressThread.sleep(12L);
                }
                catch (InterruptedException interruptedException) {}
            }
            pm.close();
        }
    }

    private class ProgressThread
    extends Thread {
        public void run() {
            EmasProgressMonitor pm = new EmasProgressMonitor(null, (Object)UpgradePackageController.this.progressBarTitle, (Object)UpgradePackageController.this.progressBarMessage, UpgradePackageController.this.upgradePackageMo.getDN(), 0, 100);
            int progressCount = 0;
            pm.setMillisToPopup(0);
            pm.setMillisToDecideToPopup(0);
            while (UpgradePackageController.this.deleting) {
                if (progressCount == 99) {
                    progressCount = 0;
                    pm.resetProgressBar();
                }
                pm.setProgress(progressCount++);
                try {
                    ProgressThread.sleep(12L);
                }
                catch (InterruptedException interruptedException) {}
            }
            pm.close();
        }
    }

    private class DeleteThread
    extends Thread {
        public void run() {
            UpgradePackageController.this.view.setDeleteEnabled(false);
            UpgradePackageController.this.view.setInstallEnabled(false);
            UpgradePackageController.this.deleting = true;
            new ProgressThread().start();
            Transaction deleteMoTransaction = null;
            try {
                deleteMoTransaction = new Transaction(600000);
                UpgradePackageController.this.upgradePackageMo.delete(deleteMoTransaction.session);
                deleteMoTransaction.commit();
                deleteMoTransaction.end();
                String notificationType = UpgradePackageController.UP_DELETED_NOTIFICATION;
                String notificationLdn = UpgradePackageController.this.upgradePackageMo.getDN();
                Log.logNotify((String)("Performing sendEmNotification('Delete') " + notificationLdn));
                UpgradePackageController.this.sendNotification(notificationType, notificationLdn);
            }
            catch (CSException e) {
                UpgradePackageController.this.deleting = false;
                UpgradePackageController.this.reportException((Exception)((Object)e), "UP_DELETE_ERROR_MSG", null);
                UpgradePackageController.this.finishFailedTransaction(deleteMoTransaction, "Deletion of UpgradePackageMO " + UpgradePackageController.this.upgradePackageMo.getDN() + " failed", (Exception)((Object)e));
            }
            UpgradePackageController.this.deleting = false;
            try {
                UpgradePackageController.this.viewClosing();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }

    private class CreateThread
    extends Thread {
        public void run() {
            new CreateProgressThread().start();
            UpgradePackageController.this.createUpgradePackage();
        }
    }
}

