/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.emas.sm.elements;

import java.awt.Component;
import java.awt.Dimension;
import java.lang.reflect.Constructor;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import se.ericsson.cello.emas.sm.elements.ConfigurationVersionElement;
import se.ericsson.cello.emas.sm.elements.EmasElementCreator;
import se.ericsson.cello.support.gui.AbstractViewElement;
import se.ericsson.cello.support.gui.EmasGuilibMediator;
import se.ericsson.cello.support.gui.EmasProgressMonitor;
import se.ericsson.cello.support.gui.MainWindowController;
import se.ericsson.cello.support.gui.PropertiesHelper;
import se.ericsson.cello.support.gui.TopologyModel;
import se.ericsson.cello.support.gui.guilib.comp.IconHelper;
import se.ericsson.cello.support.gui.guilib.comp.Log;
import se.ericsson.cello.support.mgr.AttributeBuffer;
import se.ericsson.cello.support.mgr.EmasViewElement;
import se.ericsson.cello.support.mgr.EmasViewElementInterface;
import se.ericsson.cello.support.mgr.MOComposite;
import se.ericsson.cello.support.proxy.CSException;
import se.ericsson.cello.support.proxy.MOProxy;
import se.ericsson.cello.support.proxy.NameValue;
import se.ericsson.cello.support.proxy.Struct;

public class ConfigurationVersionElementCreator
extends EmasElementCreator {
    protected AbstractViewElement parent = null;
    protected MOProxy cvMO = null;
    boolean dirtyvariable = true;
    private AttributeBuffer myAttrBuffer = null;

    public ConfigurationVersionElementCreator(Properties p) {
        super(p);
    }

    public void dispose() {
        if (this.cvMO != null) {
            this.cvMO.removeMOListener((MOProxy.MOListener)this);
        }
    }

    public AbstractViewElement[] createInstances(AbstractViewElement parent) {
        Struct[] storedCVs = null;
        Vector<EmasViewElementInterface> newElements = new Vector<EmasViewElementInterface>();
        this.parent = parent;
        if (this.dirtyvariable) {
            this.dirtyvariable = false;
            try {
                this.cvMO = ((EmasViewElement)parent).getMO("ConfigurationVersion");
                this.cvMO.addMOListener((MOProxy.MOListener)this);
                storedCVs = (Struct[])this.cvMO.getAttribute("storedConfigurationVersions", null);
            }
            catch (CSException e) {
                Log.logError((String)"createInstances failed", (Throwable)e);
                return newElements.toArray(new AbstractViewElement[0]);
            }
            if (storedCVs != null) {
                EmasProgressMonitor pm = new EmasProgressMonitor(null, (Object)parent.translate("PROGRESS_BAR_TITLE"), (Object)parent.translate("PROGRESS_BAR_MESSAGE"), parent.getName(), 0, storedCVs.length);
                int progressCount = 0;
                for (int index = 0; index < storedCVs.length; ++index) {
                    EmasViewElementInterface newElement = null;
                    try {
                        newElement = this.createElement(new Integer(index));
                        if (newElement != null) {
                            this.addElement(newElement);
                            newElements.add(newElement);
                        }
                    }
                    catch (Exception e) {
                        Log.logError((String)("CV Element " + this.getClassName() + " could not be created"), (Throwable)e);
                    }
                    pm.setProgress(progressCount++);
                }
                pm.close();
            }
        }
        return newElements.toArray(new AbstractViewElement[0]);
    }

    public synchronized boolean addElement(EmasViewElementInterface newElement) {
        boolean elementWasAdded;
        block6: {
            elementWasAdded = false;
            if (newElement != null) {
                Log.trace((String)("addElement " + newElement.getType()));
                String dn = newElement.getDN();
                this.childElements.put(dn, newElement);
                boolean allMosArePresent = true;
                Iterator i = newElement.getMOC().iterator();
                try {
                    while (i.hasNext()) {
                        MOProxy mo = (MOProxy)i.next();
                        Log.trace((String)("addMOListener " + dn));
                        mo.addMOListener((MOProxy.MOListener)newElement);
                        if (mo.isExisting()) continue;
                        allMosArePresent = false;
                    }
                    if (!allMosArePresent) {
                        this.deleteElement(newElement);
                        break block6;
                    }
                    elementWasAdded = true;
                }
                catch (CSException ce) {
                    Log.logWarning((String)("Exception while checking MO existance." + (Object)((Object)ce)));
                    elementWasAdded = false;
                }
            } else {
                Log.trace((String)"addElement newElement is null!");
            }
        }
        Log.trace((String)("addElement return=" + elementWasAdded));
        return elementWasAdded;
    }

    public void attributesChanged(MOProxy anMO, NameValue[] nameValue) {
        Struct[] cvList = null;
        try {
            boolean cvsUpdated = false;
            for (int i = 0; i < nameValue.length; ++i) {
                if (nameValue[i].name.equals("storedConfigurationVersions")) {
                    cvList = nameValue[i].value != null ? (Struct[])nameValue[i].value : new Struct[]{};
                    if (!cvsUpdated) {
                        this.updateStoredConfigurationVersions(cvList);
                        cvsUpdated = true;
                    }
                    this.parent.refreshSubtree();
                    continue;
                }
                if (!nameValue[i].name.equals("rollbackList")) continue;
                cvList = (Struct[])anMO.getAttribute("storedConfigurationVersions", null);
                if (!cvsUpdated) {
                    this.updateStoredConfigurationVersions(cvList);
                    cvsUpdated = true;
                }
                this.parent.refreshSubtree();
            }
        }
        catch (Exception e) {
            Log.logError((String)"update failed", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateStoredConfigurationVersions(Struct[] cvList) {
        AbstractViewElement[] children = this.parent.getChildren();
        EmasViewElementInterface newElement = null;
        boolean found = false;
        AbstractViewElement abstractViewElement = this.parent;
        synchronized (abstractViewElement) {
            TopologyModel topologyModel = this.parent.getModel();
            synchronized (topologyModel) {
                if (this.parent.getChildCount() < cvList.length) {
                    for (int count = 0; count < cvList.length; ++count) {
                        found = false;
                        for (int i = 0; i < children.length; ++i) {
                            try {
                                if (!cvList[count].getElementValue("name").equals(children[i].getName())) continue;
                                found = true;
                                break;
                            }
                            catch (NoSuchFieldException nsfe) {
                                Log.logError((String)"Error getting the value ", (Throwable)nsfe);
                            }
                        }
                        if (found) continue;
                        this.myAttrBuffer = null;
                        newElement = this.createElement(new Integer(count));
                        this.parent.addChildAndWaitForGUIToBeUpdated((AbstractViewElement)newElement);
                        this.addElement(newElement);
                    }
                } else {
                    for (int i = 0; i < children.length; ++i) {
                        found = false;
                        for (int count = 0; count < cvList.length; ++count) {
                            try {
                                if (!cvList[count].getElementValue("name").equals(children[i].getName())) continue;
                                found = true;
                                break;
                            }
                            catch (NoSuchFieldException nsfe) {
                                Log.logError((String)"Error getting the value ", (Throwable)nsfe);
                            }
                        }
                        if (found) continue;
                        this.deleteElement((EmasViewElementInterface)children[i]);
                        this.parent.removeChildAndWaitForGUIToBeUpdated(children[i]);
                    }
                }
                this.updateCVIndices(cvList);
            }
        }
    }

    protected void updateCVIndices(Struct[] cvList) {
        AbstractViewElement[] children = (AbstractViewElement[])this.parent.getChildren().clone();
        Object newElement = null;
        boolean found = false;
        if (cvList != null && children != null) {
            for (int count = 0; count < cvList.length; ++count) {
                found = false;
                try {
                    for (int i = 0; i < children.length; ++i) {
                        if (!cvList[count].getElementValue("name").equals(children[i].getName())) continue;
                        ((ConfigurationVersionElement)children[i]).setCVIndex(cvList, count);
                    }
                    continue;
                }
                catch (NoSuchFieldException nsfe) {
                    Log.logError((String)"Error getting the value ", (Throwable)nsfe);
                }
            }
        }
    }

    protected EmasViewElementInterface createElement(Integer index) {
        EmasViewElementInterface newElement = null;
        try {
            if (this.myAttrBuffer == null) {
                String[] attributeNames = new String[]{"storedConfigurationVersions", "currentLoadedConfigurationVersion", "startableConfigurationVersion"};
                Object[] values = this.cvMO.getAttributes(attributeNames, null);
                this.myAttrBuffer = new AttributeBuffer(attributeNames, values);
            }
            MOComposite moc = new MOComposite();
            moc.add(this.cvMO);
            Object[] args = new Object[]{moc, this.getProperties(), this, index, this.myAttrBuffer};
            Class<?> c = Class.forName(this.getClassName());
            Vector v = new Vector();
            for (int i = 0; i < args.length; ++i) {
                v.add(args[i].getClass());
            }
            Constructor<?> constructor = c.getConstructor(v.toArray(new Class[0]));
            newElement = (EmasViewElementInterface)constructor.newInstance(args);
        }
        catch (Exception e) {
            Log.logError((String)("CV Element " + this.getClassName() + " could not be created"), (Throwable)e);
        }
        return newElement;
    }

    protected void clearAttributeList() {
        this.myAttrBuffer = null;
    }

    private Object showConfirmDialogForSM(String msgKey, Object[] msgArgs, String titleKey, Object[] titleArgs, int msgType, String iconName) {
        String msg = null;
        String title = null;
        String presentViewBundle = null;
        Properties properties = null;
        MainWindowController refMainWindowController = EmasGuilibMediator.getReference().getMainWindowReference();
        presentViewBundle = refMainWindowController.getCurrentView().getResourceBundleBasename();
        if (presentViewBundle != null) {
            properties = new PropertiesHelper("/" + presentViewBundle.replace('.', '/') + ".properties");
        }
        Icon icon = IconHelper.createIcon((String)iconName);
        if (msgKey != null && !msgKey.equals("")) {
            msg = properties.getProperty(msgKey);
            if (msgArgs != null && msg != null) {
                msg = MessageFormat.format(msg, msgArgs);
            }
        }
        if (titleKey != null && !titleKey.equals("")) {
            title = properties.getProperty(titleKey);
            if (titleArgs != null && title != null) {
                title = MessageFormat.format(title, titleArgs);
            }
        }
        if (msg == null) {
            msg = "MISSING_MESSAGE_IN_BUNDLE : " + presentViewBundle;
        }
        if (title == null) {
            title = "MISSING_TITLE";
        }
        JTextArea txt = new JTextArea(msg);
        txt.setEditable(false);
        txt.setBackground(refMainWindowController.getView().getBackground());
        txt.setFont(refMainWindowController.getView().getFont());
        txt.setLineWrap(true);
        txt.setWrapStyleWord(true);
        txt.setCaretPosition(0);
        JScrollPane scrollPane = new JScrollPane(txt, 20, 31);
        JOptionPane pane = new JOptionPane(scrollPane, msgType);
        pane.setPreferredSize(new Dimension(400, 120));
        JDialog dialog = pane.createDialog((Component)refMainWindowController.getView(), title);
        dialog.setResizable(true);
        dialog.setModal(true);
        dialog.show();
        return pane.getValue();
    }
}

