/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.emas.sm.services;

import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import se.ericsson.cello.support.mgr.cellomom.ConfigurationVersionType;

public class StoredConfigurationVersion {
    private String name = "";
    private String identity = "";
    private ConfigurationVersionType type = ConfigurationVersionType.OTHER;
    private String date = "";
    private String operatorName = "";
    private String upID = "";
    private String comment = "";

    public StoredConfigurationVersion(String aStoredCV) {
        String cvType = null;
        StringTokenizer st = new StringTokenizer(aStoredCV, "~");
        while (st.hasMoreTokens()) {
            try {
                StringTokenizer nameValue = new StringTokenizer(st.nextToken(), "#", false);
                String attrib = nameValue.nextToken();
                if (attrib.toUpperCase().equals("NAME")) {
                    this.name = nameValue.nextToken();
                    continue;
                }
                if (attrib.toUpperCase().equals(" IDENTITY")) {
                    this.identity = nameValue.nextToken();
                    continue;
                }
                if (attrib.toUpperCase().equals(" DATE")) {
                    this.date = nameValue.nextToken();
                    continue;
                }
                if (attrib.toUpperCase().equals(" TYPE")) {
                    cvType = "CONFIGURATIONVERSIONTYPE." + nameValue.nextToken().toUpperCase();
                    if (cvType.equals(ConfigurationVersionType.STANDARD.toString())) {
                        this.type = ConfigurationVersionType.STANDARD;
                        continue;
                    }
                    if (cvType.equals(ConfigurationVersionType.UPGRADE.toString())) {
                        this.type = ConfigurationVersionType.UPGRADE;
                        continue;
                    }
                    if (cvType.equals(ConfigurationVersionType.MINIMAL.toString())) {
                        this.type = ConfigurationVersionType.MINIMAL;
                        continue;
                    }
                    if (cvType.equals(ConfigurationVersionType.TEST.toString())) {
                        this.type = ConfigurationVersionType.TEST;
                        continue;
                    }
                    if (cvType.equals(ConfigurationVersionType.AUTOCREATE.toString())) {
                        this.type = ConfigurationVersionType.AUTOCREATE;
                        continue;
                    }
                    this.type = ConfigurationVersionType.OTHER;
                    continue;
                }
                if (attrib.toUpperCase().equals(" OPERATOR NAME")) {
                    this.operatorName = nameValue.nextToken();
                    continue;
                }
                if (attrib.toUpperCase().equals(" UPGRADEPACKAGEID")) {
                    this.upID = nameValue.nextToken();
                    continue;
                }
                if (!attrib.toUpperCase().equals(" COMMENT")) continue;
                this.comment = nameValue.nextToken();
            }
            catch (NoSuchElementException nse) {}
        }
    }

    private StoredConfigurationVersion() {
    }

    public String getName() {
        return this.name;
    }

    public String getDate() {
        return this.date;
    }

    public String getIdentity() {
        return this.identity;
    }

    public ConfigurationVersionType getType() {
        return this.type;
    }

    public String getOperatorName() {
        return this.operatorName;
    }

    public String getUpgradePackageID() {
        return this.upID;
    }

    public String getComment() {
        return this.comment;
    }
}

