/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.configurationversion.cancelrestore;

import se.ericsson.cello.configurationversion.base.CV_SubFunctionController;
import se.ericsson.cello.configurationversion.cancelrestore.RestoreCancelInterface;
import se.ericsson.cello.configurationversion.cancelrestore.RestoreCancellerException;
import se.ericsson.cello.configurationversion.main.event.detailedactivity.ExecutingBlockingActionEvent;
import se.ericsson.cello.configurationversion.main.event.detailedactivity.NodeRestartRequestEvent;
import se.ericsson.cello.configurationversion.main.event.mainactivity.CancellingRestoreOfDownloadedBackupCV_Event;
import se.ericsson.cello.configurationversion.util.progresshandler.CV_ProgressInformationHandler;
import se.ericsson.cello.configurationversion.util.progresshandler.NotifyingConfigurationVersionPropertyName;
import se.ericsson.cello.mao.RestartReasonEnum;
import se.ericsson.cello.upgradepackage.trace.Trace;

public class RestoreCanceller
extends CV_SubFunctionController {
    private RestoreCancelInterface myRestorer = null;

    public RestoreCanceller() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "RestoreCanceller()");
        }
    }

    public RestoreCanceller(RestoreCancelInterface restoreCancelInterface) {
        this.myRestorer = restoreCancelInterface;
    }

    public void cancelRestoreAllowed(boolean bl) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "cancelRestoreAllowed(boolean anIsNodeRestartRequired)", "anIsNodeRestartRequired: " + bl);
        }
        try {
            if (bl) {
                CV_ProgressInformationHandler.instance().firePropertyChange(NotifyingConfigurationVersionPropertyName.DetailedActivity, new NodeRestartRequestEvent(this));
                this.requestRollback("The execution of restore failed (cancel restore manually requested) i.e. the node is restarted on the rollback CV.", new RestartReasonEnum(25, this.getClass()));
            }
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "cancelRestoreAllowed(boolean anIsNodeRestartRequired)", "Throwable caught.\n\tanIsNodeRestartRequired: " + bl + throwable);
        }
    }

    public void cancelRestoreRequest() throws RestoreCancellerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "cancelRestoreRequest()");
        }
        try {
            CV_ProgressInformationHandler.instance().firePropertyChange(NotifyingConfigurationVersionPropertyName.MainActivity, new CancellingRestoreOfDownloadedBackupCV_Event(this));
            CV_ProgressInformationHandler.instance().firePropertyChange(NotifyingConfigurationVersionPropertyName.DetailedActivity, new ExecutingBlockingActionEvent(this));
            if (this.myRestorer != null) {
                this.myRestorer.cancelExecutionOfRestore(this);
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "cancelRestoreRequest()", "Cancel of an ongoing restore has been requested (waiting for acknowledge from restore service).");
                }
            } else {
                this.cancelRestoreAllowed(true);
            }
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "cancelRestoreRequest()", "Throwable caught." + throwable);
            throw new RestoreCancellerException("Class name: " + this.getClass().getName() + "\n\tcancelRestoreRequest()" + "\n\tThrowable caught." + "\n\tThrowable data: " + throwable.toString());
        }
        finally {
            Trace.flushToTraceFile();
        }
    }
}

