/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.configurationversion.util.mohandler.ethernetlink;

import se.ericsson.cello.configurationversion.file.ipnetworkdata.proxy.IP_NetworkDataProxy;
import se.ericsson.cello.configurationversion.file.ipnetworkdata.proxy.IP_NetworkDataProxyLookup;
import se.ericsson.cello.configurationversion.main.exception.ConfigurationVersionException;
import se.ericsson.cello.configurationversion.util.mohandler.ethernetlink.EthernetLinkMO_handlerInterface;
import se.ericsson.cello.ipoam.suaccess.EthernetLinkMoSU_Access;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoRepository;
import se.ericsson.cello.transaction.Control;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.upgradepackage.trace.Trace;
import se.ericsson.cello.upgradepackage.util.mohandler.factory.MO_HandlerFactoryInterface;
import se.ericsson.cello.upgradepackage.util.transaction.Transaction;

public class EthernetLinkMO_Handler
implements EthernetLinkMO_handlerInterface {
    private EthernetLinkMoSU_Access myEthernetLinkMoSU_Access = null;
    private boolean myIsLogged = false;

    public EthernetLinkMO_Handler(MO_HandlerFactoryInterface mO_HandlerFactoryInterface) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "EthernetLinkMO_Handler(MO_HandlerFactoryInterface aMO_HandlerFactoryInterface)");
        }
    }

    public boolean existsEthernetLinkMo() throws ConfigurationVersionException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "existsEthernetLinkMo()");
        }
        try {
            return this.getEthernetLinkMo() != null;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "existsEthernetLinkMo()", "Throwable caught when attempting to find out if the EthernetLinkMo exists.", throwable);
            throw new ConfigurationVersionException("Class name: " + this.getClass().getName() + "\n\texistsEthernetLinkMo()" + "\n\tThrowable caught when attempting to find out if the EthernetLinkMo exists." + "\n\tThrowable: " + throwable + "\n\tThrowable data: " + throwable.toString());
        }
    }

    public String getInterfaceName() throws ConfigurationVersionException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getInterfaceName()");
        }
        try {
            EthernetLinkMoSU_Access ethernetLinkMoSU_Access = this.getEthernetLinkMo();
            if (ethernetLinkMoSU_Access != null) {
                String string = ethernetLinkMoSU_Access.getInterfaceName(null);
                if (Trace.valid(this.getClass(), 21)) {
                    Trace.debug(this.getClass(), 21, "getInterfaceName()", "RETURNS - " + string);
                }
                return string;
            }
            throw new ConfigurationVersionException("No EthernetLink Mo instance was configured");
        }
        catch (ConfigurationVersionException configurationVersionException) {
            throw configurationVersionException;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "getNodeIP_Address()", "Throwable caught when attempting to retreive the SubnetMask of the node.", throwable);
            throw new ConfigurationVersionException("Class name: " + this.getClass().getName() + "\n\tgetNodeIP_Address()" + "\n\tThrowable caught when attempting to retreive the SubnetMask of the node." + "\n\tThrowable: " + throwable + "\n\tThrowable data: " + throwable.toString());
        }
    }

    public String getNodeIP_Address() throws ConfigurationVersionException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getNodeIP_Address()");
        }
        try {
            EthernetLinkMoSU_Access ethernetLinkMoSU_Access = this.getEthernetLinkMo();
            if (ethernetLinkMoSU_Access != null) {
                String string = ethernetLinkMoSU_Access.getIpAddress(null);
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "getNodeIP_Address()", "The IP address on the node is " + string);
                }
                return string;
            }
            throw new ConfigurationVersionException("No EthernetLink Mo instance was configured");
        }
        catch (ConfigurationVersionException configurationVersionException) {
            throw configurationVersionException;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "getNodeIP_Address()", "Throwable caught when attempting to retreive the IP address of the node.", throwable);
            throw new ConfigurationVersionException("Class name: " + this.getClass().getName() + "\n\tgetNodeIP_Address()" + "\n\tThrowable caught when attempting to retreive the IP address of the node." + "\n\tThrowable: " + throwable + "\n\tThrowable data: " + throwable.toString());
        }
    }

    public String getNodeSubnetMask() throws ConfigurationVersionException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getNodeSubnetMask()");
        }
        try {
            EthernetLinkMoSU_Access ethernetLinkMoSU_Access = this.getEthernetLinkMo();
            if (ethernetLinkMoSU_Access != null) {
                String string = ethernetLinkMoSU_Access.getSubnetMask(null);
                if (Trace.valid(this.getClass(), 21)) {
                    Trace.debug(this.getClass(), 21, "getNodeSubnetMask()", "RETURNS - " + string);
                }
                return string;
            }
            throw new ConfigurationVersionException("No EthernetLink Mo instance was configured");
        }
        catch (ConfigurationVersionException configurationVersionException) {
            throw configurationVersionException;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "getNodeSubnetMask()", "Throwable caught when attempting to retreive the SubnetMask of the node.", throwable);
            throw new ConfigurationVersionException("Class name: " + this.getClass().getName() + "\n\tgetNodeIP_Address()" + "\n\tThrowable caught when attempting to retreive the SubnetMask of the node." + "\n\tThrowable: " + throwable + "\n\tThrowable data: " + throwable.toString());
        }
    }

    public String getBroadcastAddress() throws ConfigurationVersionException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getBroadcastAddress()");
        }
        try {
            EthernetLinkMoSU_Access ethernetLinkMoSU_Access = this.getEthernetLinkMo();
            if (ethernetLinkMoSU_Access != null) {
                String string = ethernetLinkMoSU_Access.getBroadcastAddress(null);
                if (Trace.valid(this.getClass(), 21)) {
                    Trace.debug(this.getClass(), 21, "getBroadcastAddress()", "RETURNS - " + string);
                }
                return string;
            }
            throw new ConfigurationVersionException("No EthernetLink Mo instance was configured");
        }
        catch (ConfigurationVersionException configurationVersionException) {
            throw configurationVersionException;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "getBroadcastAddress()", "Throwable caught when attempting to retreive the BroadcastAddress of the node.", throwable);
            throw new ConfigurationVersionException("Class name: " + this.getClass().getName() + "\n\tgetBroadcastAddress()" + "\n\tThrowable caught when attempting to retreive the BroadcastAddress of the node." + "\n\tThrowable: " + throwable + "\n\tThrowable data: " + throwable.toString());
        }
    }

    public boolean setIP_AddressData(String string, boolean bl) throws ConfigurationVersionException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "setIP_AddressData(String aPathToIP_AddressDir)", "aPathToIP_AddressDir: " + string + "\n\taCompareToFirstVersion: " + bl);
        }
        boolean bl2 = false;
        try {
            IP_NetworkDataProxy iP_NetworkDataProxy = IP_NetworkDataProxyLookup.getIP_NetworkDataProxy(string, bl);
            String string2 = iP_NetworkDataProxy.getIP_Address();
            String string3 = iP_NetworkDataProxy.getSubnetMask();
            String string4 = iP_NetworkDataProxy.getBroadcastAddress();
            String string5 = this.getNodeIP_Address();
            String string6 = this.getNodeSubnetMask();
            String string7 = this.getBroadcastAddress();
            String string8 = string5;
            String string9 = string6;
            String string10 = string7;
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "setIP_AddressData(String aPathToIP_AddressDir, boolean aCompareToFirstVersion)", "theIP_FileIP_Address: " + string2 + "\n\ttheIP_FileBroadcastAddress: " + string4 + "\n\ttheIP_FileSubnetmask: " + string3 + "\n\ttheNodeIP_Address: " + string5 + "\n\ttheNodeSubnetmask: " + string6 + "\n\ttheNodeBroadcastAddress: " + string7);
            }
            boolean bl3 = false;
            if (this.checkIfIP_DataNeedToBeSet(string2, string5, "a.b.c.d")) {
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "setIP_AddressData(String aPathToIP_AddressDir, boolean aCompareToFirstVersion)", "ipAddress is different. Setting of IPData required.");
                }
                string8 = string2;
                bl3 = true;
            }
            if (this.checkIfIP_DataNeedToBeSet(string3, string6, "a.b.c.d")) {
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "setIP_AddressData(String aPathToIP_AddressDir, boolean aCompareToFirstVersion)", "subnetMask is different. Setting of IPData required.");
                }
                string9 = string3;
                bl3 = true;
            }
            if (this.checkIfIP_DataNeedToBeSet(string4, string7, "a.b.c.d")) {
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "setIP_AddressData(String aPathToIP_AddressDir, boolean aCompareToFirstVersion)", "broadcastAddress is different. Setting of IPData required.");
                }
                string10 = string4;
                bl3 = true;
            }
            if (bl3) {
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "setIP_AddressData(String aPathToIP_AddressDir, boolean aCompareToFirstVersion)", "Setting IPData.\n\ttheIpAddressToBeUsed: " + string8 + "\n\ttheSubnetMaskToBeUsed: " + string9 + "\n\ttheBroadcastAddressToBeUsed: " + string10);
                }
                this.setIP_Data(string8, string9, string10);
                bl2 = true;
            } else if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "setIP_AddressData(String aPathToIP_AddressDir, boolean aCompareToFirstVersion)", "Don't need to change IP data in node.");
            }
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "setIP_AddressData(String aPathToIP_AddressFile)", "aPathToIP_AddressDir: " + string + "\n\tThrowable caught when attempting to retreive the SubnetMask of the node.", throwable);
            throw new ConfigurationVersionException("Class name: " + this.getClass().getName() + "\n\tsetIP_AddressData(String aPathToIP_AddressFile)" + "\n\taPathToIP_AddressDir: " + string + "\n\tThrowable caught when attempting to retreive the SubnetMask of the node." + "\n\tThrowable: " + throwable + "\n\tThrowable data: " + throwable.toString());
        }
        return bl2;
    }

    private boolean checkIfIP_DataNeedToBeSet(String string, String string2, String string3) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "checkIfIP_DataNeedToBeSet(String anIP_FileIP_Data, String aNodeIP_Data, String aDefaultValue)", "anIP_FileIP_Data: " + string + "\n\taNodeIP_Data: " + string2 + "\n\taDefaultValue: " + string3);
        }
        if (string != null && string2 != null) {
            if (string.equals(string2)) {
                return false;
            }
            return !string.equals(string3);
        }
        if (string == string2) {
            return false;
        }
        return string != null;
    }

    private EthernetLinkMoSU_Access getEthernetLinkMo() throws ConfigurationVersionException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getEthernetLinkMo( )");
        }
        try {
            if (this.myEthernetLinkMoSU_Access == null) {
                MoIterator moIterator = MoRepository.instance().lookupType("EthernetLink");
                if (moIterator != null) {
                    this.myEthernetLinkMoSU_Access = (EthernetLinkMoSU_Access)moIterator.nextElement();
                } else if (!this.myIsLogged) {
                    Trace.log1(this.getClass(), "getEthernetLinkMo( )", "No EthernetLink MO instance was found in the node.");
                    this.myIsLogged = true;
                }
            }
            return this.myEthernetLinkMoSU_Access;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "getEthernetLinkMo( )", "Throwable caught when attempting to look up the EthernetLinkMo.", throwable);
            throw new ConfigurationVersionException("Class name: " + this.getClass().getName() + "\n\tgetEthernetLinkMo( )" + "\n\tThrowable caught when attempting to look up the EthernetLinkMo." + "\n\tThrowable: " + throwable + "\n\tThrowable data: " + throwable.toString());
        }
    }

    private void setIP_Data(String string, String string2, String string3) throws ConfigurationVersionException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "setIP_Data(String anIP_Address, String aSubnetMask)", "anIP_Address: " + string + "\n\taSubnetMask: " + string2 + "\n\taBroadcastAddress: " + string3);
        }
        Control control = null;
        Coordinator coordinator = null;
        try {
            EthernetLinkMoSU_Access ethernetLinkMoSU_Access = this.getEthernetLinkMo();
            if (ethernetLinkMoSU_Access != null) {
                control = Transaction.create();
                coordinator = Transaction.getCoordinator(control);
                this.logEthernetLinkIP_Data();
                ethernetLinkMoSU_Access.actionAssignAllIpAddresses(string, string2, string3, coordinator);
                Transaction.commit(control);
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "setIP_Data(String anIP_Address, String aSubnetMask)", "Following IP data has been set:\n\tanIP_Address: " + string + "\n\taSubnetMask: " + string2 + "\n\taBroadcastAddress: " + string3);
                }
                this.logEthernetLinkIP_Data();
            } else {
                Trace.warning(this.getClass(), "setIP_Data(String anIP_Address, String aSubnetMask)", "Not possible to set IP data for the node due to no EthernetLinkMo exists.\n\tIP data that should have been set: \n\tanIP_Address: " + string + "\n\taSubnetMask: " + string2 + "\n\taBroadcastAddress: " + string3);
            }
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "setIP_Data(String anIP_Address, String aSubnetMask)", "Throwable caught when attempting to set the IP data of the node.\n\tanIP_Address: " + string + "\n\taSubnetMask: " + string2 + "\n\taBroadcastAddress: " + string3, throwable);
            Transaction.rollback(control);
            throw new ConfigurationVersionException("Class name: " + this.getClass().getName() + "\n\tsetIP_Data(String anIP_Address, String aSubnetMask)" + "\n\tanIP_Address: " + string + "\n\taSubnetMask: " + string2 + "\n\taBroadcastAddress: " + string3 + "\n\tThrowable caught when attempting to set the IP data of the node." + "\n\tThrowable: " + throwable);
        }
    }

    public void logEthernetLinkIP_Data() throws ConfigurationVersionException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "logEthernetLinkIP_Data()");
        }
        try {
            EthernetLinkMoSU_Access ethernetLinkMoSU_Access = this.getEthernetLinkMo();
            if (ethernetLinkMoSU_Access != null) {
                String string = ethernetLinkMoSU_Access.getIpAddress(null);
                String string2 = ethernetLinkMoSU_Access.getSubnetMask(null);
                String string3 = ethernetLinkMoSU_Access.getBroadcastAddress(null);
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "logEthernetLinkIP_Data()", "The IP address on the node is " + string + "\n\tThe SubnetMask on the node is " + string2 + "\n\tThe BroadcastAddress on the node is " + string3);
                }
            } else if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "logEthernetLinkIP_Data()", "No EthernetLink is defined on the node.");
            }
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "logEthernetLinkIP_Data()", "Throwable caught when attempting to log the ip configuration on the node.", throwable);
            throw new ConfigurationVersionException("Class name: " + this.getClass().getName() + "\n\tlogEthernetLinkIP_Data()" + "\n\tThrowable caught when attempting to log the ip configuration on the node." + "\n\tThrowable: " + throwable + "\n\tThrowable data: " + throwable.toString());
        }
    }
}

