/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.su;

import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import se.ericsson.cello.configurationversion.preupgrade.CV_PreUpgradeRelationHandler;
import se.ericsson.cello.configurationversion.restore.AutoMerger;
import se.ericsson.cello.configurationversion.restore.RestoreProperties;
import se.ericsson.cello.configurationversion.service.ServiceDecider;
import se.ericsson.cello.configurationversion.util.mohandler.upgradepackage.UpgradePackageMO_HandlerInterface;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoFactory;
import se.ericsson.cello.moframework.MoFactoryMgr;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoRepository;
import se.ericsson.cello.su.extsuif.upgradepackage.util.enumer.ActualTypeOfUP;
import se.ericsson.cello.su.upgradedbstorage.UpgradeDB_StorageUtil;
import se.ericsson.cello.su.util.versionhandler.SU_AccessVersionHandler;
import se.ericsson.cello.sudom.extif.eq.suaccess.sudom.ProxySelectorEquInterface;
import se.ericsson.cello.sudom.extif.swm.suaccess.sudom.ProxySelectorSwmInterface;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.support.servloc.ServiceLocatorFacade;
import se.ericsson.cello.swmanagement.suaccess.LoadModuleMoSU_Access;
import se.ericsson.cello.transaction.Control;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.TransactionFactory;
import se.ericsson.cello.transaction.TransactionServiceImpl;
import se.ericsson.cello.upgradepackage.create.UpgradePackageShadowCreator;
import se.ericsson.cello.upgradepackage.create.UpgradePackageShadowData;
import se.ericsson.cello.upgradepackage.main.HSI_VariantEnum;
import se.ericsson.cello.upgradepackage.main.UpgradePackageMoImpl;
import se.ericsson.cello.upgradepackage.main.handler.attributehandler.NSI_ElementPresentEnum;
import se.ericsson.cello.upgradepackage.main.handler.obsolete.ObsoleteLmUpHandler;
import se.ericsson.cello.upgradepackage.main.info.UpgradePackagesInfoCollector;
import se.ericsson.cello.upgradepackage.main.info.UpgradePackagesInfoContainer;
import se.ericsson.cello.upgradepackage.main.interfaces.UpgradePackageMoExtended;
import se.ericsson.cello.upgradepackage.piutypesupervisor.PiuTypeInstallStateSupervisor;
import se.ericsson.cello.upgradepackage.proxy.ProxySelector;
import se.ericsson.cello.upgradepackage.proxy.ProxySelectorInterface;
import se.ericsson.cello.upgradepackage.trace.Trace;
import se.ericsson.cello.upgradepackage.util.library.SuLib;
import se.ericsson.cello.upgradepackage.util.mohandler.configurationversion.ConfigurationVersionMO_HandlerException;
import se.ericsson.cello.upgradepackage.util.mohandler.configurationversion.ConfigurationVersionMO_HandlerInterface;
import se.ericsson.cello.upgradepackage.util.servicefinder.ServiceFinder;

public class SuStartUpHandler {
    private boolean theCurrentActiveUpMoControlFileExists = true;

    public void execute() {
        if (Trace.valid(this.getClass(), 20)) {
            MessageLog.info(this.getClass(), (String)"execute() - Start all UP MOs...");
        }
        ConfigurationVersionMO_HandlerInterface configurationVersionMO_HandlerInterface = ServiceFinder.getConfigurationVersionMO_HandlerInterface();
        UpgradePackageMoExtended upgradePackageMoExtended = null;
        try {
            upgradePackageMoExtended = configurationVersionMO_HandlerInterface.getCurrentUpgradePackage(null);
        }
        catch (MoAccessException moAccessException) {
            Trace.error(this.getClass(), "checkIfActiveUpHavingUcfs()", "MoAccessException caught (ignored)during getCurrentUpgradePackage.", moAccessException);
        }
        this.startUP_MOs(upgradePackageMoExtended);
        this.prepareActiveUcfInCaseRestoreInProgress();
        if (Trace.valid(this.getClass(), 22)) {
            MessageLog.info(this.getClass(), (String)"start() - Prepare SU DOM...");
        }
        this.prepareSU_DOM();
        if (!SuLib.isSU_SIM() && System.getProperty("SIM") != null) {
            return;
        }
        if (Trace.valid(this.getClass(), 22)) {
            MessageLog.info(this.getClass(), (String)"execute() - Collecting UpgradePackage information...");
        }
        UpgradePackagesInfoContainer upgradePackagesInfoContainer = new UpgradePackagesInfoCollector().collectInfo();
        this.handleEmptyUpDirs(upgradePackagesInfoContainer.getDirsWithoutUCFs());
        if (Trace.valid(this.getClass(), 22)) {
            MessageLog.info(this.getClass(), (String)"execute() - Creation of shadow UPs...");
        }
        HashSet hashSet = new HashSet(upgradePackagesInfoContainer.getUpgradePackageShadowDatas());
        this.createShadowUPs(hashSet);
        if (Trace.valid(this.getClass(), 22)) {
            Trace.debug(this.getClass(), 22, "execute()", "Updating attribute HSI variant.");
        }
        this.updateAttributeHSI_Variant(upgradePackagesInfoContainer.getUpgradePackageShadowDatas());
        if (upgradePackagesInfoContainer.isAllLM_InfoProperlyCollected()) {
            if (Trace.valid(this.getClass(), 22)) {
                MessageLog.info(this.getClass(), (String)"execute() - Removal of not needed LM MOs (that is not installed and does not belong to an UP");
            }
            this.deleteNotInstalledLoadModuleMosNotUsed(upgradePackagesInfoContainer.getNotInstalledLoadModuleMosNotUsed());
        }
        if (Trace.valid(this.getClass(), 22)) {
            Trace.debug(this.getClass(), 22, "execute()", "Deleting ObsoleteLmUp information if exist.");
        }
        new ObsoleteLmUpHandler().deleteExistingObsoleteLmUP_Info(upgradePackagesInfoContainer.getProductDataContainerForObsoleteUP());
        if (Trace.valid(this.getClass(), 22)) {
            MessageLog.info(this.getClass(), (String)"start() - Update states in all PiuType's...");
        }
        PiuTypeInstallStateSupervisor piuTypeInstallStateSupervisor = (PiuTypeInstallStateSupervisor)ServiceLocatorFacade.getRepository().getService(PiuTypeInstallStateSupervisor.class);
        if (this.theCurrentActiveUpMoControlFileExists) {
            piuTypeInstallStateSupervisor.updatePiuTypeLoadModuleInstallState(true);
            piuTypeInstallStateSupervisor.addAsListener();
            ServiceLocatorFacade.getRepository().addService((Object)piuTypeInstallStateSupervisor, PiuTypeInstallStateSupervisor.class, null);
        } else {
            Trace.info(this.getClass(), "startUpMos()", "UpdatePiuTypeLoadModuleInstallState is not done during startUp to avoid some exceptions when upgradecontrolfile(.xml) is missing for Active UP.");
        }
        if (Trace.valid(this.getClass(), 22)) {
            MessageLog.info(this.getClass(), (String)"start() - CV Pre upgrade handling...");
        }
        CV_PreUpgradeRelationHandler.getInstance();
    }

    private void handleEmptyUpDirs(Collection collection) {
        if (!collection.isEmpty()) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                Trace.warning(this.getClass(), "handleEmptyUpDirs(Collection aDirsWithoutUCFs)", "The Upgrade Package directory " + string + "/" + " do not have any UCFs present i.e. this UP will not be visible in the MO layer.");
            }
        }
    }

    private void prepareActiveUcfInCaseRestoreInProgress() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "prepareActiveUcfInCaseRestoreInProgress()");
        }
        try {
            ServiceDecider serviceDecider = new ServiceDecider();
            if (serviceDecider.isAnyRestoreServiceInProgress(ServiceFinder.getConfigurationVersionMO_HandlerInterface().getCvMo())) {
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "prepareActiveUcfInCaseRestoreInProgress()", "Restore service is in progress i.e. auto merge is needed");
                }
                RestoreProperties restoreProperties = new RestoreProperties();
                String string = restoreProperties.cvCMA_FileDisk + restoreProperties.getCV_RestoreFilesPath();
                AutoMerger autoMerger = new AutoMerger();
                autoMerger.execute(string);
            }
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "prepareActiveUcfInCaseRestoreInProgress()", "Failed to execute the merge of a potential active delta UP that may result in failure when reading attribute values from Repertoire, PiuType and SubrackProdType MOs", throwable);
        }
    }

    private void prepareSU_DOM() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "prepareSU_DOM()");
        }
        try {
            MoFactory moFactory = MoFactoryMgr.instance().lookup("SubrackProdType");
            MoFactory moFactory2 = MoFactoryMgr.instance().lookup("Repertoire");
            MoFactory moFactory3 = MoFactoryMgr.instance().lookup("PiuType");
            MoFactory moFactory4 = MoFactoryMgr.instance().lookup("SwAllocation");
            if (SU_AccessVersionHandler.getInstance().isSupported("SU_4", (Object)moFactory) && SU_AccessVersionHandler.getInstance().isSupported("SU_2", (Object)moFactory2) && SU_AccessVersionHandler.getInstance().isSupported("SU_3", (Object)moFactory3) && SU_AccessVersionHandler.getInstance().isSupported("SU_2", (Object)moFactory4)) {
                Object object;
                UpgradePackageMoExtended upgradePackageMoExtended = ServiceFinder.getConfigurationVersionMO_HandlerInterface().getCurrentUpgradePackage(null);
                if (UpgradeDB_StorageUtil.isNewActiveUP_Existing()) {
                    object = ServiceFinder.getUpgradePackageMO_HandlerInterface().getUpgradePackageMo(UpgradeDB_StorageUtil.getNewActiveUP_ProductNumber(), UpgradeDB_StorageUtil.getNewActiveUP_ProductRevision());
                    if (object != null) {
                        upgradePackageMoExtended = object;
                        Trace.info(this.getClass(), "prepareSU_DOM()", "Using a new active UP instead of the current active UP i.e. probably due to replaceconfigsupportmos has been executed\n\ttheNewActiveUP_MO: " + object);
                    }
                } else if (Trace.valid(this.getClass(), 20)) {
                    Trace.debug(this.getClass(), 20, "prepareSU_DOM()", "Using current active UP a SU DOM");
                }
                object = new ProxySelector(upgradePackageMoExtended);
                ServiceLocatorFacade.getRepository().addService(object, ProxySelectorEquInterface.class, null);
                ServiceLocatorFacade.getRepository().addService(object, ProxySelectorSwmInterface.class, null);
                ServiceLocatorFacade.getRepository().addService(object, ProxySelectorInterface.class, null);
            } else if (Trace.valid(this.getClass(), 20)) {
                Trace.debug(this.getClass(), 20, "prepareSU_DOM()", "The CMA environment do not support UDT feature");
            }
        }
        catch (ConfigurationVersionMO_HandlerException configurationVersionMO_HandlerException) {
            Trace.info(this.getClass(), "prepareSU_DOM()", "Failed to prepare the SU DOM. This may lead to errors at e.g. read of MO attributes from MO types PiuType, SubrackProdType or Repertoire");
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "prepareSU_DOM()", "Failed to prepare the SU DOM. This may lead to errors at e.g. read of MO attributes from MO types PiuType, SubrackProdType or Repertoire", throwable);
        }
    }

    private void updateAttributeHSI_Variant(Collection collection) {
        block9: {
            if (Trace.valid(this.getClass(), 20)) {
                Trace.debug(this.getClass(), 20, "updateAttributeHSI_Variant(Collection anUpgradePackageShadowDatas)", "anUpgradePackageShadowDatas: " + collection);
            }
            UpgradePackageShadowData upgradePackageShadowData = null;
            try {
                Iterator iterator = collection.iterator();
                UpgradePackageMoExtended upgradePackageMoExtended = null;
                UpgradePackageMO_HandlerInterface upgradePackageMO_HandlerInterface = ServiceFinder.getUpgradePackageMO_HandlerInterface();
                while (iterator.hasNext()) {
                    upgradePackageShadowData = (UpgradePackageShadowData)iterator.next();
                    upgradePackageMoExtended = upgradePackageMO_HandlerInterface.getUpgradePackageMo(upgradePackageShadowData.getProductData().getNumber(), upgradePackageShadowData.getProductData().getRevision());
                    if (upgradePackageMoExtended != null) {
                        if (upgradePackageShadowData.isNSI_ElementsPresent()) {
                            upgradePackageMoExtended.setNSI_ElementsPresent(NSI_ElementPresentEnum.YES);
                        } else {
                            upgradePackageMoExtended.setNSI_ElementsPresent(NSI_ElementPresentEnum.NO);
                        }
                        ActualTypeOfUP actualTypeOfUP = ActualTypeOfUP.getInstance(upgradePackageMoExtended.getActualTypeOfUP(null));
                        if (actualTypeOfUP.isHW_Sensitive()) {
                            if (upgradePackageShadowData.isNSI_ElementsPresent()) {
                                upgradePackageMoExtended.setHsiVariant(HSI_VariantEnum.NSI);
                                continue;
                            }
                            upgradePackageMoExtended.setHsiVariant(HSI_VariantEnum.HSI);
                            continue;
                        }
                        upgradePackageMoExtended.setHsiVariant(HSI_VariantEnum.NOT_VALID);
                        continue;
                    }
                    if (!Trace.valid(this.getClass(), 22)) continue;
                    Trace.debug(this.getClass(), 22, "updateAttributeHSI_Variant(Collection anUpgradePackageShadowDatas)", "Could not update the attribute HsiVariant due to no Instance of UP Mo was found for the product data: " + upgradePackageShadowData.getProductData());
                }
            }
            catch (Throwable throwable) {
                if (!Trace.valid(this.getClass(), 22)) break block9;
                Trace.debug(this.getClass(), 22, "updateAttributeHSI_Variant(Collection anUpgradePackageShadowDatas)", "Failed to update the attribute HsiVariant in the Upgrade Package Mo (ignored)theUpgradePackageShadowData: " + upgradePackageShadowData);
            }
        }
    }

    private void startUP_MOs(UpgradePackageMoExtended upgradePackageMoExtended) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "startUpMos()");
        }
        try {
            MoIterator moIterator = MoRepository.instance().lookupType("UpgradePackage");
            if (moIterator != null) {
                while (moIterator.hasMoreElements()) {
                    UpgradePackageMoImpl upgradePackageMoImpl = (UpgradePackageMoImpl)moIterator.nextMo();
                    if (upgradePackageMoImpl == null) continue;
                    File file = new File(upgradePackageMoImpl.getUpgradeControlFilePath(null));
                    File file2 = new File(upgradePackageMoImpl.getOriginalUpgradeControlFilePath(null));
                    if (upgradePackageMoExtended != null && upgradePackageMoImpl.getLocalDistinguishedName().equals(upgradePackageMoExtended.getLocalDistinguishedName())) {
                        if (!file.exists() || !file2.exists()) {
                            ((UpgradePackageMoImpl)upgradePackageMoExtended).raiseFileErrorAlarm();
                        }
                        if (!file.exists()) {
                            this.theCurrentActiveUpMoControlFileExists = false;
                        }
                    }
                    if (!(upgradePackageMoExtended == null || file.exists() || file2.exists() || upgradePackageMoImpl.getLocalDistinguishedName().equals(upgradePackageMoExtended.getLocalDistinguishedName()))) {
                        Trace.info(this.getClass(), "startUP_MOs(UpgradePackageMoExtended aUpgradePackageMoExtendedActiveUp)", "Deleting not active UpgradePackageMo from Data Base," + upgradePackageMoImpl.getLocalDistinguishedName() + " as it is not having both upgrade control files" + "\n\tfile " + file2.toString() + " found: " + file2.exists() + "\n\tfile " + file.toString() + " found: " + file.exists());
                        upgradePackageMoImpl.deleteAndRemoveInstance();
                        continue;
                    }
                    upgradePackageMoImpl.start();
                }
            }
        }
        catch (Exception exception) {
            Trace.error(this.getClass(), "startUpMos()", "Exception caught when trying to start all UpgradePackage MO's", exception);
        }
    }

    private void createShadowUPs(Collection collection) {
        if (Trace.valid(this.getClass(), 22)) {
            Trace.debug(this.getClass(), 22, "createShadowUPs(Collection anUpgradePackageShadowDatas)", "anUpgradePackageShadowDatas: " + collection + "\n\tDetermining whether or or not shadow Upgrade Package MO's needs to be created");
        }
        Control control = null;
        try {
            TransactionFactory transactionFactory = TransactionServiceImpl.instance().getTransactionFactory();
            control = transactionFactory.create(3600);
            Coordinator coordinator = control.getCoordinator();
            UpgradePackageShadowCreator.createNeededShadowUpgradePackages(coordinator, collection);
            control.getTerminator().commit();
        }
        catch (Exception exception) {
            Trace.error(this.getClass(), "createShadowUPs(Collection anUpgradePackageShadowDatas)", "Exception caught when trying to create UpgradePackage MO's for 'virtual' upgrade packages\n\t('virtual' = upgrade packages that exist on disk but not as MO's in current CV).", exception);
            try {
                if (control != null) {
                    control.getTerminator().rollback();
                }
            }
            catch (Exception exception2) {
                Trace.error(this.getClass(), "createShadowUPs(Collection anUpgradePackageShadowDatas)", "Exception caught when trying to rollback the transaction after failing to create UpgradePackage MO's for 'virtual' upgrade packages.", exception2);
            }
        }
    }

    private void deleteNotInstalledLoadModuleMosNotUsed(Collection collection) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "deleteNotInstalledLoadModuleMosNotUsed(Collection aNotInstalledLoadModuleMosNotUsed)", "aNotInstalledLoadModuleMosNotUsed: " + collection);
        }
        if (collection.isEmpty()) {
            return;
        }
        Control control = null;
        try {
            TransactionFactory transactionFactory = TransactionServiceImpl.instance().getTransactionFactory();
            control = transactionFactory.create(3600);
            Coordinator coordinator = control.getCoordinator();
            LoadModuleMoSU_Access loadModuleMoSU_Access = null;
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                loadModuleMoSU_Access = (LoadModuleMoSU_Access)iterator.next();
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "deleteNotInstalledLoadModuleMosNotUsed(Collection aNotInstalledLoadModuleMosNotUsed)", "Deleting LoadModule MO: " + loadModuleMoSU_Access);
                }
                loadModuleMoSU_Access.deleteMO(coordinator);
            }
            control.getTerminator().commit();
        }
        catch (Exception exception) {
            Trace.error(this.getClass(), "deleteNotInstalledLoadModuleMosNotUsed(Collection aNotInstalledLoadModuleMosNotUsed)", "Exception caught when trying to delete LoadModules MOs that are not needed.\n\t(LoadModule MOs with fileState not installed and not included in any UCF.)", exception);
            try {
                if (control != null) {
                    control.getTerminator().rollback();
                }
            }
            catch (Exception exception2) {
                Trace.error(this.getClass(), "deleteNotInstalledLoadModuleMosNotUsed(Collection aNotInstalledLoadModuleMosNotUsed)", "Exception caught when trying to rollback the transaction after failing to create UpgradePackage MO's for 'virtual' upgrade packages.", exception2);
            }
        }
    }
}

