/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.su.convert.base;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import se.ericsson.cello.su.convert.base.ConverterState;
import se.ericsson.cello.su.convert.base.ConverterStepBase;
import se.ericsson.cello.su.convert.base.UpgradeConvertFileInfoContainer;
import se.ericsson.cello.su.convert.base.UpgradeConvertMoClassAndStepInfoConstants;
import se.ericsson.cello.su.convert.base.UpgradeConvertStepInfoContainer;
import se.ericsson.cello.su.convert.exception.SuConvertActionException;
import se.ericsson.cello.su.convert.exception.SuConvertFileHandlerException;
import se.ericsson.cello.su.convert.file.handler.UnConvertFileHandler;
import se.ericsson.cello.upgradepackage.trace.Trace;

public class UpgradeConvertStepCollector {
    private static final Integer ZERO_REVISION = new Integer(0);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Collection getConvertStepsToBeExecuted(UpgradeConvertStepInfoContainer upgradeConvertStepInfoContainer) throws SuConvertActionException {
        LinkedList<Object> linkedList;
        block14: {
            Object object;
            block13: {
                if (Trace.valid(this.getClass(), 20)) {
                    Trace.debug(this.getClass(), 20, "getConvertStepsToBeExecuted(ConvertStepInfoContainer aConvertStepInfoContainer)", "aConvertStepInfoContainer: " + upgradeConvertStepInfoContainer);
                }
                linkedList = new LinkedList<Object>();
                Collection collection = null;
                if (UpgradeConvertFileInfoContainer.getConverterState().equals(ConverterState.RESTORE)) {
                    try {
                        if (Trace.valid(this.getClass(), 22)) {
                            Trace.debug(this.getClass(), 22, "getConvertStepsToBeExecuted(ConvertStepInfoContainer aConvertStepInfoContainer)", "ConverterState is Restore , get the ConvertSteps from UnConvert file.");
                        }
                        object = new UnConvertFileHandler(UpgradeConvertFileInfoContainer.getUnConvertFileDirPath(), UpgradeConvertFileInfoContainer.getUnConvertFileName());
                        collection = ((UnConvertFileHandler)object).getUnConvertSteps();
                    }
                    catch (SuConvertFileHandlerException suConvertFileHandlerException) {
                        throw new SuConvertActionException("Exception caught when trying to get UnConvert information from file. Exception info: " + suConvertFileHandlerException);
                    }
                } else {
                    if (Trace.valid(this.getClass(), 22)) {
                        Trace.debug(this.getClass(), 22, "getConvertStepsToBeExecuted(ConvertStepInfoContainer aConvertStepInfoContainer)", "ConverterState is either Upgrade or PreUpgrade, get the ConvertSteps from code.");
                    }
                    collection = UpgradeConvertMoClassAndStepInfoConstants.getSuConvertSteps();
                }
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "getConvertStepsToBeExecuted(ConvertStepInfoContainer aConvertStepInfoContainer)", "theAllConvertSteps: " + collection);
                }
                if ((object = this.getConvertStep(collection, upgradeConvertStepInfoContainer.moDataType, upgradeConvertStepInfoContainer.oldMoDataVersion)) != null) break block13;
                if (upgradeConvertStepInfoContainer.oldMoDataVersion.equals(ZERO_REVISION)) {
                    if (Trace.valid(this.getClass(), 22)) {
                        Trace.debug(this.getClass(), 22, "getConvertStepsToBeExecuted(ConvertStepInfoContainer aConvertStepInfoContainer)", "From revision for MoType is ZERO, i.e. new SU MO type that will not be autocreated during convert.\n\tMoType: " + upgradeConvertStepInfoContainer.moDataType);
                    }
                    break block14;
                } else {
                    Class clazz;
                    Trace.error(UpgradeConvertStepCollector.class, "getConvertStepsToBeExecuted(ConvertStepInfoContainer aConvertStepInfoContainer)", "Could not find a ConvertAction with supported from state.\n\taTypeName: " + upgradeConvertStepInfoContainer.moDataType + "\n\taFromVersion: " + upgradeConvertStepInfoContainer.oldMoDataVersion);
                    StringBuffer stringBuffer = new StringBuffer().append("Class: ");
                    if (class$se$ericsson$cello$su$convert$base$UpgradeConvertStepCollector == null) {
                        clazz = class$se$ericsson$cello$su$convert$base$UpgradeConvertStepCollector = UpgradeConvertStepCollector.class$("se.ericsson.cello.su.convert.base.UpgradeConvertStepCollector");
                        throw new SuConvertActionException(stringBuffer.append(clazz).append("\n\tMethod: getConvertStepsToBeExecuted(String aTypeName, Integer aFromVersion, Integer aToVersion)").append("\n\tCould not find a ConvertAction with supported from state.").append("\n\taTypeName: ").append(upgradeConvertStepInfoContainer.moDataType).append("\n\taFromVersion: ").append(upgradeConvertStepInfoContainer.oldMoDataVersion).toString());
                    }
                    clazz = class$se$ericsson$cello$su$convert$base$UpgradeConvertStepCollector;
                    throw new SuConvertActionException(stringBuffer.append(clazz).append("\n\tMethod: getConvertStepsToBeExecuted(String aTypeName, Integer aFromVersion, Integer aToVersion)").append("\n\tCould not find a ConvertAction with supported from state.").append("\n\taTypeName: ").append(upgradeConvertStepInfoContainer.moDataType).append("\n\taFromVersion: ").append(upgradeConvertStepInfoContainer.oldMoDataVersion).toString());
                }
            }
            linkedList.add(object);
            if (!((ConverterStepBase)object).toVersion.equals(upgradeConvertStepInfoContainer.newMoDataVersion)) {
                UpgradeConvertStepInfoContainer upgradeConvertStepInfoContainer2 = new UpgradeConvertStepInfoContainer(upgradeConvertStepInfoContainer.moDataType, ((ConverterStepBase)object).toVersion, upgradeConvertStepInfoContainer.newMoDataVersion);
                linkedList.addAll(this.getConvertStepsToBeExecuted(upgradeConvertStepInfoContainer2));
            }
        }
        if (!Trace.valid(this.getClass(), 21)) return linkedList;
        Trace.debug(UpgradeConvertStepCollector.class, 21, "getConvertSteps(String aTypeName, Integer aFromVersion, Integer aToVersion)", "Returning - theConvertStepsToBeExecuted: " + linkedList);
        return linkedList;
    }

    private ConverterStepBase getConvertStep(Collection collection, String string, Integer n) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getConvertStep(Collection aConvertActions, String aTypeName, Integer aFromVersion)", "aConvertActions: " + collection + "\n\taTypeName: " + string + "\n\taFromVersion: " + n);
        }
        ConverterStepBase converterStepBase = null;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            converterStepBase = (ConverterStepBase)iterator.next();
            if (converterStepBase.typeName.equals(string) && converterStepBase.fromVersion.equals(n)) break;
            converterStepBase = null;
        }
        if (Trace.valid(this.getClass(), 21)) {
            Trace.debug(UpgradeConvertStepCollector.class, 21, "getConvertStep(String aTypeName, Integer aFromVersion)", "Returning - theSU_ConvertAction: " + converterStepBase);
        }
        return converterStepBase;
    }
}

