/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.su.extsuif.upgradepackage.util.time;

import java.util.Vector;
import se.ericsson.cello.mao.UpgradeTrace;
import se.ericsson.cello.su.extsuif.upgradepackage.util.time.TimerEvent;
import se.ericsson.cello.su.extsuif.upgradepackage.util.time.TimerListener;

public class Timer
implements Runnable {
    private long myDuration = 0L;
    private long myTimeToSleep = 0L;
    private Vector myListeners = null;
    private boolean myContinueSleeping = false;
    private int myAccuracy = 1000;
    private Thread myThread = null;

    public Timer(int n) {
        this((long)n);
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"Timer(int aDuration)", (String)("\n\taDuration: " + n));
        }
    }

    public Timer(long l) {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"Timer(long aDuration)", (String)("\n\taDuration: " + l));
        }
        this.myDuration = l;
        this.myListeners = new Vector();
    }

    public void addListener(TimerListener timerListener) {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"addListener(TimerListener aListener)", (String)("\n\taListener: " + timerListener));
        }
        this.myListeners.addElement(timerListener);
    }

    public void removeListener(TimerListener timerListener) {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"removeListener(TimerListener aListener)", (String)("\n\taListener: " + timerListener));
        }
        this.myListeners.removeElement(timerListener);
    }

    public void run() {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"run ()");
        }
        this.updateDurationTime(this.myDuration);
        if (UpgradeTrace.valid(this.getClass(), (int)27)) {
            UpgradeTrace.debug(this.getClass(), (int)27, (String)"run ()", (String)("Starting a time supervision on " + this.myTimeToSleep + "ms." + "\n\tmyContinueSleeping: " + this.myContinueSleeping));
        }
        while (this.myContinueSleeping) {
            try {
                Thread.sleep(this.myAccuracy);
            }
            catch (Throwable throwable) {
                UpgradeTrace.error(this.getClass(), (String)"run ()", (String)("Throwable caught when trying to sleep.\n\tmyDuration: " + this.myDuration + "\n\tmyContinueSleeping: " + this.myContinueSleeping + "\n\tmyTimeToSleep: " + this.myTimeToSleep), (Throwable)throwable);
            }
            this.updateDurationTime(this.myTimeToSleep - (long)this.myAccuracy);
            if (this.myTimeToSleep > 0L) continue;
            this.setContinueSleeping(false);
            this.myThread = null;
        }
        this.notifyListeners();
        if (UpgradeTrace.valid(this.getClass(), (int)27)) {
            UpgradeTrace.debug(this.getClass(), (int)27, (String)"run ()", (String)"Thread for supervision of SU Events is stopped.");
        }
    }

    public synchronized void updateDurationTime(long l) {
        this.myTimeToSleep = l;
    }

    public void startTimer() {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"startTimer ()");
        }
        if (this.myThread == null) {
            this.setContinueSleeping(true);
            this.myThread = new Thread((Runnable)this, "SUDOM_EventSupervisionTimer");
            this.myThread.start();
        }
    }

    public synchronized void stopTimer() {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"stopTimer ()");
        }
        if (this.myContinueSleeping) {
            this.setContinueSleeping(false);
        }
    }

    private void notifyListeners() {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"notifyListeners ()");
        }
        TimerEvent timerEvent = new TimerEvent(this);
        Vector vector = (Vector)this.myListeners.clone();
        for (int i = 0; i < vector.size(); ++i) {
            ((TimerListener)vector.elementAt(i)).timerAction(timerEvent);
        }
    }

    private synchronized void setContinueSleeping(boolean bl) {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"setContinueSleeping(boolean aContinueSleeping)", (String)("\n\taContinueSleeping: " + bl));
        }
        this.myContinueSleeping = bl;
    }

    public static void sleep(int n) {
        try {
            Thread.sleep(n);
        }
        catch (Throwable throwable) {
            UpgradeTrace.log1((Class)Timer.class, (String)"sleep(int aMilliSeconds)", (String)("Failed to sleep specified intervall " + n + " ms."));
        }
    }
}

