/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.su.froproxy.cv;

import enea.ose.io.SignalOutputStream;
import enea.ose.system.UnlinkedSignal;
import se.ericsson.cello.mao.MaoFroTypeConverter;
import se.ericsson.cello.upgradepackage.trace.Trace;

public class OsaCvFileRsp
extends UnlinkedSignal {
    public static final int SIGNO = 68941;
    private int myFileNumber = -1;
    private boolean myIsLast = false;
    private int myDataLength = -1;
    private String myData = null;

    public OsaCvFileRsp() {
        super(68941);
    }

    public OsaCvFileRsp(int n, boolean bl, String string) {
        super(68941);
        this.myFileNumber = n;
        this.myIsLast = bl;
        this.myDataLength = string.length();
        this.myData = string;
    }

    public int getSignalNumber() {
        return 68941;
    }

    public int getFileNumber() {
        return this.myFileNumber;
    }

    public boolean isLast() {
        return this.myIsLast;
    }

    public int getDataLength() {
        return this.myDataLength;
    }

    public String getData() {
        return this.myData;
    }

    protected void initReceive() {
    }

    protected void initSend() {
        if (Trace.valid(((Object)((Object)this)).getClass(), 20)) {
            Trace.debug(((Object)((Object)this)).getClass(), 20, "initSend()", "myFileNumber: " + this.myFileNumber + "\n\tmyIsLast: " + this.myIsLast + "\n\tmyDataLength: " + this.myDataLength + "\n\tmyData: " + this.myData);
        }
        SignalOutputStream signalOutputStream = this.getSignalOutputStream();
        try {
            signalOutputStream.writeU32((long)this.myFileNumber);
            int n = 1;
            if (!this.myIsLast) {
                n = 0;
            }
            signalOutputStream.writeU32((long)n);
            signalOutputStream.writeU32((long)this.myDataLength);
            byte[] byArray = MaoFroTypeConverter.string2byteArray((String)this.myData, (int)16000);
            signalOutputStream.writeS8Array(byArray);
            if (Trace.valid(((Object)((Object)this)).getClass(), 20)) {
                String string = "";
                for (int i = 0; i < byArray.length; ++i) {
                    string = string + byArray[i] + "*";
                }
                Trace.debug(((Object)((Object)this)).getClass(), 20, "initSend()", "myData: " + this.myData + "\n\tbyte[]: " + string);
            }
            signalOutputStream.flush();
        }
        catch (Throwable throwable) {
            Trace.error(((Object)((Object)this)).getClass(), "initSend( )", "Sending CV FRO req failed", throwable);
        }
    }
}

