/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.su.swproductinventory.control;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Enumeration;
import java.util.Properties;
import se.ericsson.cello.su.swproductinventory.control.SwPiPropFileHandlerException;
import se.ericsson.cello.upgradepackage.trace.Trace;
import se.ericsson.cello.upgradepackage.trace.TraceProperties;
import se.ericsson.cello.upgradepackage.util.library.SuLib;

public class SW_ProductInventoryInfoFileHandler {
    private static String mySwPiInfoDirPath = TraceProperties.getRootDirectoryPath() + "systemfiles/cello/cma/su/swpi/";
    private static String mySwPiInfoFileName = "suswpi.info";
    private static String myTotalFilePath = mySwPiInfoDirPath + mySwPiInfoFileName;
    private static Properties mySavedSwPiProperties = new Properties();

    public static void createSwPiInfoFileDir() throws SwPiPropFileHandlerException {
        if (Trace.valid(SW_ProductInventoryInfoFileHandler.class, 20)) {
            Trace.debug(SW_ProductInventoryInfoFileHandler.class, 20, "createSwPiInfoFileDir()");
        }
        if (SW_ProductInventoryInfoFileHandler.isRunningInSimCelloEnvironment()) {
            if (Trace.valid(SW_ProductInventoryInfoFileHandler.class, 22)) {
                Trace.debug(SW_ProductInventoryInfoFileHandler.class, 22, "createSwPiInfoFileDir()", "Running in SimCello environment, will not create the SW PI information file directory and file.");
            }
            return;
        }
        try {
            File file = new File(mySwPiInfoDirPath);
            if (!file.exists() && !file.mkdir()) {
                throw new SwPiPropFileHandlerException("Failed to create the directory " + mySwPiInfoDirPath + "for the SW product inventory property file! (mkdir returned false)");
            }
        }
        catch (Throwable throwable) {
            throw new SwPiPropFileHandlerException("Failed to create the directory " + mySwPiInfoDirPath + " for the SW product inventory property file, throwable caught." + "throwable: " + throwable);
        }
    }

    public static void printInfoToFileIfNeeded(Properties properties) throws SwPiPropFileHandlerException {
        if (Trace.valid(SW_ProductInventoryInfoFileHandler.class, 20)) {
            Trace.debug(SW_ProductInventoryInfoFileHandler.class, 20, "printInfoToFileIfNeeded(Properties aProperties)aProperties: " + properties);
        }
        if (SW_ProductInventoryInfoFileHandler.isRunningInSimCelloEnvironment() || properties.isEmpty() || !SW_ProductInventoryInfoFileHandler.hasCurrentInfoChanged(properties)) {
            return;
        }
        SW_ProductInventoryInfoFileHandler.createSwPiInfoFileDir();
        File file = new File(mySwPiInfoDirPath + mySwPiInfoFileName);
        SW_ProductInventoryInfoFileHandler.printInfoToFile(file, properties);
        mySavedSwPiProperties = properties;
    }

    public static Properties getSwProductInventoryInfoFromFile() throws SwPiPropFileHandlerException {
        if (Trace.valid(SW_ProductInventoryInfoFileHandler.class, 20)) {
            Trace.debug(SW_ProductInventoryInfoFileHandler.class, 20, "getSwProductInventoryInfoFromFile()");
        }
        return SW_ProductInventoryInfoFileHandler.getSavedSwPiProperties();
    }

    public static void deleteSwPiInformationFile() throws SwPiPropFileHandlerException {
        File file;
        if (Trace.valid(SW_ProductInventoryInfoFileHandler.class, 20)) {
            Trace.debug(SW_ProductInventoryInfoFileHandler.class, 20, "deleteSwPiInformationFile()");
        }
        if (!SW_ProductInventoryInfoFileHandler.isRunningInSimCelloEnvironment() && (file = SW_ProductInventoryInfoFileHandler.getSwPiInfoFile()) != null && !file.delete()) {
            throw new SwPiPropFileHandlerException("The call to method delete on object File returned false, i.e. failed to delete the SW Inventory information file correctly.");
        }
        mySavedSwPiProperties = new Properties();
    }

    private static Properties getSavedSwPiProperties() throws SwPiPropFileHandlerException {
        File file;
        if (mySavedSwPiProperties.isEmpty() && (file = SW_ProductInventoryInfoFileHandler.getSwPiInfoFile()) != null) {
            mySavedSwPiProperties = SW_ProductInventoryInfoFileHandler.extractInfoFromFile(file);
        }
        if (Trace.valid(SW_ProductInventoryInfoFileHandler.class, 21)) {
            Trace.debug(SW_ProductInventoryInfoFileHandler.class, 21, "getSavedSwPiProperties()", "Returning - mySavedSwPiProperties: " + mySavedSwPiProperties);
        }
        return mySavedSwPiProperties;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void printInfoToFile(File file, Properties properties) throws SwPiPropFileHandlerException {
        if (Trace.valid(SW_ProductInventoryInfoFileHandler.class, 20)) {
            Trace.debug(SW_ProductInventoryInfoFileHandler.class, 20, "printInfoToFile(File aSwPiPropFile, Properties aPropertiesTable)", "aSwPiPropFile: " + file + "\n\taPropertiesTable: " + properties);
        }
        String string = null;
        String string2 = null;
        Properties properties2 = new Properties();
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            string2 = (String)properties.get(string);
            properties2.setProperty(string, string2);
        }
        FileOutputStream fileOutputStream = null;
        try {
            try {
                fileOutputStream = new FileOutputStream(file);
                properties2.store(fileOutputStream, "Auto Store Of SU SW ProductInventory Information.");
                fileOutputStream.close();
            }
            catch (Throwable throwable) {
                throw new SwPiPropFileHandlerException("Could not store the SW Product Inventory information to the " + myTotalFilePath + " file, throwable caught." + " Throwable: " + throwable);
            }
            Object var9_7 = null;
        }
        catch (Throwable throwable) {
            Object var9_8 = null;
            try {
                if (fileOutputStream == null) throw throwable;
                fileOutputStream.close();
                throw throwable;
            }
            catch (Throwable throwable2) {
                throw new SwPiPropFileHandlerException("Failed to close the handle to the " + myTotalFilePath + " file, throwable caught." + " Throwable: " + throwable2);
            }
        }
        try {}
        catch (Throwable throwable) {
            throw new SwPiPropFileHandlerException("Failed to close the handle to the " + myTotalFilePath + " file, throwable caught." + " Throwable: " + throwable);
        }
        if (fileOutputStream == null) return;
        fileOutputStream.close();
    }

    private static boolean hasCurrentInfoChanged(Properties properties) throws SwPiPropFileHandlerException {
        Properties properties2 = SW_ProductInventoryInfoFileHandler.getSavedSwPiProperties();
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = properties2.getProperty(string);
            String string3 = properties.getProperty(string);
            if (!(string3 != null ? !string3.equals(string2) : string2 != null)) continue;
            return true;
        }
        return false;
    }

    /*
     * Loose catch block
     */
    private static Properties extractInfoFromFile(File file) throws SwPiPropFileHandlerException {
        Properties properties;
        block10: {
            if (Trace.valid(SW_ProductInventoryInfoFileHandler.class, 20)) {
                Trace.debug(SW_ProductInventoryInfoFileHandler.class, 20, "extractInfoFromFile(File aSwPiPropFile)", "aSwPiPropFile: " + file);
            }
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream(file);
            }
            catch (Throwable throwable) {
                throw new SwPiPropFileHandlerException("Failed to open the " + file.getAbsolutePath() + " file due to throwable caught." + "\n\tThrowable: " + throwable);
            }
            properties = new Properties();
            properties.load(fileInputStream);
            Object var5_4 = null;
            try {
                fileInputStream.close();
            }
            catch (Throwable throwable) {
                Trace.error(SW_ProductInventoryInfoFileHandler.class, "extractInfoFromFile(File aSwPiPropFile)", "Failed to close the stream to the " + myTotalFilePath + " file, throwable caught.", throwable);
            }
            break block10;
            {
                catch (Throwable throwable) {
                    throw new SwPiPropFileHandlerException("Failed to extract the information from the " + myTotalFilePath + " file, throwable caught." + "\n\tThrowable: " + throwable);
                }
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                try {
                    fileInputStream.close();
                }
                catch (Throwable throwable2) {
                    Trace.error(SW_ProductInventoryInfoFileHandler.class, "extractInfoFromFile(File aSwPiPropFile)", "Failed to close the stream to the " + myTotalFilePath + " file, throwable caught.", throwable2);
                }
                throw throwable;
            }
        }
        return properties;
    }

    private static File getSwPiInfoFile() throws SwPiPropFileHandlerException {
        if (Trace.valid(SW_ProductInventoryInfoFileHandler.class, 20)) {
            Trace.debug(SW_ProductInventoryInfoFileHandler.class, 20, "getSwPiInfoFile()");
        }
        File file = null;
        if (!SW_ProductInventoryInfoFileHandler.isRunningInSimCelloEnvironment() && !(file = new File(myTotalFilePath)).exists()) {
            file = null;
        }
        return file;
    }

    private static boolean isRunningInSimCelloEnvironment() {
        return System.getProperty("SIM") != null && !SuLib.isSU_SIM();
    }
}

