/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.su.xmlparser.base;

import java.util.StringTokenizer;
import org.xml.sax.Locator;
import se.ericsson.cello.configurationversion.file.base.IllegalAttributeIP_AddressValueException;
import se.ericsson.cello.configurationversion.file.nodeipdata.parser.IP_AddressIP_AddressValue;
import se.ericsson.cello.su.xmlparser.base.IllegalAttributeValueException;
import se.ericsson.cello.su.xmlparser.base.ValidateException;
import se.ericsson.cello.sudom.parser.dom.util.locator.LocatorProxy;
import se.ericsson.cello.upgradepackage.trace.Trace;
import se.ericsson.cello.upgradepackage.util.library.SuLib;

public abstract class AttributeValue {
    protected static boolean validate(String string, String[] stringArray) {
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (!string.equalsIgnoreCase(stringArray[i])) continue;
                return true;
            }
        }
        return false;
    }

    public static void errorIllegalAttributeValue(Class clazz, String string, String string2, String string3, String string4, String string5, String[] stringArray, Locator locator) throws ValidateException {
        String string6 = "XML file " + string2 + "," + "\n\tillegal attribute value: " + string4 + " = \"" + string5 + "\"" + " found in element of type " + string3 + "." + "\n\tAllowed values: " + SuLib.toString(stringArray);
        Trace.error(clazz, string, string6 + "\n\taLocator: " + LocatorProxy.getLocatorInfo(locator));
        throw new IllegalAttributeValueException(string6, locator);
    }

    public static void illegalAttributeValue(Class clazz, String string, String string2, String string3, String string4, String string5, String[] stringArray, Locator locator) throws ValidateException {
        String string6 = "XML file " + string2 + "," + "\n\tillegal attribute value: " + string4 + " = \"" + string5 + "\"" + " found in element of type " + string3 + "." + "\n\tAllowed values: " + SuLib.toString(stringArray);
        throw new IllegalAttributeValueException(string6, locator);
    }

    public static void warningIllegalAttributeValue(Class clazz, String string, String string2, String string3, String string4, String string5, String[] stringArray, Locator locator) throws ValidateException {
        String string6 = "XML file " + string2 + "," + "\n\tunknown attribute value: " + string4 + " = \"" + string5 + "\"" + " found in element of type " + string3 + "." + "\n\tKnown values: " + SuLib.toString(stringArray);
        Trace.warning(clazz, string, string6 + "\n\taLocator: " + LocatorProxy.getLocatorInfo(locator));
    }

    protected static void validateIP_Address(Class clazz, String string, String string2, String string3, String string4, String string5, Locator locator) throws ValidateException {
        try {
            StringTokenizer stringTokenizer;
            if (string5 == null) {
                AttributeValue.log_IllegalIP_AddressValue(clazz, string, string2, string3, string4, null, "Format x.x.x.x where x may be 0-255.", locator);
            }
            if ((stringTokenizer = new StringTokenizer(string5, ".")).countTokens() != 4) {
                AttributeValue.errorIllegalIP_AddressValue(clazz, string, string2, string3, string4, string5, "Format x.x.x.x where x may be 0-255.", locator);
            }
            String string6 = null;
            int n = -1;
            while (stringTokenizer.hasMoreElements()) {
                string6 = (String)stringTokenizer.nextElement();
                n = Integer.parseInt(string6);
                if (n >= 0 && n <= 255) continue;
                AttributeValue.errorIllegalIP_AddressValue(clazz, string, string2, string3, string4, string5, "Format x.x.x.x where x may be 0-255.", locator);
            }
        }
        catch (NumberFormatException numberFormatException) {
            AttributeValue.errorIllegalIP_AddressValue(clazz, string, string2, string3, string4, string5, "Format x.x.x.x where x may be 0-255.", locator);
        }
    }

    protected static void validateIP_AddressOrExample(Class clazz, String string, String string2, String string3, String string4, String string5, Locator locator) throws ValidateException {
        if (Trace.valid(IP_AddressIP_AddressValue.class, 20)) {
            Trace.debug(IP_AddressIP_AddressValue.class, 20, "validateIP_AddressOrExample(Class aClass, String anOperation, String anAbsoluteFilePath, String anElementName, String anAttributeName, String anAttributeValue, Locator aLocator)", "aClass: " + clazz + "\n\tanOperation: " + string + "\n\tanAbsoluteFilePath: " + string2 + "\n\tanElementName: " + string3 + "\n\tanAttributeName: " + string4 + "\n\tanAttributeValue: " + string5);
        }
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string5, ".");
            if (stringTokenizer.countTokens() != 4) {
                AttributeValue.errorIllegalIP_AddressValue(clazz, string, string2, string3, string4, string5, "Format x.x.x.x where x may be 0-255 or format 'a.b.c.d'", locator);
            }
            String string6 = null;
            int n = -1;
            int n2 = 0;
            while (stringTokenizer.hasMoreElements()) {
                string6 = (String)stringTokenizer.nextElement();
                if (!(AttributeValue.legalCharacter(string6, n2) || (n = Integer.parseInt(string6)) >= 0 && n <= 255)) {
                    AttributeValue.errorIllegalIP_AddressValue(clazz, string, string2, string3, string4, string5, "Format x.x.x.x where x may be 0-255 or format 'a.b.c.d'", locator);
                }
                ++n2;
            }
        }
        catch (NumberFormatException numberFormatException) {
            AttributeValue.errorIllegalIP_AddressValue(clazz, string, string2, string3, string4, string5, "Format x.x.x.x where x may be 0-255 or format 'a.b.c.d'", locator);
        }
    }

    private static void errorIllegalIP_AddressValue(Class clazz, String string, String string2, String string3, String string4, String string5, String string6, Locator locator) throws ValidateException {
        String string7 = "XML file " + string2 + "," + "\n\tillegal attribute value: " + string4 + " = \"" + string5 + "\"" + " found in element of type " + string3 + "." + "\n\tAllowed values: Format x.x.x.x where x may be 0-255 or format 'a.b.c.d'";
        Trace.error(clazz, string, string7 + "\n\taLocator: " + LocatorProxy.getLocatorInfo(locator));
        throw new IllegalAttributeIP_AddressValueException(string7, locator);
    }

    private static void log_IllegalIP_AddressValue(Class clazz, String string, String string2, String string3, String string4, String string5, String string6, Locator locator) throws ValidateException {
        String string7 = "XML file " + string2 + "," + "\n\tillegal attribute value: " + string4 + " = \"" + string5 + "\"" + " found in element of type " + string3 + "." + "\n\tAllowed values: Format x.x.x.x where x may be 0-255 or format 'a.b.c.d'";
        if (Trace.valid(AttributeValue.class, 20)) {
            Trace.debug(AttributeValue.class, 20, string, string7 + "\n\taLocator: " + LocatorProxy.getLocatorInfo(locator));
        }
        throw new IllegalAttributeIP_AddressValueException(string7, locator);
    }

    private static boolean legalCharacter(String string, int n) {
        if (Trace.valid(AttributeValue.class, 20)) {
            Trace.debug(AttributeValue.class, 20, "legalCharacter ( String aSubIP_Address, int anIndex )", "aSubIP_Address: " + string + "\n\tanIndex: " + n);
        }
        if (n == 0 && string.equals("a")) {
            return true;
        }
        if (n == 1 && string.equals("b")) {
            return true;
        }
        if (n == 2 && string.equals("c")) {
            return true;
        }
        return n == 3 && string.equals("d");
    }
}

