/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.sudom.parser.control.transform;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Vector;
import se.ericsson.cello.mao.UpgradeTrace;
import se.ericsson.cello.sudom.parser.control.transform.ProductDataTransformerBase;
import se.ericsson.cello.sudom.parser.control.transform.TransformException;
import se.ericsson.cello.sudom.parser.dom.DocumentObjectUpgradePackage;
import se.ericsson.cello.sudom.parser.dom.productdata.ProductData;
import se.ericsson.cello.sudom.parser.dom.subrackprodtype.SubrackProdType;
import se.ericsson.cello.sudom.parser.dom.subrackprodtype.SubrackProdTypeData;
import se.ericsson.cello.sudom.parser.dom.subrackprodtype.SubrackProdTypeDataAttributeName;
import se.ericsson.cello.sudom.parser.dom.transform.Value;

public class SubrackProdTypeTransformer
extends ProductDataTransformerBase {
    public static final String ProductDataPath = "UpgradePackage/SubrackProdType/ProductData";
    public static final String SubrackProdTypeDataPath = "UpgradePackage/SubrackProdType/SubrackProdTypeData";

    public void execute(Value value, DocumentObjectUpgradePackage documentObjectUpgradePackage) throws TransformException {
        if (value.getElementPath().equals(ProductDataPath)) {
            this.transformProductDataAttribute(value, documentObjectUpgradePackage);
        } else if (value.getElementPath().equals(SubrackProdTypeDataPath)) {
            this.transformSubrackProdTypeDataAttribute(value, documentObjectUpgradePackage);
        } else {
            UpgradeTrace.info(this.getClass(), (String)"transformValue(Value aTransformValueElement, DocumentObjectUpgradePackage aDOUP)", (String)("Unexpected element path has been specified which is ignored\n\tUCF Element path: " + value.getElementPath() + "\n\tUCF Attribute name: " + value.getAttributeName() + "\n\tUCF From value: " + value.getFrom() + "\n\tUCF To value: " + value.getTo()));
        }
    }

    private void transformProductDataAttribute(Value value, DocumentObjectUpgradePackage documentObjectUpgradePackage) throws TransformException {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"transformProductDataAttribute(Value aTransformValueElement, DocumentObjectUpgradePackage aDOUP)", (String)("aTransformValueElement: " + value + "\n\taDOUP: " + documentObjectUpgradePackage));
        }
        Collection collection = this.getProductDatas(documentObjectUpgradePackage);
        this.transformProductDataAttribute(value, collection);
    }

    private Collection getProductDatas(DocumentObjectUpgradePackage documentObjectUpgradePackage) throws TransformException {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)("getProductDatas(DocumentObjectUpgradePackage aDOUP)aDOUP: " + documentObjectUpgradePackage));
        }
        HashSet<ProductData> hashSet = new HashSet<ProductData>();
        Vector vector = documentObjectUpgradePackage.getSubrackProdType();
        Iterator iterator = vector.iterator();
        SubrackProdType subrackProdType = null;
        while (iterator.hasNext()) {
            subrackProdType = (SubrackProdType)iterator.next();
            hashSet.add(subrackProdType.getProductData());
        }
        return hashSet;
    }

    private void transformSubrackProdTypeDataAttribute(Value value, DocumentObjectUpgradePackage documentObjectUpgradePackage) throws TransformException {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"transformSubrackProdTypeDataAttribute(Value aTransformValueElement, DocumentObjectUpgradePackage aDOUP)", (String)("aTransformValueElement: " + value + "\n\taDOUP: " + documentObjectUpgradePackage));
        }
        Collection collection = this.getSubrackProdTypeDatas(documentObjectUpgradePackage);
        Iterator iterator = collection.iterator();
        SubrackProdTypeData subrackProdTypeData = null;
        while (iterator.hasNext()) {
            subrackProdTypeData = (SubrackProdTypeData)iterator.next();
            if (value.getAttributeName().equals(SubrackProdTypeDataAttributeName.FanConfiguration.getValue())) {
                if (subrackProdTypeData.getFanConfiguration() == null || !subrackProdTypeData.getFanConfiguration().equals(value.getFrom())) continue;
                subrackProdTypeData.setFanConfiguration(value.getTo());
                continue;
            }
            if (value.getAttributeName().equals(SubrackProdTypeDataAttributeName.TransmissionType.getValue())) {
                if (subrackProdTypeData.getTransmissionType() == null || !subrackProdTypeData.getTransmissionType().equals(value.getFrom())) continue;
                subrackProdTypeData.setTransmissionType(value.getTo());
                continue;
            }
            UpgradeTrace.info(this.getClass(), (String)"transformSubrackProdTypeDataAttribute(Value aTransformValueElement, DocumentObjectUpgradePackage aDOUP)", (String)("Unexpected attribute (ignored)\n\tElement path: " + value.getElementPath() + "\n\tAttribute name: " + value.getAttributeName() + "\n\tFrom value: " + value.getFrom() + "\n\tTo value: " + value.getTo()));
        }
    }

    private Collection getSubrackProdTypeDatas(DocumentObjectUpgradePackage documentObjectUpgradePackage) throws TransformException {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"getSubrackProdTypeDatas(DocumentObjectUpgradePackage aDOUP)", (String)("aDOUP: " + documentObjectUpgradePackage));
        }
        LinkedList<SubrackProdTypeData> linkedList = new LinkedList<SubrackProdTypeData>();
        Vector vector = documentObjectUpgradePackage.getSubrackProdType();
        Iterator iterator = vector.iterator();
        SubrackProdType subrackProdType = null;
        while (iterator.hasNext()) {
            subrackProdType = (SubrackProdType)iterator.next();
            linkedList.add(subrackProdType.getSubrackProdTypeData());
        }
        return linkedList;
    }
}

