/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.sudom.parser.control.transform;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Vector;
import se.ericsson.cello.mao.UpgradeTrace;
import se.ericsson.cello.sudom.parser.control.transform.TransformException;
import se.ericsson.cello.sudom.parser.dom.DocumentObjectUpgradePackage;
import se.ericsson.cello.sudom.parser.dom.transform.Value;
import se.ericsson.cello.sudom.parser.dom.upgradesequence.RebootJvmUpgrade;
import se.ericsson.cello.sudom.parser.dom.upgradesequence.RebootJvmUpgradeAttributeName;
import se.ericsson.cello.sudom.parser.dom.upgradesequence.RebootNodeUpgrade;
import se.ericsson.cello.sudom.parser.dom.upgradesequence.RebootNodeUpgradeAttributeName;
import se.ericsson.cello.sudom.parser.dom.upgradesequence.RebootPiuUpgrade;
import se.ericsson.cello.sudom.parser.dom.upgradesequence.RebootPiuUpgradeAttributeName;
import se.ericsson.cello.sudom.parser.dom.upgradesequence.RebootProgramUpgrade;
import se.ericsson.cello.sudom.parser.dom.upgradesequence.RunPrograms;
import se.ericsson.cello.sudom.parser.dom.upgradesequence.RunProgramsAttributeName;
import se.ericsson.cello.sudom.parser.dom.upgradesequence.Sequence;
import se.ericsson.cello.sudom.parser.dom.upgradesequence.SequenceAttributeName;
import se.ericsson.cello.sudom.parser.dom.upgradesequence.SoftPiuUpgrade;
import se.ericsson.cello.sudom.parser.dom.upgradesequence.SoftPiuUpgradeAttributeName;
import se.ericsson.cello.sudom.parser.dom.upgradesequence.SoftSequence;
import se.ericsson.cello.sudom.parser.dom.upgradesequence.SoftSequenceAttributeName;
import se.ericsson.cello.sudom.parser.dom.upgradesequence.Step;
import se.ericsson.cello.sudom.parser.dom.upgradesequence.UpgradeSequence;

public class UpgradeSequenceTransformer {
    public static final String RebootNodeUpgradePath = "UpgradePackage/UpgradeSequence/Step/RebootNodeUpgrade";
    public static final String RebootJvmUpgradePath = "UpgradePackage/UpgradeSequence/Step/RebootJvmUpgrade";
    public static final String RebootPiuUpgradePath = "UpgradePackage/UpgradeSequence/Step/RebootPiuUpgrade";
    public static final String SequencePath = "UpgradePackage/UpgradeSequence/Step/RebootPiuUpgrade/Sequence";
    public static final String SoftPiuUpgradePath = "UpgradePackage/UpgradeSequence/Step/SoftPiuUpgrade";
    public static final String SoftSequencePath = "UpgradePackage/UpgradeSequence/Step/RebootPiuUpgrade/SoftSequence";
    public static final String RebootProgramUpgradePath = "UpgradePackage/UpgradeSequence/Step/RebootProgramUpgrade";
    public static final String RunProgramsPath = "UpgradePackage/UpgradeSequence/Step/RebootProgramUpgrade/RunPrograms";

    public void execute(Value value, DocumentObjectUpgradePackage documentObjectUpgradePackage) throws TransformException {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)("execute(Value aTransformValueElement, DocumentObjectUpgradePackage aDOUP)aTransformValueElement: " + value + "\n\taDOUP: " + documentObjectUpgradePackage));
        }
        if (value.getElementPath().equals(RebootNodeUpgradePath)) {
            this.transformRebootNodeUpgradePathAttribute(value, documentObjectUpgradePackage);
        } else if (value.getElementPath().equals(RebootJvmUpgradePath)) {
            this.transformRebootJvmUpgradePathAttribute(value, documentObjectUpgradePackage);
        } else if (value.getElementPath().equals(RebootPiuUpgradePath)) {
            this.transformRebootPiuUpgradePathAttribute(value, documentObjectUpgradePackage);
        } else if (value.getElementPath().equals(SequencePath)) {
            this.transformSequencePathAttribute(value, documentObjectUpgradePackage);
        } else if (value.getElementPath().equals(SoftPiuUpgradePath)) {
            this.transformSoftPiuUpgradePathAttribute(value, documentObjectUpgradePackage);
        } else if (value.getElementPath().equals(SoftSequencePath)) {
            this.transformSoftSequencePathAttribute(value, documentObjectUpgradePackage);
        } else if (value.getElementPath().equals(RunProgramsPath)) {
            this.transformRunProgramsPathAttribute(value, documentObjectUpgradePackage);
        } else {
            UpgradeTrace.info(this.getClass(), (String)"execute(Value aTransformValueElement, DocumentObjectUpgradePackage aDOUP)", (String)("Unexpected element path has been specified which is ignored\n\tUCF Element path: " + value.getElementPath() + "\n\tUCF Attribute name: " + value.getAttributeName() + "\n\tUCF From value: " + value.getFrom() + "\n\tUCF To value: " + value.getTo()));
        }
    }

    private void transformRebootNodeUpgradePathAttribute(Value value, DocumentObjectUpgradePackage documentObjectUpgradePackage) throws TransformException {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"transformRebootNodeUpgradePathAttribute(Value aTransformValueElement, DocumentObjectUpgradePackage aDOUP)", (String)("aTransformValueElement: " + value + "\n\taDOUP: " + documentObjectUpgradePackage));
        }
        Collection collection = this.getRebootNodeUpgrades(documentObjectUpgradePackage);
        Iterator iterator = collection.iterator();
        RebootNodeUpgrade rebootNodeUpgrade = null;
        while (iterator.hasNext()) {
            rebootNodeUpgrade = (RebootNodeUpgrade)iterator.next();
            if (value.getAttributeName().equals(RebootNodeUpgradeAttributeName.BaseClassPath.getValue())) {
                if (rebootNodeUpgrade.getBaseClassPath() == null || !rebootNodeUpgrade.getBaseClassPath().equals(value.getFrom())) continue;
                rebootNodeUpgrade.setBaseClassPath(value.getTo());
                continue;
            }
            if (value.getAttributeName().equals(RebootNodeUpgradeAttributeName.UseRepertoiresValue.getValue())) {
                if (rebootNodeUpgrade.getUseRepertoiresValue() == null || !rebootNodeUpgrade.getUseRepertoiresValue().equals(value.getFrom())) continue;
                rebootNodeUpgrade.setUseRepertoiresValue(value.getTo());
                continue;
            }
            if (value.getAttributeName().equals(RebootNodeUpgradeAttributeName.ForcedMoppletUsage.getValue())) {
                if (rebootNodeUpgrade.getForcedMoppletUsage() == null || !rebootNodeUpgrade.getForcedMoppletUsage().equals(value.getFrom())) continue;
                rebootNodeUpgrade.setForcedMoppletUsage(value.getTo());
                continue;
            }
            UpgradeTrace.info(this.getClass(), (String)"transformRebootNodeUpgradePathAttribute(Value aTransformValueElement, DocumentObjectUpgradePackage aDOUP)", (String)("Unexpected attribute (ignored)\n\tElement path: " + value.getElementPath() + "\n\tAttribute name: " + value.getAttributeName() + "\n\tFrom value: " + value.getFrom() + "\n\tTo value: " + value.getTo()));
        }
    }

    private void transformRebootJvmUpgradePathAttribute(Value value, DocumentObjectUpgradePackage documentObjectUpgradePackage) throws TransformException {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"transformRebootJvmUpgradePathAttribute(Value aTransformValueElement, DocumentObjectUpgradePackage aDOUP)", (String)("aTransformValueElement: " + value + "\n\taDOUP: " + documentObjectUpgradePackage));
        }
        Collection collection = this.getRebootJvmUpgrades(documentObjectUpgradePackage);
        Iterator iterator = collection.iterator();
        RebootJvmUpgrade rebootJvmUpgrade = null;
        while (iterator.hasNext()) {
            rebootJvmUpgrade = (RebootJvmUpgrade)iterator.next();
            if (value.getAttributeName().equals(RebootJvmUpgradeAttributeName.BaseClassPath.getValue())) {
                if (rebootJvmUpgrade.getBaseClassPath() == null || !rebootJvmUpgrade.getBaseClassPath().equals(value.getFrom())) continue;
                rebootJvmUpgrade.setBaseClassPath(value.getTo());
                continue;
            }
            if (value.getAttributeName().equals(RebootJvmUpgradeAttributeName.UseRepertoiresValue.getValue())) {
                if (rebootJvmUpgrade.getUseRepertoiresValue() == null || !rebootJvmUpgrade.getUseRepertoiresValue().equals(value.getFrom())) continue;
                rebootJvmUpgrade.setUseRepertoiresValue(value.getTo());
                continue;
            }
            if (value.getAttributeName().equals(RebootJvmUpgradeAttributeName.ForcedMoppletUsage.getValue())) {
                if (rebootJvmUpgrade.getForcedMoppletUsage() == null || !rebootJvmUpgrade.getForcedMoppletUsage().equals(value.getFrom())) continue;
                rebootJvmUpgrade.setForcedMoppletUsage(value.getTo());
                continue;
            }
            UpgradeTrace.info(this.getClass(), (String)"transformRebootJvmUpgradePathAttribute(Value aTransformValueElement, DocumentObjectUpgradePackage aDOUP)", (String)("Unexpected attribute (ignored)\n\tElement path: " + value.getElementPath() + "\n\tAttribute name: " + value.getAttributeName() + "\n\tFrom value: " + value.getFrom() + "\n\tTo value: " + value.getTo()));
        }
    }

    private void transformRebootPiuUpgradePathAttribute(Value value, DocumentObjectUpgradePackage documentObjectUpgradePackage) throws TransformException {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"transformRebootPiuUpgradePathAttribute(Value aTransformValueElement, DocumentObjectUpgradePackage aDOUP)", (String)("aTransformValueElement: " + value + "\n\taDOUP: " + documentObjectUpgradePackage));
        }
        Collection collection = this.getRebootPiuUpgrades(documentObjectUpgradePackage);
        Iterator iterator = collection.iterator();
        RebootPiuUpgrade rebootPiuUpgrade = null;
        while (iterator.hasNext()) {
            rebootPiuUpgrade = (RebootPiuUpgrade)iterator.next();
            if (value.getAttributeName().equals(RebootPiuUpgradeAttributeName.BaseClassPath.getValue())) {
                if (rebootPiuUpgrade.getBaseClassPath() == null || !rebootPiuUpgrade.getBaseClassPath().equals(value.getFrom())) continue;
                rebootPiuUpgrade.setBaseClassPath(value.getTo());
                continue;
            }
            if (value.getAttributeName().equals(RebootPiuUpgradeAttributeName.Optional.getValue())) {
                if (rebootPiuUpgrade.getOptional() == null || !rebootPiuUpgrade.getOptional().equals(value.getFrom())) continue;
                rebootPiuUpgrade.setOptional(value.getTo());
                continue;
            }
            if (value.getAttributeName().equals(RebootPiuUpgradeAttributeName.UseRepertoiresValue.getValue())) {
                if (rebootPiuUpgrade.getUseRepertoiresValue() == null || !rebootPiuUpgrade.getUseRepertoiresValue().equals(value.getFrom())) continue;
                rebootPiuUpgrade.setUseRepertoiresValue(value.getTo());
                continue;
            }
            if (value.getAttributeName().equals(RebootPiuUpgradeAttributeName.ForcedMoppletUsage.getValue())) {
                if (rebootPiuUpgrade.getForcedMoppletUsage() == null || !rebootPiuUpgrade.getForcedMoppletUsage().equals(value.getFrom())) continue;
                rebootPiuUpgrade.setForcedMoppletUsage(value.getTo());
                continue;
            }
            UpgradeTrace.info(this.getClass(), (String)"transformRebootPiuUpgradePathAttribute(Value aTransformValueElement, DocumentObjectUpgradePackage aDOUP)", (String)("Unexpected attribute (ignored)\n\tElement path: " + value.getElementPath() + "\n\tAttribute name: " + value.getAttributeName() + "\n\tFrom value: " + value.getFrom() + "\n\tTo value: " + value.getTo()));
        }
    }

    private void transformRunProgramsPathAttribute(Value value, DocumentObjectUpgradePackage documentObjectUpgradePackage) throws TransformException {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"transformRunProgramsPathAttribute(Value aTransformValueElement, DocumentObjectUpgradePackage aDOUP)", (String)("aTransformValueElement: " + value + "\n\taDOUP: " + documentObjectUpgradePackage));
        }
        Collection collection = this.getRunPrograms(documentObjectUpgradePackage);
        Iterator iterator = collection.iterator();
        RunPrograms runPrograms = null;
        while (iterator.hasNext()) {
            runPrograms = (RunPrograms)iterator.next();
            if (value.getAttributeName().equals(RunProgramsAttributeName.OneInstance.getValue())) {
                if (runPrograms.getOneInstance() == null || !runPrograms.getOneInstance().equals(value.getFrom())) continue;
                runPrograms.setOneInstance(value.getTo());
                continue;
            }
            UpgradeTrace.info(this.getClass(), (String)"transformRunProgramsPathAttribute(Value aTransformValueElement, DocumentObjectUpgradePackage aDOUP)", (String)("Unexpected attribute (ignored)\n\tElement path: " + value.getElementPath() + "\n\tAttribute name: " + value.getAttributeName() + "\n\tFrom value: " + value.getFrom() + "\n\tTo value: " + value.getTo()));
        }
    }

    private void transformSoftPiuUpgradePathAttribute(Value value, DocumentObjectUpgradePackage documentObjectUpgradePackage) throws TransformException {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"transformSoftPiuUpgradePathAttribute(Value aTransformValueElement, DocumentObjectUpgradePackage aDOUP)", (String)("aTransformValueElement: " + value + "\n\taDOUP: " + documentObjectUpgradePackage));
        }
        Collection collection = this.getSoftPiuUpgrades(documentObjectUpgradePackage);
        Iterator iterator = collection.iterator();
        SoftPiuUpgrade softPiuUpgrade = null;
        while (iterator.hasNext()) {
            softPiuUpgrade = (SoftPiuUpgrade)iterator.next();
            if (value.getAttributeName().equals(SoftPiuUpgradeAttributeName.UnreliableProgramSelect.getValue())) {
                if (softPiuUpgrade.getUnreliableProgramSelect() == null || !softPiuUpgrade.getUnreliableProgramSelect().equals(value.getFrom())) continue;
                softPiuUpgrade.setUnreliableProgramSelect(value.getTo());
                continue;
            }
            UpgradeTrace.info(this.getClass(), (String)"transformSoftPiuUpgradePathAttribute(Value aTransformValueElement, DocumentObjectUpgradePackage aDOUP)", (String)("Unexpected attribute (ignored)\n\tElement path: " + value.getElementPath() + "\n\tAttribute name: " + value.getAttributeName() + "\n\tFrom value: " + value.getFrom() + "\n\tTo value: " + value.getTo()));
        }
    }

    private void transformSequencePathAttribute(Value value, DocumentObjectUpgradePackage documentObjectUpgradePackage) throws TransformException {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"transformSequencePathAttribute(Value aTransformValueElement, DocumentObjectUpgradePackage aDOUP)", (String)("aTransformValueElement: " + value + "\n\taDOUP: " + documentObjectUpgradePackage));
        }
        Collection collection = this.getSequences(documentObjectUpgradePackage);
        Iterator iterator = collection.iterator();
        Sequence sequence = null;
        while (iterator.hasNext()) {
            sequence = (Sequence)iterator.next();
            if (value.getAttributeName().equals(SequenceAttributeName.Type.getValue())) {
                if (sequence.getType() == null || !sequence.getType().equals(value.getFrom())) continue;
                sequence.setType(value.getTo());
                continue;
            }
            if (value.getAttributeName().equals(SequenceAttributeName.Shutdown.getValue())) {
                if (sequence.getShutdown() == null || !sequence.getShutdown().equals(value.getFrom())) continue;
                sequence.setShutdown(value.getTo());
                continue;
            }
            UpgradeTrace.info(this.getClass(), (String)"transformSequencePathAttribute(Value aTransformValueElement, DocumentObjectUpgradePackage aDOUP)", (String)("Unexpected attribute (ignored)\n\tElement path: " + value.getElementPath() + "\n\tAttribute name: " + value.getAttributeName() + "\n\tFrom value: " + value.getFrom() + "\n\tTo value: " + value.getTo()));
        }
    }

    private void transformSoftSequencePathAttribute(Value value, DocumentObjectUpgradePackage documentObjectUpgradePackage) throws TransformException {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"transformSoftSequencePathAttribute(Value aTransformValueElement, DocumentObjectUpgradePackage aDOUP)", (String)("aTransformValueElement: " + value + "\n\taDOUP: " + documentObjectUpgradePackage));
        }
        Collection collection = this.getSoftSequences(documentObjectUpgradePackage);
        Iterator iterator = collection.iterator();
        SoftSequence softSequence = null;
        while (iterator.hasNext()) {
            softSequence = (SoftSequence)iterator.next();
            if (value.getAttributeName().equals(SoftSequenceAttributeName.Type.getValue())) {
                if (softSequence.getType() == null || !softSequence.getType().equals(value.getFrom())) continue;
                softSequence.setType(value.getTo());
                continue;
            }
            UpgradeTrace.info(this.getClass(), (String)"transformSoftSequencePathAttribute(Value aTransformValueElement, DocumentObjectUpgradePackage aDOUP)", (String)("Unexpected attribute (ignored)\n\tElement path: " + value.getElementPath() + "\n\tAttribute name: " + value.getAttributeName() + "\n\tFrom value: " + value.getFrom() + "\n\tTo value: " + value.getTo()));
        }
    }

    private Collection getRebootNodeUpgrades(DocumentObjectUpgradePackage documentObjectUpgradePackage) throws TransformException {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)("getRebootNodeUpgrades(DocumentObjectUpgradePackage aDOUP)aDOUP: " + documentObjectUpgradePackage));
        }
        Vector vector = documentObjectUpgradePackage.getUpgradeSequences();
        Iterator iterator = vector.iterator();
        LinkedList<RebootNodeUpgrade> linkedList = new LinkedList<RebootNodeUpgrade>();
        UpgradeSequence upgradeSequence = null;
        Vector vector2 = null;
        Iterator iterator2 = null;
        Step step = null;
        while (iterator.hasNext()) {
            upgradeSequence = (UpgradeSequence)iterator.next();
            vector2 = upgradeSequence.getSteps();
            iterator2 = vector2.iterator();
            while (iterator2.hasNext()) {
                step = (Step)iterator2.next();
                if (step.getRebootNodeUpgrade() == null) continue;
                linkedList.add(step.getRebootNodeUpgrade());
            }
        }
        return linkedList;
    }

    private Collection getRebootJvmUpgrades(DocumentObjectUpgradePackage documentObjectUpgradePackage) throws TransformException {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)("getRebootJvmUpgrades(DocumentObjectUpgradePackage aDOUP)aDOUP: " + documentObjectUpgradePackage));
        }
        Vector vector = documentObjectUpgradePackage.getUpgradeSequences();
        Iterator iterator = vector.iterator();
        LinkedList<RebootJvmUpgrade> linkedList = new LinkedList<RebootJvmUpgrade>();
        UpgradeSequence upgradeSequence = null;
        Vector vector2 = null;
        Iterator iterator2 = null;
        Step step = null;
        while (iterator.hasNext()) {
            upgradeSequence = (UpgradeSequence)iterator.next();
            vector2 = upgradeSequence.getSteps();
            iterator2 = vector2.iterator();
            while (iterator2.hasNext()) {
                step = (Step)iterator2.next();
                if (step.getRebootJvmUpgrade() == null) continue;
                linkedList.add(step.getRebootJvmUpgrade());
            }
        }
        return linkedList;
    }

    private Collection getRebootPiuUpgrades(DocumentObjectUpgradePackage documentObjectUpgradePackage) throws TransformException {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)("getRebootPiuUpgrades(DocumentObjectUpgradePackage aDOUP)aDOUP: " + documentObjectUpgradePackage));
        }
        Vector vector = documentObjectUpgradePackage.getUpgradeSequences();
        Iterator iterator = vector.iterator();
        LinkedList linkedList = new LinkedList();
        UpgradeSequence upgradeSequence = null;
        Vector vector2 = null;
        Iterator iterator2 = null;
        Step step = null;
        while (iterator.hasNext()) {
            upgradeSequence = (UpgradeSequence)iterator.next();
            vector2 = upgradeSequence.getSteps();
            iterator2 = vector2.iterator();
            while (iterator2.hasNext()) {
                step = (Step)iterator2.next();
                if (step.getRebootPiuUpgrade() == null) continue;
                linkedList.addAll(step.getRebootPiuUpgrade());
            }
        }
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)("getRebootPiuUpgrades(DocumentObjectUpgradePackage aDOUP)RETURNS - theRebootPiuUpgrades: " + linkedList));
        }
        return linkedList;
    }

    private Collection getRebootProgramUpgrades(DocumentObjectUpgradePackage documentObjectUpgradePackage) throws TransformException {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)("getRebootProgramUpgrades(DocumentObjectUpgradePackage aDOUP)aDOUP: " + documentObjectUpgradePackage));
        }
        Vector vector = documentObjectUpgradePackage.getUpgradeSequences();
        Iterator iterator = vector.iterator();
        LinkedList linkedList = new LinkedList();
        UpgradeSequence upgradeSequence = null;
        Vector vector2 = null;
        Iterator iterator2 = null;
        Step step = null;
        while (iterator.hasNext()) {
            upgradeSequence = (UpgradeSequence)iterator.next();
            vector2 = upgradeSequence.getSteps();
            iterator2 = vector2.iterator();
            while (iterator2.hasNext()) {
                step = (Step)iterator2.next();
                if (step.getRebootProgramUpgrade() == null) continue;
                linkedList.addAll(step.getRebootProgramUpgrade());
            }
        }
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)("getRebootProgramUpgrades(DocumentObjectUpgradePackage aDOUP)RETURNS - theRebootProgramUpgrade: " + linkedList));
        }
        return linkedList;
    }

    private Collection getSoftPiuUpgrades(DocumentObjectUpgradePackage documentObjectUpgradePackage) throws TransformException {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)("getSoftPiuUpgrades(DocumentObjectUpgradePackage aDOUP)aDOUP: " + documentObjectUpgradePackage));
        }
        Vector vector = documentObjectUpgradePackage.getUpgradeSequences();
        Iterator iterator = vector.iterator();
        LinkedList linkedList = new LinkedList();
        UpgradeSequence upgradeSequence = null;
        Vector vector2 = null;
        Iterator iterator2 = null;
        Step step = null;
        while (iterator.hasNext()) {
            upgradeSequence = (UpgradeSequence)iterator.next();
            vector2 = upgradeSequence.getSteps();
            iterator2 = vector2.iterator();
            while (iterator2.hasNext()) {
                step = (Step)iterator2.next();
                if (step.getSoftPiuUpgrade() == null) continue;
                linkedList.addAll(step.getSoftPiuUpgrade());
            }
        }
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)("getSoftPiuUpgrades(DocumentObjectUpgradePackage aDOUP)RETURNS - theRebootPiuUpgrades: " + linkedList));
        }
        return linkedList;
    }

    private Collection getSequences(DocumentObjectUpgradePackage documentObjectUpgradePackage) throws TransformException {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)("getSequences(DocumentObjectUpgradePackage aDOUP)aDOUP: " + documentObjectUpgradePackage));
        }
        Collection collection = this.getRebootPiuUpgrades(documentObjectUpgradePackage);
        Iterator iterator = collection.iterator();
        LinkedList<Sequence> linkedList = new LinkedList<Sequence>();
        RebootPiuUpgrade rebootPiuUpgrade = null;
        while (iterator.hasNext()) {
            rebootPiuUpgrade = (RebootPiuUpgrade)iterator.next();
            if (rebootPiuUpgrade.getSequence() == null) continue;
            linkedList.add(rebootPiuUpgrade.getSequence());
        }
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)("getSequences(DocumentObjectUpgradePackage aDOUP)RETURNS - theSequences: " + linkedList));
        }
        return linkedList;
    }

    private Collection getRunPrograms(DocumentObjectUpgradePackage documentObjectUpgradePackage) throws TransformException {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)("getRunPrograms(DocumentObjectUpgradePackage aDOUP)aDOUP: " + documentObjectUpgradePackage));
        }
        Collection collection = this.getRebootProgramUpgrades(documentObjectUpgradePackage);
        Iterator iterator = collection.iterator();
        LinkedList linkedList = new LinkedList();
        RebootProgramUpgrade rebootProgramUpgrade = null;
        while (iterator.hasNext()) {
            rebootProgramUpgrade = (RebootProgramUpgrade)iterator.next();
            if (rebootProgramUpgrade.getRunPrograms() == null) continue;
            linkedList.addAll(rebootProgramUpgrade.getRunPrograms());
        }
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)("getRunPrograms(DocumentObjectUpgradePackage aDOUP)RETURNS - theRunPrograms: " + linkedList));
        }
        return linkedList;
    }

    private Collection getSoftSequences(DocumentObjectUpgradePackage documentObjectUpgradePackage) throws TransformException {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)("getSoftSequences(DocumentObjectUpgradePackage aDOUP)aDOUP: " + documentObjectUpgradePackage));
        }
        Collection collection = this.getSoftPiuUpgrades(documentObjectUpgradePackage);
        Iterator iterator = collection.iterator();
        LinkedList<SoftSequence> linkedList = new LinkedList<SoftSequence>();
        SoftPiuUpgrade softPiuUpgrade = null;
        while (iterator.hasNext()) {
            softPiuUpgrade = (SoftPiuUpgrade)iterator.next();
            if (softPiuUpgrade.getSoftSequence() == null) continue;
            linkedList.add(softPiuUpgrade.getSoftSequence());
        }
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)("getSoftSequences(DocumentObjectUpgradePackage aDOUP)RETURNS - theSoftSequences: " + linkedList));
        }
        return linkedList;
    }
}

