/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.sudom.parser.dom.piutype;

import java.io.PrintStream;
import org.xml.sax.AttributeList;
import org.xml.sax.Locator;
import se.ericsson.cello.mao.UpgradeTrace;
import se.ericsson.cello.sudom.extif.sudom.proxy.piutype.PiuTypeDataInterface;
import se.ericsson.cello.sudom.parser.ParseException;
import se.ericsson.cello.sudom.parser.UnexpectedAttributeException;
import se.ericsson.cello.sudom.parser.dom.DocumentObjectInterface;
import se.ericsson.cello.sudom.parser.dom.ParsedData;
import se.ericsson.cello.sudom.parser.dom.piutype.PiuTypeDataAirFlowAttributes;
import se.ericsson.cello.sudom.parser.dom.piutype.PiuTypeDataAttributeName;
import se.ericsson.cello.sudom.parser.dom.piutype.PiuTypeSubElementName;
import se.ericsson.cello.sudom.parser.exceptions.ValidateException;

public class PiuTypeData
extends ParsedData
implements DocumentObjectInterface,
PiuTypeDataInterface {
    private String myBoardWidth = null;
    private String myDefaultPiuRole = null;
    private PiuTypeDataAirFlowAttributes myPiuTypeDataAirFlowAttributes = null;
    private String myDefAllowedSeqRestarts = null;

    public PiuTypeData(AttributeList attributeList, Locator locator) throws UnexpectedAttributeException {
        super(locator);
        String[] stringArray;
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"PiuTypeData(AttributeList anAttributeList, Locator aLocator)", (String)("anAttributeList: " + attributeList + "\n\taLocator: " + locator));
        }
        if ((stringArray = PiuTypeDataAttributeName.verifyNames(attributeList)) == null || stringArray.length > 0) {
            super.handleUnexpectedAttribute("PiuTypeData(AttributeList anAttributeList, Locator aLocator)", PiuTypeSubElementName.PiuTypeData.getValue(), stringArray, locator);
        }
        this.myBoardWidth = attributeList.getValue(PiuTypeDataAttributeName.BoardWidth.getValue());
        this.myDefaultPiuRole = attributeList.getValue(PiuTypeDataAttributeName.DefaultPiuRole.getValue());
        String string = attributeList.getValue(PiuTypeDataAttributeName.NormalLowTempAirFlow.getValue());
        String string2 = attributeList.getValue(PiuTypeDataAttributeName.NormalHighTempAirFlow.getValue());
        String string3 = attributeList.getValue(PiuTypeDataAttributeName.NoiseReducedLowTempAirFlow.getValue());
        String string4 = attributeList.getValue(PiuTypeDataAttributeName.NoiseReducedHighTempAirFlow.getValue());
        if (string != null || string2 != null || string3 != null || string4 != null) {
            this.myPiuTypeDataAirFlowAttributes = new PiuTypeDataAirFlowAttributes(string, string2, string3, string4);
        }
        this.myDefAllowedSeqRestarts = attributeList.getValue(PiuTypeDataAttributeName.DefAllowedSeqRestarts.getValue());
    }

    public DocumentObjectInterface create(String string, AttributeList attributeList, Locator locator) throws ParseException {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"create(String aDocumentObjectName, AttributeList anAttributeList, Locator aLocator)", (String)("aDocumentObjectName: " + string + "\n\tanAttributeList: " + attributeList + "\n\taLocator: " + locator));
        }
        return super.handleUnexpectedElement("create(String aDocumentObjectName, AttributeList anAttributeList, Locator aLocator)", PiuTypeSubElementName.PiuTypeData.getValue(), string, locator);
    }

    public void print(PrintStream printStream, String string) {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"print(PrintStream aPrintStream, String anIndentation)", (String)("aPrintStream: " + printStream + "\n\tanIndentation: " + string));
        }
        printStream.println(string + "<" + PiuTypeSubElementName.PiuTypeData.getValue());
        if (this.myBoardWidth != null) {
            printStream.println(string + "  " + PiuTypeDataAttributeName.BoardWidth.getValue() + " = \"" + this.myBoardWidth + "\"");
        }
        if (this.myDefaultPiuRole != null) {
            printStream.println(string + "  " + PiuTypeDataAttributeName.DefaultPiuRole.getValue() + " = \"" + this.myDefaultPiuRole + "\"");
        }
        if (this.myPiuTypeDataAirFlowAttributes != null) {
            if (this.myPiuTypeDataAirFlowAttributes.getNormalLowTempAirFlow() != null) {
                printStream.println(string + "  " + PiuTypeDataAttributeName.NormalLowTempAirFlow.getValue() + " = \"" + this.myPiuTypeDataAirFlowAttributes.getNormalLowTempAirFlow() + "\"");
            }
            if (this.myPiuTypeDataAirFlowAttributes.getNormalHighTempAirFlow() != null) {
                printStream.println(string + "  " + PiuTypeDataAttributeName.NormalHighTempAirFlow.getValue() + " = \"" + this.myPiuTypeDataAirFlowAttributes.getNormalHighTempAirFlow() + "\"");
            }
            if (this.myPiuTypeDataAirFlowAttributes.getNoiseReducedLowTempAirFlow() != null) {
                printStream.println(string + "  " + PiuTypeDataAttributeName.NoiseReducedLowTempAirFlow.getValue() + " = \"" + this.myPiuTypeDataAirFlowAttributes.getNoiseReducedLowTempAirFlow() + "\"");
            }
            if (this.myPiuTypeDataAirFlowAttributes.getNoiseReducedHighTempAirFlow() != null) {
                printStream.println(string + "  " + PiuTypeDataAttributeName.NoiseReducedHighTempAirFlow.getValue() + " = \"" + this.myPiuTypeDataAirFlowAttributes.getNoiseReducedHighTempAirFlow() + "\"");
            }
        }
        if (this.myDefAllowedSeqRestarts != null) {
            printStream.println(string + "  " + PiuTypeDataAttributeName.DefAllowedSeqRestarts.getValue() + " = \"" + this.myDefAllowedSeqRestarts + "\"");
        }
        printStream.println(string + "/>");
    }

    public void validate() throws ValidateException {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"validate( )");
        }
        PiuTypeDataAttributeName.BoardWidth.validate(this.myBoardWidth, super.getLocatorData(), false);
        PiuTypeDataAttributeName.DefaultPiuRole.validate(this.myDefaultPiuRole, super.getLocatorData(), false);
        String string = null;
        if (this.myPiuTypeDataAirFlowAttributes != null) {
            string = this.myPiuTypeDataAirFlowAttributes.getNormalLowTempAirFlow();
        }
        PiuTypeDataAttributeName.NormalLowTempAirFlow.validate(string, super.getLocatorData(), false);
        String string2 = null;
        if (this.myPiuTypeDataAirFlowAttributes != null) {
            string2 = this.myPiuTypeDataAirFlowAttributes.getNormalHighTempAirFlow();
        }
        PiuTypeDataAttributeName.NormalHighTempAirFlow.validate(string2, super.getLocatorData(), false);
        String string3 = null;
        if (this.myPiuTypeDataAirFlowAttributes != null) {
            string3 = this.myPiuTypeDataAirFlowAttributes.getNoiseReducedLowTempAirFlow();
        }
        PiuTypeDataAttributeName.NoiseReducedLowTempAirFlow.validate(string3, super.getLocatorData(), false);
        String string4 = null;
        if (this.myPiuTypeDataAirFlowAttributes != null) {
            string4 = this.myPiuTypeDataAirFlowAttributes.getNoiseReducedHighTempAirFlow();
        }
        PiuTypeDataAttributeName.NoiseReducedHighTempAirFlow.validate(string4, super.getLocatorData(), false);
        PiuTypeDataAttributeName.DefAllowedSeqRestarts.validate(this.myDefAllowedSeqRestarts, super.getLocatorData(), false);
    }

    public Integer getBoardWidth() {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"getBoardWidth( )");
        }
        if (this.myBoardWidth != null) {
            return new Integer(this.myBoardWidth);
        }
        return null;
    }

    public String getDefaultPiuRole() {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"getDefaultPiuRole( )");
        }
        return this.myDefaultPiuRole;
    }

    public Float getNormalLowTempAirFlow() {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"getNormalLowTempAirFlow( )");
        }
        if (this.myPiuTypeDataAirFlowAttributes != null && this.myPiuTypeDataAirFlowAttributes.getNormalLowTempAirFlow() != null) {
            return new Float(this.myPiuTypeDataAirFlowAttributes.getNormalLowTempAirFlow());
        }
        return null;
    }

    public Float getNormalHighTempAirFlow() {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"getNormalHighTempAirFlow( )");
        }
        if (this.myPiuTypeDataAirFlowAttributes != null && this.myPiuTypeDataAirFlowAttributes.getNormalHighTempAirFlow() != null) {
            return new Float(this.myPiuTypeDataAirFlowAttributes.getNormalHighTempAirFlow());
        }
        return null;
    }

    public Float getNoiseReducedLowTempAirFlow() {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"getNoiseReducedLowTempAirFlow( )");
        }
        if (this.myPiuTypeDataAirFlowAttributes != null && this.myPiuTypeDataAirFlowAttributes.getNoiseReducedLowTempAirFlow() != null) {
            return new Float(this.myPiuTypeDataAirFlowAttributes.getNoiseReducedLowTempAirFlow());
        }
        return null;
    }

    public Float getNoiseReducedHighTempAirFlow() {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"getNoiseReducedHighTempAirFlow( )");
        }
        if (this.myPiuTypeDataAirFlowAttributes != null && this.myPiuTypeDataAirFlowAttributes.getNoiseReducedHighTempAirFlow() != null) {
            return new Float(this.myPiuTypeDataAirFlowAttributes.getNoiseReducedHighTempAirFlow());
        }
        return null;
    }

    public void setBoardWidth(Integer n) {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"setBoardWidth(Integer aBoardWidth)", (String)("aBoardWidth: " + n));
        }
        this.myBoardWidth = n.toString();
    }

    public void setDefaultPiuRole(String string) {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"setDefaultPiuRole(String aDefaultPiuRole)", (String)("aDefaultPiuRole: " + string));
        }
        this.myDefaultPiuRole = string;
    }

    public void setDefAllowedSeqRestarts(String string) {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"setDefAllowedSeqRestarts(String aDefAllowedSeqRestarts)");
        }
        this.myDefAllowedSeqRestarts = string;
    }

    public void setNormalLowTempAirFlow(Float f) {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"setNormalLowTempAirFlow(Float aNormalLowTempAirFlow)", (String)("aNormalLowTempAirFlow: " + f));
        }
        if (this.myPiuTypeDataAirFlowAttributes != null) {
            this.myPiuTypeDataAirFlowAttributes.setNormalLowTempAirFlow(f.toString());
        } else {
            this.myPiuTypeDataAirFlowAttributes = new PiuTypeDataAirFlowAttributes(f.toString(), null, null, null);
        }
    }

    public void setNormalHighTempAirFlow(Float f) {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"setNormalHighTempAirFlow(Float aNormalHighTempAirFlow)", (String)("aNormalHighTempAirFlow: " + f));
        }
        if (this.myPiuTypeDataAirFlowAttributes != null) {
            this.myPiuTypeDataAirFlowAttributes.setNormalHighTempAirFlow(f.toString());
        } else {
            this.myPiuTypeDataAirFlowAttributes = new PiuTypeDataAirFlowAttributes(null, f.toString(), null, null);
        }
    }

    public void setNoiseReducedLowTempAirFlow(Float f) {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"setNoiseReducedLowTempAirFlow(Float aNoiseReducedLowTempAirFlow)", (String)("aNoiseReducedLowTempAirFlow: " + f));
        }
        if (this.myPiuTypeDataAirFlowAttributes != null) {
            this.myPiuTypeDataAirFlowAttributes.setNoiseReducedLowTempAirFlow(f.toString());
        } else {
            this.myPiuTypeDataAirFlowAttributes = new PiuTypeDataAirFlowAttributes(null, null, f.toString(), null);
        }
    }

    public void setNoiseReducedHighTempAirFlow(Float f) {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"setNoiseReducedHighTempAirFlow(Float aNoiseReducedHighTempAirFlow)", (String)("aNoiseReducedHighTempAirFlow: " + f));
        }
        if (this.myPiuTypeDataAirFlowAttributes != null) {
            this.myPiuTypeDataAirFlowAttributes.setNoiseReducedHighTempAirFlow(f.toString());
        } else {
            this.myPiuTypeDataAirFlowAttributes = new PiuTypeDataAirFlowAttributes(null, null, null, f.toString());
        }
    }

    public String getDefAllowedSeqRestarts() {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"getDefAllowedSeqRestarts( )");
        }
        return this.myDefAllowedSeqRestarts;
    }
}

